# spacestudio-satellite-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.1
- Package version: 1.0.8
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import spacestudio_satellite_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import spacestudio_satellite_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import spacestudio_satellite_client
from spacestudio_satellite_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://spacestudio-satellite.exotrail.space
# See configuration.py for a list of all supported configuration parameters.
configuration = spacestudio_satellite_client.Configuration(
    host = "https://spacestudio-satellite.exotrail.space"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = spacestudio_satellite_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with spacestudio_satellite_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = spacestudio_satellite_client.AnnouncementApi(api_client)
    announcement_id = 'announcement_id_example' # str | Numeric ID of the announcement to delete.

    try:
        # DeleteAnnouncement
        api_instance.delete_announcement(announcement_id)
    except ApiException as e:
        print("Exception when calling AnnouncementApi->delete_announcement: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://spacestudio-satellite.exotrail.space*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnnouncementApi* | [**delete_announcement**](docs/AnnouncementApi.md#delete_announcement) | **DELETE** /announcement/{announcementId} | DeleteAnnouncement
*AnnouncementApi* | [**get_announcement**](docs/AnnouncementApi.md#get_announcement) | **GET** /announcement | GetAnnouncement
*AnnouncementApi* | [**post_announcement**](docs/AnnouncementApi.md#post_announcement) | **POST** /announcement | PostAnnouncement
*ComputationsApi* | [**cancel_computations**](docs/ComputationsApi.md#cancel_computations) | **POST** /computations/cancel | CancelAllComputations
*ComputationsApi* | [**get_computations_count**](docs/ComputationsApi.md#get_computations_count) | **HEAD** /computations | GetComputationsCount
*NotificationApi* | [**delete_notification**](docs/NotificationApi.md#delete_notification) | **DELETE** /notification/{notificationId} | DeleteNotification
*NotificationApi* | [**get_nortifications**](docs/NotificationApi.md#get_nortifications) | **GET** /notification/{userId} | GetNotifications
*OrbitsApi* | [**create_orbit**](docs/OrbitsApi.md#create_orbit) | **POST** /orbits | CreateOrbit
*OrbitsApi* | [**delete_orbit**](docs/OrbitsApi.md#delete_orbit) | **DELETE** /orbits/{id} | DeleteOrbit
*OrbitsApi* | [**delete_orbits**](docs/OrbitsApi.md#delete_orbits) | **DELETE** /orbits | DeleteOrbits
*OrbitsApi* | [**get_orbits**](docs/OrbitsApi.md#get_orbits) | **GET** /orbits | GetOrbits
*OrbitsApi* | [**update_orbit**](docs/OrbitsApi.md#update_orbit) | **PUT** /orbits/{id} | UpdateOrbit
*PlatformsApi* | [**create_platform**](docs/PlatformsApi.md#create_platform) | **POST** /platforms | CreatePlatform
*PlatformsApi* | [**delete_platform**](docs/PlatformsApi.md#delete_platform) | **DELETE** /platforms/{id} | DeletePlatform
*PlatformsApi* | [**delete_platforms**](docs/PlatformsApi.md#delete_platforms) | **DELETE** /platforms | DeletePlatforms
*PlatformsApi* | [**get_platforms**](docs/PlatformsApi.md#get_platforms) | **GET** /platforms | GetPlatforms
*PlatformsApi* | [**update_platform**](docs/PlatformsApi.md#update_platform) | **PUT** /platforms/{id} | UpdatePlatform
*PropulsionSystemsApi* | [**create_propulsion_system**](docs/PropulsionSystemsApi.md#create_propulsion_system) | **POST** /propulsionsystems | CreatePropulsionSystem
*PropulsionSystemsApi* | [**delete_propulsion_system**](docs/PropulsionSystemsApi.md#delete_propulsion_system) | **DELETE** /propulsionsystems/{id} | DeletePropulsionSystem
*PropulsionSystemsApi* | [**delete_propulsion_systems**](docs/PropulsionSystemsApi.md#delete_propulsion_systems) | **DELETE** /propulsionsystems | DeletePropulsionSystems
*PropulsionSystemsApi* | [**get_propulsion_systems**](docs/PropulsionSystemsApi.md#get_propulsion_systems) | **GET** /propulsionsystems | GetPropulsionSystems
*PropulsionSystemsApi* | [**update_propulsion_system**](docs/PropulsionSystemsApi.md#update_propulsion_system) | **PUT** /propulsionsystems/{id} | UpdatePropulsionSystem
*ScenariosApi* | [**create_scenario**](docs/ScenariosApi.md#create_scenario) | **POST** /scenarios | CreateScenario
*ScenariosApi* | [**delete_scenario**](docs/ScenariosApi.md#delete_scenario) | **DELETE** /scenarios/{id} | DeleteScenario
*ScenariosApi* | [**delete_scenarios**](docs/ScenariosApi.md#delete_scenarios) | **DELETE** /scenarios | DeleteScenarios
*ScenariosApi* | [**duplicate_scenario**](docs/ScenariosApi.md#duplicate_scenario) | **POST** /scenarios/{id}/copy | DuplicateScenario
*ScenariosApi* | [**get_scenario**](docs/ScenariosApi.md#get_scenario) | **GET** /scenarios/{id} | GetScenario
*ScenariosApi* | [**get_scenarios**](docs/ScenariosApi.md#get_scenarios) | **GET** /scenarios | GetScenarios
*ScenariosApi* | [**patch_scenario**](docs/ScenariosApi.md#patch_scenario) | **PATCH** /scenarios/{id} | PatchScenario
*SpacecraftGeometriesApi* | [**create_spacecraft_geometry**](docs/SpacecraftGeometriesApi.md#create_spacecraft_geometry) | **POST** /geometries | CreateSpacecraftGeometry
*SpacecraftGeometriesApi* | [**delete_spacecraft_geometries**](docs/SpacecraftGeometriesApi.md#delete_spacecraft_geometries) | **DELETE** /geometries | DeleteSpacecraftGeometries
*SpacecraftGeometriesApi* | [**delete_spacecraft_geometry**](docs/SpacecraftGeometriesApi.md#delete_spacecraft_geometry) | **DELETE** /geometries/{id} | DeleteSpacecraftGeometry
*SpacecraftGeometriesApi* | [**get_spacecraft_geometries**](docs/SpacecraftGeometriesApi.md#get_spacecraft_geometries) | **GET** /geometries | GetSpacecraftGeometries
*SpacecraftGeometriesApi* | [**update_spacecraft_geometry**](docs/SpacecraftGeometriesApi.md#update_spacecraft_geometry) | **PUT** /geometries/{id} | UpdateSpacecraftGeometry
*StudiesApi* | [**create_computation**](docs/StudiesApi.md#create_computation) | **POST** /studies/{id}/computation | CreateComputation
*StudiesApi* | [**create_study**](docs/StudiesApi.md#create_study) | **POST** /studies | CreateStudy
*StudiesApi* | [**delete_study**](docs/StudiesApi.md#delete_study) | **DELETE** /studies/{id} | DeleteStudy
*StudiesApi* | [**get_studies**](docs/StudiesApi.md#get_studies) | **GET** /studies | GetStudies
*StudiesApi* | [**get_study**](docs/StudiesApi.md#get_study) | **GET** /studies/{id} | GetStudy
*StudiesApi* | [**update_study**](docs/StudiesApi.md#update_study) | **PUT** /studies/{id} | UpdateStudy
*StudiesApi* | [**update_study_display_configuration**](docs/StudiesApi.md#update_study_display_configuration) | **PUT** /studies/{id}/displayConfiguration | UpdateStudyDisplayConfiguration


## Documentation For Models

 - [AdvancedOrbitParameters](docs/AdvancedOrbitParameters.md)
 - [AnalyticalStudyParameters](docs/AnalyticalStudyParameters.md)
 - [Announcement](docs/Announcement.md)
 - [BaselineConfiguration](docs/BaselineConfiguration.md)
 - [CircularAltitudeOrbitParameters](docs/CircularAltitudeOrbitParameters.md)
 - [CircularGroundTrackRepeatedOrbitParameters](docs/CircularGroundTrackRepeatedOrbitParameters.md)
 - [ComparisonItem](docs/ComparisonItem.md)
 - [ComparisonItem1](docs/ComparisonItem1.md)
 - [Computation](docs/Computation.md)
 - [ComputationMode](docs/ComputationMode.md)
 - [ComputationOutputs](docs/ComputationOutputs.md)
 - [ComputationStatus](docs/ComputationStatus.md)
 - [ComputationType](docs/ComputationType.md)
 - [ContextOutputs](docs/ContextOutputs.md)
 - [Deorbitation](docs/Deorbitation.md)
 - [DisplayConfiguration](docs/DisplayConfiguration.md)
 - [DisplayConfigurationComparisonOverview](docs/DisplayConfigurationComparisonOverview.md)
 - [DragPerturbation](docs/DragPerturbation.md)
 - [DuplicateScenarioRequest](docs/DuplicateScenarioRequest.md)
 - [EarthPotentialConfiguration](docs/EarthPotentialConfiguration.md)
 - [EarthPotentialPerturbation](docs/EarthPotentialPerturbation.md)
 - [EllipticalGroundTrackRepeatedEccentricityOrbitParameters](docs/EllipticalGroundTrackRepeatedEccentricityOrbitParameters.md)
 - [EllipticalPerigeeAltApogeeAltOrbitParameters](docs/EllipticalPerigeeAltApogeeAltOrbitParameters.md)
 - [EllipticalPerigeeAltEccentricityOrbitParameters](docs/EllipticalPerigeeAltEccentricityOrbitParameters.md)
 - [EllipticalSmaEccentricityOrbitParameters](docs/EllipticalSmaEccentricityOrbitParameters.md)
 - [LeoStationKeeping](docs/LeoStationKeeping.md)
 - [Maneuver](docs/Maneuver.md)
 - [ManeuverTimelineSlot](docs/ManeuverTimelineSlot.md)
 - [ManeuveringStrategy](docs/ManeuveringStrategy.md)
 - [Notification](docs/Notification.md)
 - [NotificationContent](docs/NotificationContent.md)
 - [NumericalEphemeris](docs/NumericalEphemeris.md)
 - [NumericalOutputsConfiguration](docs/NumericalOutputsConfiguration.md)
 - [NumericalStudyParameters](docs/NumericalStudyParameters.md)
 - [Orbit](docs/Orbit.md)
 - [OrbitParameters](docs/OrbitParameters.md)
 - [OrbitPhasing](docs/OrbitPhasing.md)
 - [OrbitPropagation](docs/OrbitPropagation.md)
 - [OrbitTimelineSlot](docs/OrbitTimelineSlot.md)
 - [OrbitalTransfer](docs/OrbitalTransfer.md)
 - [Payload](docs/Payload.md)
 - [Perturbation](docs/Perturbation.md)
 - [PerturbationType](docs/PerturbationType.md)
 - [Platform](docs/Platform.md)
 - [Plot](docs/Plot.md)
 - [PropulsionSystem](docs/PropulsionSystem.md)
 - [RaanPhasing](docs/RaanPhasing.md)
 - [Scenario](docs/Scenario.md)
 - [ScenarioBaseline](docs/ScenarioBaseline.md)
 - [SimulationConfiguration](docs/SimulationConfiguration.md)
 - [SingleSatelliteAnalyticalComputationOutputs](docs/SingleSatelliteAnalyticalComputationOutputs.md)
 - [SingleSatelliteNumericalComputationOutputs](docs/SingleSatelliteNumericalComputationOutputs.md)
 - [SolarRadiationPressurePerturbation](docs/SolarRadiationPressurePerturbation.md)
 - [SpacecraftGeometry](docs/SpacecraftGeometry.md)
 - [Study](docs/Study.md)
 - [StudyComputation](docs/StudyComputation.md)
 - [StudyInputs](docs/StudyInputs.md)
 - [StudyParameters](docs/StudyParameters.md)
 - [Tab](docs/Tab.md)
 - [ThirdBodyPerturbation](docs/ThirdBodyPerturbation.md)
 - [ThrustArcsPosition](docs/ThrustArcsPosition.md)
 - [TimelineSlot](docs/TimelineSlot.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




