# Winter Field Day log aggregating server

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg?style=for-the-badge)](https://www.gnu.org/licenses/gpl-3.0)
[![Python: 3.9+](https://img.shields.io/badge/python-3.9+-blue.svg?logo=python&style=for-the-badge)](https://www.python.org/downloads/)
![Made With: Ancient Technology](https://img.shields.io/badge/Made%20with-Ancient%20technology-red?style=for-the-badge)
![PyPI - Downloads](https://img.shields.io/pypi/dm/wfdserver?label=PYPI-Downloads&logo=pypi&style=for-the-badge)

## TOC

- [Winter Field Day log aggregating server](#winter-field-day-log-aggregating-server)
  - [TOC](#toc)
  - [What is it](#what-is-it)
  - [No really what is it](#no-really-what-is-it)
  - [Screenshot](#screenshot)
  - [Installation](#installation)
  - [Configuration and first run](#configuration-and-first-run)

## What is it

[Winter Field Day](https://www.winterfieldday.org/) is a once a year 24hr
emergency preparidness event for radio amateurs (Hams). During the event, we try
and make as many radio contacts with other Hams in a 24 hour period. Bonus
points are awarded for operating outside or using alternate power sources, such
as battery/solar/wind. You can find out more about Winter Field Day by visiting
the [WFDA](https://winterfieldday.org/). You can find out more about amateur radio
by visiting the [ARRL](https://www.arrl.org/).

## No really what is it

This server listens to multicast logging packets generated by multiple [wfdlogger](https://github.com/mbridak/WinterFieldDayLogger)
clients. So a group or club can submit a group cabrillo log.



## Screenshot

![main display](https://raw.githubusercontent.com/mbridak/wfdserver/master/pics/server_pic.png)

## Installation

```bash
pip install wfdserver
```

```text
usage: wfdserver [-h] [-l]

Winter Field Day aggregation server.

options:
  -h, --help  show this help message and exit
  -l, --log   Generate log
```

## Configuration and first run

When executed for the first time, the server will not find a configuration file.
When this happens, the server will place a fresh copy in the local directory.
Press CTRL-C to end the program then edit the configuration file now found at
`./server_preferences.json`. Unless you have good reason to, don't change the
multicast settings.

```json
{
    "ourcall": "W1AW",
    "ourclass": "3O",
    "oursection": "ORG",
    "name": "Hiram Maxim",
    "address": "225 Main Street",
    "city": "Newington",
    "state": "CT",
    "postalcode": "06111",
    "country": "USA",
    "email": "Hiram.Maxim@arrl.net",
    "bonus": {
        "altpower": false,
        "outdoors": false,
        "notathome": false,
        "antenna": false,
        "satellite": false
    },
    "mullticast_group": "224.1.1.1",
    "multicast_port": 2239,
    "interface_ip": "0.0.0.0",
    "node_red_server_ip": "127.0.0.1",
    "node_red_server_port": 12062
}
```

Save the file and relaunch the wfdserver application.
