# Generated by Django 3.2 on 2021-04-20 13:55

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EmailMessageTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(blank=True, max_length=998)),
                ('plain_body', models.TextField(blank=True)),
                ('html_body', models.TextField(blank=True)),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EmailMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(blank=True, max_length=998)),
                ('plain_body', models.TextField(blank=True)),
                ('html_body', models.TextField(blank=True)),
                ('status', models.CharField(choices=[('new', 'New'), ('in_sending', 'In Sending'), ('canceled', 'Canceled'), ('failed', 'Failed'), ('sent', 'Sent')], default='new', editable=False, max_length=10)),
                ('priority', models.PositiveSmallIntegerField(choices=[(1, 'High'), (2, 'Medium'), (3, 'Low')], default=1)),
                ('name', models.CharField(max_length=100)),
                ('retries_number', models.PositiveSmallIntegerField(default=0)),
                ('max_retries_number', models.PositiveSmallIntegerField(default=1)),
                ('retry_delay', models.PositiveIntegerField(default=900)),
                ('from_email', models.EmailField(blank=True, max_length=254)),
                ('fail_silently', models.BooleanField(default=False)),
                ('reply_to', django.contrib.postgres.fields.ArrayField(base_field=models.EmailField(blank=True, max_length=254), blank=True, size=None)),
                ('to', django.contrib.postgres.fields.ArrayField(base_field=models.EmailField(blank=True, max_length=254), blank=True, size=None)),
                ('cc', django.contrib.postgres.fields.ArrayField(base_field=models.EmailField(blank=True, max_length=254), blank=True, size=None)),
                ('bcc', django.contrib.postgres.fields.ArrayField(base_field=models.EmailField(blank=True, max_length=254), blank=True, size=None)),
                ('headers', models.JSONField(blank=True)),
                ('context', models.JSONField(blank=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('send_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='mail_office.emailmessagetemplate')),
            ],
            options={
                'ordering': ('priority', 'created_at'),
            },
        ),
    ]
