"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDirectiveArguments = void 0;
const graphql_1 = require("graphql");
function getDirectiveArguments(directive) {
    return directive.arguments
        ? directive.arguments.reduce((acc, arg) => ({
            ...acc,
            [arg.name.value]: graphql_1.valueFromASTUntyped(arg.value),
        }), {})
        : [];
}
exports.getDirectiveArguments = getDirectiveArguments;
//# sourceMappingURL=getDirectiveArguments.js.map