"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stateManager = exports.StateManager = void 0;
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const lodash_1 = __importDefault(require("lodash"));
const __1 = require("..");
const cliConstants_1 = require("../cliConstants");
const jsonUtilities_1 = require("../jsonUtilities");
const tags_1 = require("../tags");
const pathManager_1 = require("./pathManager");
class StateManager {
    constructor() {
        this.metaFileExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getAmplifyMetaFilePath, projectPath);
        this.getMeta = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getAmplifyMetaFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            const data = this.getData(filePath, mergedOptions);
            return data;
        };
        this.currentMetaFileExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getCurrentAmplifyMetaFilePath, projectPath);
        this.setDeploymentSecrets = (deploymentSecrets) => {
            const path = pathManager_1.pathManager.getDeploymentSecrets();
            jsonUtilities_1.JSONUtilities.writeJson(path, deploymentSecrets, { mode: cliConstants_1.SecretFileMode });
        };
        this.getCurrentMeta = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getCurrentAmplifyMetaFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            const data = this.getData(filePath, mergedOptions);
            return data;
        };
        this.getDeploymentSecrets = () => {
            return (jsonUtilities_1.JSONUtilities.readJson(pathManager_1.pathManager.getDeploymentSecrets(), {
                throwIfNotExist: false,
            }) || { appSecrets: [] });
        };
        this.getProjectTags = (projectPath) => tags_1.ReadTags(pathManager_1.pathManager.getTagFilePath(projectPath));
        this.getCurrentProjectTags = (projectPath) => tags_1.ReadTags(pathManager_1.pathManager.getCurrentTagFilePath(projectPath));
        this.teamProviderInfoExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getTeamProviderInfoFilePath, projectPath);
        this.getTeamProviderInfo = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getTeamProviderInfoFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.localEnvInfoExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getLocalEnvFilePath, projectPath);
        this.getLocalEnvInfo = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getLocalEnvFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.localAWSInfoExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getLocalAWSInfoFilePath, projectPath);
        this.getLocalAWSInfo = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getLocalAWSInfoFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.projectConfigExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getProjectConfigFilePath, projectPath);
        this.getProjectConfig = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getProjectConfigFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.backendConfigFileExists = (projectPath) => this.doesExist(pathManager_1.pathManager.getBackendConfigFilePath, projectPath);
        this.getBackendConfig = (projectPath, options) => {
            const filePath = pathManager_1.pathManager.getBackendConfigFilePath(projectPath);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.getResourceParametersJson = (projectPath, category, resourceName, options) => {
            const filePath = pathManager_1.pathManager.getResourceParametersFilePath(projectPath, category, resourceName);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.getCurrentResourceParametersJson = (projectPath, category, resourceName, options) => {
            const filePath = pathManager_1.pathManager.getCurrentResourceParametersJsonPath(projectPath, category, resourceName);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.getAmplifyAdminConfigEntry = (appId, options) => {
            var _a;
            const mergedOptions = {
                throwIfNotExist: false,
                default: {},
                ...options,
            };
            const adminConfig = (_a = jsonUtilities_1.JSONUtilities.readJson(pathManager_1.pathManager.getAmplifyAdminConfigFilePath(), { throwIfNotExist: false })) !== null && _a !== void 0 ? _a : mergedOptions.default;
            return adminConfig[appId];
        };
        this.removeAmplifyAdminConfigEntry = (appId) => {
            const adminConfig = jsonUtilities_1.JSONUtilities.readJson(pathManager_1.pathManager.getAmplifyAdminConfigFilePath());
            delete adminConfig[appId];
            jsonUtilities_1.JSONUtilities.writeJson(pathManager_1.pathManager.getAmplifyAdminConfigFilePath(), adminConfig, { secureFile: true });
        };
        this.setAmplifyAdminConfigEntry = (appId, config) => {
            const adminConfig = jsonUtilities_1.JSONUtilities.readJson(pathManager_1.pathManager.getAmplifyAdminConfigFilePath(), { throwIfNotExist: false }) || {};
            adminConfig[appId] = config;
            jsonUtilities_1.JSONUtilities.writeJson(pathManager_1.pathManager.getAmplifyAdminConfigFilePath(), adminConfig, { secureFile: true });
        };
        this.setLocalEnvInfo = (projectPath, localEnvInfo) => {
            const filePath = pathManager_1.pathManager.getLocalEnvFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, localEnvInfo);
        };
        this.setLocalAWSInfo = (projectPath, localAWSInfo) => {
            const filePath = pathManager_1.pathManager.getLocalAWSInfoFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, localAWSInfo);
        };
        this.getHydratedTags = (projectPath) => {
            const tags = this.getProjectTags(projectPath);
            const { projectName } = this.getProjectConfig(projectPath);
            const { envName } = this.getLocalEnvInfo(projectPath);
            return tags_1.HydrateTags(tags, { projectName, envName });
        };
        this.isTagFilePresent = (projectPath) => {
            if (pathManager_1.pathManager.findProjectRoot())
                return fs.existsSync(pathManager_1.pathManager.getTagFilePath(projectPath));
            return false;
        };
        this.setProjectFileTags = (projectPath, tags) => {
            const tagFilePath = pathManager_1.pathManager.getTagFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(tagFilePath, tags);
        };
        this.setProjectConfig = (projectPath, projectConfig) => {
            const filePath = pathManager_1.pathManager.getProjectConfigFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, projectConfig);
        };
        this.setTeamProviderInfo = (projectPath, teamProviderInfo) => {
            const filePath = pathManager_1.pathManager.getTeamProviderInfoFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, teamProviderInfo);
        };
        this.setBackendConfig = (projectPath, backendConfig) => {
            const filePath = pathManager_1.pathManager.getBackendConfigFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, backendConfig);
        };
        this.setMeta = (projectPath, meta) => {
            const filePath = pathManager_1.pathManager.getAmplifyMetaFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, meta);
        };
        this.setCurrentMeta = (projectPath, meta) => {
            const filePath = pathManager_1.pathManager.getCurrentAmplifyMetaFilePath(projectPath);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, meta);
        };
        this.getHooksConfigJson = (projectPath) => { var _a; return (_a = this.getData(pathManager_1.pathManager.getHooksConfigFilePath(projectPath), { throwIfNotExist: false })) !== null && _a !== void 0 ? _a : {}; };
        this.setSampleHooksDir = (projectPath, sourceDirPath) => {
            const targetDirPath = pathManager_1.pathManager.getHooksDirPath(projectPath);
            if (!fs.existsSync(targetDirPath)) {
                fs.ensureDirSync(targetDirPath);
                fs.copySync(path.join(sourceDirPath, __1.PathConstants.HooksShellSampleFileName), path.join(targetDirPath, __1.PathConstants.HooksShellSampleFileName));
                fs.copySync(path.join(sourceDirPath, __1.PathConstants.HooksJsSampleFileName), path.join(targetDirPath, __1.PathConstants.HooksJsSampleFileName));
                fs.copySync(path.join(sourceDirPath, __1.PathConstants.HooksReadmeFileName), path.join(targetDirPath, __1.PathConstants.ReadMeFileName));
            }
        };
        this.setResourceParametersJson = (projectPath, category, resourceName, parameters) => {
            const filePath = pathManager_1.pathManager.getResourceParametersFilePath(projectPath, category, resourceName);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, parameters);
        };
        this.cliJSONFileExists = (projectPath, env) => {
            try {
                return fs.existsSync(pathManager_1.pathManager.getCLIJSONFilePath(projectPath, env));
            }
            catch (e) {
                return false;
            }
        };
        this.getCLIJSON = (projectPath, env, options) => {
            const filePath = pathManager_1.pathManager.getCLIJSONFilePath(projectPath, env);
            const mergedOptions = {
                throwIfNotExist: true,
                ...options,
            };
            return this.getData(filePath, mergedOptions);
        };
        this.setCLIJSON = (projectPath, cliJSON, env) => {
            const filePath = pathManager_1.pathManager.getCLIJSONFilePath(projectPath, env);
            jsonUtilities_1.JSONUtilities.writeJson(filePath, cliJSON, {
                keepComments: true,
            });
        };
        this.getResourceFromMeta = (amplifyMeta, categoryName, serviceName, resourceName, throwIfNotExist = true) => {
            const resources = this.filterResourcesFromMeta(amplifyMeta, categoryName, serviceName, resourceName);
            if (resources.length == 0) {
                const withNamePart = resourceName ? `with name: ${resourceName} ` : '';
                if (throwIfNotExist) {
                    throw new Error(`Resource for ${serviceName} service in ${categoryName} category, ${withNamePart}was not found.`);
                }
                else {
                    return null;
                }
            }
            else if (resources.length > 1) {
                throw new Error(`${resources.length} resources were found for ${serviceName} service in ${categoryName} category, but expected only 1.`);
            }
            return resources[0];
        };
        this.filterResourcesFromMeta = (amplifyMeta, categoryName, serviceName, resourceName) => {
            const categoryResources = lodash_1.default.get(amplifyMeta, [categoryName]);
            if (!categoryResources) {
                return [];
            }
            const result = [];
            for (const resourceKey of Object.keys(categoryResources)) {
                if (categoryResources[resourceKey].service === serviceName && (!resourceName || (resourceName && resourceKey === resourceName))) {
                    result.push({
                        resourceName: resourceKey,
                        resource: categoryResources[resourceKey],
                    });
                    if (resourceName && result.length === 1) {
                        break;
                    }
                }
            }
            return result;
        };
        this.doesExist = (filePathGetter, projectPath) => {
            let path;
            try {
                path = filePathGetter(projectPath);
            }
            catch (e) {
                return false;
            }
            return fs.existsSync(path);
        };
        this.getData = (filePath, options) => {
            var _a;
            const data = jsonUtilities_1.JSONUtilities.readJson(filePath, {
                throwIfNotExist: (_a = options === null || options === void 0 ? void 0 : options.throwIfNotExist) !== null && _a !== void 0 ? _a : true,
            });
            return data !== null && data !== void 0 ? data : options === null || options === void 0 ? void 0 : options.default;
        };
    }
}
exports.StateManager = StateManager;
exports.stateManager = new StateManager();
//# sourceMappingURL=stateManager.js.map