/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kg.apc.cmdtools.AbstractCMDTool;
import org.apache.jmeter.util.JMeterUtils;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.logging.LoggingHooker;
import org.jmeterplugins.repository.plugins.PluginSuggester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManagerCMD
extends AbstractCMDTool
implements GenericCallback<String> {
    private static final Logger log = LoggerFactory.getLogger(PluginManagerCMD.class);

    public PluginManagerCMD() {
        this.setJMeterHome();
        if (LoggingHooker.isJMeter32orLater()) {
            this.configureCMDLogging();
        }
    }

    private void configureCMDLogging() {
        try {
            Class<?> cls = Class.forName("org.jmeterplugins.repository.logging.LoggingConfigurator");
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            System.out.println("Fail to configure logging " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
    }

    private void setJMeterHome() {
        if (JMeterUtils.getJMeterHome() == null || JMeterUtils.getJMeterHome().isEmpty()) {
            File self = new File(PluginManagerCMD.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            String home = self.getParentFile().getParentFile().getParent();
            try {
                home = URLDecoder.decode(home, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Failed decode JMeter home path: " + home);
                e.printStackTrace(System.out);
            }
            log.debug("Set JMeter home: " + home);
            JMeterUtils.setJMeterHome((String)home);
            JMeterUtils.loadJMeterProperties((String)(JMeterUtils.getJMeterBinDir() + File.separator + "jmeter.properties"));
        }
    }

    protected int processParams(ListIterator listIterator) throws UnsupportedOperationException, IllegalArgumentException {
        if (!listIterator.hasNext()) {
            this.showHelp(System.out);
            throw new IllegalArgumentException("Command parameter is missing");
        }
        String command = listIterator.next().toString();
        log.info("Command is: " + command);
        try {
            switch (command) {
                case "status": {
                    System.out.println(PluginManager.getAllPluginsStatus());
                    break;
                }
                case "install": {
                    this.process(listIterator, true);
                    break;
                }
                case "install-all-except": {
                    this.installAll(listIterator, true);
                    break;
                }
                case "install-for-jmx": {
                    this.installPluginsForJmx(listIterator);
                    break;
                }
                case "uninstall": {
                    this.process(listIterator, false);
                    break;
                }
                case "help": {
                    this.showHelp(System.out);
                    break;
                }
                case "available": {
                    System.out.println(PluginManager.getAvailablePluginsAsString());
                    break;
                }
                case "upgrades": {
                    System.out.println(PluginManager.getUpgradablePluginsAsString());
                    break;
                }
                default: {
                    this.showHelp(System.out);
                    throw new UnsupportedOperationException("Wrong command: " + command);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to perform cmdline operation: " + e.getMessage(), e);
        }
        return 0;
    }

    private PluginManager getPluginsManager(boolean isSendRepoStats) throws Throwable {
        PluginManager mgr = new PluginManager();
        mgr.setSendRepoStats(isSendRepoStats);
        mgr.setTimeout(30000);
        mgr.load();
        return mgr;
    }

    protected void installPluginsForJmx(ListIterator jmxFilesIterator) throws Throwable {
        if (!jmxFilesIterator.hasNext()) {
            throw new IllegalArgumentException("No jmx files specified");
        }
        String files = jmxFilesIterator.next().toString();
        PluginManager mgr = this.getPluginsManager(false);
        PluginSuggester suggester = new PluginSuggester(mgr);
        HashSet<Plugin> pluginsToInstall = new HashSet<Plugin>();
        Set<String> jmxFiles = this.parseParams(files).keySet();
        for (String jmxPath : jmxFiles) {
            pluginsToInstall.addAll(suggester.analyzeTestPlan(jmxPath));
        }
        mgr.togglePlugins(pluginsToInstall, true);
        mgr.applyChanges(this, false, null);
    }

    protected void installAll(ListIterator exclusions, boolean install) throws Throwable {
        Set<Object> exceptedPlugins = Collections.emptySet();
        if (exclusions.hasNext()) {
            exceptedPlugins = this.parseParams(exclusions.next().toString()).keySet();
        }
        PluginManager mgr = this.getPluginsManager(true);
        for (Plugin plugin : mgr.getAvailablePlugins()) {
            if (exceptedPlugins.contains(plugin.getID())) continue;
            mgr.toggleInstalled(plugin, install);
        }
        mgr.applyChanges(this, false, null);
    }

    protected void process(ListIterator listIterator, boolean install) throws Throwable {
        if (!listIterator.hasNext()) {
            throw new IllegalArgumentException("Plugins list parameter is missing");
        }
        Map<String, String> params = this.parseParams(listIterator.next().toString());
        PluginManager mgr = this.getPluginsManager(true);
        for (Map.Entry<String, String> pluginSpec : params.entrySet()) {
            Plugin plugin = mgr.getPluginByID(pluginSpec.getKey());
            if (pluginSpec.getValue() != null) {
                plugin.setCandidateVersion(pluginSpec.getValue());
            }
            mgr.toggleInstalled(plugin, install);
        }
        mgr.applyChanges(this, false, null);
    }

    private Map<String, String> parseParams(String paramStr) {
        log.info("Params line is: " + paramStr);
        HashMap<String, String> res = new HashMap<String, String>();
        for (String part : paramStr.split(",")) {
            if (part.contains("=")) {
                String[] pieces = part.split("=");
                res.put(pieces[0].trim(), pieces[1].trim());
                continue;
            }
            res.put(part.trim(), null);
        }
        return res;
    }

    protected void showHelp(PrintStream printStream) {
        printStream.println("Options for tool 'PluginManagerCMD': <command> <paramstr>  where <command> is one of: help, status, available, upgrades, install, install-all-except, install-for-jmx, uninstall.");
    }

    @Override
    public void notify(String s) {
        if (s.endsWith("%")) {
            log.debug(s);
        } else {
            log.info(s);
        }
    }
}

