/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class HitsPerSecondGui
extends AbstractOverTimeVisualizer {
    public HitsPerSecondGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Number of hits /sec");
    }

    private void addHit(String threadGroupName, long time, int count) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(this.model, 4, threadGroupName, 2, false, false, false, true, true);
        }
        if (this.getGranulation() > 0) {
            row.add(time, (double)count * 1000.0 / (double)this.getGranulation());
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Hits per Second");
    }

    private void addHits(SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        if (!this.isFromTransactionControler(res)) {
            this.addHit("Server Hits per Second", this.normalizeTime(res.getStartTime()), 1);
        }
        for (int i = 0; i < subResults.length; ++i) {
            this.addHits(subResults[i]);
        }
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        this.addHits(res);
        this.updateGui(null);
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 2843);
    }

    public String getWikiPage() {
        return "HitsPerSecond";
    }
}

