# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotLifecycleArgs', 'SnapshotLifecycle']

@pulumi.input_type
class SnapshotLifecycleArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[str],
                 schedule: pulumi.Input[str],
                 elasticsearch_connection: Optional[pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs']] = None,
                 expand_wildcards: Optional[pulumi.Input[str]] = None,
                 expire_after: Optional[pulumi.Input[str]] = None,
                 feature_states: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unavailable: Optional[pulumi.Input[bool]] = None,
                 include_global_state: Optional[pulumi.Input[bool]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partial: Optional[pulumi.Input[bool]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SnapshotLifecycle resource.
        :param pulumi.Input[str] repository: Repository used to store snapshots created by this policy.
        :param pulumi.Input[str] schedule: Periodic or absolute schedule at which the policy creates snapshots.
        :param pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] expand_wildcards: Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        :param pulumi.Input[str] expire_after: Time period after which a snapshot is considered expired and eligible for deletion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_states: Feature states to include in the snapshot.
        :param pulumi.Input[bool] ignore_unavailable: If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        :param pulumi.Input[bool] include_global_state: If `true`, include the cluster state in the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] indices: Comma-separated list of data streams and indices to include in the snapshot.
        :param pulumi.Input[int] max_count: Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        :param pulumi.Input[str] metadata: Attaches arbitrary metadata to the snapshot.
        :param pulumi.Input[int] min_count: Minimum number of snapshots to retain, even if the snapshots have expired.
        :param pulumi.Input[str] name: ID for the snapshot lifecycle policy you want to create or update.
        :param pulumi.Input[bool] partial: If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        :param pulumi.Input[str] snapshot_name: Name automatically assigned to each snapshot created by the policy.
        """
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "schedule", schedule)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if expand_wildcards is not None:
            pulumi.set(__self__, "expand_wildcards", expand_wildcards)
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)
        if feature_states is not None:
            pulumi.set(__self__, "feature_states", feature_states)
        if ignore_unavailable is not None:
            pulumi.set(__self__, "ignore_unavailable", ignore_unavailable)
        if include_global_state is not None:
            pulumi.set(__self__, "include_global_state", include_global_state)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partial is not None:
            pulumi.set(__self__, "partial", partial)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        Repository used to store snapshots created by this policy.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        Periodic or absolute schedule at which the policy creates snapshots.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="expandWildcards")
    def expand_wildcards(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        """
        return pulumi.get(self, "expand_wildcards")

    @expand_wildcards.setter
    def expand_wildcards(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expand_wildcards", value)

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[pulumi.Input[str]]:
        """
        Time period after which a snapshot is considered expired and eligible for deletion.
        """
        return pulumi.get(self, "expire_after")

    @expire_after.setter
    def expire_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_after", value)

    @property
    @pulumi.getter(name="featureStates")
    def feature_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Feature states to include in the snapshot.
        """
        return pulumi.get(self, "feature_states")

    @feature_states.setter
    def feature_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "feature_states", value)

    @property
    @pulumi.getter(name="ignoreUnavailable")
    def ignore_unavailable(self) -> Optional[pulumi.Input[bool]]:
        """
        If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        """
        return pulumi.get(self, "ignore_unavailable")

    @ignore_unavailable.setter
    def ignore_unavailable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unavailable", value)

    @property
    @pulumi.getter(name="includeGlobalState")
    def include_global_state(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, include the cluster state in the snapshot.
        """
        return pulumi.get(self, "include_global_state")

    @include_global_state.setter
    def include_global_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_global_state", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Comma-separated list of data streams and indices to include in the snapshot.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Attaches arbitrary metadata to the snapshot.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of snapshots to retain, even if the snapshots have expired.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        ID for the snapshot lifecycle policy you want to create or update.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partial(self) -> Optional[pulumi.Input[bool]]:
        """
        If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        """
        return pulumi.get(self, "partial")

    @partial.setter
    def partial(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "partial", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name automatically assigned to each snapshot created by the policy.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)


@pulumi.input_type
class _SnapshotLifecycleState:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs']] = None,
                 expand_wildcards: Optional[pulumi.Input[str]] = None,
                 expire_after: Optional[pulumi.Input[str]] = None,
                 feature_states: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unavailable: Optional[pulumi.Input[bool]] = None,
                 include_global_state: Optional[pulumi.Input[bool]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partial: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SnapshotLifecycle resources.
        :param pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] expand_wildcards: Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        :param pulumi.Input[str] expire_after: Time period after which a snapshot is considered expired and eligible for deletion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_states: Feature states to include in the snapshot.
        :param pulumi.Input[bool] ignore_unavailable: If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        :param pulumi.Input[bool] include_global_state: If `true`, include the cluster state in the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] indices: Comma-separated list of data streams and indices to include in the snapshot.
        :param pulumi.Input[int] max_count: Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        :param pulumi.Input[str] metadata: Attaches arbitrary metadata to the snapshot.
        :param pulumi.Input[int] min_count: Minimum number of snapshots to retain, even if the snapshots have expired.
        :param pulumi.Input[str] name: ID for the snapshot lifecycle policy you want to create or update.
        :param pulumi.Input[bool] partial: If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        :param pulumi.Input[str] repository: Repository used to store snapshots created by this policy.
        :param pulumi.Input[str] schedule: Periodic or absolute schedule at which the policy creates snapshots.
        :param pulumi.Input[str] snapshot_name: Name automatically assigned to each snapshot created by the policy.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if expand_wildcards is not None:
            pulumi.set(__self__, "expand_wildcards", expand_wildcards)
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)
        if feature_states is not None:
            pulumi.set(__self__, "feature_states", feature_states)
        if ignore_unavailable is not None:
            pulumi.set(__self__, "ignore_unavailable", ignore_unavailable)
        if include_global_state is not None:
            pulumi.set(__self__, "include_global_state", include_global_state)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partial is not None:
            pulumi.set(__self__, "partial", partial)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SnapshotLifecycleElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="expandWildcards")
    def expand_wildcards(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        """
        return pulumi.get(self, "expand_wildcards")

    @expand_wildcards.setter
    def expand_wildcards(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expand_wildcards", value)

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[pulumi.Input[str]]:
        """
        Time period after which a snapshot is considered expired and eligible for deletion.
        """
        return pulumi.get(self, "expire_after")

    @expire_after.setter
    def expire_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_after", value)

    @property
    @pulumi.getter(name="featureStates")
    def feature_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Feature states to include in the snapshot.
        """
        return pulumi.get(self, "feature_states")

    @feature_states.setter
    def feature_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "feature_states", value)

    @property
    @pulumi.getter(name="ignoreUnavailable")
    def ignore_unavailable(self) -> Optional[pulumi.Input[bool]]:
        """
        If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        """
        return pulumi.get(self, "ignore_unavailable")

    @ignore_unavailable.setter
    def ignore_unavailable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unavailable", value)

    @property
    @pulumi.getter(name="includeGlobalState")
    def include_global_state(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, include the cluster state in the snapshot.
        """
        return pulumi.get(self, "include_global_state")

    @include_global_state.setter
    def include_global_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_global_state", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Comma-separated list of data streams and indices to include in the snapshot.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Attaches arbitrary metadata to the snapshot.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of snapshots to retain, even if the snapshots have expired.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        ID for the snapshot lifecycle policy you want to create or update.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partial(self) -> Optional[pulumi.Input[bool]]:
        """
        If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        """
        return pulumi.get(self, "partial")

    @partial.setter
    def partial(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "partial", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        Repository used to store snapshots created by this policy.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Periodic or absolute schedule at which the policy creates snapshots.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name automatically assigned to each snapshot created by the policy.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)


class SnapshotLifecycle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SnapshotLifecycleElasticsearchConnectionArgs']]] = None,
                 expand_wildcards: Optional[pulumi.Input[str]] = None,
                 expire_after: Optional[pulumi.Input[str]] = None,
                 feature_states: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unavailable: Optional[pulumi.Input[bool]] = None,
                 include_global_state: Optional[pulumi.Input[bool]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partial: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates or updates a snapshot lifecycle policy. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/slm-api-put-policy.html

        ## Example Usage

        ```python
        import pulumi
        import pulumi_elasticstack as elasticstack

        # create a repository for snapshots
        repo = elasticstack.SnapshotRepository("repo", fs=elasticstack.SnapshotRepositoryFsArgs(
            location="/tmp/snapshots",
            compress=True,
            max_restore_bytes_per_sec="20mb",
        ))
        # create a SLM policy and use the above created repository
        slm_policy = elasticstack.SnapshotLifecycle("slmPolicy",
            schedule="0 30 1 * * ?",
            snapshot_name="<daily-snap-{now/d}>",
            repository=repo.name,
            indices=[
                "data-*",
                "important",
            ],
            ignore_unavailable=False,
            include_global_state=False,
            expire_after="30d",
            min_count=5,
            max_count=50)
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/snapshotLifecycle:SnapshotLifecycle my_policy <cluster_uuid>/<slm policy name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SnapshotLifecycleElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] expand_wildcards: Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        :param pulumi.Input[str] expire_after: Time period after which a snapshot is considered expired and eligible for deletion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_states: Feature states to include in the snapshot.
        :param pulumi.Input[bool] ignore_unavailable: If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        :param pulumi.Input[bool] include_global_state: If `true`, include the cluster state in the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] indices: Comma-separated list of data streams and indices to include in the snapshot.
        :param pulumi.Input[int] max_count: Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        :param pulumi.Input[str] metadata: Attaches arbitrary metadata to the snapshot.
        :param pulumi.Input[int] min_count: Minimum number of snapshots to retain, even if the snapshots have expired.
        :param pulumi.Input[str] name: ID for the snapshot lifecycle policy you want to create or update.
        :param pulumi.Input[bool] partial: If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        :param pulumi.Input[str] repository: Repository used to store snapshots created by this policy.
        :param pulumi.Input[str] schedule: Periodic or absolute schedule at which the policy creates snapshots.
        :param pulumi.Input[str] snapshot_name: Name automatically assigned to each snapshot created by the policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotLifecycleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or updates a snapshot lifecycle policy. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/slm-api-put-policy.html

        ## Example Usage

        ```python
        import pulumi
        import pulumi_elasticstack as elasticstack

        # create a repository for snapshots
        repo = elasticstack.SnapshotRepository("repo", fs=elasticstack.SnapshotRepositoryFsArgs(
            location="/tmp/snapshots",
            compress=True,
            max_restore_bytes_per_sec="20mb",
        ))
        # create a SLM policy and use the above created repository
        slm_policy = elasticstack.SnapshotLifecycle("slmPolicy",
            schedule="0 30 1 * * ?",
            snapshot_name="<daily-snap-{now/d}>",
            repository=repo.name,
            indices=[
                "data-*",
                "important",
            ],
            ignore_unavailable=False,
            include_global_state=False,
            expire_after="30d",
            min_count=5,
            max_count=50)
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/snapshotLifecycle:SnapshotLifecycle my_policy <cluster_uuid>/<slm policy name>
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotLifecycleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotLifecycleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SnapshotLifecycleElasticsearchConnectionArgs']]] = None,
                 expand_wildcards: Optional[pulumi.Input[str]] = None,
                 expire_after: Optional[pulumi.Input[str]] = None,
                 feature_states: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_unavailable: Optional[pulumi.Input[bool]] = None,
                 include_global_state: Optional[pulumi.Input[bool]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partial: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotLifecycleArgs.__new__(SnapshotLifecycleArgs)

            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["expand_wildcards"] = expand_wildcards
            __props__.__dict__["expire_after"] = expire_after
            __props__.__dict__["feature_states"] = feature_states
            __props__.__dict__["ignore_unavailable"] = ignore_unavailable
            __props__.__dict__["include_global_state"] = include_global_state
            __props__.__dict__["indices"] = indices
            __props__.__dict__["max_count"] = max_count
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["min_count"] = min_count
            __props__.__dict__["name"] = name
            __props__.__dict__["partial"] = partial
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["snapshot_name"] = snapshot_name
        super(SnapshotLifecycle, __self__).__init__(
            'elasticstack:index/snapshotLifecycle:SnapshotLifecycle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SnapshotLifecycleElasticsearchConnectionArgs']]] = None,
            expand_wildcards: Optional[pulumi.Input[str]] = None,
            expire_after: Optional[pulumi.Input[str]] = None,
            feature_states: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ignore_unavailable: Optional[pulumi.Input[bool]] = None,
            include_global_state: Optional[pulumi.Input[bool]] = None,
            indices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_count: Optional[pulumi.Input[int]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            min_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            partial: Optional[pulumi.Input[bool]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            snapshot_name: Optional[pulumi.Input[str]] = None) -> 'SnapshotLifecycle':
        """
        Get an existing SnapshotLifecycle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SnapshotLifecycleElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] expand_wildcards: Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        :param pulumi.Input[str] expire_after: Time period after which a snapshot is considered expired and eligible for deletion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_states: Feature states to include in the snapshot.
        :param pulumi.Input[bool] ignore_unavailable: If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        :param pulumi.Input[bool] include_global_state: If `true`, include the cluster state in the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] indices: Comma-separated list of data streams and indices to include in the snapshot.
        :param pulumi.Input[int] max_count: Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        :param pulumi.Input[str] metadata: Attaches arbitrary metadata to the snapshot.
        :param pulumi.Input[int] min_count: Minimum number of snapshots to retain, even if the snapshots have expired.
        :param pulumi.Input[str] name: ID for the snapshot lifecycle policy you want to create or update.
        :param pulumi.Input[bool] partial: If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        :param pulumi.Input[str] repository: Repository used to store snapshots created by this policy.
        :param pulumi.Input[str] schedule: Periodic or absolute schedule at which the policy creates snapshots.
        :param pulumi.Input[str] snapshot_name: Name automatically assigned to each snapshot created by the policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotLifecycleState.__new__(_SnapshotLifecycleState)

        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["expand_wildcards"] = expand_wildcards
        __props__.__dict__["expire_after"] = expire_after
        __props__.__dict__["feature_states"] = feature_states
        __props__.__dict__["ignore_unavailable"] = ignore_unavailable
        __props__.__dict__["include_global_state"] = include_global_state
        __props__.__dict__["indices"] = indices
        __props__.__dict__["max_count"] = max_count
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["min_count"] = min_count
        __props__.__dict__["name"] = name
        __props__.__dict__["partial"] = partial
        __props__.__dict__["repository"] = repository
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["snapshot_name"] = snapshot_name
        return SnapshotLifecycle(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.SnapshotLifecycleElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter(name="expandWildcards")
    def expand_wildcards(self) -> pulumi.Output[Optional[str]]:
        """
        Determines how wildcard patterns in the `indices` parameter match data streams and indices. Supports comma-separated values, such as `closed,hidden`.
        """
        return pulumi.get(self, "expand_wildcards")

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> pulumi.Output[Optional[str]]:
        """
        Time period after which a snapshot is considered expired and eligible for deletion.
        """
        return pulumi.get(self, "expire_after")

    @property
    @pulumi.getter(name="featureStates")
    def feature_states(self) -> pulumi.Output[Sequence[str]]:
        """
        Feature states to include in the snapshot.
        """
        return pulumi.get(self, "feature_states")

    @property
    @pulumi.getter(name="ignoreUnavailable")
    def ignore_unavailable(self) -> pulumi.Output[Optional[bool]]:
        """
        If `false`, the snapshot fails if any data stream or index in indices is missing or closed. If `true`, the snapshot ignores missing or closed data streams and indices.
        """
        return pulumi.get(self, "ignore_unavailable")

    @property
    @pulumi.getter(name="includeGlobalState")
    def include_global_state(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, include the cluster state in the snapshot.
        """
        return pulumi.get(self, "include_global_state")

    @property
    @pulumi.getter
    def indices(self) -> pulumi.Output[Sequence[str]]:
        """
        Comma-separated list of data streams and indices to include in the snapshot.
        """
        return pulumi.get(self, "indices")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of snapshots to retain, even if the snapshots have not yet expired.
        """
        return pulumi.get(self, "max_count")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        Attaches arbitrary metadata to the snapshot.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum number of snapshots to retain, even if the snapshots have expired.
        """
        return pulumi.get(self, "min_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        ID for the snapshot lifecycle policy you want to create or update.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partial(self) -> pulumi.Output[Optional[bool]]:
        """
        If `false`, the entire snapshot will fail if one or more indices included in the snapshot do not have all primary shards available.
        """
        return pulumi.get(self, "partial")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        Repository used to store snapshots created by this policy.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[str]:
        """
        Periodic or absolute schedule at which the policy creates snapshots.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name automatically assigned to each snapshot created by the policy.
        """
        return pulumi.get(self, "snapshot_name")

