# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityUserArgs', 'SecurityUser']

@pulumi.input_type
class SecurityUserArgs:
    def __init__(__self__, *,
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 username: pulumi.Input[str],
                 elasticsearch_connection: Optional[pulumi.Input['SecurityUserElasticsearchConnectionArgs']] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_hash: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityUser resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        :param pulumi.Input[str] username: An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        :param pulumi.Input['SecurityUserElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[bool] enabled: Specifies whether the user is enabled. The default value is true.
        :param pulumi.Input[str] full_name: The full name of the user.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the user.
        :param pulumi.Input[str] password: The user’s password. Passwords must be at least 6 characters long.
        :param pulumi.Input[str] password_hash: A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        """
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "username", username)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_hash is not None:
            pulumi.set(__self__, "password_hash", password_hash)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SecurityUserElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SecurityUserElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the user is enabled. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the user.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary metadata that you want to associate with the user.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The user’s password. Passwords must be at least 6 characters long.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordHash")
    def password_hash(self) -> Optional[pulumi.Input[str]]:
        """
        A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        """
        return pulumi.get(self, "password_hash")

    @password_hash.setter
    def password_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_hash", value)


@pulumi.input_type
class _SecurityUserState:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['SecurityUserElasticsearchConnectionArgs']] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_hash: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityUser resources.
        :param pulumi.Input['SecurityUserElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[bool] enabled: Specifies whether the user is enabled. The default value is true.
        :param pulumi.Input[str] full_name: The full name of the user.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the user.
        :param pulumi.Input[str] password: The user’s password. Passwords must be at least 6 characters long.
        :param pulumi.Input[str] password_hash: A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        :param pulumi.Input[str] username: An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_hash is not None:
            pulumi.set(__self__, "password_hash", password_hash)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SecurityUserElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SecurityUserElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the user is enabled. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the user.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary metadata that you want to associate with the user.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The user’s password. Passwords must be at least 6 characters long.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordHash")
    def password_hash(self) -> Optional[pulumi.Input[str]]:
        """
        A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        """
        return pulumi.get(self, "password_hash")

    @password_hash.setter
    def password_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_hash", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class SecurityUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityUserElasticsearchConnectionArgs']]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_hash: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Adds and updates users in the native realm. These users are commonly referred to as native users. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        user = elasticstack.SecurityUser("user",
            username="testuser",
            password_hash="$2a$10$rMZe6TdsUwBX/TA8vRDz0OLwKAZeCzXM4jT3tfCjpSTB8HoFuq8xO",
            roles=["kibana_user"],
            metadata=json.dumps({
                "env": "testing",
                "open": False,
                "number": 49,
            }),
            elasticsearch_connection=elasticstack.SecurityUserElasticsearchConnectionArgs(
                endpoints=["http://localhost:9200"],
                username="elastic",
                password="changeme",
            ))
        dev = elasticstack.SecurityUser("dev",
            username="devuser",
            password="1234567890",
            roles=["kibana_user"],
            metadata=json.dumps({
                "env": "testing",
                "open": False,
                "number": 49,
            }))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/securityUser:SecurityUser user <cluster_uuid>/elastic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SecurityUserElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[bool] enabled: Specifies whether the user is enabled. The default value is true.
        :param pulumi.Input[str] full_name: The full name of the user.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the user.
        :param pulumi.Input[str] password: The user’s password. Passwords must be at least 6 characters long.
        :param pulumi.Input[str] password_hash: A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        :param pulumi.Input[str] username: An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds and updates users in the native realm. These users are commonly referred to as native users. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        user = elasticstack.SecurityUser("user",
            username="testuser",
            password_hash="$2a$10$rMZe6TdsUwBX/TA8vRDz0OLwKAZeCzXM4jT3tfCjpSTB8HoFuq8xO",
            roles=["kibana_user"],
            metadata=json.dumps({
                "env": "testing",
                "open": False,
                "number": 49,
            }),
            elasticsearch_connection=elasticstack.SecurityUserElasticsearchConnectionArgs(
                endpoints=["http://localhost:9200"],
                username="elastic",
                password="changeme",
            ))
        dev = elasticstack.SecurityUser("dev",
            username="devuser",
            password="1234567890",
            roles=["kibana_user"],
            metadata=json.dumps({
                "env": "testing",
                "open": False,
                "number": 49,
            }))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/securityUser:SecurityUser user <cluster_uuid>/elastic
        ```

        :param str resource_name: The name of the resource.
        :param SecurityUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityUserElasticsearchConnectionArgs']]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_hash: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityUserArgs.__new__(SecurityUserArgs)

            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["email"] = email
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["full_name"] = full_name
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_hash"] = None if password_hash is None else pulumi.Output.secret(password_hash)
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "passwordHash"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecurityUser, __self__).__init__(
            'elasticstack:index/securityUser:SecurityUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityUserElasticsearchConnectionArgs']]] = None,
            email: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            full_name: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_hash: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'SecurityUser':
        """
        Get an existing SecurityUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SecurityUserElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[bool] enabled: Specifies whether the user is enabled. The default value is true.
        :param pulumi.Input[str] full_name: The full name of the user.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the user.
        :param pulumi.Input[str] password: The user’s password. Passwords must be at least 6 characters long.
        :param pulumi.Input[str] password_hash: A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        :param pulumi.Input[str] username: An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityUserState.__new__(_SecurityUserState)

        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["email"] = email
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["password"] = password
        __props__.__dict__["password_hash"] = password_hash
        __props__.__dict__["roles"] = roles
        __props__.__dict__["username"] = username
        return SecurityUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.SecurityUserElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the user is enabled. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[Optional[str]]:
        """
        The full name of the user.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        Arbitrary metadata that you want to associate with the user.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The user’s password. Passwords must be at least 6 characters long.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordHash")
    def password_hash(self) -> pulumi.Output[Optional[str]]:
        """
        A hash of the user’s password. This must be produced using the same hashing algorithm as has been configured for password storage (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#hashing-settings).
        """
        return pulumi.get(self, "password_hash")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[str]]:
        """
        A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        An identifier for the user (see https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-user.html#security-api-put-user-path-params).
        """
        return pulumi.get(self, "username")

