# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScriptArgs', 'Script']

@pulumi.input_type
class ScriptArgs:
    def __init__(__self__, *,
                 lang: pulumi.Input[str],
                 script_id: pulumi.Input[str],
                 source: pulumi.Input[str],
                 context: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['ScriptElasticsearchConnectionArgs']] = None,
                 params: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Script resource.
        :param pulumi.Input[str] lang: Script language. For search templates, use `mustache`.
        :param pulumi.Input[str] script_id: Identifier for the stored script. Must be unique within the cluster.
        :param pulumi.Input[str] source: For scripts, a string containing the script. For search templates, an object containing the search template.
        :param pulumi.Input[str] context: Context in which the script or search template should run.
        :param pulumi.Input['ScriptElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] params: Parameters for the script or search template.
        """
        pulumi.set(__self__, "lang", lang)
        pulumi.set(__self__, "script_id", script_id)
        pulumi.set(__self__, "source", source)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if params is not None:
            pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def lang(self) -> pulumi.Input[str]:
        """
        Script language. For search templates, use `mustache`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: pulumi.Input[str]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Input[str]:
        """
        Identifier for the stored script. Must be unique within the cluster.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        For scripts, a string containing the script. For search templates, an object containing the search template.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Context in which the script or search template should run.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['ScriptElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['ScriptElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[str]]:
        """
        Parameters for the script or search template.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "params", value)


@pulumi.input_type
class _ScriptState:
    def __init__(__self__, *,
                 context: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['ScriptElasticsearchConnectionArgs']] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Script resources.
        :param pulumi.Input[str] context: Context in which the script or search template should run.
        :param pulumi.Input['ScriptElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] lang: Script language. For search templates, use `mustache`.
        :param pulumi.Input[str] params: Parameters for the script or search template.
        :param pulumi.Input[str] script_id: Identifier for the stored script. Must be unique within the cluster.
        :param pulumi.Input[str] source: For scripts, a string containing the script. For search templates, an object containing the search template.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Context in which the script or search template should run.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['ScriptElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['ScriptElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        Script language. For search templates, use `mustache`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[str]]:
        """
        Parameters for the script or search template.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the stored script. Must be unique within the cluster.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        For scripts, a string containing the script. For search templates, an object containing the search template.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


class Script(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ScriptElasticsearchConnectionArgs']]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates or updates a stored script or search template. See https://www.elastic.co/guide/en/elasticsearch/reference/current/create-stored-script-api.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        my_script = elasticstack.Script("myScript",
            script_id="my_script",
            lang="painless",
            source="Math.log(_score * 2) + params['my_modifier']",
            context="score")
        my_search_template = elasticstack.Script("mySearchTemplate",
            script_id="my_search_template",
            lang="mustache",
            source=json.dumps({
                "query": {
                    "match": {
                        "message": "{{query_string}}",
                    },
                },
                "from": "{{from}}",
                "size": "{{size}}",
            }),
            params=json.dumps({
                "query_string": "My query string",
            }))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/script:Script my_script <cluster_uuid>/<script id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] context: Context in which the script or search template should run.
        :param pulumi.Input[pulumi.InputType['ScriptElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] lang: Script language. For search templates, use `mustache`.
        :param pulumi.Input[str] params: Parameters for the script or search template.
        :param pulumi.Input[str] script_id: Identifier for the stored script. Must be unique within the cluster.
        :param pulumi.Input[str] source: For scripts, a string containing the script. For search templates, an object containing the search template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScriptArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or updates a stored script or search template. See https://www.elastic.co/guide/en/elasticsearch/reference/current/create-stored-script-api.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        my_script = elasticstack.Script("myScript",
            script_id="my_script",
            lang="painless",
            source="Math.log(_score * 2) + params['my_modifier']",
            context="score")
        my_search_template = elasticstack.Script("mySearchTemplate",
            script_id="my_search_template",
            lang="mustache",
            source=json.dumps({
                "query": {
                    "match": {
                        "message": "{{query_string}}",
                    },
                },
                "from": "{{from}}",
                "size": "{{size}}",
            }),
            params=json.dumps({
                "query_string": "My query string",
            }))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/script:Script my_script <cluster_uuid>/<script id>
        ```

        :param str resource_name: The name of the resource.
        :param ScriptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScriptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ScriptElasticsearchConnectionArgs']]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScriptArgs.__new__(ScriptArgs)

            __props__.__dict__["context"] = context
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            if lang is None and not opts.urn:
                raise TypeError("Missing required property 'lang'")
            __props__.__dict__["lang"] = lang
            __props__.__dict__["params"] = params
            if script_id is None and not opts.urn:
                raise TypeError("Missing required property 'script_id'")
            __props__.__dict__["script_id"] = script_id
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
        super(Script, __self__).__init__(
            'elasticstack:index/script:Script',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            context: Optional[pulumi.Input[str]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ScriptElasticsearchConnectionArgs']]] = None,
            lang: Optional[pulumi.Input[str]] = None,
            params: Optional[pulumi.Input[str]] = None,
            script_id: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None) -> 'Script':
        """
        Get an existing Script resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] context: Context in which the script or search template should run.
        :param pulumi.Input[pulumi.InputType['ScriptElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] lang: Script language. For search templates, use `mustache`.
        :param pulumi.Input[str] params: Parameters for the script or search template.
        :param pulumi.Input[str] script_id: Identifier for the stored script. Must be unique within the cluster.
        :param pulumi.Input[str] source: For scripts, a string containing the script. For search templates, an object containing the search template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScriptState.__new__(_ScriptState)

        __props__.__dict__["context"] = context
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["lang"] = lang
        __props__.__dict__["params"] = params
        __props__.__dict__["script_id"] = script_id
        __props__.__dict__["source"] = source
        return Script(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[str]]:
        """
        Context in which the script or search template should run.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.ScriptElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def lang(self) -> pulumi.Output[str]:
        """
        Script language. For search templates, use `mustache`.
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional[str]]:
        """
        Parameters for the script or search template.
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Output[str]:
        """
        Identifier for the stored script. Must be unique within the cluster.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        For scripts, a string containing the script. For search templates, an object containing the search template.
        """
        return pulumi.get(self, "source")

