# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ClusterSettingsElasticsearchConnection',
    'ClusterSettingsPersistent',
    'ClusterSettingsPersistentSetting',
    'ClusterSettingsTransient',
    'ClusterSettingsTransientSetting',
    'ComponentTemplateElasticsearchConnection',
    'ComponentTemplateTemplate',
    'ComponentTemplateTemplateAlias',
    'DataSecurityRoleApplicationResult',
    'DataSecurityRoleElasticsearchConnectionResult',
    'DataSecurityRoleIndexResult',
    'DataSecurityRoleIndexFieldSecurityResult',
    'DataSecurityRoleMappingElasticsearchConnectionResult',
    'DataSecurityUserElasticsearchConnectionResult',
    'DataSnapshotRepositoryAzureResult',
    'DataSnapshotRepositoryElasticsearchConnectionResult',
    'DataSnapshotRepositoryFResult',
    'DataSnapshotRepositoryGcResult',
    'DataSnapshotRepositoryHdfResult',
    'DataSnapshotRepositoryS3Result',
    'DataSnapshotRepositoryUrlResult',
    'DataStreamElasticsearchConnection',
    'DataStreamIndex',
    'IndexAlias',
    'IndexElasticsearchConnection',
    'IndexLifecycleCold',
    'IndexLifecycleColdAllocate',
    'IndexLifecycleColdFreeze',
    'IndexLifecycleColdMigrate',
    'IndexLifecycleColdReadonly',
    'IndexLifecycleColdSearchableSnapshot',
    'IndexLifecycleColdSetPriority',
    'IndexLifecycleColdUnfollow',
    'IndexLifecycleDelete',
    'IndexLifecycleDeleteDelete',
    'IndexLifecycleDeleteWaitForSnapshot',
    'IndexLifecycleElasticsearchConnection',
    'IndexLifecycleFrozen',
    'IndexLifecycleFrozenSearchableSnapshot',
    'IndexLifecycleHot',
    'IndexLifecycleHotForcemerge',
    'IndexLifecycleHotReadonly',
    'IndexLifecycleHotRollover',
    'IndexLifecycleHotSearchableSnapshot',
    'IndexLifecycleHotSetPriority',
    'IndexLifecycleHotShrink',
    'IndexLifecycleHotUnfollow',
    'IndexLifecycleWarm',
    'IndexLifecycleWarmAllocate',
    'IndexLifecycleWarmForcemerge',
    'IndexLifecycleWarmMigrate',
    'IndexLifecycleWarmReadonly',
    'IndexLifecycleWarmSetPriority',
    'IndexLifecycleWarmShrink',
    'IndexLifecycleWarmUnfollow',
    'IndexSettings',
    'IndexSettingsSetting',
    'IndexTemplateDataStream',
    'IndexTemplateElasticsearchConnection',
    'IndexTemplateTemplate',
    'IndexTemplateTemplateAlias',
    'IngestPipelineElasticsearchConnection',
    'LogstashPipelineElasticsearchConnection',
    'ScriptElasticsearchConnection',
    'SecurityApiKeyElasticsearchConnection',
    'SecurityRoleApplication',
    'SecurityRoleElasticsearchConnection',
    'SecurityRoleIndex',
    'SecurityRoleIndexFieldSecurity',
    'SecurityRoleMappingElasticsearchConnection',
    'SecuritySystemUserElasticsearchConnection',
    'SecurityUserElasticsearchConnection',
    'SnapshotLifecycleElasticsearchConnection',
    'SnapshotRepositoryAzure',
    'SnapshotRepositoryElasticsearchConnection',
    'SnapshotRepositoryFs',
    'SnapshotRepositoryGcs',
    'SnapshotRepositoryHdfs',
    'SnapshotRepositoryS3',
    'SnapshotRepositoryUrl',
]

@pulumi.output_type
class ClusterSettingsElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSettingsElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSettingsElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSettingsElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ClusterSettingsPersistent(dict):
    def __init__(__self__, *,
                 settings: Sequence['outputs.ClusterSettingsPersistentSetting']):
        """
        :param Sequence['ClusterSettingsPersistentSettingArgs'] settings: Defines the setting in the cluster.
        """
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.ClusterSettingsPersistentSetting']:
        """
        Defines the setting in the cluster.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class ClusterSettingsPersistentSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueLists":
            suggest = "value_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSettingsPersistentSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSettingsPersistentSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSettingsPersistentSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_lists: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_lists is not None:
            pulumi.set(__self__, "value_lists", value_lists)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueLists")
    def value_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "value_lists")


@pulumi.output_type
class ClusterSettingsTransient(dict):
    def __init__(__self__, *,
                 settings: Sequence['outputs.ClusterSettingsTransientSetting']):
        """
        :param Sequence['ClusterSettingsTransientSettingArgs'] settings: Defines the setting in the cluster.
        """
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.ClusterSettingsTransientSetting']:
        """
        Defines the setting in the cluster.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class ClusterSettingsTransientSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueLists":
            suggest = "value_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSettingsTransientSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSettingsTransientSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSettingsTransientSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_lists: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_lists is not None:
            pulumi.set(__self__, "value_lists", value_lists)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueLists")
    def value_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "value_lists")


@pulumi.output_type
class ComponentTemplateElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTemplateElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTemplateElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTemplateElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ComponentTemplateTemplate(dict):
    def __init__(__self__, *,
                 aliases: Optional[Sequence['outputs.ComponentTemplateTemplateAlias']] = None,
                 mappings: Optional[str] = None,
                 settings: Optional[str] = None):
        """
        :param Sequence['ComponentTemplateTemplateAliasArgs'] aliases: Alias to add.
        :param str mappings: Mapping for fields in the index.
        :param str settings: Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence['outputs.ComponentTemplateTemplateAlias']]:
        """
        Alias to add.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[str]:
        """
        Mapping for fields in the index.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter
    def settings(self) -> Optional[str]:
        """
        Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class ComponentTemplateTemplateAlias(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexRouting":
            suggest = "index_routing"
        elif key == "isHidden":
            suggest = "is_hidden"
        elif key == "isWriteIndex":
            suggest = "is_write_index"
        elif key == "searchRouting":
            suggest = "search_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTemplateTemplateAlias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTemplateTemplateAlias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTemplateTemplateAlias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 filter: Optional[str] = None,
                 index_routing: Optional[str] = None,
                 is_hidden: Optional[bool] = None,
                 is_write_index: Optional[bool] = None,
                 routing: Optional[str] = None,
                 search_routing: Optional[str] = None):
        """
        :param str name: Name of the component template to create.
        """
        pulumi.set(__self__, "name", name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if index_routing is not None:
            pulumi.set(__self__, "index_routing", index_routing)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if is_write_index is not None:
            pulumi.set(__self__, "is_write_index", is_write_index)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if search_routing is not None:
            pulumi.set(__self__, "search_routing", search_routing)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the component template to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="indexRouting")
    def index_routing(self) -> Optional[str]:
        return pulumi.get(self, "index_routing")

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[bool]:
        return pulumi.get(self, "is_hidden")

    @property
    @pulumi.getter(name="isWriteIndex")
    def is_write_index(self) -> Optional[bool]:
        return pulumi.get(self, "is_write_index")

    @property
    @pulumi.getter
    def routing(self) -> Optional[str]:
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="searchRouting")
    def search_routing(self) -> Optional[str]:
        return pulumi.get(self, "search_routing")


@pulumi.output_type
class DataSecurityRoleApplicationResult(dict):
    def __init__(__self__, *,
                 application: str,
                 privileges: Sequence[str],
                 resources: Sequence[str]):
        pulumi.set(__self__, "application", application)
        pulumi.set(__self__, "privileges", privileges)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def application(self) -> str:
        return pulumi.get(self, "application")

    @property
    @pulumi.getter
    def privileges(self) -> Sequence[str]:
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        return pulumi.get(self, "resources")


@pulumi.output_type
class DataSecurityRoleElasticsearchConnectionResult(dict):
    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataSecurityRoleIndexResult(dict):
    def __init__(__self__, *,
                 allow_restricted_indices: bool,
                 field_securities: Sequence['outputs.DataSecurityRoleIndexFieldSecurityResult'],
                 names: Sequence[str],
                 privileges: Sequence[str],
                 query: str):
        pulumi.set(__self__, "allow_restricted_indices", allow_restricted_indices)
        pulumi.set(__self__, "field_securities", field_securities)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "privileges", privileges)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="allowRestrictedIndices")
    def allow_restricted_indices(self) -> bool:
        return pulumi.get(self, "allow_restricted_indices")

    @property
    @pulumi.getter(name="fieldSecurities")
    def field_securities(self) -> Sequence['outputs.DataSecurityRoleIndexFieldSecurityResult']:
        return pulumi.get(self, "field_securities")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def privileges(self) -> Sequence[str]:
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def query(self) -> str:
        return pulumi.get(self, "query")


@pulumi.output_type
class DataSecurityRoleIndexFieldSecurityResult(dict):
    def __init__(__self__, *,
                 excepts: Sequence[str],
                 grants: Sequence[str]):
        pulumi.set(__self__, "excepts", excepts)
        pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def excepts(self) -> Sequence[str]:
        return pulumi.get(self, "excepts")

    @property
    @pulumi.getter
    def grants(self) -> Sequence[str]:
        return pulumi.get(self, "grants")


@pulumi.output_type
class DataSecurityRoleMappingElasticsearchConnectionResult(dict):
    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataSecurityUserElasticsearchConnectionResult(dict):
    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataSnapshotRepositoryAzureResult(dict):
    def __init__(__self__, *,
                 base_path: str,
                 chunk_size: str,
                 client: str,
                 compress: bool,
                 container: str,
                 location_mode: str,
                 max_restore_bytes_per_sec: str,
                 max_snapshot_bytes_per_sec: str,
                 readonly: bool):
        pulumi.set(__self__, "base_path", base_path)
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "client", client)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "location_mode", location_mode)
        pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> str:
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> str:
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def client(self) -> str:
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter
    def container(self) -> str:
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="locationMode")
    def location_mode(self) -> str:
        return pulumi.get(self, "location_mode")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        return pulumi.get(self, "readonly")


@pulumi.output_type
class DataSnapshotRepositoryElasticsearchConnectionResult(dict):
    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataSnapshotRepositoryFResult(dict):
    def __init__(__self__, *,
                 chunk_size: str,
                 compress: bool,
                 location: str,
                 max_number_of_snapshots: int,
                 max_restore_bytes_per_sec: str,
                 max_snapshot_bytes_per_sec: str,
                 readonly: bool):
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "max_number_of_snapshots", max_number_of_snapshots)
        pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> str:
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxNumberOfSnapshots")
    def max_number_of_snapshots(self) -> int:
        return pulumi.get(self, "max_number_of_snapshots")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        return pulumi.get(self, "readonly")


@pulumi.output_type
class DataSnapshotRepositoryGcResult(dict):
    def __init__(__self__, *,
                 base_path: str,
                 bucket: str,
                 chunk_size: str,
                 client: str,
                 compress: bool,
                 max_restore_bytes_per_sec: str,
                 max_snapshot_bytes_per_sec: str,
                 readonly: bool):
        pulumi.set(__self__, "base_path", base_path)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "client", client)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> str:
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> str:
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def client(self) -> str:
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        return pulumi.get(self, "readonly")


@pulumi.output_type
class DataSnapshotRepositoryHdfResult(dict):
    def __init__(__self__, *,
                 chunk_size: str,
                 compress: bool,
                 load_defaults: bool,
                 max_restore_bytes_per_sec: str,
                 max_snapshot_bytes_per_sec: str,
                 path: str,
                 readonly: bool,
                 uri: str):
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "load_defaults", load_defaults)
        pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "readonly", readonly)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> str:
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="loadDefaults")
    def load_defaults(self) -> bool:
        return pulumi.get(self, "load_defaults")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


@pulumi.output_type
class DataSnapshotRepositoryS3Result(dict):
    def __init__(__self__, *,
                 base_path: str,
                 bucket: str,
                 buffer_size: str,
                 canned_acl: str,
                 chunk_size: str,
                 client: str,
                 compress: bool,
                 max_restore_bytes_per_sec: str,
                 max_snapshot_bytes_per_sec: str,
                 readonly: bool,
                 server_side_encryption: bool,
                 storage_class: str):
        pulumi.set(__self__, "base_path", base_path)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "buffer_size", buffer_size)
        pulumi.set(__self__, "canned_acl", canned_acl)
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "client", client)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        pulumi.set(__self__, "readonly", readonly)
        pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> str:
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> str:
        return pulumi.get(self, "buffer_size")

    @property
    @pulumi.getter(name="cannedAcl")
    def canned_acl(self) -> str:
        return pulumi.get(self, "canned_acl")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> str:
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def client(self) -> str:
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> bool:
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class DataSnapshotRepositoryUrlResult(dict):
    def __init__(__self__, *,
                 chunk_size: str,
                 compress: bool,
                 http_max_retries: int,
                 http_socket_timeout: str,
                 max_number_of_snapshots: int,
                 max_restore_bytes_per_sec: str,
                 max_snapshot_bytes_per_sec: str,
                 readonly: bool,
                 url: str):
        """
        :param str url: URL repository. Set only if the type of the fetched repo is `url`.
        """
        pulumi.set(__self__, "chunk_size", chunk_size)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "http_max_retries", http_max_retries)
        pulumi.set(__self__, "http_socket_timeout", http_socket_timeout)
        pulumi.set(__self__, "max_number_of_snapshots", max_number_of_snapshots)
        pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        pulumi.set(__self__, "readonly", readonly)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> str:
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="httpMaxRetries")
    def http_max_retries(self) -> int:
        return pulumi.get(self, "http_max_retries")

    @property
    @pulumi.getter(name="httpSocketTimeout")
    def http_socket_timeout(self) -> str:
        return pulumi.get(self, "http_socket_timeout")

    @property
    @pulumi.getter(name="maxNumberOfSnapshots")
    def max_number_of_snapshots(self) -> int:
        return pulumi.get(self, "max_number_of_snapshots")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> str:
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL repository. Set only if the type of the fetched repo is `url`.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DataStreamElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStreamElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStreamElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStreamElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataStreamIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "indexUuid":
            suggest = "index_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStreamIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStreamIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStreamIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: Optional[str] = None,
                 index_uuid: Optional[str] = None):
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)
        if index_uuid is not None:
            pulumi.set(__self__, "index_uuid", index_uuid)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="indexUuid")
    def index_uuid(self) -> Optional[str]:
        return pulumi.get(self, "index_uuid")


@pulumi.output_type
class IndexAlias(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexRouting":
            suggest = "index_routing"
        elif key == "isHidden":
            suggest = "is_hidden"
        elif key == "isWriteIndex":
            suggest = "is_write_index"
        elif key == "searchRouting":
            suggest = "search_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexAlias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexAlias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexAlias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 filter: Optional[str] = None,
                 index_routing: Optional[str] = None,
                 is_hidden: Optional[bool] = None,
                 is_write_index: Optional[bool] = None,
                 routing: Optional[str] = None,
                 search_routing: Optional[str] = None):
        """
        :param str name: Index alias name.
        :param str filter: Query used to limit documents the alias can access.
        :param str index_routing: Value used to route indexing operations to a specific shard. If specified, this overwrites the `routing` value for indexing operations.
        :param bool is_hidden: If true, the alias is hidden.
        :param bool is_write_index: If true, the index is the write index for the alias.
        :param str routing: Value used to route indexing and search operations to a specific shard.
        :param str search_routing: Value used to route search operations to a specific shard. If specified, this overwrites the routing value for search operations.
        """
        pulumi.set(__self__, "name", name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if index_routing is not None:
            pulumi.set(__self__, "index_routing", index_routing)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if is_write_index is not None:
            pulumi.set(__self__, "is_write_index", is_write_index)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if search_routing is not None:
            pulumi.set(__self__, "search_routing", search_routing)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Index alias name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        Query used to limit documents the alias can access.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="indexRouting")
    def index_routing(self) -> Optional[str]:
        """
        Value used to route indexing operations to a specific shard. If specified, this overwrites the `routing` value for indexing operations.
        """
        return pulumi.get(self, "index_routing")

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[bool]:
        """
        If true, the alias is hidden.
        """
        return pulumi.get(self, "is_hidden")

    @property
    @pulumi.getter(name="isWriteIndex")
    def is_write_index(self) -> Optional[bool]:
        """
        If true, the index is the write index for the alias.
        """
        return pulumi.get(self, "is_write_index")

    @property
    @pulumi.getter
    def routing(self) -> Optional[str]:
        """
        Value used to route indexing and search operations to a specific shard.
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="searchRouting")
    def search_routing(self) -> Optional[str]:
        """
        Value used to route search operations to a specific shard. If specified, this overwrites the routing value for search operations.
        """
        return pulumi.get(self, "search_routing")


@pulumi.output_type
class IndexElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class IndexLifecycleCold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAge":
            suggest = "min_age"
        elif key == "searchableSnapshot":
            suggest = "searchable_snapshot"
        elif key == "setPriority":
            suggest = "set_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleCold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleCold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleCold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocate: Optional['outputs.IndexLifecycleColdAllocate'] = None,
                 freeze: Optional['outputs.IndexLifecycleColdFreeze'] = None,
                 migrate: Optional['outputs.IndexLifecycleColdMigrate'] = None,
                 min_age: Optional[str] = None,
                 readonly: Optional['outputs.IndexLifecycleColdReadonly'] = None,
                 searchable_snapshot: Optional['outputs.IndexLifecycleColdSearchableSnapshot'] = None,
                 set_priority: Optional['outputs.IndexLifecycleColdSetPriority'] = None,
                 unfollow: Optional['outputs.IndexLifecycleColdUnfollow'] = None):
        """
        :param 'IndexLifecycleColdAllocateArgs' allocate: Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.
        :param 'IndexLifecycleColdFreezeArgs' freeze: Freeze the index to minimize its memory footprint.
        :param 'IndexLifecycleColdMigrateArgs' migrate: Moves the index to the data tier that corresponds to the current phase by updating the "index.routing.allocation.include.*tier*preference" index setting.
        :param str min_age: ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        :param 'IndexLifecycleColdReadonlyArgs' readonly: Makes the index read-only.
        :param 'IndexLifecycleColdSearchableSnapshotArgs' searchable_snapshot: Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot.
        :param 'IndexLifecycleColdSetPriorityArgs' set_priority: Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        :param 'IndexLifecycleColdUnfollowArgs' unfollow: Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
        """
        if allocate is not None:
            pulumi.set(__self__, "allocate", allocate)
        if freeze is not None:
            pulumi.set(__self__, "freeze", freeze)
        if migrate is not None:
            pulumi.set(__self__, "migrate", migrate)
        if min_age is not None:
            pulumi.set(__self__, "min_age", min_age)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if searchable_snapshot is not None:
            pulumi.set(__self__, "searchable_snapshot", searchable_snapshot)
        if set_priority is not None:
            pulumi.set(__self__, "set_priority", set_priority)
        if unfollow is not None:
            pulumi.set(__self__, "unfollow", unfollow)

    @property
    @pulumi.getter
    def allocate(self) -> Optional['outputs.IndexLifecycleColdAllocate']:
        """
        Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.
        """
        return pulumi.get(self, "allocate")

    @property
    @pulumi.getter
    def freeze(self) -> Optional['outputs.IndexLifecycleColdFreeze']:
        """
        Freeze the index to minimize its memory footprint.
        """
        return pulumi.get(self, "freeze")

    @property
    @pulumi.getter
    def migrate(self) -> Optional['outputs.IndexLifecycleColdMigrate']:
        """
        Moves the index to the data tier that corresponds to the current phase by updating the "index.routing.allocation.include.*tier*preference" index setting.
        """
        return pulumi.get(self, "migrate")

    @property
    @pulumi.getter(name="minAge")
    def min_age(self) -> Optional[str]:
        """
        ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        """
        return pulumi.get(self, "min_age")

    @property
    @pulumi.getter
    def readonly(self) -> Optional['outputs.IndexLifecycleColdReadonly']:
        """
        Makes the index read-only.
        """
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter(name="searchableSnapshot")
    def searchable_snapshot(self) -> Optional['outputs.IndexLifecycleColdSearchableSnapshot']:
        """
        Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot.
        """
        return pulumi.get(self, "searchable_snapshot")

    @property
    @pulumi.getter(name="setPriority")
    def set_priority(self) -> Optional['outputs.IndexLifecycleColdSetPriority']:
        """
        Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        """
        return pulumi.get(self, "set_priority")

    @property
    @pulumi.getter
    def unfollow(self) -> Optional['outputs.IndexLifecycleColdUnfollow']:
        """
        Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
        """
        return pulumi.get(self, "unfollow")


@pulumi.output_type
class IndexLifecycleColdAllocate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfReplicas":
            suggest = "number_of_replicas"
        elif key == "totalShardsPerNode":
            suggest = "total_shards_per_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleColdAllocate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleColdAllocate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleColdAllocate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude: Optional[str] = None,
                 include: Optional[str] = None,
                 number_of_replicas: Optional[int] = None,
                 require: Optional[str] = None,
                 total_shards_per_node: Optional[int] = None):
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if number_of_replicas is not None:
            pulumi.set(__self__, "number_of_replicas", number_of_replicas)
        if require is not None:
            pulumi.set(__self__, "require", require)
        if total_shards_per_node is not None:
            pulumi.set(__self__, "total_shards_per_node", total_shards_per_node)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[str]:
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[str]:
        return pulumi.get(self, "include")

    @property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> Optional[int]:
        return pulumi.get(self, "number_of_replicas")

    @property
    @pulumi.getter
    def require(self) -> Optional[str]:
        return pulumi.get(self, "require")

    @property
    @pulumi.getter(name="totalShardsPerNode")
    def total_shards_per_node(self) -> Optional[int]:
        return pulumi.get(self, "total_shards_per_node")


@pulumi.output_type
class IndexLifecycleColdFreeze(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleColdMigrate(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleColdReadonly(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleColdSearchableSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotRepository":
            suggest = "snapshot_repository"
        elif key == "forceMergeIndex":
            suggest = "force_merge_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleColdSearchableSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleColdSearchableSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleColdSearchableSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_repository: str,
                 force_merge_index: Optional[bool] = None):
        pulumi.set(__self__, "snapshot_repository", snapshot_repository)
        if force_merge_index is not None:
            pulumi.set(__self__, "force_merge_index", force_merge_index)

    @property
    @pulumi.getter(name="snapshotRepository")
    def snapshot_repository(self) -> str:
        return pulumi.get(self, "snapshot_repository")

    @property
    @pulumi.getter(name="forceMergeIndex")
    def force_merge_index(self) -> Optional[bool]:
        return pulumi.get(self, "force_merge_index")


@pulumi.output_type
class IndexLifecycleColdSetPriority(dict):
    def __init__(__self__, *,
                 priority: int):
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")


@pulumi.output_type
class IndexLifecycleColdUnfollow(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleDelete(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAge":
            suggest = "min_age"
        elif key == "waitForSnapshot":
            suggest = "wait_for_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleDelete. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleDelete.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleDelete.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete: Optional['outputs.IndexLifecycleDeleteDelete'] = None,
                 min_age: Optional[str] = None,
                 wait_for_snapshot: Optional['outputs.IndexLifecycleDeleteWaitForSnapshot'] = None):
        """
        :param 'IndexLifecycleDeleteDeleteArgs' delete: Permanently removes the index.
        :param str min_age: ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        :param 'IndexLifecycleDeleteWaitForSnapshotArgs' wait_for_snapshot: Waits for the specified SLM policy to be executed before removing the index. This ensures that a snapshot of the deleted index is available.
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if min_age is not None:
            pulumi.set(__self__, "min_age", min_age)
        if wait_for_snapshot is not None:
            pulumi.set(__self__, "wait_for_snapshot", wait_for_snapshot)

    @property
    @pulumi.getter
    def delete(self) -> Optional['outputs.IndexLifecycleDeleteDelete']:
        """
        Permanently removes the index.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter(name="minAge")
    def min_age(self) -> Optional[str]:
        """
        ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        """
        return pulumi.get(self, "min_age")

    @property
    @pulumi.getter(name="waitForSnapshot")
    def wait_for_snapshot(self) -> Optional['outputs.IndexLifecycleDeleteWaitForSnapshot']:
        """
        Waits for the specified SLM policy to be executed before removing the index. This ensures that a snapshot of the deleted index is available.
        """
        return pulumi.get(self, "wait_for_snapshot")


@pulumi.output_type
class IndexLifecycleDeleteDelete(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteSearchableSnapshot":
            suggest = "delete_searchable_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleDeleteDelete. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleDeleteDelete.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleDeleteDelete.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_searchable_snapshot: Optional[bool] = None):
        if delete_searchable_snapshot is not None:
            pulumi.set(__self__, "delete_searchable_snapshot", delete_searchable_snapshot)

    @property
    @pulumi.getter(name="deleteSearchableSnapshot")
    def delete_searchable_snapshot(self) -> Optional[bool]:
        return pulumi.get(self, "delete_searchable_snapshot")


@pulumi.output_type
class IndexLifecycleDeleteWaitForSnapshot(dict):
    def __init__(__self__, *,
                 policy: str):
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")


@pulumi.output_type
class IndexLifecycleElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class IndexLifecycleFrozen(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAge":
            suggest = "min_age"
        elif key == "searchableSnapshot":
            suggest = "searchable_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleFrozen. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleFrozen.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleFrozen.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_age: Optional[str] = None,
                 searchable_snapshot: Optional['outputs.IndexLifecycleFrozenSearchableSnapshot'] = None):
        """
        :param str min_age: ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        :param 'IndexLifecycleFrozenSearchableSnapshotArgs' searchable_snapshot: Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot.
        """
        if min_age is not None:
            pulumi.set(__self__, "min_age", min_age)
        if searchable_snapshot is not None:
            pulumi.set(__self__, "searchable_snapshot", searchable_snapshot)

    @property
    @pulumi.getter(name="minAge")
    def min_age(self) -> Optional[str]:
        """
        ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        """
        return pulumi.get(self, "min_age")

    @property
    @pulumi.getter(name="searchableSnapshot")
    def searchable_snapshot(self) -> Optional['outputs.IndexLifecycleFrozenSearchableSnapshot']:
        """
        Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot.
        """
        return pulumi.get(self, "searchable_snapshot")


@pulumi.output_type
class IndexLifecycleFrozenSearchableSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotRepository":
            suggest = "snapshot_repository"
        elif key == "forceMergeIndex":
            suggest = "force_merge_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleFrozenSearchableSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleFrozenSearchableSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleFrozenSearchableSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_repository: str,
                 force_merge_index: Optional[bool] = None):
        pulumi.set(__self__, "snapshot_repository", snapshot_repository)
        if force_merge_index is not None:
            pulumi.set(__self__, "force_merge_index", force_merge_index)

    @property
    @pulumi.getter(name="snapshotRepository")
    def snapshot_repository(self) -> str:
        return pulumi.get(self, "snapshot_repository")

    @property
    @pulumi.getter(name="forceMergeIndex")
    def force_merge_index(self) -> Optional[bool]:
        return pulumi.get(self, "force_merge_index")


@pulumi.output_type
class IndexLifecycleHot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAge":
            suggest = "min_age"
        elif key == "searchableSnapshot":
            suggest = "searchable_snapshot"
        elif key == "setPriority":
            suggest = "set_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleHot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleHot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleHot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forcemerge: Optional['outputs.IndexLifecycleHotForcemerge'] = None,
                 min_age: Optional[str] = None,
                 readonly: Optional['outputs.IndexLifecycleHotReadonly'] = None,
                 rollover: Optional['outputs.IndexLifecycleHotRollover'] = None,
                 searchable_snapshot: Optional['outputs.IndexLifecycleHotSearchableSnapshot'] = None,
                 set_priority: Optional['outputs.IndexLifecycleHotSetPriority'] = None,
                 shrink: Optional['outputs.IndexLifecycleHotShrink'] = None,
                 unfollow: Optional['outputs.IndexLifecycleHotUnfollow'] = None):
        """
        :param 'IndexLifecycleHotForcemergeArgs' forcemerge: Force merges the index into the specified maximum number of segments. This action makes the index read-only.
        :param str min_age: ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        :param 'IndexLifecycleHotReadonlyArgs' readonly: Makes the index read-only.
        :param 'IndexLifecycleHotRolloverArgs' rollover: Rolls over a target to a new index when the existing index meets one or more of the rollover conditions.
        :param 'IndexLifecycleHotSearchableSnapshotArgs' searchable_snapshot: Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot.
        :param 'IndexLifecycleHotSetPriorityArgs' set_priority: Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        :param 'IndexLifecycleHotShrinkArgs' shrink: Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        :param 'IndexLifecycleHotUnfollowArgs' unfollow: Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
        """
        if forcemerge is not None:
            pulumi.set(__self__, "forcemerge", forcemerge)
        if min_age is not None:
            pulumi.set(__self__, "min_age", min_age)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if rollover is not None:
            pulumi.set(__self__, "rollover", rollover)
        if searchable_snapshot is not None:
            pulumi.set(__self__, "searchable_snapshot", searchable_snapshot)
        if set_priority is not None:
            pulumi.set(__self__, "set_priority", set_priority)
        if shrink is not None:
            pulumi.set(__self__, "shrink", shrink)
        if unfollow is not None:
            pulumi.set(__self__, "unfollow", unfollow)

    @property
    @pulumi.getter
    def forcemerge(self) -> Optional['outputs.IndexLifecycleHotForcemerge']:
        """
        Force merges the index into the specified maximum number of segments. This action makes the index read-only.
        """
        return pulumi.get(self, "forcemerge")

    @property
    @pulumi.getter(name="minAge")
    def min_age(self) -> Optional[str]:
        """
        ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        """
        return pulumi.get(self, "min_age")

    @property
    @pulumi.getter
    def readonly(self) -> Optional['outputs.IndexLifecycleHotReadonly']:
        """
        Makes the index read-only.
        """
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter
    def rollover(self) -> Optional['outputs.IndexLifecycleHotRollover']:
        """
        Rolls over a target to a new index when the existing index meets one or more of the rollover conditions.
        """
        return pulumi.get(self, "rollover")

    @property
    @pulumi.getter(name="searchableSnapshot")
    def searchable_snapshot(self) -> Optional['outputs.IndexLifecycleHotSearchableSnapshot']:
        """
        Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot.
        """
        return pulumi.get(self, "searchable_snapshot")

    @property
    @pulumi.getter(name="setPriority")
    def set_priority(self) -> Optional['outputs.IndexLifecycleHotSetPriority']:
        """
        Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        """
        return pulumi.get(self, "set_priority")

    @property
    @pulumi.getter
    def shrink(self) -> Optional['outputs.IndexLifecycleHotShrink']:
        """
        Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        """
        return pulumi.get(self, "shrink")

    @property
    @pulumi.getter
    def unfollow(self) -> Optional['outputs.IndexLifecycleHotUnfollow']:
        """
        Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
        """
        return pulumi.get(self, "unfollow")


@pulumi.output_type
class IndexLifecycleHotForcemerge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNumSegments":
            suggest = "max_num_segments"
        elif key == "indexCodec":
            suggest = "index_codec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleHotForcemerge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleHotForcemerge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleHotForcemerge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_num_segments: int,
                 index_codec: Optional[str] = None):
        pulumi.set(__self__, "max_num_segments", max_num_segments)
        if index_codec is not None:
            pulumi.set(__self__, "index_codec", index_codec)

    @property
    @pulumi.getter(name="maxNumSegments")
    def max_num_segments(self) -> int:
        return pulumi.get(self, "max_num_segments")

    @property
    @pulumi.getter(name="indexCodec")
    def index_codec(self) -> Optional[str]:
        return pulumi.get(self, "index_codec")


@pulumi.output_type
class IndexLifecycleHotReadonly(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleHotRollover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAge":
            suggest = "max_age"
        elif key == "maxDocs":
            suggest = "max_docs"
        elif key == "maxPrimaryShardSize":
            suggest = "max_primary_shard_size"
        elif key == "maxSize":
            suggest = "max_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleHotRollover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleHotRollover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleHotRollover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age: Optional[str] = None,
                 max_docs: Optional[int] = None,
                 max_primary_shard_size: Optional[str] = None,
                 max_size: Optional[str] = None):
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)
        if max_docs is not None:
            pulumi.set(__self__, "max_docs", max_docs)
        if max_primary_shard_size is not None:
            pulumi.set(__self__, "max_primary_shard_size", max_primary_shard_size)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        return pulumi.get(self, "max_age")

    @property
    @pulumi.getter(name="maxDocs")
    def max_docs(self) -> Optional[int]:
        return pulumi.get(self, "max_docs")

    @property
    @pulumi.getter(name="maxPrimaryShardSize")
    def max_primary_shard_size(self) -> Optional[str]:
        return pulumi.get(self, "max_primary_shard_size")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[str]:
        return pulumi.get(self, "max_size")


@pulumi.output_type
class IndexLifecycleHotSearchableSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotRepository":
            suggest = "snapshot_repository"
        elif key == "forceMergeIndex":
            suggest = "force_merge_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleHotSearchableSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleHotSearchableSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleHotSearchableSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_repository: str,
                 force_merge_index: Optional[bool] = None):
        pulumi.set(__self__, "snapshot_repository", snapshot_repository)
        if force_merge_index is not None:
            pulumi.set(__self__, "force_merge_index", force_merge_index)

    @property
    @pulumi.getter(name="snapshotRepository")
    def snapshot_repository(self) -> str:
        return pulumi.get(self, "snapshot_repository")

    @property
    @pulumi.getter(name="forceMergeIndex")
    def force_merge_index(self) -> Optional[bool]:
        return pulumi.get(self, "force_merge_index")


@pulumi.output_type
class IndexLifecycleHotSetPriority(dict):
    def __init__(__self__, *,
                 priority: int):
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")


@pulumi.output_type
class IndexLifecycleHotShrink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPrimaryShardSize":
            suggest = "max_primary_shard_size"
        elif key == "numberOfShards":
            suggest = "number_of_shards"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleHotShrink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleHotShrink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleHotShrink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_primary_shard_size: Optional[str] = None,
                 number_of_shards: Optional[int] = None):
        if max_primary_shard_size is not None:
            pulumi.set(__self__, "max_primary_shard_size", max_primary_shard_size)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)

    @property
    @pulumi.getter(name="maxPrimaryShardSize")
    def max_primary_shard_size(self) -> Optional[str]:
        return pulumi.get(self, "max_primary_shard_size")

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[int]:
        return pulumi.get(self, "number_of_shards")


@pulumi.output_type
class IndexLifecycleHotUnfollow(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleWarm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAge":
            suggest = "min_age"
        elif key == "setPriority":
            suggest = "set_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleWarm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleWarm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleWarm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocate: Optional['outputs.IndexLifecycleWarmAllocate'] = None,
                 forcemerge: Optional['outputs.IndexLifecycleWarmForcemerge'] = None,
                 migrate: Optional['outputs.IndexLifecycleWarmMigrate'] = None,
                 min_age: Optional[str] = None,
                 readonly: Optional['outputs.IndexLifecycleWarmReadonly'] = None,
                 set_priority: Optional['outputs.IndexLifecycleWarmSetPriority'] = None,
                 shrink: Optional['outputs.IndexLifecycleWarmShrink'] = None,
                 unfollow: Optional['outputs.IndexLifecycleWarmUnfollow'] = None):
        """
        :param 'IndexLifecycleWarmAllocateArgs' allocate: Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.
        :param 'IndexLifecycleWarmForcemergeArgs' forcemerge: Force merges the index into the specified maximum number of segments. This action makes the index read-only.
        :param 'IndexLifecycleWarmMigrateArgs' migrate: Moves the index to the data tier that corresponds to the current phase by updating the "index.routing.allocation.include.*tier*preference" index setting.
        :param str min_age: ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        :param 'IndexLifecycleWarmReadonlyArgs' readonly: Makes the index read-only.
        :param 'IndexLifecycleWarmSetPriorityArgs' set_priority: Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        :param 'IndexLifecycleWarmShrinkArgs' shrink: Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        :param 'IndexLifecycleWarmUnfollowArgs' unfollow: Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
        """
        if allocate is not None:
            pulumi.set(__self__, "allocate", allocate)
        if forcemerge is not None:
            pulumi.set(__self__, "forcemerge", forcemerge)
        if migrate is not None:
            pulumi.set(__self__, "migrate", migrate)
        if min_age is not None:
            pulumi.set(__self__, "min_age", min_age)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if set_priority is not None:
            pulumi.set(__self__, "set_priority", set_priority)
        if shrink is not None:
            pulumi.set(__self__, "shrink", shrink)
        if unfollow is not None:
            pulumi.set(__self__, "unfollow", unfollow)

    @property
    @pulumi.getter
    def allocate(self) -> Optional['outputs.IndexLifecycleWarmAllocate']:
        """
        Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.
        """
        return pulumi.get(self, "allocate")

    @property
    @pulumi.getter
    def forcemerge(self) -> Optional['outputs.IndexLifecycleWarmForcemerge']:
        """
        Force merges the index into the specified maximum number of segments. This action makes the index read-only.
        """
        return pulumi.get(self, "forcemerge")

    @property
    @pulumi.getter
    def migrate(self) -> Optional['outputs.IndexLifecycleWarmMigrate']:
        """
        Moves the index to the data tier that corresponds to the current phase by updating the "index.routing.allocation.include.*tier*preference" index setting.
        """
        return pulumi.get(self, "migrate")

    @property
    @pulumi.getter(name="minAge")
    def min_age(self) -> Optional[str]:
        """
        ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a minimum age for each phase.
        """
        return pulumi.get(self, "min_age")

    @property
    @pulumi.getter
    def readonly(self) -> Optional['outputs.IndexLifecycleWarmReadonly']:
        """
        Makes the index read-only.
        """
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter(name="setPriority")
    def set_priority(self) -> Optional['outputs.IndexLifecycleWarmSetPriority']:
        """
        Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        """
        return pulumi.get(self, "set_priority")

    @property
    @pulumi.getter
    def shrink(self) -> Optional['outputs.IndexLifecycleWarmShrink']:
        """
        Sets a source index to read-only and shrinks it into a new index with fewer primary shards.
        """
        return pulumi.get(self, "shrink")

    @property
    @pulumi.getter
    def unfollow(self) -> Optional['outputs.IndexLifecycleWarmUnfollow']:
        """
        Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
        """
        return pulumi.get(self, "unfollow")


@pulumi.output_type
class IndexLifecycleWarmAllocate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfReplicas":
            suggest = "number_of_replicas"
        elif key == "totalShardsPerNode":
            suggest = "total_shards_per_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleWarmAllocate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleWarmAllocate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleWarmAllocate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude: Optional[str] = None,
                 include: Optional[str] = None,
                 number_of_replicas: Optional[int] = None,
                 require: Optional[str] = None,
                 total_shards_per_node: Optional[int] = None):
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if number_of_replicas is not None:
            pulumi.set(__self__, "number_of_replicas", number_of_replicas)
        if require is not None:
            pulumi.set(__self__, "require", require)
        if total_shards_per_node is not None:
            pulumi.set(__self__, "total_shards_per_node", total_shards_per_node)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[str]:
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[str]:
        return pulumi.get(self, "include")

    @property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> Optional[int]:
        return pulumi.get(self, "number_of_replicas")

    @property
    @pulumi.getter
    def require(self) -> Optional[str]:
        return pulumi.get(self, "require")

    @property
    @pulumi.getter(name="totalShardsPerNode")
    def total_shards_per_node(self) -> Optional[int]:
        return pulumi.get(self, "total_shards_per_node")


@pulumi.output_type
class IndexLifecycleWarmForcemerge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNumSegments":
            suggest = "max_num_segments"
        elif key == "indexCodec":
            suggest = "index_codec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleWarmForcemerge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleWarmForcemerge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleWarmForcemerge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_num_segments: int,
                 index_codec: Optional[str] = None):
        pulumi.set(__self__, "max_num_segments", max_num_segments)
        if index_codec is not None:
            pulumi.set(__self__, "index_codec", index_codec)

    @property
    @pulumi.getter(name="maxNumSegments")
    def max_num_segments(self) -> int:
        return pulumi.get(self, "max_num_segments")

    @property
    @pulumi.getter(name="indexCodec")
    def index_codec(self) -> Optional[str]:
        return pulumi.get(self, "index_codec")


@pulumi.output_type
class IndexLifecycleWarmMigrate(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleWarmReadonly(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexLifecycleWarmSetPriority(dict):
    def __init__(__self__, *,
                 priority: int):
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")


@pulumi.output_type
class IndexLifecycleWarmShrink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPrimaryShardSize":
            suggest = "max_primary_shard_size"
        elif key == "numberOfShards":
            suggest = "number_of_shards"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLifecycleWarmShrink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLifecycleWarmShrink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLifecycleWarmShrink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_primary_shard_size: Optional[str] = None,
                 number_of_shards: Optional[int] = None):
        if max_primary_shard_size is not None:
            pulumi.set(__self__, "max_primary_shard_size", max_primary_shard_size)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)

    @property
    @pulumi.getter(name="maxPrimaryShardSize")
    def max_primary_shard_size(self) -> Optional[str]:
        return pulumi.get(self, "max_primary_shard_size")

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[int]:
        return pulumi.get(self, "number_of_shards")


@pulumi.output_type
class IndexLifecycleWarmUnfollow(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IndexSettings(dict):
    def __init__(__self__, *,
                 settings: Sequence['outputs.IndexSettingsSetting']):
        """
        :param Sequence['IndexSettingsSettingArgs'] settings: Defines the setting for the index.
        """
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.IndexSettingsSetting']:
        """
        Defines the setting for the index.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class IndexSettingsSetting(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the index you wish to create.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the index you wish to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class IndexTemplateDataStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCustomRouting":
            suggest = "allow_custom_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexTemplateDataStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexTemplateDataStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexTemplateDataStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_custom_routing: Optional[bool] = None,
                 hidden: Optional[bool] = None):
        """
        :param bool allow_custom_routing: If `true`, the data stream supports custom routing. Defaults to `false`. Available only in **8.x**
        :param bool hidden: If true, the data stream is hidden.
        """
        if allow_custom_routing is not None:
            pulumi.set(__self__, "allow_custom_routing", allow_custom_routing)
        if hidden is not None:
            pulumi.set(__self__, "hidden", hidden)

    @property
    @pulumi.getter(name="allowCustomRouting")
    def allow_custom_routing(self) -> Optional[bool]:
        """
        If `true`, the data stream supports custom routing. Defaults to `false`. Available only in **8.x**
        """
        return pulumi.get(self, "allow_custom_routing")

    @property
    @pulumi.getter
    def hidden(self) -> Optional[bool]:
        """
        If true, the data stream is hidden.
        """
        return pulumi.get(self, "hidden")


@pulumi.output_type
class IndexTemplateElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexTemplateElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexTemplateElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexTemplateElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class IndexTemplateTemplate(dict):
    def __init__(__self__, *,
                 aliases: Optional[Sequence['outputs.IndexTemplateTemplateAlias']] = None,
                 mappings: Optional[str] = None,
                 settings: Optional[str] = None):
        """
        :param Sequence['IndexTemplateTemplateAliasArgs'] aliases: Alias to add.
        :param str mappings: Mapping for fields in the index.
        :param str settings: Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence['outputs.IndexTemplateTemplateAlias']]:
        """
        Alias to add.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[str]:
        """
        Mapping for fields in the index.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter
    def settings(self) -> Optional[str]:
        """
        Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class IndexTemplateTemplateAlias(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexRouting":
            suggest = "index_routing"
        elif key == "isHidden":
            suggest = "is_hidden"
        elif key == "isWriteIndex":
            suggest = "is_write_index"
        elif key == "searchRouting":
            suggest = "search_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexTemplateTemplateAlias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexTemplateTemplateAlias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexTemplateTemplateAlias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 filter: Optional[str] = None,
                 index_routing: Optional[str] = None,
                 is_hidden: Optional[bool] = None,
                 is_write_index: Optional[bool] = None,
                 routing: Optional[str] = None,
                 search_routing: Optional[str] = None):
        """
        :param str name: Name of the index template to create.
        """
        pulumi.set(__self__, "name", name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if index_routing is not None:
            pulumi.set(__self__, "index_routing", index_routing)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if is_write_index is not None:
            pulumi.set(__self__, "is_write_index", is_write_index)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if search_routing is not None:
            pulumi.set(__self__, "search_routing", search_routing)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the index template to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="indexRouting")
    def index_routing(self) -> Optional[str]:
        return pulumi.get(self, "index_routing")

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[bool]:
        return pulumi.get(self, "is_hidden")

    @property
    @pulumi.getter(name="isWriteIndex")
    def is_write_index(self) -> Optional[bool]:
        return pulumi.get(self, "is_write_index")

    @property
    @pulumi.getter
    def routing(self) -> Optional[str]:
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="searchRouting")
    def search_routing(self) -> Optional[str]:
        return pulumi.get(self, "search_routing")


@pulumi.output_type
class IngestPipelineElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngestPipelineElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngestPipelineElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngestPipelineElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class LogstashPipelineElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogstashPipelineElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogstashPipelineElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogstashPipelineElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ScriptElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityApiKeyElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityApiKeyElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityApiKeyElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityApiKeyElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityRoleApplication(dict):
    def __init__(__self__, *,
                 application: str,
                 privileges: Sequence[str],
                 resources: Sequence[str]):
        """
        :param str application: The name of the application to which this entry applies.
        :param Sequence[str] privileges: A list of strings, where each element is the name of an application privilege or action.
        :param Sequence[str] resources: A list resources to which the privileges are applied.
        """
        pulumi.set(__self__, "application", application)
        pulumi.set(__self__, "privileges", privileges)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def application(self) -> str:
        """
        The name of the application to which this entry applies.
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter
    def privileges(self) -> Sequence[str]:
        """
        A list of strings, where each element is the name of an application privilege or action.
        """
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A list resources to which the privileges are applied.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class SecurityRoleElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRoleElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRoleElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRoleElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityRoleIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowRestrictedIndices":
            suggest = "allow_restricted_indices"
        elif key == "fieldSecurity":
            suggest = "field_security"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRoleIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRoleIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRoleIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 names: Sequence[str],
                 privileges: Sequence[str],
                 allow_restricted_indices: Optional[bool] = None,
                 field_security: Optional['outputs.SecurityRoleIndexFieldSecurity'] = None,
                 query: Optional[str] = None):
        """
        :param Sequence[str] names: A list of indices (or index name patterns) to which the permissions in this entry apply.
        :param Sequence[str] privileges: The index level privileges that the owners of the role have on the specified indices.
        :param bool allow_restricted_indices: Include matching restricted indices in names parameter. Usage is strongly discouraged as it can grant unrestricted operations on critical data, make the entire system unstable or leak sensitive information.
        :param 'SecurityRoleIndexFieldSecurityArgs' field_security: The document fields that the owners of the role have read access to.
        :param str query: A search query that defines the documents the owners of the role have read access to.
        """
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "privileges", privileges)
        if allow_restricted_indices is not None:
            pulumi.set(__self__, "allow_restricted_indices", allow_restricted_indices)
        if field_security is not None:
            pulumi.set(__self__, "field_security", field_security)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of indices (or index name patterns) to which the permissions in this entry apply.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def privileges(self) -> Sequence[str]:
        """
        The index level privileges that the owners of the role have on the specified indices.
        """
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter(name="allowRestrictedIndices")
    def allow_restricted_indices(self) -> Optional[bool]:
        """
        Include matching restricted indices in names parameter. Usage is strongly discouraged as it can grant unrestricted operations on critical data, make the entire system unstable or leak sensitive information.
        """
        return pulumi.get(self, "allow_restricted_indices")

    @property
    @pulumi.getter(name="fieldSecurity")
    def field_security(self) -> Optional['outputs.SecurityRoleIndexFieldSecurity']:
        """
        The document fields that the owners of the role have read access to.
        """
        return pulumi.get(self, "field_security")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        A search query that defines the documents the owners of the role have read access to.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class SecurityRoleIndexFieldSecurity(dict):
    def __init__(__self__, *,
                 excepts: Optional[Sequence[str]] = None,
                 grants: Optional[Sequence[str]] = None):
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "excepts")

    @property
    @pulumi.getter
    def grants(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "grants")


@pulumi.output_type
class SecurityRoleMappingElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRoleMappingElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRoleMappingElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRoleMappingElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecuritySystemUserElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecuritySystemUserElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecuritySystemUserElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecuritySystemUserElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityUserElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityUserElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityUserElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityUserElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SnapshotLifecycleElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotLifecycleElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotLifecycleElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotLifecycleElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SnapshotRepositoryAzure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basePath":
            suggest = "base_path"
        elif key == "chunkSize":
            suggest = "chunk_size"
        elif key == "locationMode":
            suggest = "location_mode"
        elif key == "maxRestoreBytesPerSec":
            suggest = "max_restore_bytes_per_sec"
        elif key == "maxSnapshotBytesPerSec":
            suggest = "max_snapshot_bytes_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryAzure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryAzure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryAzure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: str,
                 base_path: Optional[str] = None,
                 chunk_size: Optional[str] = None,
                 client: Optional[str] = None,
                 compress: Optional[bool] = None,
                 location_mode: Optional[str] = None,
                 max_restore_bytes_per_sec: Optional[str] = None,
                 max_snapshot_bytes_per_sec: Optional[str] = None,
                 readonly: Optional[bool] = None):
        """
        :param str container: Container name. You must create the Azure container before creating the repository.
        :param str base_path: Specifies the path within the container to the repository data.
        :param str chunk_size: Maximum size of files in snapshots.
        :param str client: Azure named client to use.
        :param bool compress: If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        :param str location_mode: Location mode. `primary_only` or `secondary_only`. See: https://docs.microsoft.com/en-us/azure/storage/common/storage-redundancy
        :param str max_restore_bytes_per_sec: Maximum snapshot restore rate per node.
        :param str max_snapshot_bytes_per_sec: Maximum snapshot creation rate per node.
        :param bool readonly: If true, the repository is read-only.
        """
        pulumi.set(__self__, "container", container)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if location_mode is not None:
            pulumi.set(__self__, "location_mode", location_mode)
        if max_restore_bytes_per_sec is not None:
            pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        if max_snapshot_bytes_per_sec is not None:
            pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        Container name. You must create the Azure container before creating the repository.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[str]:
        """
        Specifies the path within the container to the repository data.
        """
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[str]:
        """
        Maximum size of files in snapshots.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def client(self) -> Optional[str]:
        """
        Azure named client to use.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="locationMode")
    def location_mode(self) -> Optional[str]:
        """
        Location mode. `primary_only` or `secondary_only`. See: https://docs.microsoft.com/en-us/azure/storage/common/storage-redundancy
        """
        return pulumi.get(self, "location_mode")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot restore rate per node.
        """
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot creation rate per node.
        """
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        If true, the repository is read-only.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class SnapshotRepositoryElasticsearchConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "caData":
            suggest = "ca_data"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "certData":
            suggest = "cert_data"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyData":
            suggest = "key_data"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryElasticsearchConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryElasticsearchConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryElasticsearchConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 ca_data: Optional[str] = None,
                 ca_file: Optional[str] = None,
                 cert_data: Optional[str] = None,
                 cert_file: Optional[str] = None,
                 endpoints: Optional[Sequence[str]] = None,
                 insecure: Optional[bool] = None,
                 key_data: Optional[str] = None,
                 key_file: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str api_key: API Key to use for authentication to Elasticsearch
        :param str ca_data: PEM-encoded custom Certificate Authority certificate
        :param str ca_file: Path to a custom Certificate Authority certificate
        :param str cert_data: PEM encoded certificate for client auth
        :param str cert_file: Path to a file containing the PEM encoded certificate for client auth
        :param bool insecure: Disable TLS certificate validation
        :param str key_data: PEM encoded private key for client auth
        :param str key_file: Path to a file containing the PEM encoded private key for client auth
        :param str password: Password to use for API authentication to Elasticsearch.
        :param str username: Username to use for API authentication to Elasticsearch.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if ca_data is not None:
            pulumi.set(__self__, "ca_data", ca_data)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        API Key to use for authentication to Elasticsearch
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="caData")
    def ca_data(self) -> Optional[str]:
        """
        PEM-encoded custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_data")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        Path to a custom Certificate Authority certificate
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded certificate for client auth
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disable TLS certificate validation
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[str]:
        """
        Path to a file containing the PEM encoded private key for client auth
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for API authentication to Elasticsearch.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SnapshotRepositoryFs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkSize":
            suggest = "chunk_size"
        elif key == "maxNumberOfSnapshots":
            suggest = "max_number_of_snapshots"
        elif key == "maxRestoreBytesPerSec":
            suggest = "max_restore_bytes_per_sec"
        elif key == "maxSnapshotBytesPerSec":
            suggest = "max_snapshot_bytes_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryFs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryFs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryFs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 chunk_size: Optional[str] = None,
                 compress: Optional[bool] = None,
                 max_number_of_snapshots: Optional[int] = None,
                 max_restore_bytes_per_sec: Optional[str] = None,
                 max_snapshot_bytes_per_sec: Optional[str] = None,
                 readonly: Optional[bool] = None):
        """
        :param str location: Location of the shared filesystem used to store and retrieve snapshots.
        :param str chunk_size: Maximum size of files in snapshots.
        :param bool compress: If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        :param int max_number_of_snapshots: Maximum number of snapshots the repository can contain.
        :param str max_restore_bytes_per_sec: Maximum snapshot restore rate per node.
        :param str max_snapshot_bytes_per_sec: Maximum snapshot creation rate per node.
        :param bool readonly: If true, the repository is read-only.
        """
        pulumi.set(__self__, "location", location)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if max_number_of_snapshots is not None:
            pulumi.set(__self__, "max_number_of_snapshots", max_number_of_snapshots)
        if max_restore_bytes_per_sec is not None:
            pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        if max_snapshot_bytes_per_sec is not None:
            pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Location of the shared filesystem used to store and retrieve snapshots.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[str]:
        """
        Maximum size of files in snapshots.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="maxNumberOfSnapshots")
    def max_number_of_snapshots(self) -> Optional[int]:
        """
        Maximum number of snapshots the repository can contain.
        """
        return pulumi.get(self, "max_number_of_snapshots")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot restore rate per node.
        """
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot creation rate per node.
        """
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        If true, the repository is read-only.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class SnapshotRepositoryGcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basePath":
            suggest = "base_path"
        elif key == "chunkSize":
            suggest = "chunk_size"
        elif key == "maxRestoreBytesPerSec":
            suggest = "max_restore_bytes_per_sec"
        elif key == "maxSnapshotBytesPerSec":
            suggest = "max_snapshot_bytes_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryGcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryGcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryGcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 base_path: Optional[str] = None,
                 chunk_size: Optional[str] = None,
                 client: Optional[str] = None,
                 compress: Optional[bool] = None,
                 max_restore_bytes_per_sec: Optional[str] = None,
                 max_snapshot_bytes_per_sec: Optional[str] = None,
                 readonly: Optional[bool] = None):
        """
        :param str bucket: The name of the bucket to be used for snapshots.
        :param str base_path: Specifies the path within the bucket to the repository data. Defaults to the root of the bucket.
        :param str chunk_size: Maximum size of files in snapshots.
        :param str client: The name of the client to use to connect to Google Cloud Storage.
        :param bool compress: If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        :param str max_restore_bytes_per_sec: Maximum snapshot restore rate per node.
        :param str max_snapshot_bytes_per_sec: Maximum snapshot creation rate per node.
        :param bool readonly: If true, the repository is read-only.
        """
        pulumi.set(__self__, "bucket", bucket)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if max_restore_bytes_per_sec is not None:
            pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        if max_snapshot_bytes_per_sec is not None:
            pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket to be used for snapshots.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[str]:
        """
        Specifies the path within the bucket to the repository data. Defaults to the root of the bucket.
        """
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[str]:
        """
        Maximum size of files in snapshots.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def client(self) -> Optional[str]:
        """
        The name of the client to use to connect to Google Cloud Storage.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot restore rate per node.
        """
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot creation rate per node.
        """
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        If true, the repository is read-only.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class SnapshotRepositoryHdfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkSize":
            suggest = "chunk_size"
        elif key == "loadDefaults":
            suggest = "load_defaults"
        elif key == "maxRestoreBytesPerSec":
            suggest = "max_restore_bytes_per_sec"
        elif key == "maxSnapshotBytesPerSec":
            suggest = "max_snapshot_bytes_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryHdfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryHdfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryHdfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 uri: str,
                 chunk_size: Optional[str] = None,
                 compress: Optional[bool] = None,
                 load_defaults: Optional[bool] = None,
                 max_restore_bytes_per_sec: Optional[str] = None,
                 max_snapshot_bytes_per_sec: Optional[str] = None,
                 readonly: Optional[bool] = None):
        """
        :param str path: The file path within the filesystem where data is stored/loaded.
        :param str uri: The uri address for hdfs. ex: "hdfs://\\n\\n:\\n\\n/".
        :param str chunk_size: Maximum size of files in snapshots.
        :param bool compress: If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        :param bool load_defaults: Whether to load the default Hadoop configuration or not.
        :param str max_restore_bytes_per_sec: Maximum snapshot restore rate per node.
        :param str max_snapshot_bytes_per_sec: Maximum snapshot creation rate per node.
        :param bool readonly: If true, the repository is read-only.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "uri", uri)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if load_defaults is not None:
            pulumi.set(__self__, "load_defaults", load_defaults)
        if max_restore_bytes_per_sec is not None:
            pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        if max_snapshot_bytes_per_sec is not None:
            pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The file path within the filesystem where data is stored/loaded.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The uri address for hdfs. ex: "hdfs://\\n\\n:\\n\\n/".
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[str]:
        """
        Maximum size of files in snapshots.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="loadDefaults")
    def load_defaults(self) -> Optional[bool]:
        """
        Whether to load the default Hadoop configuration or not.
        """
        return pulumi.get(self, "load_defaults")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot restore rate per node.
        """
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot creation rate per node.
        """
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        If true, the repository is read-only.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class SnapshotRepositoryS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basePath":
            suggest = "base_path"
        elif key == "bufferSize":
            suggest = "buffer_size"
        elif key == "cannedAcl":
            suggest = "canned_acl"
        elif key == "chunkSize":
            suggest = "chunk_size"
        elif key == "maxRestoreBytesPerSec":
            suggest = "max_restore_bytes_per_sec"
        elif key == "maxSnapshotBytesPerSec":
            suggest = "max_snapshot_bytes_per_sec"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 base_path: Optional[str] = None,
                 buffer_size: Optional[str] = None,
                 canned_acl: Optional[str] = None,
                 chunk_size: Optional[str] = None,
                 client: Optional[str] = None,
                 compress: Optional[bool] = None,
                 max_restore_bytes_per_sec: Optional[str] = None,
                 max_snapshot_bytes_per_sec: Optional[str] = None,
                 readonly: Optional[bool] = None,
                 server_side_encryption: Optional[bool] = None,
                 storage_class: Optional[str] = None):
        """
        :param str bucket: Name of the S3 bucket to use for snapshots.
        :param str base_path: Specifies the path to the repository data within its bucket.
        :param str buffer_size: Minimum threshold below which the chunk is uploaded using a single request.
        :param str canned_acl: The S3 repository supports all S3 canned ACLs.
        :param str chunk_size: Maximum size of files in snapshots.
        :param str client: The name of the S3 client to use to connect to S3.
        :param bool compress: If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        :param str max_restore_bytes_per_sec: Maximum snapshot restore rate per node.
        :param str max_snapshot_bytes_per_sec: Maximum snapshot creation rate per node.
        :param bool readonly: If true, the repository is read-only.
        :param bool server_side_encryption: When true, files are encrypted server-side using AES-256 algorithm.
        :param str storage_class: Sets the S3 storage class for objects stored in the snapshot repository.
        """
        pulumi.set(__self__, "bucket", bucket)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if buffer_size is not None:
            pulumi.set(__self__, "buffer_size", buffer_size)
        if canned_acl is not None:
            pulumi.set(__self__, "canned_acl", canned_acl)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if max_restore_bytes_per_sec is not None:
            pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        if max_snapshot_bytes_per_sec is not None:
            pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the S3 bucket to use for snapshots.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[str]:
        """
        Specifies the path to the repository data within its bucket.
        """
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> Optional[str]:
        """
        Minimum threshold below which the chunk is uploaded using a single request.
        """
        return pulumi.get(self, "buffer_size")

    @property
    @pulumi.getter(name="cannedAcl")
    def canned_acl(self) -> Optional[str]:
        """
        The S3 repository supports all S3 canned ACLs.
        """
        return pulumi.get(self, "canned_acl")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[str]:
        """
        Maximum size of files in snapshots.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def client(self) -> Optional[str]:
        """
        The name of the S3 client to use to connect to S3.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot restore rate per node.
        """
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot creation rate per node.
        """
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        If true, the repository is read-only.
        """
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[bool]:
        """
        When true, files are encrypted server-side using AES-256 algorithm.
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        Sets the S3 storage class for objects stored in the snapshot repository.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class SnapshotRepositoryUrl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkSize":
            suggest = "chunk_size"
        elif key == "httpMaxRetries":
            suggest = "http_max_retries"
        elif key == "httpSocketTimeout":
            suggest = "http_socket_timeout"
        elif key == "maxNumberOfSnapshots":
            suggest = "max_number_of_snapshots"
        elif key == "maxRestoreBytesPerSec":
            suggest = "max_restore_bytes_per_sec"
        elif key == "maxSnapshotBytesPerSec":
            suggest = "max_snapshot_bytes_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryUrl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryUrl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryUrl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 chunk_size: Optional[str] = None,
                 compress: Optional[bool] = None,
                 http_max_retries: Optional[int] = None,
                 http_socket_timeout: Optional[str] = None,
                 max_number_of_snapshots: Optional[int] = None,
                 max_restore_bytes_per_sec: Optional[str] = None,
                 max_snapshot_bytes_per_sec: Optional[str] = None,
                 readonly: Optional[bool] = None):
        """
        :param str url: URL location of the root of the shared filesystem repository.
        :param str chunk_size: Maximum size of files in snapshots.
        :param bool compress: If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        :param int http_max_retries: Maximum number of retries for http and https URLs.
        :param str http_socket_timeout: Maximum wait time for data transfers over a connection.
        :param int max_number_of_snapshots: Maximum number of snapshots the repository can contain.
        :param str max_restore_bytes_per_sec: Maximum snapshot restore rate per node.
        :param str max_snapshot_bytes_per_sec: Maximum snapshot creation rate per node.
        :param bool readonly: If true, the repository is read-only.
        """
        pulumi.set(__self__, "url", url)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if http_max_retries is not None:
            pulumi.set(__self__, "http_max_retries", http_max_retries)
        if http_socket_timeout is not None:
            pulumi.set(__self__, "http_socket_timeout", http_socket_timeout)
        if max_number_of_snapshots is not None:
            pulumi.set(__self__, "max_number_of_snapshots", max_number_of_snapshots)
        if max_restore_bytes_per_sec is not None:
            pulumi.set(__self__, "max_restore_bytes_per_sec", max_restore_bytes_per_sec)
        if max_snapshot_bytes_per_sec is not None:
            pulumi.set(__self__, "max_snapshot_bytes_per_sec", max_snapshot_bytes_per_sec)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL location of the root of the shared filesystem repository.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[str]:
        """
        Maximum size of files in snapshots.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        If true, metadata files, such as index mappings and settings, are compressed in snapshots.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="httpMaxRetries")
    def http_max_retries(self) -> Optional[int]:
        """
        Maximum number of retries for http and https URLs.
        """
        return pulumi.get(self, "http_max_retries")

    @property
    @pulumi.getter(name="httpSocketTimeout")
    def http_socket_timeout(self) -> Optional[str]:
        """
        Maximum wait time for data transfers over a connection.
        """
        return pulumi.get(self, "http_socket_timeout")

    @property
    @pulumi.getter(name="maxNumberOfSnapshots")
    def max_number_of_snapshots(self) -> Optional[int]:
        """
        Maximum number of snapshots the repository can contain.
        """
        return pulumi.get(self, "max_number_of_snapshots")

    @property
    @pulumi.getter(name="maxRestoreBytesPerSec")
    def max_restore_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot restore rate per node.
        """
        return pulumi.get(self, "max_restore_bytes_per_sec")

    @property
    @pulumi.getter(name="maxSnapshotBytesPerSec")
    def max_snapshot_bytes_per_sec(self) -> Optional[str]:
        """
        Maximum snapshot creation rate per node.
        """
        return pulumi.get(self, "max_snapshot_bytes_per_sec")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        If true, the repository is read-only.
        """
        return pulumi.get(self, "readonly")


