# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogstashPipelineArgs', 'LogstashPipeline']

@pulumi.input_type
class LogstashPipelineArgs:
    def __init__(__self__, *,
                 pipeline: pulumi.Input[str],
                 pipeline_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['LogstashPipelineElasticsearchConnectionArgs']] = None,
                 pipeline_batch_delay: Optional[pulumi.Input[int]] = None,
                 pipeline_batch_size: Optional[pulumi.Input[int]] = None,
                 pipeline_ecs_compatibility: Optional[pulumi.Input[str]] = None,
                 pipeline_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pipeline_ordered: Optional[pulumi.Input[str]] = None,
                 pipeline_plugin_classloaders: Optional[pulumi.Input[bool]] = None,
                 pipeline_unsafe_shutdown: Optional[pulumi.Input[bool]] = None,
                 pipeline_workers: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_acks: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_retry: Optional[pulumi.Input[bool]] = None,
                 queue_checkpoint_writes: Optional[pulumi.Input[int]] = None,
                 queue_drain: Optional[pulumi.Input[bool]] = None,
                 queue_max_bytes_number: Optional[pulumi.Input[int]] = None,
                 queue_max_bytes_units: Optional[pulumi.Input[str]] = None,
                 queue_max_events: Optional[pulumi.Input[int]] = None,
                 queue_page_capacity: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LogstashPipeline resource.
        :param pulumi.Input[str] pipeline: Configuration for the pipeline.
        :param pulumi.Input[str] pipeline_id: Identifier for the pipeline.
        :param pulumi.Input[str] description: Description of the pipeline.
        :param pulumi.Input['LogstashPipelineElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[int] pipeline_batch_delay: Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        :param pulumi.Input[int] pipeline_batch_size: The maximum number of events an individual worker thread collects before executing filters and outputs.
        :param pulumi.Input[str] pipeline_ecs_compatibility: Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pipeline_metadata: Optional metadata about the pipeline.
        :param pulumi.Input[str] pipeline_ordered: Set the pipeline event ordering.
        :param pulumi.Input[bool] pipeline_plugin_classloaders: (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        :param pulumi.Input[bool] pipeline_unsafe_shutdown: Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        :param pulumi.Input[int] pipeline_workers: The number of parallel workers used to run the filter and output stages of the pipeline.
        :param pulumi.Input[int] queue_checkpoint_acks: The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_checkpoint_retry: When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        :param pulumi.Input[int] queue_checkpoint_writes: The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_drain: When enabled, Logstash waits until the persistent queue is drained before shutting down.
        :param pulumi.Input[int] queue_max_bytes_number: The total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_max_bytes_units: Units for the total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[int] queue_max_events: The maximum number of unread events in the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_page_capacity: The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        :param pulumi.Input[str] queue_type: The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        :param pulumi.Input[str] username: User who last updated the pipeline.
        """
        pulumi.set(__self__, "pipeline", pipeline)
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if pipeline_batch_delay is not None:
            pulumi.set(__self__, "pipeline_batch_delay", pipeline_batch_delay)
        if pipeline_batch_size is not None:
            pulumi.set(__self__, "pipeline_batch_size", pipeline_batch_size)
        if pipeline_ecs_compatibility is not None:
            pulumi.set(__self__, "pipeline_ecs_compatibility", pipeline_ecs_compatibility)
        if pipeline_metadata is not None:
            pulumi.set(__self__, "pipeline_metadata", pipeline_metadata)
        if pipeline_ordered is not None:
            pulumi.set(__self__, "pipeline_ordered", pipeline_ordered)
        if pipeline_plugin_classloaders is not None:
            pulumi.set(__self__, "pipeline_plugin_classloaders", pipeline_plugin_classloaders)
        if pipeline_unsafe_shutdown is not None:
            pulumi.set(__self__, "pipeline_unsafe_shutdown", pipeline_unsafe_shutdown)
        if pipeline_workers is not None:
            pulumi.set(__self__, "pipeline_workers", pipeline_workers)
        if queue_checkpoint_acks is not None:
            pulumi.set(__self__, "queue_checkpoint_acks", queue_checkpoint_acks)
        if queue_checkpoint_retry is not None:
            pulumi.set(__self__, "queue_checkpoint_retry", queue_checkpoint_retry)
        if queue_checkpoint_writes is not None:
            pulumi.set(__self__, "queue_checkpoint_writes", queue_checkpoint_writes)
        if queue_drain is not None:
            pulumi.set(__self__, "queue_drain", queue_drain)
        if queue_max_bytes_number is not None:
            pulumi.set(__self__, "queue_max_bytes_number", queue_max_bytes_number)
        if queue_max_bytes_units is not None:
            pulumi.set(__self__, "queue_max_bytes_units", queue_max_bytes_units)
        if queue_max_events is not None:
            pulumi.set(__self__, "queue_max_events", queue_max_events)
        if queue_page_capacity is not None:
            pulumi.set(__self__, "queue_page_capacity", queue_page_capacity)
        if queue_type is not None:
            pulumi.set(__self__, "queue_type", queue_type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Input[str]:
        """
        Configuration for the pipeline.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: pulumi.Input[str]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[str]:
        """
        Identifier for the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['LogstashPipelineElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['LogstashPipelineElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="pipelineBatchDelay")
    def pipeline_batch_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        """
        return pulumi.get(self, "pipeline_batch_delay")

    @pipeline_batch_delay.setter
    def pipeline_batch_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_batch_delay", value)

    @property
    @pulumi.getter(name="pipelineBatchSize")
    def pipeline_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of events an individual worker thread collects before executing filters and outputs.
        """
        return pulumi.get(self, "pipeline_batch_size")

    @pipeline_batch_size.setter
    def pipeline_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_batch_size", value)

    @property
    @pulumi.getter(name="pipelineEcsCompatibility")
    def pipeline_ecs_compatibility(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        """
        return pulumi.get(self, "pipeline_ecs_compatibility")

    @pipeline_ecs_compatibility.setter
    def pipeline_ecs_compatibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_ecs_compatibility", value)

    @property
    @pulumi.getter(name="pipelineMetadata")
    def pipeline_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional metadata about the pipeline.
        """
        return pulumi.get(self, "pipeline_metadata")

    @pipeline_metadata.setter
    def pipeline_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pipeline_metadata", value)

    @property
    @pulumi.getter(name="pipelineOrdered")
    def pipeline_ordered(self) -> Optional[pulumi.Input[str]]:
        """
        Set the pipeline event ordering.
        """
        return pulumi.get(self, "pipeline_ordered")

    @pipeline_ordered.setter
    def pipeline_ordered(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_ordered", value)

    @property
    @pulumi.getter(name="pipelinePluginClassloaders")
    def pipeline_plugin_classloaders(self) -> Optional[pulumi.Input[bool]]:
        """
        (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        """
        return pulumi.get(self, "pipeline_plugin_classloaders")

    @pipeline_plugin_classloaders.setter
    def pipeline_plugin_classloaders(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_plugin_classloaders", value)

    @property
    @pulumi.getter(name="pipelineUnsafeShutdown")
    def pipeline_unsafe_shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        """
        return pulumi.get(self, "pipeline_unsafe_shutdown")

    @pipeline_unsafe_shutdown.setter
    def pipeline_unsafe_shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_unsafe_shutdown", value)

    @property
    @pulumi.getter(name="pipelineWorkers")
    def pipeline_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The number of parallel workers used to run the filter and output stages of the pipeline.
        """
        return pulumi.get(self, "pipeline_workers")

    @pipeline_workers.setter
    def pipeline_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_workers", value)

    @property
    @pulumi.getter(name="queueCheckpointAcks")
    def queue_checkpoint_acks(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_checkpoint_acks")

    @queue_checkpoint_acks.setter
    def queue_checkpoint_acks(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_checkpoint_acks", value)

    @property
    @pulumi.getter(name="queueCheckpointRetry")
    def queue_checkpoint_retry(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        """
        return pulumi.get(self, "queue_checkpoint_retry")

    @queue_checkpoint_retry.setter
    def queue_checkpoint_retry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queue_checkpoint_retry", value)

    @property
    @pulumi.getter(name="queueCheckpointWrites")
    def queue_checkpoint_writes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_checkpoint_writes")

    @queue_checkpoint_writes.setter
    def queue_checkpoint_writes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_checkpoint_writes", value)

    @property
    @pulumi.getter(name="queueDrain")
    def queue_drain(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Logstash waits until the persistent queue is drained before shutting down.
        """
        return pulumi.get(self, "queue_drain")

    @queue_drain.setter
    def queue_drain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queue_drain", value)

    @property
    @pulumi.getter(name="queueMaxBytesNumber")
    def queue_max_bytes_number(self) -> Optional[pulumi.Input[int]]:
        """
        The total capacity of the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_bytes_number")

    @queue_max_bytes_number.setter
    def queue_max_bytes_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_max_bytes_number", value)

    @property
    @pulumi.getter(name="queueMaxBytesUnits")
    def queue_max_bytes_units(self) -> Optional[pulumi.Input[str]]:
        """
        Units for the total capacity of the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_bytes_units")

    @queue_max_bytes_units.setter
    def queue_max_bytes_units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_max_bytes_units", value)

    @property
    @pulumi.getter(name="queueMaxEvents")
    def queue_max_events(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of unread events in the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_events")

    @queue_max_events.setter
    def queue_max_events(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_max_events", value)

    @property
    @pulumi.getter(name="queuePageCapacity")
    def queue_page_capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        """
        return pulumi.get(self, "queue_page_capacity")

    @queue_page_capacity.setter
    def queue_page_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_page_capacity", value)

    @property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> Optional[pulumi.Input[str]]:
        """
        The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        """
        return pulumi.get(self, "queue_type")

    @queue_type.setter
    def queue_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_type", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        User who last updated the pipeline.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _LogstashPipelineState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['LogstashPipelineElasticsearchConnectionArgs']] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 pipeline_batch_delay: Optional[pulumi.Input[int]] = None,
                 pipeline_batch_size: Optional[pulumi.Input[int]] = None,
                 pipeline_ecs_compatibility: Optional[pulumi.Input[str]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 pipeline_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pipeline_ordered: Optional[pulumi.Input[str]] = None,
                 pipeline_plugin_classloaders: Optional[pulumi.Input[bool]] = None,
                 pipeline_unsafe_shutdown: Optional[pulumi.Input[bool]] = None,
                 pipeline_workers: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_acks: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_retry: Optional[pulumi.Input[bool]] = None,
                 queue_checkpoint_writes: Optional[pulumi.Input[int]] = None,
                 queue_drain: Optional[pulumi.Input[bool]] = None,
                 queue_max_bytes_number: Optional[pulumi.Input[int]] = None,
                 queue_max_bytes_units: Optional[pulumi.Input[str]] = None,
                 queue_max_events: Optional[pulumi.Input[int]] = None,
                 queue_page_capacity: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogstashPipeline resources.
        :param pulumi.Input[str] description: Description of the pipeline.
        :param pulumi.Input['LogstashPipelineElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] last_modified: Date the pipeline was last updated.
        :param pulumi.Input[str] pipeline: Configuration for the pipeline.
        :param pulumi.Input[int] pipeline_batch_delay: Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        :param pulumi.Input[int] pipeline_batch_size: The maximum number of events an individual worker thread collects before executing filters and outputs.
        :param pulumi.Input[str] pipeline_ecs_compatibility: Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        :param pulumi.Input[str] pipeline_id: Identifier for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pipeline_metadata: Optional metadata about the pipeline.
        :param pulumi.Input[str] pipeline_ordered: Set the pipeline event ordering.
        :param pulumi.Input[bool] pipeline_plugin_classloaders: (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        :param pulumi.Input[bool] pipeline_unsafe_shutdown: Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        :param pulumi.Input[int] pipeline_workers: The number of parallel workers used to run the filter and output stages of the pipeline.
        :param pulumi.Input[int] queue_checkpoint_acks: The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_checkpoint_retry: When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        :param pulumi.Input[int] queue_checkpoint_writes: The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_drain: When enabled, Logstash waits until the persistent queue is drained before shutting down.
        :param pulumi.Input[int] queue_max_bytes_number: The total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_max_bytes_units: Units for the total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[int] queue_max_events: The maximum number of unread events in the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_page_capacity: The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        :param pulumi.Input[str] queue_type: The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        :param pulumi.Input[str] username: User who last updated the pipeline.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if pipeline_batch_delay is not None:
            pulumi.set(__self__, "pipeline_batch_delay", pipeline_batch_delay)
        if pipeline_batch_size is not None:
            pulumi.set(__self__, "pipeline_batch_size", pipeline_batch_size)
        if pipeline_ecs_compatibility is not None:
            pulumi.set(__self__, "pipeline_ecs_compatibility", pipeline_ecs_compatibility)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_metadata is not None:
            pulumi.set(__self__, "pipeline_metadata", pipeline_metadata)
        if pipeline_ordered is not None:
            pulumi.set(__self__, "pipeline_ordered", pipeline_ordered)
        if pipeline_plugin_classloaders is not None:
            pulumi.set(__self__, "pipeline_plugin_classloaders", pipeline_plugin_classloaders)
        if pipeline_unsafe_shutdown is not None:
            pulumi.set(__self__, "pipeline_unsafe_shutdown", pipeline_unsafe_shutdown)
        if pipeline_workers is not None:
            pulumi.set(__self__, "pipeline_workers", pipeline_workers)
        if queue_checkpoint_acks is not None:
            pulumi.set(__self__, "queue_checkpoint_acks", queue_checkpoint_acks)
        if queue_checkpoint_retry is not None:
            pulumi.set(__self__, "queue_checkpoint_retry", queue_checkpoint_retry)
        if queue_checkpoint_writes is not None:
            pulumi.set(__self__, "queue_checkpoint_writes", queue_checkpoint_writes)
        if queue_drain is not None:
            pulumi.set(__self__, "queue_drain", queue_drain)
        if queue_max_bytes_number is not None:
            pulumi.set(__self__, "queue_max_bytes_number", queue_max_bytes_number)
        if queue_max_bytes_units is not None:
            pulumi.set(__self__, "queue_max_bytes_units", queue_max_bytes_units)
        if queue_max_events is not None:
            pulumi.set(__self__, "queue_max_events", queue_max_events)
        if queue_page_capacity is not None:
            pulumi.set(__self__, "queue_page_capacity", queue_page_capacity)
        if queue_type is not None:
            pulumi.set(__self__, "queue_type", queue_type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['LogstashPipelineElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['LogstashPipelineElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Date the pipeline was last updated.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration for the pipeline.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="pipelineBatchDelay")
    def pipeline_batch_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        """
        return pulumi.get(self, "pipeline_batch_delay")

    @pipeline_batch_delay.setter
    def pipeline_batch_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_batch_delay", value)

    @property
    @pulumi.getter(name="pipelineBatchSize")
    def pipeline_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of events an individual worker thread collects before executing filters and outputs.
        """
        return pulumi.get(self, "pipeline_batch_size")

    @pipeline_batch_size.setter
    def pipeline_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_batch_size", value)

    @property
    @pulumi.getter(name="pipelineEcsCompatibility")
    def pipeline_ecs_compatibility(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        """
        return pulumi.get(self, "pipeline_ecs_compatibility")

    @pipeline_ecs_compatibility.setter
    def pipeline_ecs_compatibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_ecs_compatibility", value)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="pipelineMetadata")
    def pipeline_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional metadata about the pipeline.
        """
        return pulumi.get(self, "pipeline_metadata")

    @pipeline_metadata.setter
    def pipeline_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pipeline_metadata", value)

    @property
    @pulumi.getter(name="pipelineOrdered")
    def pipeline_ordered(self) -> Optional[pulumi.Input[str]]:
        """
        Set the pipeline event ordering.
        """
        return pulumi.get(self, "pipeline_ordered")

    @pipeline_ordered.setter
    def pipeline_ordered(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_ordered", value)

    @property
    @pulumi.getter(name="pipelinePluginClassloaders")
    def pipeline_plugin_classloaders(self) -> Optional[pulumi.Input[bool]]:
        """
        (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        """
        return pulumi.get(self, "pipeline_plugin_classloaders")

    @pipeline_plugin_classloaders.setter
    def pipeline_plugin_classloaders(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_plugin_classloaders", value)

    @property
    @pulumi.getter(name="pipelineUnsafeShutdown")
    def pipeline_unsafe_shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        """
        return pulumi.get(self, "pipeline_unsafe_shutdown")

    @pipeline_unsafe_shutdown.setter
    def pipeline_unsafe_shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_unsafe_shutdown", value)

    @property
    @pulumi.getter(name="pipelineWorkers")
    def pipeline_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The number of parallel workers used to run the filter and output stages of the pipeline.
        """
        return pulumi.get(self, "pipeline_workers")

    @pipeline_workers.setter
    def pipeline_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_workers", value)

    @property
    @pulumi.getter(name="queueCheckpointAcks")
    def queue_checkpoint_acks(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_checkpoint_acks")

    @queue_checkpoint_acks.setter
    def queue_checkpoint_acks(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_checkpoint_acks", value)

    @property
    @pulumi.getter(name="queueCheckpointRetry")
    def queue_checkpoint_retry(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        """
        return pulumi.get(self, "queue_checkpoint_retry")

    @queue_checkpoint_retry.setter
    def queue_checkpoint_retry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queue_checkpoint_retry", value)

    @property
    @pulumi.getter(name="queueCheckpointWrites")
    def queue_checkpoint_writes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_checkpoint_writes")

    @queue_checkpoint_writes.setter
    def queue_checkpoint_writes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_checkpoint_writes", value)

    @property
    @pulumi.getter(name="queueDrain")
    def queue_drain(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Logstash waits until the persistent queue is drained before shutting down.
        """
        return pulumi.get(self, "queue_drain")

    @queue_drain.setter
    def queue_drain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queue_drain", value)

    @property
    @pulumi.getter(name="queueMaxBytesNumber")
    def queue_max_bytes_number(self) -> Optional[pulumi.Input[int]]:
        """
        The total capacity of the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_bytes_number")

    @queue_max_bytes_number.setter
    def queue_max_bytes_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_max_bytes_number", value)

    @property
    @pulumi.getter(name="queueMaxBytesUnits")
    def queue_max_bytes_units(self) -> Optional[pulumi.Input[str]]:
        """
        Units for the total capacity of the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_bytes_units")

    @queue_max_bytes_units.setter
    def queue_max_bytes_units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_max_bytes_units", value)

    @property
    @pulumi.getter(name="queueMaxEvents")
    def queue_max_events(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of unread events in the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_events")

    @queue_max_events.setter
    def queue_max_events(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_max_events", value)

    @property
    @pulumi.getter(name="queuePageCapacity")
    def queue_page_capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        """
        return pulumi.get(self, "queue_page_capacity")

    @queue_page_capacity.setter
    def queue_page_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_page_capacity", value)

    @property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> Optional[pulumi.Input[str]]:
        """
        The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        """
        return pulumi.get(self, "queue_type")

    @queue_type.setter
    def queue_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_type", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        User who last updated the pipeline.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class LogstashPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['LogstashPipelineElasticsearchConnectionArgs']]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 pipeline_batch_delay: Optional[pulumi.Input[int]] = None,
                 pipeline_batch_size: Optional[pulumi.Input[int]] = None,
                 pipeline_ecs_compatibility: Optional[pulumi.Input[str]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 pipeline_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pipeline_ordered: Optional[pulumi.Input[str]] = None,
                 pipeline_plugin_classloaders: Optional[pulumi.Input[bool]] = None,
                 pipeline_unsafe_shutdown: Optional[pulumi.Input[bool]] = None,
                 pipeline_workers: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_acks: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_retry: Optional[pulumi.Input[bool]] = None,
                 queue_checkpoint_writes: Optional[pulumi.Input[int]] = None,
                 queue_drain: Optional[pulumi.Input[bool]] = None,
                 queue_max_bytes_number: Optional[pulumi.Input[int]] = None,
                 queue_max_bytes_units: Optional[pulumi.Input[str]] = None,
                 queue_max_events: Optional[pulumi.Input[int]] = None,
                 queue_page_capacity: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates or updates centrally managed logstash pipelines. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/logstash-apis.html

        ## Example Usage

        ```python
        import pulumi
        import pulumi_elasticstack as elasticstack

        example = elasticstack.LogstashPipeline("example",
            pipeline_id="test_pipeline",
            description="This is an example pipeline",
            pipeline=\"\"\"input{}
        filter{}
        output{}
        \"\"\",
            pipeline_metadata={
                "type": "logstash_pipeline",
                "version": "1",
            },
            pipeline_batch_delay=50,
            pipeline_batch_size=125,
            pipeline_ecs_compatibility="disabled",
            pipeline_ordered="auto",
            pipeline_plugin_classloaders=False,
            pipeline_unsafe_shutdown=False,
            pipeline_workers=1,
            queue_checkpoint_acks=1024,
            queue_checkpoint_retry=True,
            queue_checkpoint_writes=1024,
            queue_drain=False,
            queue_max_bytes_number=1,
            queue_max_bytes_units="gb",
            queue_max_events=0,
            queue_page_capacity="64mb",
            queue_type="persisted")
        pulumi.export("pipeline", example.pipeline_id)
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/logstashPipeline:LogstashPipeline my_pipeline <cluster_uuid>/<pipeline ID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the pipeline.
        :param pulumi.Input[pulumi.InputType['LogstashPipelineElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] pipeline: Configuration for the pipeline.
        :param pulumi.Input[int] pipeline_batch_delay: Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        :param pulumi.Input[int] pipeline_batch_size: The maximum number of events an individual worker thread collects before executing filters and outputs.
        :param pulumi.Input[str] pipeline_ecs_compatibility: Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        :param pulumi.Input[str] pipeline_id: Identifier for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pipeline_metadata: Optional metadata about the pipeline.
        :param pulumi.Input[str] pipeline_ordered: Set the pipeline event ordering.
        :param pulumi.Input[bool] pipeline_plugin_classloaders: (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        :param pulumi.Input[bool] pipeline_unsafe_shutdown: Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        :param pulumi.Input[int] pipeline_workers: The number of parallel workers used to run the filter and output stages of the pipeline.
        :param pulumi.Input[int] queue_checkpoint_acks: The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_checkpoint_retry: When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        :param pulumi.Input[int] queue_checkpoint_writes: The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_drain: When enabled, Logstash waits until the persistent queue is drained before shutting down.
        :param pulumi.Input[int] queue_max_bytes_number: The total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_max_bytes_units: Units for the total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[int] queue_max_events: The maximum number of unread events in the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_page_capacity: The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        :param pulumi.Input[str] queue_type: The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        :param pulumi.Input[str] username: User who last updated the pipeline.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogstashPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or updates centrally managed logstash pipelines. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/logstash-apis.html

        ## Example Usage

        ```python
        import pulumi
        import pulumi_elasticstack as elasticstack

        example = elasticstack.LogstashPipeline("example",
            pipeline_id="test_pipeline",
            description="This is an example pipeline",
            pipeline=\"\"\"input{}
        filter{}
        output{}
        \"\"\",
            pipeline_metadata={
                "type": "logstash_pipeline",
                "version": "1",
            },
            pipeline_batch_delay=50,
            pipeline_batch_size=125,
            pipeline_ecs_compatibility="disabled",
            pipeline_ordered="auto",
            pipeline_plugin_classloaders=False,
            pipeline_unsafe_shutdown=False,
            pipeline_workers=1,
            queue_checkpoint_acks=1024,
            queue_checkpoint_retry=True,
            queue_checkpoint_writes=1024,
            queue_drain=False,
            queue_max_bytes_number=1,
            queue_max_bytes_units="gb",
            queue_max_events=0,
            queue_page_capacity="64mb",
            queue_type="persisted")
        pulumi.export("pipeline", example.pipeline_id)
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/logstashPipeline:LogstashPipeline my_pipeline <cluster_uuid>/<pipeline ID>
        ```

        :param str resource_name: The name of the resource.
        :param LogstashPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogstashPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['LogstashPipelineElasticsearchConnectionArgs']]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 pipeline_batch_delay: Optional[pulumi.Input[int]] = None,
                 pipeline_batch_size: Optional[pulumi.Input[int]] = None,
                 pipeline_ecs_compatibility: Optional[pulumi.Input[str]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 pipeline_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pipeline_ordered: Optional[pulumi.Input[str]] = None,
                 pipeline_plugin_classloaders: Optional[pulumi.Input[bool]] = None,
                 pipeline_unsafe_shutdown: Optional[pulumi.Input[bool]] = None,
                 pipeline_workers: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_acks: Optional[pulumi.Input[int]] = None,
                 queue_checkpoint_retry: Optional[pulumi.Input[bool]] = None,
                 queue_checkpoint_writes: Optional[pulumi.Input[int]] = None,
                 queue_drain: Optional[pulumi.Input[bool]] = None,
                 queue_max_bytes_number: Optional[pulumi.Input[int]] = None,
                 queue_max_bytes_units: Optional[pulumi.Input[str]] = None,
                 queue_max_events: Optional[pulumi.Input[int]] = None,
                 queue_page_capacity: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogstashPipelineArgs.__new__(LogstashPipelineArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            if pipeline is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline'")
            __props__.__dict__["pipeline"] = pipeline
            __props__.__dict__["pipeline_batch_delay"] = pipeline_batch_delay
            __props__.__dict__["pipeline_batch_size"] = pipeline_batch_size
            __props__.__dict__["pipeline_ecs_compatibility"] = pipeline_ecs_compatibility
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["pipeline_metadata"] = pipeline_metadata
            __props__.__dict__["pipeline_ordered"] = pipeline_ordered
            __props__.__dict__["pipeline_plugin_classloaders"] = pipeline_plugin_classloaders
            __props__.__dict__["pipeline_unsafe_shutdown"] = pipeline_unsafe_shutdown
            __props__.__dict__["pipeline_workers"] = pipeline_workers
            __props__.__dict__["queue_checkpoint_acks"] = queue_checkpoint_acks
            __props__.__dict__["queue_checkpoint_retry"] = queue_checkpoint_retry
            __props__.__dict__["queue_checkpoint_writes"] = queue_checkpoint_writes
            __props__.__dict__["queue_drain"] = queue_drain
            __props__.__dict__["queue_max_bytes_number"] = queue_max_bytes_number
            __props__.__dict__["queue_max_bytes_units"] = queue_max_bytes_units
            __props__.__dict__["queue_max_events"] = queue_max_events
            __props__.__dict__["queue_page_capacity"] = queue_page_capacity
            __props__.__dict__["queue_type"] = queue_type
            __props__.__dict__["username"] = username
            __props__.__dict__["last_modified"] = None
        super(LogstashPipeline, __self__).__init__(
            'elasticstack:index/logstashPipeline:LogstashPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['LogstashPipelineElasticsearchConnectionArgs']]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            pipeline: Optional[pulumi.Input[str]] = None,
            pipeline_batch_delay: Optional[pulumi.Input[int]] = None,
            pipeline_batch_size: Optional[pulumi.Input[int]] = None,
            pipeline_ecs_compatibility: Optional[pulumi.Input[str]] = None,
            pipeline_id: Optional[pulumi.Input[str]] = None,
            pipeline_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            pipeline_ordered: Optional[pulumi.Input[str]] = None,
            pipeline_plugin_classloaders: Optional[pulumi.Input[bool]] = None,
            pipeline_unsafe_shutdown: Optional[pulumi.Input[bool]] = None,
            pipeline_workers: Optional[pulumi.Input[int]] = None,
            queue_checkpoint_acks: Optional[pulumi.Input[int]] = None,
            queue_checkpoint_retry: Optional[pulumi.Input[bool]] = None,
            queue_checkpoint_writes: Optional[pulumi.Input[int]] = None,
            queue_drain: Optional[pulumi.Input[bool]] = None,
            queue_max_bytes_number: Optional[pulumi.Input[int]] = None,
            queue_max_bytes_units: Optional[pulumi.Input[str]] = None,
            queue_max_events: Optional[pulumi.Input[int]] = None,
            queue_page_capacity: Optional[pulumi.Input[str]] = None,
            queue_type: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'LogstashPipeline':
        """
        Get an existing LogstashPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the pipeline.
        :param pulumi.Input[pulumi.InputType['LogstashPipelineElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] last_modified: Date the pipeline was last updated.
        :param pulumi.Input[str] pipeline: Configuration for the pipeline.
        :param pulumi.Input[int] pipeline_batch_delay: Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        :param pulumi.Input[int] pipeline_batch_size: The maximum number of events an individual worker thread collects before executing filters and outputs.
        :param pulumi.Input[str] pipeline_ecs_compatibility: Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        :param pulumi.Input[str] pipeline_id: Identifier for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pipeline_metadata: Optional metadata about the pipeline.
        :param pulumi.Input[str] pipeline_ordered: Set the pipeline event ordering.
        :param pulumi.Input[bool] pipeline_plugin_classloaders: (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        :param pulumi.Input[bool] pipeline_unsafe_shutdown: Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        :param pulumi.Input[int] pipeline_workers: The number of parallel workers used to run the filter and output stages of the pipeline.
        :param pulumi.Input[int] queue_checkpoint_acks: The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_checkpoint_retry: When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        :param pulumi.Input[int] queue_checkpoint_writes: The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        :param pulumi.Input[bool] queue_drain: When enabled, Logstash waits until the persistent queue is drained before shutting down.
        :param pulumi.Input[int] queue_max_bytes_number: The total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_max_bytes_units: Units for the total capacity of the queue when persistent queues are enabled.
        :param pulumi.Input[int] queue_max_events: The maximum number of unread events in the queue when persistent queues are enabled.
        :param pulumi.Input[str] queue_page_capacity: The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        :param pulumi.Input[str] queue_type: The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        :param pulumi.Input[str] username: User who last updated the pipeline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogstashPipelineState.__new__(_LogstashPipelineState)

        __props__.__dict__["description"] = description
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["pipeline"] = pipeline
        __props__.__dict__["pipeline_batch_delay"] = pipeline_batch_delay
        __props__.__dict__["pipeline_batch_size"] = pipeline_batch_size
        __props__.__dict__["pipeline_ecs_compatibility"] = pipeline_ecs_compatibility
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["pipeline_metadata"] = pipeline_metadata
        __props__.__dict__["pipeline_ordered"] = pipeline_ordered
        __props__.__dict__["pipeline_plugin_classloaders"] = pipeline_plugin_classloaders
        __props__.__dict__["pipeline_unsafe_shutdown"] = pipeline_unsafe_shutdown
        __props__.__dict__["pipeline_workers"] = pipeline_workers
        __props__.__dict__["queue_checkpoint_acks"] = queue_checkpoint_acks
        __props__.__dict__["queue_checkpoint_retry"] = queue_checkpoint_retry
        __props__.__dict__["queue_checkpoint_writes"] = queue_checkpoint_writes
        __props__.__dict__["queue_drain"] = queue_drain
        __props__.__dict__["queue_max_bytes_number"] = queue_max_bytes_number
        __props__.__dict__["queue_max_bytes_units"] = queue_max_bytes_units
        __props__.__dict__["queue_max_events"] = queue_max_events
        __props__.__dict__["queue_page_capacity"] = queue_page_capacity
        __props__.__dict__["queue_type"] = queue_type
        __props__.__dict__["username"] = username
        return LogstashPipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.LogstashPipelineElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        Date the pipeline was last updated.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Output[str]:
        """
        Configuration for the pipeline.
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="pipelineBatchDelay")
    def pipeline_batch_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
        """
        return pulumi.get(self, "pipeline_batch_delay")

    @property
    @pulumi.getter(name="pipelineBatchSize")
    def pipeline_batch_size(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of events an individual worker thread collects before executing filters and outputs.
        """
        return pulumi.get(self, "pipeline_batch_size")

    @property
    @pulumi.getter(name="pipelineEcsCompatibility")
    def pipeline_ecs_compatibility(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the pipeline default value for ecs_compatibility, a setting that is available to plugins that implement an ECS compatibility mode for use with the Elastic Common Schema.
        """
        return pulumi.get(self, "pipeline_ecs_compatibility")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[str]:
        """
        Identifier for the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="pipelineMetadata")
    def pipeline_metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional metadata about the pipeline.
        """
        return pulumi.get(self, "pipeline_metadata")

    @property
    @pulumi.getter(name="pipelineOrdered")
    def pipeline_ordered(self) -> pulumi.Output[Optional[str]]:
        """
        Set the pipeline event ordering.
        """
        return pulumi.get(self, "pipeline_ordered")

    @property
    @pulumi.getter(name="pipelinePluginClassloaders")
    def pipeline_plugin_classloaders(self) -> pulumi.Output[Optional[bool]]:
        """
        (Beta) Load Java plugins in independent classloaders to isolate their dependencies.
        """
        return pulumi.get(self, "pipeline_plugin_classloaders")

    @property
    @pulumi.getter(name="pipelineUnsafeShutdown")
    def pipeline_unsafe_shutdown(self) -> pulumi.Output[Optional[bool]]:
        """
        Forces Logstash to exit during shutdown even if there are still inflight events in memory.
        """
        return pulumi.get(self, "pipeline_unsafe_shutdown")

    @property
    @pulumi.getter(name="pipelineWorkers")
    def pipeline_workers(self) -> pulumi.Output[Optional[int]]:
        """
        The number of parallel workers used to run the filter and output stages of the pipeline.
        """
        return pulumi.get(self, "pipeline_workers")

    @property
    @pulumi.getter(name="queueCheckpointAcks")
    def queue_checkpoint_acks(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of ACKed events before forcing a checkpoint when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_checkpoint_acks")

    @property
    @pulumi.getter(name="queueCheckpointRetry")
    def queue_checkpoint_retry(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, Logstash will retry four times per attempted checkpoint write for any checkpoint writes that fail. Any subsequent errors are not retried.
        """
        return pulumi.get(self, "queue_checkpoint_retry")

    @property
    @pulumi.getter(name="queueCheckpointWrites")
    def queue_checkpoint_writes(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of written events before forcing a checkpoint when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_checkpoint_writes")

    @property
    @pulumi.getter(name="queueDrain")
    def queue_drain(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, Logstash waits until the persistent queue is drained before shutting down.
        """
        return pulumi.get(self, "queue_drain")

    @property
    @pulumi.getter(name="queueMaxBytesNumber")
    def queue_max_bytes_number(self) -> pulumi.Output[Optional[int]]:
        """
        The total capacity of the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_bytes_number")

    @property
    @pulumi.getter(name="queueMaxBytesUnits")
    def queue_max_bytes_units(self) -> pulumi.Output[Optional[str]]:
        """
        Units for the total capacity of the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_bytes_units")

    @property
    @pulumi.getter(name="queueMaxEvents")
    def queue_max_events(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of unread events in the queue when persistent queues are enabled.
        """
        return pulumi.get(self, "queue_max_events")

    @property
    @pulumi.getter(name="queuePageCapacity")
    def queue_page_capacity(self) -> pulumi.Output[Optional[str]]:
        """
        The size of the page data files used when persistent queues are enabled. The queue data consists of append-only data files separated into pages.
        """
        return pulumi.get(self, "queue_page_capacity")

    @property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> pulumi.Output[Optional[str]]:
        """
        The internal queueing model for event buffering. Options are memory for in-memory queueing, or persisted for disk-based acknowledged queueing.
        """
        return pulumi.get(self, "queue_type")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        User who last updated the pipeline.
        """
        return pulumi.get(self, "username")

