# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorUserAgentResult',
    'AwaitableIngestProcessorUserAgentResult',
    'ingest_processor_user_agent',
    'ingest_processor_user_agent_output',
]

@pulumi.output_type
class IngestProcessorUserAgentResult:
    """
    A collection of values returned by IngestProcessorUserAgent.
    """
    def __init__(__self__, extract_device_type=None, field=None, id=None, ignore_missing=None, json=None, properties=None, regex_file=None, target_field=None):
        if extract_device_type and not isinstance(extract_device_type, bool):
            raise TypeError("Expected argument 'extract_device_type' to be a bool")
        pulumi.set(__self__, "extract_device_type", extract_device_type)
        if field and not isinstance(field, str):
            raise TypeError("Expected argument 'field' to be a str")
        pulumi.set(__self__, "field", field)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_missing and not isinstance(ignore_missing, bool):
            raise TypeError("Expected argument 'ignore_missing' to be a bool")
        pulumi.set(__self__, "ignore_missing", ignore_missing)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if regex_file and not isinstance(regex_file, str):
            raise TypeError("Expected argument 'regex_file' to be a str")
        pulumi.set(__self__, "regex_file", regex_file)
        if target_field and not isinstance(target_field, str):
            raise TypeError("Expected argument 'target_field' to be a str")
        pulumi.set(__self__, "target_field", target_field)

    @property
    @pulumi.getter(name="extractDeviceType")
    def extract_device_type(self) -> Optional[bool]:
        """
        Extracts device type from the user agent string on a best-effort basis. Supported only starting from Elasticsearch version **8.0**
        """
        return pulumi.get(self, "extract_device_type")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The field containing the user agent string.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreMissing")
    def ignore_missing(self) -> Optional[bool]:
        """
        If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
        """
        return pulumi.get(self, "ignore_missing")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence[str]]:
        """
        Controls what properties are added to `target_field`.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="regexFile")
    def regex_file(self) -> Optional[str]:
        """
        The name of the file in the `config/ingest-user-agent` directory containing the regular expressions for parsing the user agent string.
        """
        return pulumi.get(self, "regex_file")

    @property
    @pulumi.getter(name="targetField")
    def target_field(self) -> Optional[str]:
        """
        The field that will be filled with the user agent details.
        """
        return pulumi.get(self, "target_field")


class AwaitableIngestProcessorUserAgentResult(IngestProcessorUserAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorUserAgentResult(
            extract_device_type=self.extract_device_type,
            field=self.field,
            id=self.id,
            ignore_missing=self.ignore_missing,
            json=self.json,
            properties=self.properties,
            regex_file=self.regex_file,
            target_field=self.target_field)


def ingest_processor_user_agent(extract_device_type: Optional[bool] = None,
                                field: Optional[str] = None,
                                ignore_missing: Optional[bool] = None,
                                properties: Optional[Sequence[str]] = None,
                                regex_file: Optional[str] = None,
                                target_field: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorUserAgentResult:
    """
    The `user_agent` processor extracts details from the user agent string a browser sends with its web requests. This processor adds this information by default under the `user_agent` field.

    The ingest-user-agent module ships by default with the regexes.yaml made available by uap-java with an Apache 2.0 license. For more details see https://github.com/ua-parser/uap-core.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/user-agent-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    agent = elasticstack.ingest_processor_user_agent(field="agent")
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[agent.json])
    ```


    :param bool extract_device_type: Extracts device type from the user agent string on a best-effort basis. Supported only starting from Elasticsearch version **8.0**
    :param str field: The field containing the user agent string.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param Sequence[str] properties: Controls what properties are added to `target_field`.
    :param str regex_file: The name of the file in the `config/ingest-user-agent` directory containing the regular expressions for parsing the user agent string.
    :param str target_field: The field that will be filled with the user agent details.
    """
    __args__ = dict()
    __args__['extractDeviceType'] = extract_device_type
    __args__['field'] = field
    __args__['ignoreMissing'] = ignore_missing
    __args__['properties'] = properties
    __args__['regexFile'] = regex_file
    __args__['targetField'] = target_field
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorUserAgent:IngestProcessorUserAgent', __args__, opts=opts, typ=IngestProcessorUserAgentResult).value

    return AwaitableIngestProcessorUserAgentResult(
        extract_device_type=__ret__.extract_device_type,
        field=__ret__.field,
        id=__ret__.id,
        ignore_missing=__ret__.ignore_missing,
        json=__ret__.json,
        properties=__ret__.properties,
        regex_file=__ret__.regex_file,
        target_field=__ret__.target_field)


@_utilities.lift_output_func(ingest_processor_user_agent)
def ingest_processor_user_agent_output(extract_device_type: Optional[pulumi.Input[Optional[bool]]] = None,
                                       field: Optional[pulumi.Input[str]] = None,
                                       ignore_missing: Optional[pulumi.Input[Optional[bool]]] = None,
                                       properties: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       regex_file: Optional[pulumi.Input[Optional[str]]] = None,
                                       target_field: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorUserAgentResult]:
    """
    The `user_agent` processor extracts details from the user agent string a browser sends with its web requests. This processor adds this information by default under the `user_agent` field.

    The ingest-user-agent module ships by default with the regexes.yaml made available by uap-java with an Apache 2.0 license. For more details see https://github.com/ua-parser/uap-core.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/user-agent-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    agent = elasticstack.ingest_processor_user_agent(field="agent")
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[agent.json])
    ```


    :param bool extract_device_type: Extracts device type from the user agent string on a best-effort basis. Supported only starting from Elasticsearch version **8.0**
    :param str field: The field containing the user agent string.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param Sequence[str] properties: Controls what properties are added to `target_field`.
    :param str regex_file: The name of the file in the `config/ingest-user-agent` directory containing the regular expressions for parsing the user agent string.
    :param str target_field: The field that will be filled with the user agent details.
    """
    ...
