# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorScriptResult',
    'AwaitableIngestProcessorScriptResult',
    'ingest_processor_script',
    'ingest_processor_script_output',
]

@pulumi.output_type
class IngestProcessorScriptResult:
    """
    A collection of values returned by IngestProcessorScript.
    """
    def __init__(__self__, description=None, id=None, if_=None, ignore_failure=None, json=None, lang=None, on_failures=None, params=None, script_id=None, source=None, tag=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if if_ and not isinstance(if_, str):
            raise TypeError("Expected argument 'if_' to be a str")
        pulumi.set(__self__, "if_", if_)
        if ignore_failure and not isinstance(ignore_failure, bool):
            raise TypeError("Expected argument 'ignore_failure' to be a bool")
        pulumi.set(__self__, "ignore_failure", ignore_failure)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if params and not isinstance(params, str):
            raise TypeError("Expected argument 'params' to be a str")
        pulumi.set(__self__, "params", params)
        if script_id and not isinstance(script_id, str):
            raise TypeError("Expected argument 'script_id' to be a str")
        pulumi.set(__self__, "script_id", script_id)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the processor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="if")
    def if_(self) -> Optional[str]:
        """
        Conditionally execute the processor
        """
        return pulumi.get(self, "if_")

    @property
    @pulumi.getter(name="ignoreFailure")
    def ignore_failure(self) -> Optional[bool]:
        """
        Ignore failures for the processor.
        """
        return pulumi.get(self, "ignore_failure")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def lang(self) -> Optional[str]:
        """
        Script language.
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[Sequence[str]]:
        """
        Handle failures for the processor.
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter
    def params(self) -> Optional[str]:
        """
        Object containing parameters for the script.
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[str]:
        """
        ID of a stored script. If no `source` is specified, this parameter is required.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Inline script. If no id is specified, this parameter is required.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Identifier for the processor.
        """
        return pulumi.get(self, "tag")


class AwaitableIngestProcessorScriptResult(IngestProcessorScriptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorScriptResult(
            description=self.description,
            id=self.id,
            if_=self.if_,
            ignore_failure=self.ignore_failure,
            json=self.json,
            lang=self.lang,
            on_failures=self.on_failures,
            params=self.params,
            script_id=self.script_id,
            source=self.source,
            tag=self.tag)


def ingest_processor_script(description: Optional[str] = None,
                            if_: Optional[str] = None,
                            ignore_failure: Optional[bool] = None,
                            lang: Optional[str] = None,
                            on_failures: Optional[Sequence[str]] = None,
                            params: Optional[str] = None,
                            script_id: Optional[str] = None,
                            source: Optional[str] = None,
                            tag: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorScriptResult:
    """
    Runs an inline or stored script on incoming documents. The script runs in the ingest context.

    The script processor uses the script cache to avoid recompiling the script for each incoming document. To improve performance, ensure the script cache is properly sized before using a script processor in production.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/script-processor.html


    :param str description: Description of the processor.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param str lang: Script language.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str params: Object containing parameters for the script.
    :param str script_id: ID of a stored script. If no `source` is specified, this parameter is required.
    :param str source: Inline script. If no id is specified, this parameter is required.
    :param str tag: Identifier for the processor.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['if'] = if_
    __args__['ignoreFailure'] = ignore_failure
    __args__['lang'] = lang
    __args__['onFailures'] = on_failures
    __args__['params'] = params
    __args__['scriptId'] = script_id
    __args__['source'] = source
    __args__['tag'] = tag
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorScript:IngestProcessorScript', __args__, opts=opts, typ=IngestProcessorScriptResult).value

    return AwaitableIngestProcessorScriptResult(
        description=__ret__.description,
        id=__ret__.id,
        if_=__ret__.if_,
        ignore_failure=__ret__.ignore_failure,
        json=__ret__.json,
        lang=__ret__.lang,
        on_failures=__ret__.on_failures,
        params=__ret__.params,
        script_id=__ret__.script_id,
        source=__ret__.source,
        tag=__ret__.tag)


@_utilities.lift_output_func(ingest_processor_script)
def ingest_processor_script_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                                   if_: Optional[pulumi.Input[Optional[str]]] = None,
                                   ignore_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                                   lang: Optional[pulumi.Input[Optional[str]]] = None,
                                   on_failures: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   params: Optional[pulumi.Input[Optional[str]]] = None,
                                   script_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   source: Optional[pulumi.Input[Optional[str]]] = None,
                                   tag: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorScriptResult]:
    """
    Runs an inline or stored script on incoming documents. The script runs in the ingest context.

    The script processor uses the script cache to avoid recompiling the script for each incoming document. To improve performance, ensure the script cache is properly sized before using a script processor in production.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/script-processor.html


    :param str description: Description of the processor.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param str lang: Script language.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str params: Object containing parameters for the script.
    :param str script_id: ID of a stored script. If no `source` is specified, this parameter is required.
    :param str source: Inline script. If no id is specified, this parameter is required.
    :param str tag: Identifier for the processor.
    """
    ...
