# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'DataSecurityUserResult',
    'AwaitableDataSecurityUserResult',
    'data_security_user',
    'data_security_user_output',
]

@pulumi.output_type
class DataSecurityUserResult:
    """
    A collection of values returned by DataSecurityUser.
    """
    def __init__(__self__, elasticsearch_connection=None, email=None, enabled=None, full_name=None, id=None, metadata=None, roles=None, username=None):
        if elasticsearch_connection and not isinstance(elasticsearch_connection, dict):
            raise TypeError("Expected argument 'elasticsearch_connection' to be a dict")
        pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if full_name and not isinstance(full_name, str):
            raise TypeError("Expected argument 'full_name' to be a str")
        pulumi.set(__self__, "full_name", full_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional['outputs.DataSecurityUserElasticsearchConnectionResult']:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies whether the user is enabled. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> str:
        """
        The full name of the user.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        Arbitrary metadata that you want to associate with the user.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        A set of roles the user has. The roles determine the user’s access permissions. Default is [].
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        An identifier for the user
        """
        return pulumi.get(self, "username")


class AwaitableDataSecurityUserResult(DataSecurityUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return DataSecurityUserResult(
            elasticsearch_connection=self.elasticsearch_connection,
            email=self.email,
            enabled=self.enabled,
            full_name=self.full_name,
            id=self.id,
            metadata=self.metadata,
            roles=self.roles,
            username=self.username)


def data_security_user(elasticsearch_connection: Optional[pulumi.InputType['DataSecurityUserElasticsearchConnectionArgs']] = None,
                       username: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableDataSecurityUserResult:
    """
    Use this data source to get information about existing Elasticsearch user. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-get-user.html".

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    user_data_security_user = elasticstack.data_security_user(username="elastic")
    pulumi.export("user", user_data_security_user)
    ```


    :param pulumi.InputType['DataSecurityUserElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
    :param str username: An identifier for the user
    """
    __args__ = dict()
    __args__['elasticsearchConnection'] = elasticsearch_connection
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/dataSecurityUser:DataSecurityUser', __args__, opts=opts, typ=DataSecurityUserResult).value

    return AwaitableDataSecurityUserResult(
        elasticsearch_connection=__ret__.elasticsearch_connection,
        email=__ret__.email,
        enabled=__ret__.enabled,
        full_name=__ret__.full_name,
        id=__ret__.id,
        metadata=__ret__.metadata,
        roles=__ret__.roles,
        username=__ret__.username)


@_utilities.lift_output_func(data_security_user)
def data_security_user_output(elasticsearch_connection: Optional[pulumi.Input[Optional[pulumi.InputType['DataSecurityUserElasticsearchConnectionArgs']]]] = None,
                              username: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[DataSecurityUserResult]:
    """
    Use this data source to get information about existing Elasticsearch user. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-get-user.html".

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    user_data_security_user = elasticstack.data_security_user(username="elastic")
    pulumi.export("user", user_data_security_user)
    ```


    :param pulumi.InputType['DataSecurityUserElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
    :param str username: An identifier for the user
    """
    ...
