>>> from nessvec.indexers import Index
>>> import pandas as pd
>>> import sentence_transformers
>>> from nessvec.indexers import tokenize
>>> import numpy as np
>>> index = Index(num_vecs=500_000)
>>> index[0]
array([ 1.0730e-01,  8.9000e-03,  6.0000e-04,  5.5000e-03, -6.4600e-02,
       -6.0000e-02,  4.5000e-02, -1.3300e-02, -3.5700e-02,  4.3000e-02,
       -3.5600e-02, -3.2000e-03,  7.3000e-03, -1.0000e-04,  2.5800e-02,
       -1.6600e-02,  7.5000e-03,  6.8600e-02,  3.9200e-02,  7.5300e-02,
        1.1500e-02, -8.7000e-03,  4.2100e-02,  2.6500e-02, -6.0100e-02,
        2.4200e-01,  1.9900e-02, -7.3900e-02, -3.1000e-03, -2.6300e-02,
       -6.2000e-03,  1.6800e-02, -3.5700e-02, -2.4900e-02,  1.9000e-02,
       -1.8400e-02, -5.3700e-02,  1.4200e-01,  6.0000e-02,  2.2600e-02,
       -3.8000e-03, -6.7500e-02, -3.6000e-03, -8.0000e-03,  5.7000e-02,
        2.0800e-02,  2.2300e-02, -2.5600e-02, -1.5300e-02,  2.2000e-03,
       -4.8200e-02,  1.3100e-02, -6.0160e-01, -8.8000e-03,  1.0600e-02,
        2.2900e-02,  3.3600e-02,  7.1000e-03,  8.8700e-02,  2.3700e-02,
       -2.9000e-02, -4.0500e-02, -1.2500e-02,  1.4700e-02,  4.7500e-02,
        6.4700e-02,  4.7400e-02,  1.9900e-02,  4.0800e-02,  3.2200e-02,
        3.6000e-03,  3.5000e-02, -7.2300e-02, -3.0500e-02,  1.8400e-02,
       -2.6000e-03,  2.4000e-02, -1.6000e-02, -3.0800e-02,  4.3400e-02,
        1.4700e-02, -4.5700e-02, -2.6700e-02, -1.7030e-01, -9.9000e-03,
        4.1700e-02,  2.3500e-02, -2.6000e-02, -1.5190e-01, -1.1600e-02,
       -3.0600e-02, -4.1300e-02,  3.3000e-02,  7.2300e-02,  3.6500e-02,
       -1.0000e-04,  4.2000e-03,  3.4600e-02,  2.7700e-02, -3.0500e-02,
        7.8400e-02, -4.0400e-02,  1.8700e-02, -2.2500e-02, -2.0600e-02,
       -1.7900e-02, -2.4280e-01,  6.6900e-02,  5.2300e-02,  5.2700e-02,
        1.4900e-02, -7.0800e-02, -9.8700e-02,  2.6300e-02, -6.1100e-02,
        3.0200e-02,  2.1600e-02,  3.1300e-02, -1.4000e-02, -2.4950e-01,
       -3.4600e-02, -4.8000e-02,  2.5000e-02,  2.1300e-01, -3.3000e-02,
       -1.5530e-01, -2.9200e-02, -3.4600e-02,  1.0740e-01,  1.0000e-03,
       -1.1700e-02, -5.7000e-03, -1.2800e-01, -3.8000e-03,  1.3000e-02,
       -1.1570e-01, -1.0800e-02,  2.7500e-02,  1.5800e-02, -1.6900e-02,
        7.0000e-03,  2.4700e-02,  5.1000e-02,  1.0292e+00, -2.8300e-02,
       -3.1000e-02, -2.6000e-03, -3.4300e-02,  5.7800e-02,  4.4400e-02,
        8.1200e-02, -2.1100e-02, -8.7200e-02,  1.6900e-02,  4.9900e-02,
        4.8500e-02,  2.2700e-02, -3.2300e-02, -3.5000e-03,  4.3500e-02,
       -2.7500e-02,  1.5400e-02,  1.3500e-02, -4.8400e-02, -6.9900e-02,
       -5.0200e-02,  2.7450e-01, -3.0000e-04, -3.7100e-02,  5.1700e-02,
       -9.0800e-02,  1.3000e-03,  3.6000e-02,  2.8000e-02,  8.3900e-02,
        9.8000e-02, -4.9000e-02, -2.4230e-01, -1.4200e-02,  2.4000e-03,
       -2.0700e-02,  1.2000e-03,  8.8000e-03, -1.4300e-02, -1.9700e-02,
        5.1500e-02, -8.5000e-03,  2.5700e-02,  2.1540e-01,  3.0100e-02,
        2.1100e-02,  5.3000e-02, -5.0000e-04,  1.7700e-02,  1.6000e-03,
       -5.3000e-03, -1.6200e-02, -2.2300e-02, -1.8620e-01,  3.9800e-02,
        6.5800e-02, -9.6200e-02, -7.6000e-03, -7.5000e-03, -3.4200e-02,
       -2.6500e-02,  4.2000e-02,  5.2200e-02, -2.6600e-02,  2.0100e-02,
       -1.3310e-01, -3.6700e-02,  3.5100e-02,  5.1800e-02, -8.7000e-03,
        5.9900e-02, -1.0860e-01, -1.8800e-02,  4.8100e-02,  1.0500e-02,
       -6.0000e-03,  1.5100e-02, -3.1000e-03,  7.7000e-03, -2.7600e-02,
       -3.7300e-02, -2.0300e-02,  4.7200e-02,  2.4600e-02,  1.4400e-01,
        5.4200e-02, -2.2500e-02,  2.4950e-01,  1.6170e-01,  3.8000e-03,
        1.1190e-01, -2.3000e-02, -7.8500e-02,  2.5000e-02, -6.1600e-02,
       -4.8500e-02,  2.2500e-02,  2.8100e-02,  4.1000e-03,  1.1200e-02,
        1.7200e-02,  2.9100e-02, -2.8200e-02,  2.6000e-03,  4.0550e-01,
        3.9200e-02,  8.8000e-03,  2.2800e-02,  2.9900e-02,  1.1950e-01,
        5.4500e-02, -2.0000e-03,  2.0000e-03,  4.9000e-02,  1.4500e-02,
       -8.6000e-03,  9.8000e-03, -2.3600e-02,  1.7100e-02, -7.6500e-02,
       -4.0000e-02,  1.2800e-02,  1.1000e-03,  4.2000e-03,  2.4400e-02,
        7.5000e-03,  2.0000e-02,  2.0100e-02,  1.9600e-02, -3.7700e-02,
       -4.3200e-02, -7.3000e-03, -2.1000e-03,  1.8300e-02,  7.6000e-03,
        1.8050e-01, -5.5100e-02,  7.5000e-03, -5.1600e-02,  4.2000e-02,
       -6.8000e-03, -7.1100e-02, -1.4080e-01,  5.0400e-02,  2.7600e-02,
        4.7000e-02,  3.2300e-02, -2.1900e-02,  1.0000e-03,  8.9000e-03,
        2.7600e-02,  1.8600e-02,  5.0000e-03,  1.1730e-01, -4.0000e-02],
      dtype=float32)
>>> index[0:10]
array([[ 0.1073,  0.0089,  0.0006, ...,  0.005 ,  0.1173, -0.04  ],
       [ 0.0897,  0.016 , -0.0571, ...,  0.1559, -0.0254, -0.0259],
       [ 0.0004,  0.0032, -0.0204, ...,  0.207 ,  0.0689, -0.0467],
       ...,
       [ 0.0047,  0.0223, -0.0087, ...,  0.1479,  0.1324, -0.0318],
       [-0.0899, -0.0402, -0.022 , ..., -0.0963,  0.0613, -0.1298],
       [-0.0221, -0.0133,  0.0161, ..., -0.1911, -0.0541,  0.0201]],
      dtype=float32)
>>> index[0:10].shape
(10, 300)
>>> %timeit index[0:10].sum()
>>> %timeit index.data[0:10].sum()
>>> index['word'].dot(index.data[0:100])
>>> index['word'].dot(index.data[0:100].T)
array([ 0.8977904 ,  1.1743898 ,  0.8006163 ,  0.90089   ,  1.0982143 ,
        1.0962068 ,  1.1505738 ,  1.2648288 ,  1.0842043 ,  0.7968875 ,
        0.71974623,  1.2026129 ,  0.93800056,  1.387919  ,  1.0992655 ,
        1.1644204 ,  0.7419638 ,  1.0388869 ,  1.0606496 ,  1.3986107 ,
        1.1718788 ,  1.3156295 ,  1.0634775 ,  1.1986308 ,  1.158476  ,
        1.1615225 ,  1.1023178 ,  0.97027355,  1.1323762 ,  1.331219  ,
        1.257365  ,  0.9406848 ,  1.1400793 ,  0.88839644,  1.3185581 ,
        0.9180466 ,  1.2328526 ,  1.1464584 ,  1.4642802 ,  0.9200396 ,
        0.8725652 ,  1.1565765 ,  1.0440425 ,  1.3748969 ,  1.5550954 ,
        1.091124  ,  1.3263048 ,  1.120369  ,  1.0927188 , -0.5273373 ,
        1.0446461 ,  1.1188455 ,  1.2241757 ,  1.1271675 ,  1.2274413 ,
        1.111007  ,  1.1546123 ,  1.1411108 ,  0.90475464,  1.0758796 ,
        0.81953394,  1.2545642 ,  1.4355066 ,  1.2530568 ,  1.1770327 ,
        1.5895536 ,  1.1759069 ,  1.0037993 ,  1.2778002 ,  1.1960512 ,
        1.2619977 ,  1.1736591 ,  0.42667282,  1.251125  ,  1.3765612 ,
        0.83929604,  1.261419  ,  1.3662242 ,  1.3366479 ,  1.2329887 ,
        1.1145159 ,  1.1458013 ,  1.4882871 ,  0.96337605,  1.073045  ,
        1.3394266 ,  1.6170384 ,  1.1829177 ,  1.3394649 ,  1.1235948 ,
        1.2938061 ,  1.4836483 ,  1.145143  ,  1.3558983 ,  1.416705  ,
        1.3150561 ,  1.1176174 ,  1.184308  ,  1.3049902 ,  1.2151114 ],
      dtype=float32)
>>> self
>>> self = index
>>>         popular_vectors = self.data[0:top].T
...         popular_vectors /= np.linalg.norm(popular_vectors, axis=0)
...         word_vector = self[word]
...         word_vector /= np.linalg.norm(word_vector)
...         word_vector.dot(popular_vectors)
...
>>> top=100
>>>         popular_vectors = self.data[0:top].T
...         popular_vectors /= np.linalg.norm(popular_vectors, axis=0)
...         word_vector = self[word]
...         word_vector /= np.linalg.norm(word_vector)
...         word_vector.dot(popular_vectors)
...
>>> word = 'word'
>>>         popular_vectors = self.data[0:top].T
...         popular_vectors /= np.linalg.norm(popular_vectors, axis=0)
...         word_vector = self[word]
...         word_vector /= np.linalg.norm(word_vector)
...         word_vector.dot(popular_vectors)
...
array([ 0.28999588,  0.43648604,  0.2732311 ,  0.36595255,  0.43092328,
        0.37229368,  0.43288708,  0.45051244,  0.40199134,  0.26362965,
        0.26426455,  0.41983783,  0.31835166,  0.41179416,  0.38275522,
        0.38235092,  0.18867445,  0.35764164,  0.36244783,  0.5195729 ,
        0.33984822,  0.46310377,  0.3090653 ,  0.45593187,  0.4102474 ,
        0.39293805,  0.36979184,  0.31953633,  0.29490122,  0.5065756 ,
        0.32185563,  0.31053612,  0.29529366,  0.22053234,  0.45114177,
        0.3754508 ,  0.3310456 ,  0.40631893,  0.38485473,  0.34247342,
        0.27853242,  0.42847037,  0.38606563,  0.34353733,  0.54394275,
        0.38151297,  0.44290224,  0.39382076,  0.33404797, -0.0911893 ,
        0.3464905 ,  0.3574489 ,  0.38110727,  0.36646813,  0.3742436 ,
        0.2889327 ,  0.40950438,  0.43068036,  0.24661006,  0.28432426,
        0.27192375,  0.46232787,  0.40452078,  0.42215028,  0.39699134,
        0.47993067,  0.378109  ,  0.33238882,  0.45499155,  0.41284975,
        0.38731173,  0.3861595 ,  0.06144631,  0.42269346,  0.471976  ,
        0.21765782,  0.48985112,  0.44829077,  0.43327865,  0.4308636 ,
        0.38440138,  0.2874895 ,  0.3599022 ,  0.17882152,  0.3742993 ,
        0.38020673,  0.5105174 ,  0.4300578 ,  0.38399097,  0.3494316 ,
        0.49003038,  0.3773933 ,  0.35873264,  0.4121178 ,  0.43769053,
        0.46462527,  0.41834813,  0.36768004,  0.40809372,  0.4220295 ],
      dtype=float32)
>>>         similarities = pd.Series(
...             word_vector.dot(popular_vectors),
...             index=self.vocab[:top])
...
>>> similarities.sort()
>>> similarities.sort_values()
49   -0.091189
72    0.061446
83    0.178822
16    0.188674
75    0.217658
        ...   
90    0.490030
29    0.506576
86    0.510517
19    0.519573
44    0.543943
Length: 100, dtype: float32
>>> similarities.sort_values()[-1]
>>> similarities.sort_values().iloc[-1]
0.54394275
>>> similarities.sort_values().iloc[-1].index
>>> similarities.sort_values().index.iloc[-1]
>>> similarities.sort_values().index.values[-1]
44
>>> self[similarities.sort_values().index.values[-1]]
array([ 2.97987908e-02, -2.35527568e-02,  1.01498058e-02,  1.75669731e-03,
       -3.44833173e-02,  1.40535785e-02,  2.30322517e-02, -2.69360244e-02,
       -4.03389754e-03,  2.89529730e-02, -1.17113150e-03,  5.92072075e-03,
        2.17309948e-02,  4.48933756e-03, -1.99742988e-02,  3.64352055e-02,
        1.06052468e-02, -2.53745168e-02, -3.05144824e-02, -5.92072075e-03,
       -3.64351994e-03,  2.87577845e-02, -1.14510637e-02, -1.99742988e-02,
       -1.35330753e-02,  2.66757724e-03,  1.78272240e-02,  6.57134876e-03,
        9.69436672e-03, -2.66757724e-03,  2.47889496e-02, -2.55046412e-02,
       -5.43925501e-02, -3.25314322e-04, -1.17113143e-02,  2.98638511e-02,
        2.12104935e-02,  1.10606872e-03,  8.55576694e-02,  6.05084607e-03,
        4.42427490e-03, -1.43138291e-02,  1.04100578e-01, -4.05341648e-02,
       -8.58829822e-03, -3.63050774e-02, -1.39234522e-02,  6.11590873e-03,
       -1.32077616e-02,  8.65336042e-03,  2.53745145e-03,  1.36046439e-01,
       -4.17378247e-01, -1.82176027e-02,  3.75412703e-02,  1.83477271e-02,
        2.52443906e-02, -1.46586627e-01,  2.58950181e-02, -1.01498058e-02,
        6.44122297e-03,  2.16659345e-02,  6.76653767e-03, -2.62203328e-02,
        2.01694877e-03, -1.26872584e-01, -1.17113150e-03, -5.07490290e-03,
        9.88955516e-03,  1.67211555e-02,  2.34876927e-02, -8.19792040e-03,
       -1.08654974e-02, -7.61235459e-03,  7.87260663e-03,  1.47692692e-02,
        1.23619428e-02, -2.19912454e-02, -3.33772488e-02, -2.72613391e-02,
       -2.93433499e-02, -4.58042547e-02,  1.19715668e-02, -1.75084174e-01,
        1.16462521e-02,  6.33061677e-02,  2.56998315e-02, -5.79059459e-02,
       -6.31109765e-03,  8.78348667e-03,  1.30125729e-03,  1.15811890e-02,
        3.74762081e-02, -3.37025635e-02,  2.77818423e-02, -1.66560933e-02,
        9.10880137e-03,  4.78212014e-02,  4.17703576e-02, -9.56424046e-03,
       -8.82903039e-02, -3.77364573e-03,  4.43078056e-02, -6.50628645e-04,
       -2.48540118e-02,  2.44636349e-02,  1.54198989e-01,  4.48933728e-02,
       -1.56150861e-02,  7.65789896e-02,  2.16008704e-02,  8.74444842e-02,
        1.35981375e-02,  1.42487660e-02, -3.01891658e-02, -1.02474004e-01,
       -8.45817197e-03, -1.25571322e-02, -1.67862196e-02, -2.13471249e-01,
       -1.68512817e-02, -1.13860006e-02,  4.16402332e-03,  1.93236694e-02,
        6.49977997e-02,  1.29735351e-01,  6.05084607e-03,  1.04100583e-03,
       -3.94931585e-02,  5.92072075e-03,  3.35724391e-02, -6.96172612e-03,
       -3.42881307e-02,  4.34619896e-02,  8.64034817e-02, -1.51466355e-01,
        7.80754304e-03,  2.73264013e-02, -9.33001414e-02, -6.01831451e-02,
        6.70147454e-03, -3.01241055e-02, -6.50628645e-04,  3.15554887e-01,
       -6.96172612e-03,  3.92329060e-02,  5.17900363e-02, -4.50885631e-02,
        7.80754373e-04, -2.19912454e-02,  7.20245838e-02, -1.50945829e-02,
        2.09502429e-02,  1.59404017e-02,  9.63580981e-02,  5.65396287e-02,
       -4.94477712e-02,  7.20896497e-02, -0.00000000e+00,  1.77621618e-02,
       -3.24013084e-02, -1.37933260e-02,  3.38326884e-03,  1.32077616e-02,
       -1.08264603e-01, -1.41186407e-02,  5.02285287e-02, -2.77167782e-02,
       -1.17113150e-03,  2.08201166e-02, -4.43078056e-02, -1.46391438e-02,
        4.67151366e-02, -1.02083631e-01,  1.44179299e-01, -3.37676257e-02,
        1.11582801e-01, -5.97927682e-02,  3.90377152e-03, -1.07353721e-02,
        1.98441725e-02,  4.41776849e-02, -1.75669733e-02,  2.86927223e-02,
        5.27009182e-03, -6.46074191e-02, -9.30398889e-03, -9.88955516e-03,
        1.20366290e-02,  7.48222880e-03,  2.70010866e-02,  1.28173837e-02,
        2.36178190e-02,  2.81071570e-02, -1.88031662e-02,  4.55440069e-03,
       -2.38780696e-02, -2.66107097e-02,  1.22318171e-01, -2.16659345e-02,
       -3.70858307e-03, -5.25707901e-02, -1.60054639e-02, -1.08654974e-02,
        1.93236694e-02,  9.95461829e-03,  1.64609049e-02, -1.13534696e-01,
        9.17386357e-03,  3.70858312e-02,  5.27009182e-03,  1.69163439e-02,
       -3.90377187e-04,  2.54395772e-02, -2.34226300e-03, -1.66560933e-02,
       -7.92465657e-02, -3.82569619e-02, -2.35527568e-02,  7.41716614e-03,
        1.06052468e-02, -4.24860492e-02,  6.77955002e-02,  2.07550526e-02,
        3.96232828e-02, -2.81071570e-02, -1.52897714e-02,  4.16402332e-03,
       -4.88622077e-02, -8.75746086e-02,  4.22908599e-03, -4.68452573e-02,
        2.05078140e-01, -1.22318175e-02, -1.93887334e-02,  5.34816682e-02,
       -1.90634187e-02,  1.18414402e-01, -1.19325288e-01, -1.41837038e-02,
       -2.03646757e-02,  3.29868719e-02,  2.72613391e-02, -3.83870886e-03,
       -2.20563095e-02, -5.45877367e-02,  2.33575683e-02, -9.36905202e-03,
       -5.66046918e-03,  2.28175446e-01,  6.37616031e-03,  3.91027816e-02,
       -1.93236694e-02, -8.78348667e-03,  4.13149185e-02, -1.03449952e-02,
       -2.47889496e-02,  1.61355902e-02,  2.56998315e-02, -2.07550526e-02,
       -4.21607345e-02, -1.04100583e-03,  8.45817209e-04,  1.90634187e-02,
       -1.25961706e-01, -7.80754304e-03, -1.96489841e-02, -1.32728238e-02,
       -5.65396287e-02,  3.00590415e-02,  5.48479892e-02, -1.19065037e-02,
        1.98441725e-02,  5.06189056e-02,  1.50945829e-02, -3.95582207e-02,
       -3.72810215e-02,  3.96883441e-03, -2.47238879e-03, -1.15161259e-02,
        6.90317005e-02,  1.60054639e-02,  3.48736942e-02, -2.15358082e-02,
       -2.42684484e-02,  2.68709604e-02, -5.06189056e-02, -2.34876927e-02,
       -5.19201644e-02,  1.15161259e-02,  3.43531929e-02, -2.35527568e-02,
       -8.71842355e-03,  4.87320833e-02, -4.09896020e-03,  2.00393610e-02,
        3.11651081e-02,  1.01563126e-01,  1.01953499e-01,  1.95839200e-02],
      dtype=float32)
>>> self.vocab[similarities.sort_values().index.values[-1]]
44
>>> self.vocab.index[similarities.sort_values().index.values[-1]]
'one'
>>> %hist -o -p -f 2022-03-30-mob-programming-after-party-ch06-extreme-summarization-closest-stopword.hist.py.md
