import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
import { BaseFargateService, BaseFargateServiceProps } from './main';
/**
 * @stability stable
 */
export interface DualAlbFargateServiceProps extends BaseFargateServiceProps {
}
/**
 * @stability stable
 */
export declare class DualAlbFargateService extends BaseFargateService {
    /**
     * The external ALB.
     *
     * @stability stable
     */
    readonly externalAlb?: elbv2.ApplicationLoadBalancer;
    /**
     * The internal ALB.
     *
     * @stability stable
     */
    readonly internalAlb?: elbv2.ApplicationLoadBalancer;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DualAlbFargateServiceProps);
}
