# util-captcha

1. Image

    ![](./example.png)

2. Base64

    ```
    data:image/png;base64,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
    ```

## Introduction

A library that generates image CAPTCHAs.

## Installation

```bash
pip install util-captcha
```

## Usage

```py
from captcha.image import ImageCaptcha

image_captcha = ImageCaptcha()

image_captcha.draw_chars('1234567890', "/fonts/arial.ttf")
image_captcha.draw_curve()
image_captcha.draw_dots()

image_captcha.canvas.save('example.png')
base64_data = image_captcha.generate_base64()
```
