# Autogenerated 2021-04-20 20:33:46.507775
from __future__ import absolute_import
try:
    from typing import List, Union, Optional
    from array import array
except ImportError:
    pass
try:
    import java.util.List
except ImportError:
    pass
try:
    import java.net.URL
except ImportError:
    pass
try:
    import java.net.InetAddress
except ImportError:
    pass
try:
    import java.util.Date
except ImportError:
    pass
try:
    import javax.swing.JMenuItem
except ImportError:
    pass
try:
    import java.awt.event.InputEvent
except ImportError:
    pass
try:
    import java.awt.Component
except ImportError:
    pass
try:
    import java.io.OutputStream
except ImportError:
    pass
try:
    import java.util.Map
except ImportError:
    pass


class IIntruderPayloadGeneratorFactory(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerIntruderPayloadGeneratorFactory()</code>
    to register a factory for custom Intruder payloads.
     
    """
    
    def getGeneratorName(self):
        # type: () -> str
        """
        This method is used by Burp to obtain the name of the
        payload generator.
        This will be displayed as an option within the Intruder UI
        when the user
        selects to use extension-generated payloads.

        
        :return: The name of the payload generator.

        """
        pass

    def createNewInstance(self, attack):
        # type: (IIntruderAttack) -> IIntruderPayloadGenerator
        """
        This method is used by Burp when the user starts an Intruder
        attack that
        uses this payload generator.
        :param:        An
        <code>IIntruderAttack</code> object that can be
        queried to obtain details
        about the attack in which the payload generator
        will be used.
        
        :return: A new instance of
        <code>IIntruderPayloadGenerator</code> that will be used to
        generate
        payloads for the attack.

        """
        pass

    
class IResponseVariations(object):
    """
    This interface is used to represent variations between a number HTTP
    responses, according to various attributes.
     
    """
    
    def getVariantAttributes(self):
        # type: () -> List[str]
        """
        This method is used to obtain the list of attributes that
        vary between
        the analyzed responses.

        
        :return: The attributes that vary between the analyzed responses.

        """
        pass

    def getInvariantAttributes(self):
        # type: () -> List[str]
        """
        This method is used to obtain the list of attributes that do
        not vary
        between the analyzed responses.

        
        :return: The attributes that do not vary between the analyzed
        responses.

        """
        pass

    def getAttributeValue(self, attributeName, responseIndex):
        # type: (str, int) -> int
        """
        This method is used to obtain the value of an individual
        attribute in a
        response. Note that the values of some attributes are
        intrinsically
        meaningful (e.g. a word count) while the values of others
        are less so
        (e.g. a checksum of the HTML tag names).
        :param:        The name of the attribute whose value will be
        retrieved. Extension authors can obtain the list
        of supported attributes
        by generating an <code>IResponseVariations</code>
        object for a single
        response and calling
        <code>IResponseVariations.getInvariantAttributes()
        </code>.
        :param:        The index of the response. Note that responses are
        indexed from zero in the order they were
        originally supplied to the
        <code>IExtensionHelpers.analyzeResponseVariations(
        )</code> and
        <code>IResponseVariations.updateWith()</code>
        methods.
        
        :return: The value of the specified attribute for the specified
        response.

        """
        pass

    def updateWith(self, responses):
        # type: (array) -> None
        """
        This method is used to update the analysis based on
        additional responses.

        :param:        The new responses to include in the analysis.

        """
        pass

    
class IScannerInsertionPoint(object):
    """
    This interface is used to define an insertion point for use by active Scanner
    checks. Extensions can obtain instances of this interface by registering an
    <code>IScannerCheck</code>, or can create instances for use by Burp's own
    scan checks by registering an
    <code>IScannerInsertionPointProvider</code>.
     
    """
    INS_PARAM_URL = 0x00  # type: int
    INS_PARAM_BODY = 0x01  # type: int
    INS_PARAM_COOKIE = 0x02  # type: int
    INS_PARAM_XML = 0x03  # type: int
    INS_PARAM_XML_ATTR = 0x04  # type: int
    INS_PARAM_MULTIPART_ATTR = 0x05  # type: int
    INS_PARAM_JSON = 0x06  # type: int
    INS_PARAM_AMF = 0x07  # type: int
    INS_HEADER = 0x20  # type: int
    INS_URL_PATH_FOLDER = 0x21  # type: int
    INS_URL_PATH_REST = INS_URL_PATH_FOLDER  # type: int
    INS_PARAM_NAME_URL = 0x22  # type: int
    INS_PARAM_NAME_BODY = 0x23  # type: int
    INS_ENTIRE_BODY = 0x24  # type: int
    INS_URL_PATH_FILENAME = 0x25  # type: int
    INS_USER_PROVIDED = 0x40  # type: int
    INS_EXTENSION_PROVIDED = 0x41  # type: int
    INS_UNKNOWN = 0x7f  # type: int
    
    def getInsertionPointName(self):
        # type: () -> str
        """
        This method returns the name of the insertion point.

        
        :return: The name of the insertion point (for example, a description
        of a
        particular request parameter).

        """
        pass

    def getBaseValue(self):
        # type: () -> str
        """
        This method returns the base value for this insertion point.

        
        :return: the base value that appears in this insertion point in the
        base
        request being scanned, or <code>null</code> if there is no
        value in the
        base request that corresponds to this insertion point.

        """
        pass

    def buildRequest(self, payload):
        # type: (array) -> array
        """
        This method is used to build a request with the specified
        payload placed
        into the insertion point. There is no requirement for
        extension-provided
        insertion points to adjust the Content-Length header in
        requests if the
        body length has changed, although Burp-provided insertion
        points will
        always do this and will return a request with a valid
        Content-Length
        header.
        <b>Note:</b>
        Scan checks should submit raw non-encoded payloads to
        insertion points,
        and the insertion point has responsibility for performing
        any data
        encoding that is necessary given the nature and location of
        the insertion
        point.
        :param:        The payload that should be placed into the
        insertion
        point.
        
        :return: The resulting request.

        """
        pass

    def getPayloadOffsets(self, payload):
        # type: (array) -> List[java.lang.Int]
        """
        This method is used to determine the offsets of the payload
        value within
        the request, when it is placed into the insertion point.
        Scan checks may
        invoke this method when reporting issues, so as to highlight
        the relevant
        part of the request within the UI.
        :param:        The payload that should be placed into the
        insertion
        point.
        
        :return: An int[2] array containing the start and end offsets of the
        payload within the request, or null if this is not
        applicable (for
        example, where the insertion point places a payload into a
        serialized
        data structure, the raw payload may not literally appear
        anywhere within
        the resulting request).

        """
        pass

    def getInsertionPointType(self):
        # type: () -> int
        """
        This method returns the type of the insertion point.

        
        :return: The type of the insertion point. Available types are defined
        in
        this interface.

        """
        pass

    
class IScannerInsertionPointProvider(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerScannerInsertionPointProvider()</code>
    to register a factory for custom Scanner insertion points.
     
    """
    
    def getInsertionPoints(self, baseRequestResponse):
        # type: (IHttpRequestResponse) -> List[IScannerInsertionPoint]
        """
        When a request is actively scanned, the Scanner will invoke
        this method,
        and the provider should provide a list of custom insertion
        points that
        will be used in the scan. <b>Note:</b> these insertion
        points are used in
        addition to those that are derived from Burp Scanner's
        configuration, and
        those provided by any other Burp extensions.
        :param:        The base request that will be actively
        scanned.
        
        :return: A list of
        <code>IScannerInsertionPoint</code> objects that should be
        used in the
        scanning, or
        <code>null</code> if no custom insertion points are
        applicable for this
        request.

        """
        pass

    
class IRequestInfo(object):
    """
    This interface is used to retrieve key details about an HTTP request.
    Extensions can obtain an
    <code>IRequestInfo</code> object for a given request by calling
    <code>IExtensionHelpers.analyzeRequest()</code>.
     
    """
    CONTENT_TYPE_NONE = 0  # type: int
    CONTENT_TYPE_URL_ENCODED = 1  # type: int
    CONTENT_TYPE_MULTIPART = 2  # type: int
    CONTENT_TYPE_XML = 3  # type: int
    CONTENT_TYPE_JSON = 4  # type: int
    CONTENT_TYPE_AMF = 5  # type: int
    CONTENT_TYPE_UNKNOWN = 1  # type: int
    
    def getMethod(self):
        # type: () -> str
        """
        This method is used to obtain the HTTP method used in the
        request.

        
        :return: The HTTP method used in the request.

        """
        pass

    def getUrl(self):
        # type: () -> java.net.URL
        """
        This method is used to obtain the URL in the request.

        
        :return: The URL in the request.

        """
        pass

    def getHeaders(self):
        # type: () -> List[str]
        """
        This method is used to obtain the HTTP headers contained in
        the request.

        
        :return: The HTTP headers contained in the request.

        """
        pass

    def getParameters(self):
        # type: () -> List[IParameter]
        """
        This method is used to obtain the parameters contained in
        the request.

        
        :return: The parameters contained in the request.

        """
        pass

    def getBodyOffset(self):
        # type: () -> int
        """
        This method is used to obtain the offset within the request
        where the
        message body begins.

        
        :return: The offset within the request where the message body begins.

        """
        pass

    def getContentType(self):
        # type: () -> int
        """
        This method is used to obtain the content type of the
        message body.

        
        :return: An indication of the content type of the message body.
        Available
        types are defined within this interface.

        """
        pass

    
class IScannerCheck(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerScannerCheck()</code> to register a
    custom Scanner check. When performing scanning, Burp will ask the check to
    perform active or passive scanning on the base request, and report any
    Scanner issues that are identified.
     
    """
    
    def doPassiveScan(self, baseRequestResponse):
        # type: (IHttpRequestResponse) -> List[IScanIssue]
        """
        The Scanner invokes this method for each base request /
        response that is
        passively scanned. <b>Note:</b> Extensions should only
        analyze the
        HTTP messages provided during passive scanning, and should
        not make any
        new HTTP requests of their own.
        :param:        The base HTTP request / response that should
        be passively scanned.
        
        :return: A list of <code>IScanIssue</code> objects, or
        <code>null</code>
        if no issues are identified.

        """
        pass

    def doActiveScan(self, baseRequestResponse, insertionPoint):
        # type: (IHttpRequestResponse, IScannerInsertionPoint) -> List[IScanIssue]
        """
        The Scanner invokes this method for each insertion point
        that is actively
        scanned. Extensions may issue HTTP requests as required to
        carry out
        active scanning, and should use the
        <code>IScannerInsertionPoint</code> object provided to build
        scan
        requests for particular payloads.
        <b>Note:</b>
        Scan checks should submit raw non-encoded payloads to
        insertion points,
        and the insertion point has responsibility for performing
        any data
        encoding that is necessary given the nature and location of
        the insertion
        point.
        :param:        The base HTTP request / response that should
        be actively scanned.
        :param:        An <code>IScannerInsertionPoint</code> object that
        can be queried to obtain details of the insertion
        point being tested, and
        can be used to build scan requests for particular
        payloads.
        
        :return: A list of <code>IScanIssue</code> objects, or
        <code>null</code>
        if no issues are identified.

        """
        pass

    def consolidateDuplicateIssues(self, existingIssue, newIssue):
        # type: (IScanIssue, IScanIssue) -> int
        """
        The Scanner invokes this method when the custom Scanner
        check has
        reported multiple issues for the same URL path. This can
        arise either
        because there are multiple distinct vulnerabilities, or
        because the same
        (or a similar) request has been scanned more than once. The
        custom check
        should determine whether the issues are duplicates. In most
        cases, where
        a check uses distinct issue names or descriptions for
        distinct issues,
        the consolidation process will simply be a matter of
        comparing these
        features for the two issues.
        :param:        An issue that was previously reported by this
        Scanner check.
        :param:        An issue at the same URL path that has been newly
        reported by this Scanner check.
        
        :return: An indication of which issue(s) should be reported in the
        main
        Scanner results. The method should return <code>-1</code> to
        report the
        existing issue only, <code>0</code> to report both issues,
        and
        <code>1</code> to report the new issue only.

        """
        pass

    
class IInterceptedProxyMessage(object):
    """
    This interface is used to represent an HTTP message that has been intercepted
    by Burp Proxy. Extensions can register an
    <code>IProxyListener</code> to receive details of proxy messages using this
    interface. *
     
    """
    ACTION_FOLLOW_RULES = 0  # type: int
    ACTION_DO_INTERCEPT = 1  # type: int
    ACTION_DONT_INTERCEPT = 2  # type: int
    ACTION_DROP = 3  # type: int
    ACTION_FOLLOW_RULES_AND_REHOOK = 0x10  # type: int
    ACTION_DO_INTERCEPT_AND_REHOOK = 0x11  # type: int
    ACTION_DONT_INTERCEPT_AND_REHOOK = 0x12  # type: int
    
    def getMessageReference(self):
        # type: () -> int
        """
        This method retrieves a unique reference number for this
        request/response.

        
        :return: An identifier that is unique to a single request/response
        pair.
        Extensions can use this to correlate details of requests and
        responses
        and perform processing on the response message accordingly.

        """
        pass

    def getMessageInfo(self):
        # type: () -> IHttpRequestResponse
        """
        This method retrieves details of the intercepted message.

        
        :return: An <code>IHttpRequestResponse</code> object containing
        details of
        the intercepted message.

        """
        pass

    def getInterceptAction(self):
        # type: () -> int
        """
        This method retrieves the currently defined interception
        action. The
        default action is
        <code>ACTION_FOLLOW_RULES</code>. If multiple proxy
        listeners are
        registered, then other listeners may already have modified
        the
        interception action before it reaches the current listener.
        This method
        can be used to determine whether this has occurred.

        
        :return: The currently defined interception action. Possible values
        are
        defined within this interface.

        """
        pass

    def setInterceptAction(self, interceptAction):
        # type: (int) -> None
        """
        This method is used to update the interception action.

        :param:        The new interception action. Possible values are
        defined within this interface.

        """
        pass

    def getListenerInterface(self):
        # type: () -> str
        """
        This method retrieves the name of the Burp Proxy listener
        that is
        processing the intercepted message.

        
        :return: The name of the Burp Proxy listener that is processing the
        intercepted message. The format is the same as that shown in
        the Proxy
        Listeners UI - for example, "127.0.0.1:8080".

        """
        pass

    def getClientIpAddress(self):
        # type: () -> java.net.InetAddress
        """
        This method retrieves the client IP address from which the
        request for
        the intercepted message was received.

        
        :return: The client IP address from which the request for the
        intercepted
        message was received.

        """
        pass

    
class IHttpRequestResponse(object):
    """
    This interface is used to retrieve and update details about HTTP messages.

    <b>Note:</b> The setter methods generally can only be used before the message
    has been processed, and not in read-only contexts. The getter methods
    relating to response details can only be used after the request has been
    issued.
     
    """
    
    def getRequest(self):
        # type: () -> array
        """
        This method is used to retrieve the request message.

        
        :return: The request message.

        """
        pass

    def setRequest(self, message):
        # type: (array) -> None
        """
        This method is used to update the request message.

        :param:        The new request message.

        """
        pass

    def getResponse(self):
        # type: () -> array
        """
        This method is used to retrieve the response message.

        
        :return: The response message.

        """
        pass

    def setResponse(self, message):
        # type: (array) -> None
        """
        This method is used to update the response message.

        :param:        The new response message.

        """
        pass

    def getComment(self):
        # type: () -> str
        """
        This method is used to retrieve the user-annotated comment
        for this item,
        if applicable.

        
        :return: The user-annotated comment for this item, or null if none is
        set.

        """
        pass

    def setComment(self, comment):
        # type: (str) -> None
        """
        This method is used to update the user-annotated comment for
        this item.

        :param:        The comment to be assigned to this item.

        """
        pass

    def getHighlight(self):
        # type: () -> str
        """
        This method is used to retrieve the user-annotated highlight
        for this
        item, if applicable.

        
        :return: The user-annotated highlight for this item, or null if none
        is
        set.

        """
        pass

    def setHighlight(self, color):
        # type: (str) -> None
        """
        This method is used to update the user-annotated highlight
        for this item.

        :param:        The highlight color to be assigned to this item.
        Accepted
        values are: red, orange, yellow, green, cyan,
        blue, pink, magenta, gray,
        or a null String to clear any existing highlight.

        """
        pass

    def getHttpService(self):
        # type: () -> IHttpService
        """
        This method is used to retrieve the HTTP service for this
        request /
        response.

        
        :return: An
        <code>IHttpService</code> object containing details of the
        HTTP service.

        """
        pass

    def setHttpService(self, httpService):
        # type: (IHttpService) -> None
        """
        This method is used to update the HTTP service for this
        request /
        response.

        :param:        An
        <code>IHttpService</code> object containing
        details of the new HTTP
        service.

        """
        pass

    
class ICookie(object):
    """
    This interface is used to hold details about an HTTP cookie.
     
    """
    
    def getDomain(self):
        # type: () -> str
        """
        This method is used to retrieve the domain for which the
        cookie is in
        scope.

        
        :return: The domain for which the cookie is in scope. <b>Note:</b>
        For
        cookies that have been analyzed from responses (by calling
        <code>IExtensionHelpers.analyzeResponse()</code> and then
        <code>IResponseInfo.getCookies()</code>, the domain will be
        <code>null</code> if the response did not explicitly set a
        domain
        attribute for the cookie.

        """
        pass

    def getPath(self):
        # type: () -> str
        """
        This method is used to retrieve the path for which the
        cookie is in
        scope.

        
        :return: The path for which the cookie is in scope or null if none is
        set.

        """
        pass

    def getExpiration(self):
        # type: () -> java.util.Date
        """
        This method is used to retrieve the expiration time for the
        cookie.

        
        :return: The expiration time for the cookie, or
        <code>null</code> if none is set (i.e., for non-persistent
        session
        cookies).

        """
        pass

    def getName(self):
        # type: () -> str
        """
        This method is used to retrieve the name of the cookie.

        
        :return: The name of the cookie.

        """
        pass

    def getValue(self):
        # type: () -> str
        """
        This method is used to retrieve the value of the cookie.
        
        :return: The value of the cookie.

        """
        pass

    
class IContextMenuFactory(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerContextMenuFactory()</code> to register
    a factory for custom context menu items.
     
    """
    
    def createMenuItems(self, invocation):
        # type: (IContextMenuInvocation) -> List[JMenuItem]
        """
        This method will be called by Burp when the user invokes a
        context menu
        anywhere within Burp. The factory can then provide any
        custom context
        menu items that should be displayed in the context menu,
        based on the
        details of the menu invocation.
        :param:        An object that implements the
        <code>IMessageEditorTabFactory</code> interface,
        which the extension can
        query to obtain details of the context menu
        invocation.
        
        :return: A list of custom menu items (which may include sub-menus,
        checkbox menu items, etc.) that should be displayed.
        Extensions may
        return
        <code>null</code> from this method, to indicate that no menu
        items are
        required.

        """
        pass

    
class IIntruderAttack(object):
    """
    This interface is used to hold details about an Intruder attack.
     
    """
    
    def getHttpService(self):
        # type: () -> IHttpService
        """
        This method is used to retrieve the HTTP service for the
        attack.

        
        :return: The HTTP service for the attack.

        """
        pass

    def getRequestTemplate(self):
        # type: () -> array
        """
        This method is used to retrieve the request template for the
        attack.

        
        :return: The request template for the attack.

        """
        pass

    
class ISessionHandlingAction(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerSessionHandlingAction()</code> to
    register a custom session handling action. Each registered action will be
    available within the session handling rule UI for the user to select as a
    rule action. Users can choose to invoke an action directly in its own right,
    or following execution of a macro.
     
    """
    
    def getActionName(self):
        # type: () -> str
        """
        This method is used by Burp to obtain the name of the
        session handling
        action. This will be displayed as an option within the
        session handling
        rule editor when the user selects to execute an extension-
        provided
        action.

        
        :return: The name of the action.

        """
        pass

    def performAction(self, currentRequest, macroItems):
        # type: (IHttpRequestResponse, List[IHttpRequestResponse]) -> None
        """
        This method is invoked when the session handling action
        should be
        executed. This may happen as an action in its own right, or
        as a
        sub-action following execution of a macro.
        :param:        The base request that is currently being
        processed.
        The action can query this object to obtain details
        about the base
        request. It can issue additional requests of its
        own if necessary, and
        can use the setter methods on this object to
        update the base request.
        :param:        If the action is invoked following execution of a
        macro, this parameter contains the result of
        executing the macro.
        Otherwise, it is
        <code>null</code>. Actions can use the details of
        the macro items to
        perform custom analysis of the macro to derive
        values of non-standard
        session handling tokens, etc.

        """
        pass

    
class IContextMenuInvocation(object):
    """
    This interface is used when Burp calls into an extension-provided
    <code>IContextMenuFactory</code> with details of a context menu invocation.
    The custom context menu factory can query this interface to obtain details of
    the invocation event, in order to determine what menu items should be
    displayed.
     
    """
    CONTEXT_MESSAGE_EDITOR_REQUEST = 0  # type: int
    CONTEXT_MESSAGE_EDITOR_RESPONSE = 1  # type: int
    CONTEXT_MESSAGE_VIEWER_REQUEST = 2  # type: int
    CONTEXT_MESSAGE_VIEWER_RESPONSE = 3  # type: int
    CONTEXT_TARGET_SITE_MAP_TREE = 4  # type: int
    CONTEXT_TARGET_SITE_MAP_TABLE = 5  # type: int
    CONTEXT_PROXY_HISTORY = 6  # type: int
    CONTEXT_SCANNER_RESULTS = 7  # type: int
    CONTEXT_INTRUDER_PAYLOAD_POSITIONS = 8  # type: int
    CONTEXT_INTRUDER_ATTACK_RESULTS = 9  # type: int
    CONTEXT_SEARCH_RESULTS = 10  # type: int
    
    def getInputEvent(self):
        # type: () -> InputEvent
        """
        This method can be used to retrieve the native Java input
        event that was
        the trigger for the context menu invocation.

        
        :return: The <code>InputEvent</code> that was the trigger for the
        context
        menu invocation.

        """
        pass

    def getToolFlag(self):
        # type: () -> int
        """
        This method can be used to retrieve the Burp tool within
        which the
        context menu was invoked.

        
        :return: A flag indicating the Burp tool within which the context
        menu was
        invoked. Burp tool flags are defined in the
        <code>IBurpExtenderCallbacks</code> interface.

        """
        pass

    def getInvocationContext(self):
        # type: () -> int
        """
        This method can be used to retrieve the context within which
        the menu was
        invoked.

        
        :return: An index indicating the context within which the menu was
        invoked. The indices used are defined within this interface.

        """
        pass

    def getSelectionBounds(self):
        # type: () -> List[java.lang.Int]
        """
        This method can be used to retrieve the bounds of the user's
        selection
        into the current message, if applicable.

        
        :return: An int[2] array containing the start and end offsets of the
        user's selection in the current message. If the user has not
        made any
        selection in the current message, both offsets indicate the
        position of
        the caret within the editor. If the menu is not being
        invoked from a
        message editor, the method returns <code>null</code>.

        """
        pass

    def getSelectedMessages(self):
        # type: () -> List[IHttpRequestResponse]
        """
        This method can be used to retrieve details of the HTTP
        requests /
        responses that were shown or selected by the user when the
        context menu
        was invoked.

        <b>Note:</b> For performance reasons, the objects returned
        from this
        method are tied to the originating context of the messages
        within the
        Burp UI. For example, if a context menu is invoked on the
        Proxy intercept
        panel, then the
        <code>IHttpRequestResponse</code> returned by this method
        will reflect
        the current contents of the interception panel, and this
        will change when
        the current message has been forwarded or dropped. If your
        extension
        needs to store details of the message for which the context
        menu has been
        invoked, then you should query those details from the
        <code>IHttpRequestResponse</code> at the time of invocation,
        or you
        should use
        <code>IBurpExtenderCallbacks.saveBuffersToTempFiles()</code>
        to create a
        persistent read-only copy of the
        <code>IHttpRequestResponse</code>.

        
        :return: An array of <code>IHttpRequestResponse</code> objects
        representing the items that were shown or selected by the
        user when the
        context menu was invoked. This method returns
        <code>null</code> if no
        messages are applicable to the invocation.

        """
        pass

    def getSelectedIssues(self):
        # type: () -> List[IScanIssue]
        """
        This method can be used to retrieve details of the Scanner
        issues that
        were selected by the user when the context menu was invoked.

        
        :return: An array of <code>IScanIssue</code> objects representing the
        issues that were selected by the user when the context menu
        was invoked.
        This method returns <code>null</code> if no Scanner issues
        are applicable
        to the invocation.

        """
        pass

    
class IBurpExtenderCallbacks(object):
    """
    This interface is used by Burp Suite to pass to extensions a set of callback
    methods that can be used by extensions to perform various actions within
    Burp.

    When an extension is loaded, Burp invokes its
    <code>registerExtenderCallbacks()</code> method and passes an instance of the
    <code>IBurpExtenderCallbacks</code> interface. The extension may then invoke
    the methods of this interface as required in order to extend Burp's
    functionality.
     
    """
    TOOL_SUITE = 0x00000001  # type: int
    TOOL_TARGET = 0x00000002  # type: int
    TOOL_PROXY = 0x00000004  # type: int
    TOOL_SPIDER = 0x00000008  # type: int
    TOOL_SCANNER = 0x00000010  # type: int
    TOOL_INTRUDER = 0x00000020  # type: int
    TOOL_REPEATER = 0x00000040  # type: int
    TOOL_SEQUENCER = 0x00000080  # type: int
    TOOL_DECODER = 0x00000100  # type: int
    TOOL_COMPARER = 0x00000200  # type: int
    TOOL_EXTENDER = 0x00000400  # type: int
    
    def setExtensionName(self, name):
        # type: (str) -> None
        """
        This method is used to set the display name for the current
        extension,
        which will be displayed within the user interface for the
        Extender tool.

        :param:        The extension name.

        """
        pass

    def getHelpers(self):
        # type: () -> IExtensionHelpers
        """
        This method is used to obtain an
        <code>IExtensionHelpers</code> object,
        which can be used by the extension to perform numerous
        useful tasks.

        
        :return: An object containing numerous helper methods, for tasks such
        as
        building and analyzing HTTP requests.

        """
        pass

    def getStdout(self):
        # type: () -> java.io.OutputStream
        """
        This method is used to obtain the current extension's
        standard output
        stream. Extensions should write all output to this stream,
        allowing the
        Burp user to configure how that output is handled from
        within the UI.

        
        :return: The extension's standard output stream.

        """
        pass

    def getStderr(self):
        # type: () -> java.io.OutputStream
        """
        This method is used to obtain the current extension's
        standard error
        stream. Extensions should write all error messages to this
        stream,
        allowing the Burp user to configure how that output is
        handled from
        within the UI.

        
        :return: The extension's standard error stream.

        """
        pass

    def printOutput(self, output):
        # type: (str) -> None
        """
        This method prints a line of output to the current
        extension's standard
        output stream.

        :param:        The message to print.

        """
        pass

    def printError(self, error):
        # type: (str) -> None
        """
        This method prints a line of output to the current
        extension's standard
        error stream.

        :param:        The message to print.

        """
        pass

    def registerExtensionStateListener(self, listener):
        # type: (IExtensionStateListener) -> None
        """
        This method is used to register a listener which will be
        notified of
        changes to the extension's state. <b>Note:</b> Any
        extensions that start
        background threads or open system resources (such as files
        or database
        connections) should register a listener and terminate
        threads / close
        resources when the extension is unloaded.

        :param:        An object created by the extension that implements
        the
        <code>IExtensionStateListener</code> interface.

        """
        pass

    def getExtensionStateListeners(self):
        # type: () -> List[IExtensionStateListener]
        """
        This method is used to retrieve the extension state
        listeners that are
        registered by the extension.

        
        :return: A list of extension state listeners that are currently
        registered
        by this extension.

        """
        pass

    def removeExtensionStateListener(self, listener):
        # type: (IExtensionStateListener) -> None
        """
        This method is used to remove an extension state listener
        that has been
        registered by the extension.

        :param:        The extension state listener to be removed.

        """
        pass

    def registerHttpListener(self, listener):
        # type: (IHttpListener) -> None
        """
        This method is used to register a listener which will be
        notified of
        requests and responses made by any Burp tool. Extensions can
        perform
        custom analysis or modification of these messages by
        registering an HTTP
        listener.

        :param:        An object created by the extension that implements
        the
        <code>IHttpListener</code> interface.

        """
        pass

    def getHttpListeners(self):
        # type: () -> List[IHttpListener]
        """
        This method is used to retrieve the HTTP listeners that are
        registered by
        the extension.

        
        :return: A list of HTTP listeners that are currently registered by
        this
        extension.

        """
        pass

    def removeHttpListener(self, listener):
        # type: (IHttpListener) -> None
        """
        This method is used to remove an HTTP listener that has been
        registered
        by the extension.

        :param:        The HTTP listener to be removed.

        """
        pass

    def registerProxyListener(self, listener):
        # type: (IProxyListener) -> None
        """
        This method is used to register a listener which will be
        notified of
        requests and responses being processed by the Proxy tool.
        Extensions can
        perform custom analysis or modification of these messages,
        and control
        in-UI message interception, by registering a proxy listener.

        :param:        An object created by the extension that implements
        the
        <code>IProxyListener</code> interface.

        """
        pass

    def getProxyListeners(self):
        # type: () -> List[IProxyListener]
        """
        This method is used to retrieve the Proxy listeners that are
        registered
        by the extension.

        
        :return: A list of Proxy listeners that are currently registered by
        this
        extension.

        """
        pass

    def removeProxyListener(self, listener):
        # type: (IProxyListener) -> None
        """
        This method is used to remove a Proxy listener that has been
        registered
        by the extension.

        :param:        The Proxy listener to be removed.

        """
        pass

    def registerScannerListener(self, listener):
        # type: (IScannerListener) -> None
        """
        This method is used to register a listener which will be
        notified of new
        issues that are reported by the Scanner tool. Extensions can
        perform
        custom analysis or logging of Scanner issues by registering
        a Scanner
        listener.

        :param:        An object created by the extension that implements
        the
        <code>IScannerListener</code> interface.

        """
        pass

    def getScannerListeners(self):
        # type: () -> List[IScannerListener]
        """
        This method is used to retrieve the Scanner listeners that
        are registered
        by the extension.

        
        :return: A list of Scanner listeners that are currently registered by
        this
        extension.

        """
        pass

    def removeScannerListener(self, listener):
        # type: (IScannerListener) -> None
        """
        This method is used to remove a Scanner listener that has
        been registered
        by the extension.

        :param:        The Scanner listener to be removed.

        """
        pass

    def registerScopeChangeListener(self, listener):
        # type: (IScopeChangeListener) -> None
        """
        This method is used to register a listener which will be
        notified of
        changes to Burp's suite-wide target scope.

        :param:        An object created by the extension that implements
        the
        <code>IScopeChangeListener</code> interface.

        """
        pass

    def getScopeChangeListeners(self):
        # type: () -> List[IScopeChangeListener]
        """
        This method is used to retrieve the scope change listeners
        that are
        registered by the extension.

        
        :return: A list of scope change listeners that are currently
        registered by
        this extension.

        """
        pass

    def removeScopeChangeListener(self, listener):
        # type: (IScopeChangeListener) -> None
        """
        This method is used to remove a scope change listener that
        has been
        registered by the extension.

        :param:        The scope change listener to be removed.

        """
        pass

    def registerContextMenuFactory(self, factory):
        # type: (IContextMenuFactory) -> None
        """
        This method is used to register a factory for custom context
        menu items.
        When the user invokes a context menu anywhere within Burp,
        the factory
        will be passed details of the invocation event, and asked to
        provide any
        custom context menu items that should be shown.

        :param:        An object created by the extension that implements
        the
        <code>IContextMenuFactory</code> interface.

        """
        pass

    def getContextMenuFactories(self):
        # type: () -> List[IContextMenuFactory]
        """
        This method is used to retrieve the context menu factories
        that are
        registered by the extension.

        
        :return: A list of context menu factories that are currently
        registered by
        this extension.

        """
        pass

    def removeContextMenuFactory(self, factory):
        # type: (IContextMenuFactory) -> None
        """
        This method is used to remove a context menu factory that
        has been
        registered by the extension.

        :param:        The context menu factory to be removed.

        """
        pass

    def registerMessageEditorTabFactory(self, factory):
        # type: (IMessageEditorTabFactory) -> None
        """
        This method is used to register a factory for custom message
        editor tabs.
        For each message editor that already exists, or is
        subsequently created,
        within Burp, the factory will be asked to provide a new
        instance of an
        <code>IMessageEditorTab</code> object, which can provide
        custom rendering
        or editing of HTTP messages.

        :param:        An object created by the extension that implements
        the
        <code>IMessageEditorTabFactory</code> interface.

        """
        pass

    def getMessageEditorTabFactories(self):
        # type: () -> List[IMessageEditorTabFactory]
        """
        This method is used to retrieve the message editor tab
        factories that are
        registered by the extension.

        
        :return: A list of message editor tab factories that are currently
        registered by this extension.

        """
        pass

    def removeMessageEditorTabFactory(self, factory):
        # type: (IMessageEditorTabFactory) -> None
        """
        This method is used to remove a message editor tab factory
        that has been
        registered by the extension.

        :param:        The message editor tab factory to be removed.

        """
        pass

    def registerScannerInsertionPointProvider(self, provider):
        # type: (IScannerInsertionPointProvider) -> None
        """
        This method is used to register a provider of Scanner
        insertion points.
        For each base request that is actively scanned, Burp will
        ask the
        provider to provide any custom scanner insertion points that
        are
        appropriate for the request.

        :param:        An object created by the extension that implements
        the
        <code>IScannerInsertionPointProvider</code>
        interface.

        """
        pass

    def getScannerInsertionPointProviders(self):
        # type: () -> List[IScannerInsertionPointProvider]
        """
        This method is used to retrieve the Scanner insertion point
        providers
        that are registered by the extension.

        
        :return: A list of Scanner insertion point providers that are
        currently
        registered by this extension.

        """
        pass

    def removeScannerInsertionPointProvider(self, provider):
        # type: (IScannerInsertionPointProvider) -> None
        """
        This method is used to remove a Scanner insertion point
        provider that has
        been registered by the extension.

        :param:        The Scanner insertion point provider to be
        removed.

        """
        pass

    def registerScannerCheck(self, check):
        # type: (IScannerCheck) -> None
        """
        This method is used to register a custom Scanner check. When
        performing
        scanning, Burp will ask the check to perform active or
        passive scanning
        on the base request, and report any Scanner issues that are
        identified.

        :param:        An object created by the extension that implements
        the
        <code>IScannerCheck</code> interface.

        """
        pass

    def getScannerChecks(self):
        # type: () -> List[IScannerCheck]
        """
        This method is used to retrieve the Scanner checks that are
        registered by
        the extension.

        
        :return: A list of Scanner checks that are currently registered by
        this
        extension.

        """
        pass

    def removeScannerCheck(self, check):
        # type: (IScannerCheck) -> None
        """
        This method is used to remove a Scanner check that has been
        registered by
        the extension.

        :param:        The Scanner check to be removed.

        """
        pass

    def registerIntruderPayloadGeneratorFactory(self, factory):
        # type: (IIntruderPayloadGeneratorFactory) -> None
        """
        This method is used to register a factory for Intruder
        payloads. Each
        registered factory will be available within the Intruder UI
        for the user
        to select as the payload source for an attack. When this is
        selected, the
        factory will be asked to provide a new instance of an
        <code>IIntruderPayloadGenerator</code> object, which will be
        used to
        generate payloads for the attack.

        :param:        An object created by the extension that implements
        the
        <code>IIntruderPayloadGeneratorFactory</code>
        interface.

        """
        pass

    def getIntruderPayloadGeneratorFactories(self):
        # type: () -> List[IIntruderPayloadGeneratorFactory]
        """
        This method is used to retrieve the Intruder payload
        generator factories
        that are registered by the extension.

        
        :return: A list of Intruder payload generator factories that are
        currently
        registered by this extension.

        """
        pass

    def removeIntruderPayloadGeneratorFactory(self, factory):
        # type: (IIntruderPayloadGeneratorFactory) -> None
        """
        This method is used to remove an Intruder payload generator
        factory that
        has been registered by the extension.

        :param:        The Intruder payload generator factory to be
        removed.

        """
        pass

    def registerIntruderPayloadProcessor(self, processor):
        # type: (IIntruderPayloadProcessor) -> None
        """
        This method is used to register a custom Intruder payload
        processor. Each
        registered processor will be available within the Intruder
        UI for the
        user to select as the action for a payload processing rule.

        :param:        An object created by the extension that implements
        the
        <code>IIntruderPayloadProcessor</code> interface.

        """
        pass

    def getIntruderPayloadProcessors(self):
        # type: () -> List[IIntruderPayloadProcessor]
        """
        This method is used to retrieve the Intruder payload
        processors that are
        registered by the extension.

        
        :return: A list of Intruder payload processors that are currently
        registered by this extension.

        """
        pass

    def removeIntruderPayloadProcessor(self, processor):
        # type: (IIntruderPayloadProcessor) -> None
        """
        This method is used to remove an Intruder payload processor
        that has been
        registered by the extension.

        :param:        The Intruder payload processor to be removed.

        """
        pass

    def registerSessionHandlingAction(self, action):
        # type: (ISessionHandlingAction) -> None
        """
        This method is used to register a custom session handling
        action. Each
        registered action will be available within the session
        handling rule UI
        for the user to select as a rule action. Users can choose to
        invoke an
        action directly in its own right, or following execution of
        a macro.

        :param:        An object created by the extension that implements
        the
        <code>ISessionHandlingAction</code> interface.

        """
        pass

    def getSessionHandlingActions(self):
        # type: () -> List[ISessionHandlingAction]
        """
        This method is used to retrieve the session handling actions
        that are
        registered by the extension.

        
        :return: A list of session handling actions that are currently
        registered
        by this extension.

        """
        pass

    def removeSessionHandlingAction(self, action):
        # type: (ISessionHandlingAction) -> None
        """
        This method is used to remove a session handling action that
        has been
        registered by the extension.

        :param:        The extension session handling action to be
        removed.

        """
        pass

    def unloadExtension(self):
        # type: () -> None
        """
        This method is used to unload the extension from Burp Suite.

        """
        pass

    def addSuiteTab(self, tab):
        # type: (ITab) -> None
        """
        This method is used to add a custom tab to the main Burp
        Suite window.

        :param:        An object created by the extension that implements
        the
        <code>ITab</code> interface.

        """
        pass

    def removeSuiteTab(self, tab):
        # type: (ITab) -> None
        """
        This method is used to remove a previously-added tab from
        the main Burp
        Suite window.

        :param:        An object created by the extension that implements
        the
        <code>ITab</code> interface.

        """
        pass

    def customizeUiComponent(self, component):
        # type: (Component) -> None
        """
        This method is used to customize UI components in line with
        Burp's UI
        style, including font size, colors, table line spacing, etc.
        The action
        is performed recursively on any child components of the
        passed-in
        component.

        :param:        The UI component to be customized.

        """
        pass

    def createMessageEditor(self, controller, editable):
        # type: (IMessageEditorController, bool) -> IMessageEditor
        """
        This method is used to create a new instance of Burp's HTTP
        message
        editor, for the extension to use in its own UI.
        :param:        An object created by the extension that implements
        the
        <code>IMessageEditorController</code> interface.
        This parameter is
        optional and may be <code>null</code>. If it is
        provided, then the
        message editor will query the controller when
        required to obtain details
        about the currently displayed message, including
        the
        <code>IHttpService</code> for the message, and the
        associated request or
        response message. If a controller is not provided,
        then the message
        editor will not support context menu actions, such
        as sending requests to
        other Burp tools.
        :param:        Indicates whether the editor created should be
        editable,
        or used only for message viewing.
        
        :return: An object that implements the <code>IMessageEditor</code>
        interface, and which the extension can use in its own UI.

        """
        pass

    def getCommandLineArguments(self):
        # type: () -> List[str]
        """
        This method returns the command line arguments that were
        passed to Burp
        on startup.

        
        :return: The command line arguments that were passed to Burp on
        startup.

        """
        pass

    def saveExtensionSetting(self, name, value):
        # type: (str, str) -> None
        """
        This method is used to save configuration settings for the
        extension in a
        persistent way that survives reloads of the extension and of
        Burp Suite.
        Saved settings can be retrieved using the method
        <code>loadExtensionSetting()</code>.
        :param:        The name of the setting.
        :param:        The value of the setting. If this value is
        <code>null</code>
        then any existing setting with the specified name
        will be removed.

        """
        pass

    def loadExtensionSetting(self, name):
        # type: (str) -> str
        """
        This method is used to load configuration settings for the
        extension that
        were saved using the method
        <code>saveExtensionSetting()</code>.
        :param:        The name of the setting.
        
        :return: The value of the setting, or <code>null</code> if no value
        is
        set.

        """
        pass

    def createTextEditor(self):
        # type: () -> ITextEditor
        """
        This method is used to create a new instance of Burp's plain
        text editor,
        for the extension to use in its own UI.

        
        :return: An object that implements the <code>ITextEditor</code>
        interface,
        and which the extension can use in its own UI.

        """
        pass

    def sendToRepeater(self, host, port, useHttps, request, tabCaption):
        # type: (str, int, bool, array, str) -> None
        """
        This method can be used to send an HTTP request to the Burp
        Repeater
        tool. The request will be displayed in the user interface,
        but will not
        be issued until the user initiates this action.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.
        :param:        An optional caption which will appear on the
        Repeater
        tab containing the request. If this value is
        <code>null</code> then a
        default tab index will be displayed.

        """
        pass

    def sendToIntruder(self, host, port, useHttps, request):
        # type: (str, int, bool, array) -> None
        """
        This method can be used to send an HTTP request to the Burp
        Intruder
        tool. The request will be displayed in the user interface,
        and markers
        for attack payloads will be placed into default locations
        within the
        request.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.

        """
        pass

    def sendToIntruder(self, host, port, useHttps, request, payloadPositionOffsets):
        # type: (str, int, bool, array, List[List[java.lang.Int]]) -> None
        """
        This method can be used to send an HTTP request to the Burp
        Intruder
        tool. The request will be displayed in the user interface,
        and markers
        for attack payloads will be placed into the specified
        locations within
        the request.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.
        :param:        A list of index pairs representing the
        payload positions to be used. Each item in the
        list must be an int[2]
        array containing the start and end offsets for the
        payload position.

        """
        pass

    def sendToComparer(self, data):
        # type: (array) -> None
        """
        This method can be used to send data to the Comparer tool.

        :param:        The data to be sent to Comparer.

        """
        pass

    def sendToSpider(self, url):
        # type: (java) -> None
        """
        This method can be used to send a seed URL to the Burp
        Spider tool. If
        the URL is not within the current Spider scope, the user
        will be asked if
        they wish to add the URL to the scope. If the Spider is not
        currently
        running, it will be started. The seed URL will be requested,
        and the
        Spider will process the application's response in the normal
        way.

        :param:        The new seed URL to begin spidering from.

        """
        pass

    def doActiveScan(self, host, port, useHttps, request):
        # type: (str, int, bool, array) -> IScanQueueItem
        """
        This method can be used to send an HTTP request to the Burp
        Scanner tool
        to perform an active vulnerability scan. If the request is
        not within the
        current active scanning scope, the user will be asked if
        they wish to
        proceed with the scan.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.
        
        :return: The resulting scan queue item.

        """
        pass

    def doActiveScan(self, host, port, useHttps, request, insertionPointOffsets):
        # type: (str, int, bool, array, List[List[java.lang.Int]]) -> IScanQueueItem
        """
        This method can be used to send an HTTP request to the Burp
        Scanner tool
        to perform an active vulnerability scan, based on a custom
        list of
        insertion points that are to be scanned. If the request is
        not within the
        current active scanning scope, the user will be asked if
        they wish to
        proceed with the scan.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.
        :param:        A list of index pairs representing the
        positions of the insertion points that should be
        scanned. Each item in
        the list must be an int[2] array containing the
        start and end offsets for
        the insertion point.
        
        :return: The resulting scan queue item.

        """
        pass

    def doPassiveScan(self, host, port, useHttps, request, response):
        # type: (str, int, bool, array, array) -> None
        """
        This method can be used to send an HTTP request to the Burp
        Scanner tool
        to perform a passive vulnerability scan.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.
        :param:        The full HTTP response.

        """
        pass

    def makeHttpRequest(self, httpService, request):
        # type: (IHttpService, array) -> IHttpRequestResponse
        """
        This method can be used to issue HTTP requests and retrieve
        their
        responses.
        :param:        The HTTP service to which the request should be
        sent.
        :param:        The full HTTP request.
        
        :return: An object that implements the
        <code>IHttpRequestResponse</code>
        interface, and which the extension can query to obtain the
        details of the
        response.

        """
        pass

    def makeHttpRequest(self, host, port, useHttps, request):
        # type: (str, int, bool, array) -> array
        """
        This method can be used to issue HTTP requests and retrieve
        their
        responses.
        :param:        The hostname of the remote HTTP server.
        :param:        The port of the remote HTTP server.
        :param:        Flags whether the protocol is HTTPS or HTTP.
        :param:        The full HTTP request.
        
        :return: The full response retrieved from the remote server.

        """
        pass

    def isInScope(self, url):
        # type: (java) -> bool
        """
        This method can be used to query whether a specified URL is
        within the
        current Suite-wide scope.
        :param:        The URL to query.
        
        :return: Returns <code>true</code> if the URL is within the current
        Suite-wide scope.

        """
        pass

    def includeInScope(self, url):
        # type: (java) -> None
        """
        This method can be used to include the specified URL in the
        Suite-wide
        scope.

        :param:        The URL to include in the Suite-wide scope.

        """
        pass

    def excludeFromScope(self, url):
        # type: (java) -> None
        """
        This method can be used to exclude the specified URL from
        the Suite-wide
        scope.

        :param:        The URL to exclude from the Suite-wide scope.

        """
        pass

    def issueAlert(self, message):
        # type: (str) -> None
        """
        This method can be used to display a specified message in
        the Burp Suite
        alerts tab.

        :param:        The alert message to display.

        """
        pass

    def getProxyHistory(self):
        # type: () -> List[IHttpRequestResponse]
        """
        This method returns details of all items in the Proxy
        history.

        
        :return: The contents of the Proxy history.

        """
        pass

    def getSiteMap(self, urlPrefix):
        # type: (str) -> List[IHttpRequestResponse]
        """
        This method returns details of items in the site map.
        :param:        This parameter can be used to specify a URL
        prefix, in
        order to extract a specific subset of the site
        map. The method performs a
        simple case-sensitive text match, returning all
        site map items whose URL
        begins with the specified prefix. If this
        parameter is null, the entire
        site map is returned.
        
        :return: Details of items in the site map.

        """
        pass

    def getScanIssues(self, urlPrefix):
        # type: (str) -> List[IScanIssue]
        """
        This method returns all of the current scan issues for URLs
        matching the
        specified literal prefix.
        :param:        This parameter can be used to specify a URL
        prefix, in
        order to extract a specific subset of scan issues.
        The method performs a
        simple case-sensitive text match, returning all
        scan issues whose URL
        begins with the specified prefix. If this
        parameter is null, all issues
        are returned.
        
        :return: Details of the scan issues.

        """
        pass

    def generateScanReport(self, format, issues, file):
        # type: (str, List[IScanIssue], java) -> None
        """
        This method is used to generate a report for the specified
        Scanner
        issues. The report format can be specified. For all other
        reporting
        options, the default settings that appear in the reporting
        UI wizard are
        used.
        :param:        The format to be used in the report. Accepted
        values are
        HTML and XML.
        :param:        The Scanner issues to be reported.
        :param:        The file to which the report will be saved.

        """
        pass

    def getCookieJarContents(self):
        # type: () -> List[ICookie]
        """
        This method is used to retrieve the contents of Burp's
        session handling
        cookie jar. Extensions that provide an
        <code>ISessionHandlingAction</code> can query and update the
        cookie jar
        in order to handle unusual session handling mechanisms.

        
        :return: A list of <code>ICookie</code> objects representing the
        contents
        of Burp's session handling cookie jar.

        """
        pass

    def updateCookieJar(self, cookie):
        # type: (ICookie) -> None
        """
        This method is used to update the contents of Burp's session
        handling
        cookie jar. Extensions that provide an
        <code>ISessionHandlingAction</code> can query and update the
        cookie jar
        in order to handle unusual session handling mechanisms.

        :param:        An <code>ICookie</code> object containing details
        of the
        cookie to be updated. If the cookie jar already
        contains a cookie that
        matches the specified domain and name, then that
        cookie will be updated
        with the new value and expiration, unless the new
        value is
        <code>null</code>, in which case the cookie will
        be removed. If the
        cookie jar does not already contain a cookie that
        matches the specified
        domain and name, then the cookie will be added.

        """
        pass

    def addToSiteMap(self, item):
        # type: (IHttpRequestResponse) -> None
        """
        This method can be used to add an item to Burp's site map
        with the
        specified request/response details. This will overwrite the
        details of
        any existing matching item in the site map.

        :param:        Details of the item to be added to the site map

        """
        pass

    def restoreState(self, file):
        # type: (java) -> None
        """
        This method can be used to restore Burp's state from a
        specified saved
        state file. This method blocks until the restore operation
        is completed,
        and must not be called from the event dispatch
        thread.@deprecated State files have been replaced with Burp
        project files.

        :param:        The file containing Burp's saved state.
        """
        pass

    def saveState(self, file):
        # type: (java) -> None
        """
        This method can be used to save Burp's state to a specified
        file. This
        method blocks until the save operation is completed, and
        must not be
        called from the event dispatch thread.@deprecated State
        files have been replaced with Burp project files.

        :param:        The file to save Burp's state in.
        """
        pass

    def saveConfig(self):
        # type: () -> java.util.Map
        """
        This method causes Burp to save all of its current
        configuration as a Map
        of name/value Strings.@deprecated Use
        <code>saveConfigAsJson()</code> instead.

        
        :return: A Map of name/value Strings reflecting Burp's current
        configuration.
        """
        pass

    def loadConfig(self, config):
        # type: (Map) -> None
        """
        This method causes Burp to load a new configuration from the
        Map of
        name/value Strings provided. Any settings not specified in
        the Map will
        be restored to their default values. To selectively update
        only some
        settings and leave the rest unchanged, you should first call
        <code>saveConfig()</code> to obtain Burp's current
        configuration, modify
        the relevant items in the Map, and then call
        <code>loadConfig()</code>
        with the same Map.@deprecated Use
        <code>loadConfigFromJson()</code> instead.

        :param:        A map of name/value Strings to use as Burp's new
        configuration.
        """
        pass

    def saveConfigAsJson(self, configPaths):
        # type: (str) -> str
        """
        This method causes Burp to save its current project-level
        configuration
        in JSON format. This is the same format that can be saved
        and loaded via
        the Burp user interface. To include only certain sections of
        the
        configuration, you can optionally supply the path to each
        section that
        should be included, for example:
        "project_options.connections". If no
        paths are provided, then the entire configuration will be
        saved.
        :param:        A list of Strings representing the path to each
        configuration section that should be included.
        
        :return: A String representing the current configuration in JSON
        format.

        """
        pass

    def loadConfigFromJson(self, config):
        # type: (str) -> None
        """
        This method causes Burp to load a new project-level
        configuration from
        the JSON String provided. This is the same format that can
        be saved and
        loaded via the Burp user interface. Partial configurations
        are
        acceptable, and any settings not specified will be left
        unmodified.

        Any user-level configuration options contained in the input
        will be
        ignored.

        :param:        A JSON String containing the new configuration.

        """
        pass

    def setProxyInterceptionEnabled(self, enabled):
        # type: (bool) -> None
        """
        This method sets the master interception mode for Burp
        Proxy.

        :param:        Indicates whether interception of Proxy messages
        should be
        enabled.

        """
        pass

    def getBurpVersion(self):
        # type: () -> List[str]
        """
        This method retrieves information about the version of Burp
        in which the
        extension is running. It can be used by extensions to
        dynamically adjust
        their behavior depending on the functionality and APIs
        supported by the
        current version.

        
        :return: An array of Strings comprised of: the product name (e.g.
        Burp
        Suite Professional), the major version (e.g. 1.5), the minor
        version
        (e.g. 03)

        """
        pass

    def getExtensionFilename(self):
        # type: () -> str
        """
        This method retrieves the absolute path name of the file
        from which the
        current extension was loaded.

        
        :return: The absolute path name of the file from which the current
        extension was loaded.

        """
        pass

    def isExtensionBapp(self):
        # type: () -> bool
        """
        This method determines whether the current extension was
        loaded as a BApp
        (a Burp App from the BApp Store).

        
        :return: Returns true if the current extension was loaded as a BApp.

        """
        pass

    def exitSuite(self, promptUser):
        # type: (bool) -> None
        """
        This method can be used to shut down Burp programmatically,
        with an
        optional prompt to the user. If the method returns, the user
        canceled the
        shutdown prompt.

        :param:        Indicates whether to prompt the user to confirm
        the
        shutdown.

        """
        pass

    def saveToTempFile(self, buffer):
        # type: (array) -> ITempFile
        """
        This method is used to create a temporary file on disk
        containing the
        provided data. Extensions can use temporary files for long-
        term storage
        of runtime data, avoiding the need to retain that data in
        memory.
        :param:        The data to be saved to a temporary file.
        
        :return: An object that implements the <code>ITempFile</code>
        interface.

        """
        pass

    def saveBuffersToTempFiles(self, httpRequestResponse):
        # type: (IHttpRequestResponse) -> IHttpRequestResponsePersisted
        """
        This method is used to save the request and response of an
        <code>IHttpRequestResponse</code> object to temporary files,
        so that they
        are no longer held in memory. Extensions can used this
        method to convert
        <code>IHttpRequestResponse</code> objects into a form
        suitable for
        long-term storage.
        :param:        The <code>IHttpRequestResponse</code> object
        whose request and response messages are to be
        saved to temporary files.
        
        :return: An object that implements the
        <code>IHttpRequestResponsePersisted</code> interface.

        """
        pass

    def applyMarkers(self, httpRequestResponse, requestMarkers, responseMarkers):
        # type: (IHttpRequestResponse, List[List[java.lang.Int]], List[List[java.lang.Int]]) -> IHttpRequestResponseWithMarkers
        """
        This method is used to apply markers to an HTTP request or
        response, at
        offsets into the message that are relevant for some
        particular purpose.
        Markers are used in various situations, such as specifying
        Intruder
        payload positions, Scanner insertion points, and highlights
        in Scanner
        issues.
        :param:        The <code>IHttpRequestResponse</code> object
        to which the markers should be applied.
        :param:        A list of index pairs representing the offsets of
        markers to be applied to the request message. Each
        item in the list must
        be an int[2] array containing the start and end
        offsets for the marker.
        The markers in the list should be in sequence and
        not overlapping. This
        parameter is optional and may be <code>null</code>
        if no request markers
        are required.
        :param:        A list of index pairs representing the offsets of
        markers to be applied to the response message.
        Each item in the list must
        be an int[2] array containing the start and end
        offsets for the marker.
        The markers in the list should be in sequence and
        not overlapping. This
        parameter is optional and may be <code>null</code>
        if no response markers
        are required.
        
        :return: An object that implements the
        <code>IHttpRequestResponseWithMarkers</code> interface.

        """
        pass

    def getToolName(self, toolFlag):
        # type: (int) -> str
        """
        This method is used to obtain the descriptive name for the
        Burp tool
        identified by the tool flag provided.
        :param:        A flag identifying a Burp tool (
        <code>TOOL_PROXY</code>,
        <code>TOOL_SCANNER</code>, etc.). Tool flags are
        defined within this
        interface.
        
        :return: The descriptive name for the specified tool.

        """
        pass

    def addScanIssue(self, issue):
        # type: (IScanIssue) -> None
        """
        This method is used to register a new Scanner issue.
        <b>Note:</b>
        Wherever possible, extensions should implement custom
        Scanner checks
        using <code>IScannerCheck</code> and report issues via those
        checks, so
        as to integrate with Burp's user-driven workflow, and ensure
        proper
        consolidation of duplicate reported issues. This method is
        only designed
        for tasks outside of the normal testing workflow, such as
        importing
        results from other scanning tools.

        :param:        An object created by the extension that implements
        the
        <code>IScanIssue</code> interface.

        """
        pass

    def createBurpCollaboratorClientContext(self):
        # type: () -> IBurpCollaboratorClientContext
        """
        This method is used to create a new Burp Collaborator client
        context,
        which can be used to generate Burp Collaborator payloads and
        poll the
        Collaborator server for any network interactions that result
        from using
        those payloads.

        
        :return: A new instance of
        <code>IBurpCollaboratorClientContext</code>
        that can be used to generate Collaborator payloads and
        retrieve
        interactions.

        """
        pass

    def getParameters(self, request):
        # type: (array) -> str
        """
        This method parses the specified request and returns details
        of each
        request parameter.@deprecated Use
        <code>IExtensionHelpers.analyzeRequest()</code> instead.

        :param:        The request to be parsed.
        
        :return: An array of: <code>String[] { name, value, type }</code>
        containing details of the parameters contained within the
        request.
        """
        pass

    def getHeaders(self, message):
        # type: (array) -> List[str]
        """
        This method parses the specified request and returns details
        of each HTTP
        header.@deprecated Use
        <code>IExtensionHelpers.analyzeRequest()</code> or
        <code>IExtensionHelpers.analyzeResponse()</code> instead.

        :param:        The request to be parsed.
        
        :return: An array of HTTP headers.
        """
        pass

    def registerMenuItem(self, menuItemCaption, menuItemHandler):
        # type: (str, IMenuItemHandler) -> None
        """
        This method can be used to register a new menu item which
        will appear on
        the various context menus that are used throughout Burp
        Suite to handle
        user-driven actions.@deprecated Use
        <code>registerContextMenuFactory()</code> instead.

        :param:        The caption to be displayed on the menu item.
        :param:        The handler to be invoked when the user clicks on
        the menu item.
        """
        pass

    
class IBurpCollaboratorInteraction(object):
    """
    This interface represents a network interaction that occurred with the Burp
    Collaborator server.
     
    """
    
    def getProperty(self, name):
        # type: (str) -> str
        """
        This method is used to retrieve a property of the
        interaction. Properties
        of all interactions are: interaction_id, type, client_ip,
        and time_stamp.
        Properties of DNS interactions are: query_type and
        raw_query. The
        raw_query value is Base64-encoded. Properties of HTTP
        interactions are:
        protocol, request, and response. The request and response
        values are
        Base64-encoded.
        :param:        The name of the property to retrieve.
        
        :return: A string representing the property value, or null if not
        present.

        """
        pass

    def getProperties(self):
        # type: () -> java.util.Map
        """
        This method is used to retrieve a map containing all
        properties of the
        interaction.

        
        :return: A map containing all properties of the interaction.

        """
        pass

    
class IHttpService(object):
    """
    This interface is used to provide details about an HTTP service, to which
    HTTP requests can be sent.
     
    """
    
    def getHost(self):
        # type: () -> str
        """
        This method returns the hostname or IP address for the
        service.

        
        :return: The hostname or IP address for the service.

        """
        pass

    def getPort(self):
        # type: () -> int
        """
        This method returns the port number for the service.

        
        :return: The port number for the service.

        """
        pass

    def getProtocol(self):
        # type: () -> str
        """
        This method returns the protocol for the service.

        
        :return: The protocol for the service. Expected values are "http" or
        "https".

        """
        pass

    
class IMessageEditorTab(object):
    """
    Extensions that register an
    <code>IMessageEditorTabFactory</code> must return instances of this
    interface, which Burp will use to create custom tabs within its HTTP message
    editors.
     
    """
    
    def getTabCaption(self):
        # type: () -> str
        """
        This method returns the caption that should appear on the
        custom tab when
        it is displayed. <b>Note:</b> Burp invokes this method once
        when the tab
        is first generated, and the same caption will be used every
        time the tab
        is displayed.

        
        :return: The caption that should appear on the custom tab when it is
        displayed.

        """
        pass

    def getUiComponent(self):
        # type: () -> Component
        """
        This method returns the component that should be used as the
        contents of
        the custom tab when it is displayed. <b>Note:</b> Burp
        invokes this
        method once when the tab is first generated, and the same
        component will
        be used every time the tab is displayed.

        
        :return: The component that should be used as the contents of the
        custom
        tab when it is displayed.

        """
        pass

    def isEnabled(self, content, isRequest):
        # type: (array, bool) -> bool
        """
        The hosting editor will invoke this method before it
        displays a new HTTP
        message, so that the custom tab can indicate whether it
        should be enabled
        for that message.
        :param:        The message that is about to be displayed, or a
        zero-length
        array if the existing message is to be cleared.
        :param:        Indicates whether the message is a request or a
        response.
        
        :return: The method should return
        <code>true</code> if the custom tab is able to handle the
        specified
        message, and so will be displayed within the editor.
        Otherwise, the tab
        will be hidden while this message is displayed.

        """
        pass

    def setMessage(self, content, isRequest):
        # type: (array, bool) -> None
        """
        The hosting editor will invoke this method to display a new
        message or to
        clear the existing message. This method will only be called
        with a new
        message if the tab has already returned
        <code>true</code> to a call to
        <code>isEnabled()</code> with the same message details.
        :param:        The message that is to be displayed, or
        <code>null</code> if the tab should clear its
        contents and disable any
        editable controls.
        :param:        Indicates whether the message is a request or a
        response.

        """
        pass

    def getMessage(self):
        # type: () -> array
        """
        This method returns the currently displayed message.

        
        :return: The currently displayed message.

        """
        pass

    def isModified(self):
        # type: () -> bool
        """
        This method is used to determine whether the currently
        displayed message
        has been modified by the user. The hosting editor will
        always call
        <code>getMessage()</code> before calling this method, so any
        pending
        edits should be completed within
        <code>getMessage()</code>.

        
        :return: The method should return
        <code>true</code> if the user has modified the current
        message since it
        was first displayed.

        """
        pass

    def getSelectedData(self):
        # type: () -> array
        """
        This method is used to retrieve the data that is currently
        selected by
        the user.

        
        :return: The data that is currently selected by the user. This may be
        <code>null</code> if no selection is currently made.

        """
        pass

    
class IExtensionStateListener(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerExtensionStateListener()</code> to
    register an extension state listener. The listener will be notified of
    changes to the extension's state. <b>Note:</b> Any extensions that start
    background threads or open system resources (such as files or database
    connections) should register a listener and terminate threads / close
    resources when the extension is unloaded.
     
    """
    
    def extensionUnloaded(self):
        # type: () -> None
        """
        This method is called when the extension is unloaded.

        """
        pass

    
class IScannerListener(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerScannerListener()</code> to register a
    Scanner listener. The listener will be notified of new issues that are
    reported by the Scanner tool. Extensions can perform custom analysis or
    logging of Scanner issues by registering a Scanner listener.
     
    """
    
    def newScanIssue(self, issue):
        # type: (IScanIssue) -> None
        """
        This method is invoked when a new issue is added to Burp
        Scanner's
        results.

        :param:        An
        <code>IScanIssue</code> object that the extension
        can query to obtain
        details about the new issue.

        """
        pass

    
class IProxyListener(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerProxyListener()</code> to register a
    Proxy listener. The listener will be notified of requests and responses being
    processed by the Proxy tool. Extensions can perform custom analysis or
    modification of these messages, and control in-UI message interception, by
    registering a proxy listener.
     
    """
    
    def processProxyMessage(self, messageIsRequest, message):
        # type: (bool, IInterceptedProxyMessage) -> None
        """
        This method is invoked when an HTTP message is being
        processed by the
        Proxy.
        :param:        Indicates whether the HTTP message is a request
        or a response.
        :param:        An
        <code>IInterceptedProxyMessage</code> object that
        extensions can use to
        query and update details of the message, and
        control whether the message
        should be intercepted and displayed to the user
        for manual review or
        modification.

        """
        pass

    
class IHttpListener(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerHttpListener()</code> to register an
    HTTP listener. The listener will be notified of requests and responses made
    by any Burp tool. Extensions can perform custom analysis or modification of
    these messages by registering an HTTP listener.
     
    """
    
    def processHttpMessage(self, toolFlag, messageIsRequest, messageInfo):
        # type: (int, bool, IHttpRequestResponse) -> None
        """
        This method is invoked when an HTTP request is about to be
        issued, and
        when an HTTP response has been received.
        :param:        A flag indicating the Burp tool that issued the
        request.
        Burp tool flags are defined in the
        <code>IBurpExtenderCallbacks</code> interface.
        :param:        Flags whether the method is being invoked for a
        request or response.
        :param:        Details of the request / response to be processed.
        Extensions can call the setter methods on this
        object to update the
        current message and so modify Burp's behavior.

        """
        pass

    
class IIntruderPayloadGenerator(object):
    """
    This interface is used for custom Intruder payload generators. Extensions
    that have registered an
    <code>IIntruderPayloadGeneratorFactory</code> must return a new instance of
    this interface when required as part of a new Intruder attack.
     
    """
    
    def hasMorePayloads(self):
        # type: () -> bool
        """
        This method is used by Burp to determine whether the payload
        generator is
        able to provide any further payloads.

        
        :return: Extensions should return
        <code>false</code> when all the available payloads have been
        used up,
        otherwise
        <code>true</code>.

        """
        pass

    def getNextPayload(self, baseValue):
        # type: (array) -> array
        """
        This method is used by Burp to obtain the value of the next
        payload.
        :param:        The base value of the current payload position.
        This
        value may be
        <code>null</code> if the concept of a base value
        is not applicable (e.g.
        in a battering ram attack).
        
        :return: The next payload to use in the attack.

        """
        pass

    def reset(self):
        # type: () -> None
        """
        This method is used by Burp to reset the state of the
        payload generator
        so that the next call to
        <code>getNextPayload()</code> returns the first payload
        again. This
        method will be invoked when an attack uses the same payload
        generator for
        more than one payload position, for example in a sniper
        attack.

        """
        pass

    
class IParameter(object):
    """
    This interface is used to hold details about an HTTP request parameter.
     
    """
    PARAM_URL = 0  # type: int
    PARAM_BODY = 1  # type: int
    PARAM_COOKIE = 2  # type: int
    PARAM_XML = 3  # type: int
    PARAM_XML_ATTR = 4  # type: int
    PARAM_MULTIPART_ATTR = 5  # type: int
    PARAM_JSON = 6  # type: int
    
    def getType(self):
        # type: () -> int
        """
        This method is used to retrieve the parameter type.

        
        :return: The parameter type. The available types are defined within
        this
        interface.

        """
        pass

    def getName(self):
        # type: () -> str
        """
        This method is used to retrieve the parameter name.

        
        :return: The parameter name.

        """
        pass

    def getValue(self):
        # type: () -> str
        """
        This method is used to retrieve the parameter value.

        
        :return: The parameter value.

        """
        pass

    def getNameStart(self):
        # type: () -> int
        """
        This method is used to retrieve the start offset of the
        parameter name
        within the HTTP request.

        
        :return: The start offset of the parameter name within the HTTP
        request,
        or -1 if the parameter is not associated with a specific
        request.

        """
        pass

    def getNameEnd(self):
        # type: () -> int
        """
        This method is used to retrieve the end offset of the
        parameter name
        within the HTTP request.

        
        :return: The end offset of the parameter name within the HTTP
        request, or
        -1 if the parameter is not associated with a specific
        request.

        """
        pass

    def getValueStart(self):
        # type: () -> int
        """
        This method is used to retrieve the start offset of the
        parameter value
        within the HTTP request.

        
        :return: The start offset of the parameter value within the HTTP
        request,
        or -1 if the parameter is not associated with a specific
        request.

        """
        pass

    def getValueEnd(self):
        # type: () -> int
        """
        This method is used to retrieve the end offset of the
        parameter value
        within the HTTP request.

        
        :return: The end offset of the parameter value within the HTTP
        request, or
        -1 if the parameter is not associated with a specific
        request.

        """
        pass

    
class ITab(object):
    """
    This interface is used to provide Burp with details of a custom tab that will
    be added to Burp's UI, using a method such as
    <code>IBurpExtenderCallbacks.addSuiteTab()</code>.
     
    """
    
    def getTabCaption(self):
        # type: () -> str
        """
        Burp uses this method to obtain the caption that should
        appear on the
        custom tab when it is displayed.

        
        :return: The caption that should appear on the custom tab when it is
        displayed.

        """
        pass

    def getUiComponent(self):
        # type: () -> Component
        """
        Burp uses this method to obtain the component that should be
        used as the
        contents of the custom tab when it is displayed.

        
        :return: The component that should be used as the contents of the
        custom
        tab when it is displayed.

        """
        pass

    
class IMessageEditorController(object):
    """
    This interface is used by an
    <code>IMessageEditor</code> to obtain details about the currently displayed
    message. Extensions that create instances of Burp's HTTP message editor can
    optionally provide an implementation of
    <code>IMessageEditorController</code>, which the editor will invoke when it
    requires further information about the current message (for example, to send
    it to another Burp tool). Extensions that provide custom editor tabs via an
    <code>IMessageEditorTabFactory</code> will receive a reference to an
    <code>IMessageEditorController</code> object for each tab instance they
    generate, which the tab can invoke if it requires further information about
    the current message.
     
    """
    
    def getHttpService(self):
        # type: () -> IHttpService
        """
        This method is used to retrieve the HTTP service for the
        current message.

        
        :return: The HTTP service for the current message.

        """
        pass

    def getRequest(self):
        # type: () -> array
        """
        This method is used to retrieve the HTTP request associated
        with the
        current message (which may itself be a response).

        
        :return: The HTTP request associated with the current message.

        """
        pass

    def getResponse(self):
        # type: () -> array
        """
        This method is used to retrieve the HTTP response associated
        with the
        current message (which may itself be a request).

        
        :return: The HTTP response associated with the current message.

        """
        pass

    
class IExtensionHelpers(object):
    """
    This interface contains a number of helper methods, which extensions can use
    to assist with various common tasks that arise for Burp extensions.

    Extensions can call <code>IBurpExtenderCallbacks.getHelpers</code> to obtain
    an instance of this interface.
     
    """
    
    def analyzeRequest(self, request):
        # type: (IHttpRequestResponse) -> IRequestInfo
        """
        This method can be used to analyze an HTTP request, and
        obtain various
        key details about it.
        :param:        An <code>IHttpRequestResponse</code> object
        containing the
        request to be analyzed.
        
        :return: An <code>IRequestInfo</code> object that can be queried to
        obtain
        details about the request.

        """
        pass

    def analyzeRequest(self, httpService, request):
        # type: (IHttpService, array) -> IRequestInfo
        """
        This method can be used to analyze an HTTP request, and
        obtain various
        key details about it.
        :param:        The HTTP service associated with the request. This
        is
        optional and may be <code>null</code>, in which
        case the resulting
        <code>IRequestInfo</code> object will not include
        the full request URL.
        :param:        The request to be analyzed.
        
        :return: An <code>IRequestInfo</code> object that can be queried to
        obtain
        details about the request.

        """
        pass

    def analyzeRequest(self, request):
        # type: (array) -> IRequestInfo
        """
        This method can be used to analyze an HTTP request, and
        obtain various
        key details about it. The resulting
        <code>IRequestInfo</code> object will
        not include the full request URL. To obtain the full URL,
        use one of the
        other overloaded <code>analyzeRequest()</code> methods.
        :param:        The request to be analyzed.
        
        :return: An <code>IRequestInfo</code> object that can be queried to
        obtain
        details about the request.

        """
        pass

    def analyzeResponse(self, response):
        # type: (array) -> IResponseInfo
        """
        This method can be used to analyze an HTTP response, and
        obtain various
        key details about it.
        :param:        The response to be analyzed.
        
        :return: An <code>IResponseInfo</code> object that can be queried to
        obtain details about the response.

        """
        pass

    def getRequestParameter(self, request, parameterName):
        # type: (array, str) -> IParameter
        """
        This method can be used to retrieve details of a specified
        parameter
        within an HTTP request. <b>Note:</b> Use
        <code>analyzeRequest()</code> to
        obtain details of all parameters within the request.
        :param:        The request to be inspected for the specified
        parameter.
        :param:        The name of the parameter to retrieve.
        
        :return: An <code>IParameter</code> object that can be queried to
        obtain
        details about the parameter, or <code>null</code> if the
        parameter was
        not found.

        """
        pass

    def urlDecode(self, data):
        # type: (str) -> str
        """
        This method can be used to URL-decode the specified data.
        :param:        The data to be decoded.
        
        :return: The decoded data.

        """
        pass

    def urlEncode(self, data):
        # type: (str) -> str
        """
        This method can be used to URL-encode the specified data.
        Any characters
        that do not need to be encoded within HTTP requests are not
        encoded.
        :param:        The data to be encoded.
        
        :return: The encoded data.

        """
        pass

    def urlDecode(self, data):
        # type: (array) -> array
        """
        This method can be used to URL-decode the specified data.
        :param:        The data to be decoded.
        
        :return: The decoded data.

        """
        pass

    def urlEncode(self, data):
        # type: (array) -> array
        """
        This method can be used to URL-encode the specified data.
        Any characters
        that do not need to be encoded within HTTP requests are not
        encoded.
        :param:        The data to be encoded.
        
        :return: The encoded data.

        """
        pass

    def base64Decode(self, data):
        # type: (str) -> array
        """
        This method can be used to Base64-decode the specified data.
        :param:        The data to be decoded.
        
        :return: The decoded data.

        """
        pass

    def base64Decode(self, data):
        # type: (array) -> array
        """
        This method can be used to Base64-decode the specified data.
        :param:        The data to be decoded.
        
        :return: The decoded data.

        """
        pass

    def base64Encode(self, data):
        # type: (str) -> str
        """
        This method can be used to Base64-encode the specified data.
        :param:        The data to be encoded.
        
        :return: The encoded data.

        """
        pass

    def base64Encode(self, data):
        # type: (array) -> str
        """
        This method can be used to Base64-encode the specified data.
        :param:        The data to be encoded.
        
        :return: The encoded data.

        """
        pass

    def stringToBytes(self, data):
        # type: (str) -> array
        """
        This method can be used to convert data from String form
        into an array of
        bytes. The conversion does not reflect any particular
        character set, and
        a character with the hex representation 0xWXYZ will always
        be converted
        into a byte with the representation 0xYZ. It performs the
        opposite
        conversion to the method <code>bytesToString()</code>, and
        byte-based
        data that is converted to a String and back again using
        these two methods
        is guaranteed to retain its integrity (which may not be the
        case with
        conversions that reflect a given character set).
        :param:        The data to be converted.
        
        :return: The converted data.

        """
        pass

    def bytesToString(self, data):
        # type: (array) -> str
        """
        This method can be used to convert data from an array of
        bytes into
        String form. The conversion does not reflect any particular
        character
        set, and a byte with the representation 0xYZ will always be
        converted
        into a character with the hex representation 0x00YZ. It
        performs the
        opposite conversion to the method
        <code>stringToBytes()</code>, and
        byte-based data that is converted to a String and back again
        using these
        two methods is guaranteed to retain its integrity (which may
        not be the
        case with conversions that reflect a given character set).
        :param:        The data to be converted.
        
        :return: The converted data.

        """
        pass

    def indexOf(self, data, pattern, caseSensitive, from_, to):
        # type: (array, array, bool, int, int) -> int
        """
        This method searches a piece of data for the first
        occurrence of a
        specified pattern. It works on byte-based data in a way that
        is similar
        to the way the native Java method
        <code>String.indexOf()</code> works on
        String-based data.
        :param:        The data to be searched.
        :param:        The pattern to be searched for.
        :param:        Flags whether or not the search is case-sensitive.
        :param:        The offset within <code>data</code> where the
        search should
        begin.
        :param:        The offset within <code>data</code> where the
        search should
        end.
        
        :return: The offset of the first occurrence of the pattern within the
        specified bounds, or -1 if no match is found.

        """
        pass

    def buildHttpMessage(self, headers, body):
        # type: (List[str], array) -> array
        """
        This method builds an HTTP message containing the specified
        headers and
        message body. If applicable, the Content-Length header will
        be added or
        updated, based on the length of the body.
        :param:        A list of headers to include in the message.
        :param:        The body of the message, of <code>null</code> if
        the message
        has an empty body.
        
        :return: The resulting full HTTP message.

        """
        pass

    def buildHttpRequest(self, url):
        # type: (URL) -> array
        """
        This method creates a GET request to the specified URL. The
        headers used
        in the request are determined by the Request headers
        settings as
        configured in Burp Spider's options.
        :param:        The URL to which the request should be made.
        
        :return: A request to the specified URL.

        """
        pass

    def addParameter(self, request, parameter):
        # type: (array, IParameter) -> array
        """
        This method adds a new parameter to an HTTP request, and if
        appropriate
        updates the Content-Length header.
        :param:        The request to which the parameter should be
        added.
        :param:        An <code>IParameter</code> object containing
        details of
        the parameter to be added. Supported parameter
        types are:
        <code>PARAM_URL</code>, <code>PARAM_BODY</code>
        and
        <code>PARAM_COOKIE</code>.
        
        :return: A new HTTP request with the new parameter added.

        """
        pass

    def removeParameter(self, request, parameter):
        # type: (array, IParameter) -> array
        """
        This method removes a parameter from an HTTP request, and if
        appropriate
        updates the Content-Length header.
        :param:        The request from which the parameter should be
        removed.
        :param:        An <code>IParameter</code> object containing
        details of
        the parameter to be removed. Supported parameter
        types are:
        <code>PARAM_URL</code>, <code>PARAM_BODY</code>
        and
        <code>PARAM_COOKIE</code>.
        
        :return: A new HTTP request with the parameter removed.

        """
        pass

    def updateParameter(self, request, parameter):
        # type: (array, IParameter) -> array
        """
        This method updates the value of a parameter within an HTTP
        request, and
        if appropriate updates the Content-Length header.
        <b>Note:</b> This
        method can only be used to update the value of an existing
        parameter of a
        specified type. If you need to change the type of an
        existing parameter,
        you should first call <code>removeParameter()</code> to
        remove the
        parameter with the old type, and then call
        <code>addParameter()</code> to
        add a parameter with the new type.
        :param:        The request containing the parameter to be
        updated.
        :param:        An <code>IParameter</code> object containing
        details of
        the parameter to be updated. Supported parameter
        types are:
        <code>PARAM_URL</code>, <code>PARAM_BODY</code>
        and
        <code>PARAM_COOKIE</code>.
        
        :return: A new HTTP request with the parameter updated.

        """
        pass

    def toggleRequestMethod(self, request):
        # type: (array) -> array
        """
        This method can be used to toggle a request's method between
        GET and
        POST. Parameters are relocated between the URL query string
        and message
        body as required, and the Content-Length header is created
        or removed as
        applicable.
        :param:        The HTTP request whose method should be toggled.
        
        :return: A new HTTP request using the toggled method.

        """
        pass

    def buildHttpService(self, host, port, protocol):
        # type: (str, int, str) -> IHttpService
        """
        This method constructs an <code>IHttpService</code> object
        based on the
        details provided.
        :param:        The HTTP service host.
        :param:        The HTTP service port.
        :param:        The HTTP service protocol.
        
        :return: An <code>IHttpService</code> object based on the details
        provided.

        """
        pass

    def buildHttpService(self, host, port, useHttps):
        # type: (str, int, bool) -> IHttpService
        """
        This method constructs an <code>IHttpService</code> object
        based on the
        details provided.
        :param:        The HTTP service host.
        :param:        The HTTP service port.
        :param:        Flags whether the HTTP service protocol is HTTPS
        or HTTP.
        
        :return: An <code>IHttpService</code> object based on the details
        provided.

        """
        pass

    def buildParameter(self, name, value, type):
        # type: (str, str, int) -> IParameter
        """
        This method constructs an <code>IParameter</code> object
        based on the
        details provided.
        :param:        The parameter name.
        :param:        The parameter value.
        :param:        The parameter type, as defined in the
        <code>IParameter</code>
        interface.
        
        :return: An <code>IParameter</code> object based on the details
        provided.

        """
        pass

    def makeScannerInsertionPoint(self, insertionPointName, baseRequest, from_, to):
        # type: (str, array, int, int) -> IScannerInsertionPoint
        """
        This method constructs an
        <code>IScannerInsertionPoint</code> object
        based on the details provided. It can be used to quickly
        create a simple
        insertion point based on a fixed payload location within a
        base request.
        :param:        The name of the insertion point.
        :param:        The request from which to build scan requests.
        :param:        The offset of the start of the payload location.
        :param:        The offset of the end of the payload location.
        
        :return: An <code>IScannerInsertionPoint</code> object based on the
        details provided.

        """
        pass

    def analyzeResponseVariations(self, responses):
        # type: (array) -> IResponseVariations
        """
        This method analyzes one or more responses to identify
        variations in a
        number of attributes and returns an
        <code>IResponseVariations</code>
        object that can be queried to obtain details of the
        variations.
        :param:        The responses to analyze.
        
        :return: An <code>IResponseVariations</code> object representing the
        variations in the responses.

        """
        pass

    def analyzeResponseKeywords(self, keywords, responses):
        # type: (List[str], array) -> IResponseKeywords
        """
        This method analyzes one or more responses to identify the
        number of
        occurrences of the specified keywords and returns an
        <code>IResponseKeywords</code> object that can be queried to
        obtain
        details of the number of occurrences of each keyword.
        :param:        The keywords to look for.
        :param:        The responses to analyze.
        
        :return: An <code>IResponseKeywords</code> object representing the
        counts
        of the keywords appearing in the responses.

        """
        pass

    
class IMessageEditor(object):
    """
    This interface is used to provide extensions with an instance of Burp's HTTP
    message editor, for the extension to use in its own UI. Extensions should
    call <code>IBurpExtenderCallbacks.createMessageEditor()</code> to obtain an
    instance of this interface.
     
    """
    
    def getComponent(self):
        # type: () -> Component
        """
        This method returns the UI component of the editor, for
        extensions to add
        to their own UI.

        
        :return: The UI component of the editor.

        """
        pass

    def setMessage(self, message, isRequest):
        # type: (array, bool) -> None
        """
        This method is used to display an HTTP message in the
        editor.
        :param:        The HTTP message to be displayed.
        :param:        Flags whether the message is an HTTP request or
        response.

        """
        pass

    def getMessage(self):
        # type: () -> array
        """
        This method is used to retrieve the currently displayed
        message, which
        may have been modified by the user.

        
        :return: The currently displayed HTTP message.

        """
        pass

    def isMessageModified(self):
        # type: () -> bool
        """
        This method is used to determine whether the current message
        has been
        modified by the user.

        
        :return: An indication of whether the current message has been
        modified by
        the user since it was first displayed.

        """
        pass

    def getSelectedData(self):
        # type: () -> array
        """
        This method returns the data that is currently selected by
        the user.

        
        :return: The data that is currently selected by the user, or
        <code>null</code> if no selection is made.

        """
        pass

    def getSelectionBounds(self):
        # type: () -> List[java.lang.Int]
        """
        This method can be used to retrieve the bounds of the user's
        selection
        into the displayed message, if applicable.

        
        :return: An int[2] array containing the start and end offsets of the
        user's selection within the displayed message. If the user
        has not made
        any selection in the current message, both offsets indicate
        the position
        of the caret within the editor. For some editor views, the
        concept of
        selection within the message does not apply, in which case
        this method
        returns null.

        """
        pass

    
class IScanQueueItem(object):
    """
    This interface is used to retrieve details of items in the Burp Scanner
    active scan queue. Extensions can obtain references to scan queue items by
    calling
    <code>IBurpExtenderCallbacks.doActiveScan()</code>.
     
    """
    
    def getStatus(self):
        # type: () -> str
        """
        This method returns a description of the status of the scan
        queue item.

        
        :return: A description of the status of the scan queue item.

        """
        pass

    def getPercentageComplete(self):
        # type: () -> int
        """
        This method returns an indication of the percentage
        completed for the
        scan queue item.

        
        :return: An indication of the percentage completed for the scan queue
        item.

        """
        pass

    def getNumRequests(self):
        # type: () -> int
        """
        This method returns the number of requests that have been
        made for the
        scan queue item.

        
        :return: The number of requests that have been made for the scan
        queue
        item.

        """
        pass

    def getNumErrors(self):
        # type: () -> int
        """
        This method returns the number of network errors that have
        occurred for
        the scan queue item.

        
        :return: The number of network errors that have occurred for the scan
        queue item.

        """
        pass

    def getNumInsertionPoints(self):
        # type: () -> int
        """
        This method returns the number of attack insertion points
        being used for
        the scan queue item.

        
        :return: The number of attack insertion points being used for the
        scan
        queue item.

        """
        pass

    def cancel(self):
        # type: () -> None
        """
        This method allows the scan queue item to be canceled.

        """
        pass

    def getIssues(self):
        # type: () -> List[IScanIssue]
        """
        This method returns details of the issues generated for the
        scan queue
        item. <b>Note:</b> different items within the scan queue may
        contain
        duplicated versions of the same issues - for example, if the
        same request
        has been scanned multiple times. Duplicated issues are
        consolidated in
        the main view of scan results. Extensions can register an
        <code>IScannerListener</code> to get details only of unique,
        newly
        discovered Scanner issues post-consolidation.

        
        :return: Details of the issues generated for the scan queue item.

        """
        pass

    
class ITempFile(object):
    """
    This interface is used to hold details of a temporary file that has been
    created via a call to
    <code>IBurpExtenderCallbacks.saveToTempFile()</code>.

     
    """
    
    def getBuffer(self):
        # type: () -> array
        """
        This method is used to retrieve the contents of the buffer
        that was saved
        in the temporary file.

        
        :return: The contents of the buffer that was saved in the temporary
        file.

        """
        pass

    def delete(self):
        # type: () -> None
        """
        This method is deprecated and no longer performs any action.

        """
        pass

    
class IMessageEditorTabFactory(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerMessageEditorTabFactory()</code> to
    register a factory for custom message editor tabs. This allows extensions to
    provide custom rendering or editing of HTTP messages, within Burp's own HTTP
    editor.
     
    """
    
    def createNewInstance(self, controller, editable):
        # type: (IMessageEditorController, bool) -> IMessageEditorTab
        """
        Burp will call this method once for each HTTP message
        editor, and the
        factory should provide a new instance of an
        <code>IMessageEditorTab</code> object.
        :param:        An
        <code>IMessageEditorController</code> object,
        which the new tab can query
        to retrieve details about the currently displayed
        message. This may be
        <code>null</code> for extension-invoked message
        editors where the
        extension has not provided an editor controller.
        :param:        Indicates whether the hosting editor is editable
        or
        read-only.
        
        :return: A new
        <code>IMessageEditorTab</code> object for use within the
        message editor.

        """
        pass

    
class IResponseInfo(object):
    """
    This interface is used to retrieve key details about an HTTP response.
    Extensions can obtain an
    <code>IResponseInfo</code> object for a given response by calling
    <code>IExtensionHelpers.analyzeResponse()</code>.
     
    """
    
    def getHeaders(self):
        # type: () -> List[str]
        """
        This method is used to obtain the HTTP headers contained in
        the response.

        
        :return: The HTTP headers contained in the response.

        """
        pass

    def getBodyOffset(self):
        # type: () -> int
        """
        This method is used to obtain the offset within the response
        where the
        message body begins.

        
        :return: The offset within the response where the message body
        begins.

        """
        pass

    def getStatusCode(self):
        # type: () -> int
        """
        This method is used to obtain the HTTP status code contained
        in the
        response.

        
        :return: The HTTP status code contained in the response.

        """
        pass

    def getCookies(self):
        # type: () -> List[ICookie]
        """
        This method is used to obtain details of the HTTP cookies
        set in the
        response.

        
        :return: A list of <code>ICookie</code> objects representing the
        cookies
        set in the response, if any.

        """
        pass

    def getStatedMimeType(self):
        # type: () -> str
        """
        This method is used to obtain the MIME type of the response,
        as stated in
        the HTTP headers.

        
        :return: A textual label for the stated MIME type, or an empty String
        if
        this is not known or recognized. The possible labels are the
        same as
        those used in the main Burp UI.

        """
        pass

    def getInferredMimeType(self):
        # type: () -> str
        """
        This method is used to obtain the MIME type of the response,
        as inferred
        from the contents of the HTTP message body.

        
        :return: A textual label for the inferred MIME type, or an empty
        String if
        this is not known or recognized. The possible labels are the
        same as
        those used in the main Burp UI.

        """
        pass

    
class IBurpExtender(object):
    """
    All extensions must implement this interface.

    Implementations must be called BurpExtender, in the package burp, must be
    declared public, and must provide a default (public, no-argument)
    constructor.
     
    """
    
    def registerExtenderCallbacks(self, callbacks):
        # type: (IBurpExtenderCallbacks) -> None
        """
        This method is invoked when the extension is loaded. It
        registers an
        instance of the
        <code>IBurpExtenderCallbacks</code> interface, providing
        methods that may
        be invoked by the extension to perform various actions.

        :param:        An
        <code>IBurpExtenderCallbacks</code> object.

        """
        pass

    
class IMenuItemHandler(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerMenuItem()</code> to register a custom
    context menu item.

    @deprecated Use
    <code>IContextMenuFactory</code> instead.
     
    """
    
    def menuItemClicked(self, menuItemCaption, messageInfo):
        # type: (str, List[IHttpRequestResponse]) -> None
        """
        This method is invoked by Burp Suite when the user clicks on
        a custom
        menu item which the extension has registered with Burp.
        :param:        The caption of the menu item which was clicked.
        This parameter enables extensions to provide a
        single implementation
        which handles multiple different menu items.
        :param:        Details of the HTTP message(s) for which the
        context
        menu was displayed.

        """
        pass

    
class IBurpCollaboratorClientContext(object):
    """
    This interface represents an instance of a Burp Collaborator client context,
    which can be used to generate Burp Collaborator payloads and poll the
    Collaborator server for any network interactions that result from using those
    payloads. Extensions can obtain new instances of this class by calling
    <code>IBurpExtenderCallbacks.createBurpCollaboratorClientContext()</code>.
    Note that each Burp Collaborator client context is tied to the Collaborator
    server configuration that was in place at the time the context was created.
     
    """
    
    def generatePayload(self, includeCollaboratorServerLocation):
        # type: (bool) -> str
        """
        This method is used to generate new Burp Collaborator
        payloads.
        :param:        Specifies whether to include the
        Collaborator server location in the generated
        payload.
        
        :return: The payload that was generated.

        """
        pass

    def fetchAllCollaboratorInteractions(self):
        # type: () -> List[IBurpCollaboratorInteraction]
        """
        This method is used to retrieve all interactions received by
        the
        Collaborator server resulting from payloads that were
        generated for this
        context.

        
        :return: The Collaborator interactions that have occurred resulting
        from
        payloads that were generated for this context.

        """
        pass

    def fetchCollaboratorInteractionsFor(self, payload):
        # type: (str) -> List[IBurpCollaboratorInteraction]
        """
        This method is used to retrieve interactions received by the
        Collaborator
        server resulting from a single payload that was generated
        for this
        context.
        :param:        The payload for which interactions will be
        retrieved.
        
        :return: The Collaborator interactions that have occurred resulting
        from
        the given payload.

        """
        pass

    def fetchAllInfiltratorInteractions(self):
        # type: () -> List[IBurpCollaboratorInteraction]
        """
        This method is used to retrieve all interactions made by
        Burp Infiltrator
        instrumentation resulting from payloads that were generated
        for this
        context.

        
        :return: The interactions triggered by the Burp Infiltrator
        instrumentation that have occurred resulting from payloads
        that were
        generated for this context.

        """
        pass

    def fetchInfiltratorInteractionsFor(self, payload):
        # type: (str) -> List[IBurpCollaboratorInteraction]
        """
        This method is used to retrieve interactions made by Burp
        Infiltrator
        instrumentation resulting from a single payload that was
        generated for
        this context.
        :param:        The payload for which interactions will be
        retrieved.
        
        :return: The interactions triggered by the Burp Infiltrator
        instrumentation that have occurred resulting from the given
        payload.

        """
        pass

    def getCollaboratorServerLocation(self):
        # type: () -> str
        """
        This method is used to retrieve the network location of the
        Collaborator
        server.

        
        :return: The hostname or IP address of the Collaborator server.

        """
        pass

    
class IResponseKeywords(object):
    """
    This interface is used to represent the counts of keywords appearing in a
    number of HTTP responses.
     
    """
    
    def getVariantKeywords(self):
        # type: () -> List[str]
        """
        This method is used to obtain the list of keywords whose
        counts vary
        between the analyzed responses.

        
        :return: The keywords whose counts vary between the analyzed
        responses.

        """
        pass

    def getInvariantKeywords(self):
        # type: () -> List[str]
        """
        This method is used to obtain the list of keywords whose
        counts do not
        vary between the analyzed responses.

        
        :return: The keywords whose counts do not vary between the analyzed
        responses.

        """
        pass

    def getKeywordCount(self, keyword, responseIndex):
        # type: (str, int) -> int
        """
        This method is used to obtain the number of occurrences of
        an individual
        keyword in a response.
        :param:        The keyword whose count will be retrieved.
        :param:        The index of the response. Note responses are
        indexed from zero in the order they were
        originally supplied to the
        <code>IExtensionHelpers.analyzeResponseKeywords()<
        /code> and
        <code>IResponseKeywords.updateWith()</code>
        methods.
        
        :return: The number of occurrences of the specified keyword for the
        specified response.

        """
        pass

    def updateWith(self, responses):
        # type: (array) -> None
        """
        This method is used to update the analysis based on
        additional responses.

        :param:        The new responses to include in the analysis.

        """
        pass

    
class IScanIssue(object):
    """
    This interface is used to retrieve details of Scanner issues. Extensions can
    obtain details of issues by registering an <code>IScannerListener</code> or
    by calling <code>IBurpExtenderCallbacks.getScanIssues()</code>. Extensions
    can also add custom Scanner issues by registering an
    <code>IScannerCheck</code> or calling
    <code>IBurpExtenderCallbacks.addScanIssue()</code>, and providing their own
    implementations of this interface. Note that issue descriptions and other
    text generated by extensions are subject to an HTML whitelist that allows
    only formatting tags and simple hyperlinks.
     
    """
    
    def getUrl(self):
        # type: () -> java
        """
        This method returns the URL for which the issue was
        generated.

        
        :return: The URL for which the issue was generated.

        """
        pass

    def getIssueName(self):
        # type: () -> str
        """
        This method returns the name of the issue type.

        
        :return: The name of the issue type (e.g. "SQL injection").

        """
        pass

    def getIssueType(self):
        # type: () -> int
        """
        This method returns a numeric identifier of the issue type.
        See the Burp
        Scanner help documentation for a listing of all the issue
        types.

        
        :return: A numeric identifier of the issue type.

        """
        pass

    def getSeverity(self):
        # type: () -> str
        """
        This method returns the issue severity level.

        
        :return: The issue severity level. Expected values are "High",
        "Medium",
        "Low", "Information" or "False positive".


        """
        pass

    def getConfidence(self):
        # type: () -> str
        """
        This method returns the issue confidence level.

        
        :return: The issue confidence level. Expected values are "Certain",
        "Firm"
        or "Tentative".

        """
        pass

    def getIssueBackground(self):
        # type: () -> str
        """
        This method returns a background description for this type
        of issue.

        
        :return: A background description for this type of issue, or
        <code>null</code> if none applies. A limited set of HTML
        tags may be
        used.

        """
        pass

    def getRemediationBackground(self):
        # type: () -> str
        """
        This method returns a background description of the
        remediation for this
        type of issue.

        
        :return: A background description of the remediation for this type of
        issue, or <code>null</code> if none applies. A limited set
        of HTML tags
        may be used.

        """
        pass

    def getIssueDetail(self):
        # type: () -> str
        """
        This method returns detailed information about this specific
        instance of
        the issue.

        
        :return: Detailed information about this specific instance of the
        issue,
        or <code>null</code> if none applies. A limited set of HTML
        tags may be
        used.

        """
        pass

    def getRemediationDetail(self):
        # type: () -> str
        """
        This method returns detailed information about the
        remediation for this
        specific instance of the issue.

        
        :return: Detailed information about the remediation for this specific
        instance of the issue, or <code>null</code> if none applies.
        A limited
        set of HTML tags may be used.

        """
        pass

    def getHttpMessages(self):
        # type: () -> List[IHttpRequestResponse]
        """
        This method returns the HTTP messages on the basis of which
        the issue was
        generated.

        
        :return: The HTTP messages on the basis of which the issue was
        generated.
        <b>Note:</b> The items in this array should be instances of
        <code>IHttpRequestResponseWithMarkers</code> if applicable,
        so that
        details of the relevant portions of the request and response
        messages are
        available.

        """
        pass

    def getHttpService(self):
        # type: () -> IHttpService
        """
        This method returns the HTTP service for which the issue was
        generated.

        
        :return: The HTTP service for which the issue was generated.

        """
        pass

    
class IScopeChangeListener(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerScopeChangeListener()</code> to register
    a scope change listener. The listener will be notified whenever a change
    occurs to Burp's suite-wide target scope.
     
    """
    
    def scopeChanged(self):
        # type: () -> None
        """
        This method is invoked whenever a change occurs to Burp's
        suite-wide
        target scope.

        """
        pass

    
class IIntruderPayloadProcessor(object):
    """
    Extensions can implement this interface and then call
    <code>IBurpExtenderCallbacks.registerIntruderPayloadProcessor()</code> to
    register a custom Intruder payload processor.
     
    """
    
    def getProcessorName(self):
        # type: () -> str
        """
        This method is used by Burp to obtain the name of the
        payload processor.
        This will be displayed as an option within the Intruder UI
        when the user
        selects to use an extension-provided payload processor.

        
        :return: The name of the payload processor.

        """
        pass

    def processPayload(self, currentPayload, originalPayload, baseValue):
        # type: (array, array, array) -> array
        """
        This method is invoked by Burp each time the processor
        should be applied
        to an Intruder payload.
        :param:        The value of the payload to be processed.
        :param:        The value of the original payload prior to
        processing by any already-applied processing
        rules.
        :param:        The base value of the payload position, which will
        be
        replaced with the current payload.
        
        :return: The value of the processed payload. This may be
        <code>null</code> to indicate that the current payload
        should be skipped,
        and the attack will move directly to the next payload.

        """
        pass

    
class ITextEditor(object):
    """
    This interface is used to provide extensions with an instance of Burp's raw
    text editor, for the extension to use in its own UI. Extensions should call
    <code>IBurpExtenderCallbacks.createTextEditor()</code> to obtain an instance
    of this interface.
     
    """
    
    def getComponent(self):
        # type: () -> Component
        """
        This method returns the UI component of the editor, for
        extensions to add
        to their own UI.

        
        :return: The UI component of the editor.

        """
        pass

    def setEditable(self, editable):
        # type: (bool) -> None
        """
        This method is used to control whether the editor is
        currently editable.
        This status can be toggled on and off as required.

        :param:        Indicates whether the editor should be currently
        editable.

        """
        pass

    def setText(self, text):
        # type: (array) -> None
        """
        This method is used to update the currently displayed text
        in the editor.

        :param:        The text to be displayed.

        """
        pass

    def getText(self):
        # type: () -> array
        """
        This method is used to retrieve the currently displayed
        text.

        
        :return: The currently displayed text.

        """
        pass

    def isTextModified(self):
        # type: () -> bool
        """
        This method is used to determine whether the user has
        modified the
        contents of the editor.

        
        :return: An indication of whether the user has modified the contents
        of
        the editor since the last call to
        <code>setText()</code>.

        """
        pass

    def getSelectedText(self):
        # type: () -> array
        """
        This method is used to obtain the currently selected text.

        
        :return: The currently selected text, or
        <code>null</code> if the user has not made any selection.

        """
        pass

    def getSelectionBounds(self):
        # type: () -> List[java.lang.Int]
        """
        This method can be used to retrieve the bounds of the user's
        selection
        into the displayed text, if applicable.

        
        :return: An int[2] array containing the start and end offsets of the
        user's selection within the displayed text. If the user has
        not made any
        selection in the current message, both offsets indicate the
        position of
        the caret within the editor.

        """
        pass

    def setSearchExpression(self, expression):
        # type: (str) -> None
        """
        This method is used to update the search expression that is
        shown in the
        search bar below the editor. The editor will automatically
        highlight any
        regions of the displayed text that match the search
        expression.

        :param:        The search expression.

        """
        pass

    
class IHttpRequestResponsePersisted(IHttpRequestResponse):
    """
    This interface is used for an
    <code>IHttpRequestResponse</code> object whose request and response messages
    have been saved to temporary files using
    <code>IBurpExtenderCallbacks.saveBuffersToTempFiles()</code>.
     
    """
    
    def deleteTempFiles(self):
        # type: () -> None
        """
        This method is deprecated and no longer performs any action.

        """
        pass

    
class IHttpRequestResponseWithMarkers(IHttpRequestResponse):
    """
    This interface is used for an
    <code>IHttpRequestResponse</code> object that has had markers applied.
    Extensions can create instances of this interface using
    <code>IBurpExtenderCallbacks.applyMarkers()</code>, or provide their own
    implementation. Markers are used in various situations, such as specifying
    Intruder payload positions, Scanner insertion points, and highlights in
    Scanner issues.
     
    """
    
    def getRequestMarkers(self):
        # type: () -> List[List[java.lang.Int]]
        """
        This method returns the details of the request markers.

        
        :return: A list of index pairs representing the offsets of markers
        for the
        request message. Each item in the list is an int[2] array
        containing the
        start and end offsets for the marker. The method may return
        <code>null</code> if no request markers are defined.

        """
        pass

    def getResponseMarkers(self):
        # type: () -> List[List[java.lang.Int]]
        """
        This method returns the details of the response markers.

        
        :return: A list of index pairs representing the offsets of markers
        for the
        response message. Each item in the list is an int[2] array
        containing the
        start and end offsets for the marker. The method may return
        <code>null</code> if no response markers are defined.

        """
        pass

    
