"""
Django settings for chai_django project.

Generated by 'django-admin startproject' using Django 1.10.1.

For more information on this file, see
https://docs.djangoproject.com/en/1.10/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.10/ref/settings/
"""

import os

PROJECT_NAME = 'django_framework_project'

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.10/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'r%z^)v_=p7tcb0py7xxi(uy)jleo=v&39_bcxo#(82)mj#if4g'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']
INTERNAL_IPS = ['127.0.0.1']


# Database
# https://docs.djangoproject.com/en/1.10/ref/settings/#databases

DATABASES = {
    'default': {

        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'chai_django_db2',
        'USER': 'root',
        'PASSWORD': '',
        'HOST': '127.0.0.1',
        'PORT': '3306',
    }
}


PRIVATE_TRIPLE_DES_TOKEN_KEY = '0a405340000b493d8cf0' # this is used to encrypt your tokens so this really cant ever change!
IS_AUTHENTICATION_SERVER = True  # flag is used to determine if this server is allowed to verify integrity of Token

from kafka import KafkaProducer
import json
try:
    # kafka_connection = KafkaProducer(bootstrap_servers=['localhost:9092'])
    KAFKA_PRODUCER   = KafkaProducer(bootstrap_servers=['localhost:9092'], value_serializer=lambda m: json.dumps(m).encode('ascii'))
    KAFKA_ENABLED = True
except:
    KAFKA_ENABLED = False
    


REDIS_CACHE_ENABLED = True
CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": "redis://127.0.0.1:6379/1",
        "OPTIONS": {
            "CLIENT_CLASS": "django_redis.client.DefaultClient",
        }
    }
}


ALLOW_SEND_JOBS = True
SEND_JOB_URL = 'https://redisapi.chaienergy.net/set_job/?format=json'

SERVER_URL = 'localhost'
SERVER_GROUP = 'service'
SERVER_NAME = 'service1'