#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.cmdutils',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20220315',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    ('Convenience functions for working with the Cmd module, the BaseCommand class '    
 'for constructing command line programmes, and other command line related '    
 'stuff.'),
  long_description =
    ('Convenience functions for working with the Cmd module,\n'    
 'the BaseCommand class for constructing command line programmes,\n'    
 'and other command line related stuff.\n'    
 '\n'    
 '*Latest release 20220315*:\n'    
 '_BaseSubCommand.__init__: hook in the class USAGE_KEYWORDS for methods.\n'    
 '\n'    
 '## Class `BaseCommand`\n'    
 '\n'    
 'A base class for handling nestable command lines.\n'    
 '\n'    
 'This class provides the basic parse and dispatch mechanisms\n'    
 'for command lines.\n'    
 'To implement a command line\n'    
 'one instantiates a subclass of `BaseCommand`:\n'    
 '\n'    
 '    class MyCommand(BaseCommand):\n'    
 "        GETOPT_SPEC = 'ab:c'\n"    
 '        USAGE_FORMAT = r"""Usage: {cmd} [-a] [-b bvalue] [-c] [--] '    
 'arguments...\n'    
 '          -a    Do it all.\n'    
 '          -b    But using bvalue.\n'    
 "          -c    The 'c' option!\n"    
 '        """\n'    
 '        ...\n'    
 '\n'    
 'and provides either a `main` method if the command has no subcommands\n'    
 'or a suite of `cmd_`*subcommand* methods, one per subcommand.\n'    
 '\n'    
 'Running a command is done by:\n'    
 '\n'    
 '    MyCommand(argv).run()\n'    
 '\n'    
 'or via the convenience method:\n'    
 '\n'    
 '    MyCommand.run_argv(argv)\n'    
 '\n'    
 'Modules which implement a command line mode generally look like this:\n'    
 '\n'    
 '    ... imports etc ...\n'    
 '    ... other code ...\n'    
 '    class MyCommand(BaseCommand):\n'    
 '    ... other code ...\n'    
 "    if __name__ == '__main__':\n"    
 '        sys.exit(MyCommand.run_argv(sys.argv))\n'    
 '\n'    
 'Instances have a `self.options` attribute on which optional\n'    
 'modes are set,\n'    
 'avoiding conflict with the attributes of `self`.\n'    
 '\n'    
 'Subclasses with no subcommands\n'    
 'generally just implement a `main(argv)` method.\n'    
 '\n'    
 'Subclasses with subcommands\n'    
 'should implement a `cmd_`*subcommand*`(argv)` instance method\n'    
 'for each subcommand.\n'    
 'If a subcommand is itself implemented using `BaseCommand`\n'    
 'then it can be a simple attribute:\n'    
 '\n'    
 '    cmd_subthing = SubThingCommand\n'    
 '\n'    
 'Returning to methods, if there is a paragraph in the method docstring\n'    
 'commencing with `Usage:`\n'    
 'then that paragraph is incorporated automatically\n'    
 'into the main usage message.\n'    
 'Example:\n'    
 '\n'    
 '    def cmd_ls(self, argv):\n'    
 '        """ Usage: {cmd} [paths...]\n'    
 '              Emit a listing for the named paths.\n'    
 '\n'    
 '            Further docstring non-usage information here.\n'    
 '        """\n'    
 '        ... do the "ls" subcommand ...\n'    
 '\n'    
 'The subclass is customised by overriding the following methods:\n'    
 '* `apply_defaults()`:\n'    
 '  prepare the initial state of `self.options`\n'    
 '  before any command line options are applied.\n'    
 '* `apply_opt(opt,val)`:\n'    
 '  apply an individual getopt global command line option\n'    
 '  to `self.options`.\n'    
 '* `apply_opts(opts)`:\n'    
 '  apply the `opts` to `self.options`.\n'    
 '  `opts` is an `(option,value)` sequence\n'    
 '  as returned by `getopot.getopt`.\n'    
 '  The default implementation iterates over these and calls `apply_opt`.\n'    
 '* `cmd_`*subcmd*`(argv)`:\n'    
 '  if the command line options are followed by an argument\n'    
 '  whose value is *subcmd*,\n'    
 '  then the method `cmd_`*subcmd*`(subcmd_argv)`\n'    
 '  will be called where `subcmd_argv` contains the command line arguments\n'    
 '  following *subcmd*.\n'    
 '* `main(argv)`:\n'    
 '  if there are no command line arguments after the options\n'    
 '  or the first argument does not have a corresponding\n'    
 '  `cmd_`*subcmd* method\n'    
 '  then method `main(argv)`\n'    
 '  will be called where `argv` contains the command line arguments.\n'    
 '* `run_context()`:\n'    
 '  a context manager to provide setup or teardown actions\n'    
 '  to occur before and after the command implementation respectively,\n'    
 '  such as to open and close a database.\n'    
 '\n'    
 'Editorial: why not arparse?\n'    
 'Primarily because when incorrectly invoked\n'    
 'an argparse command line prints the help/usage messgae\n'    
 'and aborts the whole programme with `SystemExit`.\n'    
 '\n'    
 '*Method `BaseCommand.__init__(self, argv=None, *, cmd=None, '    
 '**kw_options)`*:\n'    
 'Initialise the command line.\n'    
 'Raises `GetoptError` for unrecognised options.\n'    
 '\n'    
 'Parameters:\n'    
 '* `argv`:\n'    
 '  optional command line arguments\n'    
 '  including the main command name if `cmd` is not specified.\n'    
 '  The default is `sys.argv`.\n'    
 '  The contents of `argv` are copied,\n'    
 '  permitting desctructive parsing of `argv`.\n'    
 '* `options`:\n'    
 '  a optional object for command state and context.\n'    
 '  If not specified a new `SimpleNamespace`\n'    
 '  is allocated for use as `options`,\n'    
 '  and prefilled with `.cmd` set to `cmd`\n'    
 '  and other values as set by `.apply_defaults()`\n'    
 '  if such a method is provided.\n'    
 '* `cmd`:\n'    
 '  optional command name for context;\n'    
 '  if this is not specified it is taken from `argv.pop(0)`.\n'    
 'Other keyword arguments are applied to `self.options`\n'    
 'as attributes.\n'    
 '\n'    
 'The command line arguments are parsed according to\n'    
 "the optional `GETOPT_SPEC` class attribute (default `''`).\n"    
 'If `getopt_spec` is not empty\n'    
 'then `apply_opts(opts)` is called\n'    
 'to apply the supplied options to the state\n'    
 'where `opts` is the return from `getopt.getopt(argv,getopt_spec)`.\n'    
 '\n'    
 'After the option parse,\n'    
 'if the first command line argument *foo*\n'    
 'has a corresponding method `cmd_`*foo*\n'    
 'then that argument is removed from the start of `argv`\n'    
 'and `self.cmd_`*foo*`(argv,options,cmd=`*foo*`)` is called\n'    
 'and its value returned.\n'    
 'Otherwise `self.main(argv,options)` is called\n'    
 'and its value returned.\n'    
 '\n'    
 'If the command implementation requires some setup or teardown\n'    
 'then this may be provided by the `run_context`\n'    
 'context manager method,\n'    
 'called with `cmd=`*subcmd* for subcommands\n'    
 'and with `cmd=None` for `main`.\n'    
 '\n'    
 '*`BaseCommand.OPTIONS_CLASS`*\n'    
 '\n'    
 '*Method `BaseCommand.__init_subclass__()`*:\n'    
 'Update subclasses of `BaseCommand`.\n'    
 '\n'    
 'Appends the usage message to the class docstring.\n'    
 '\n'    
 '*Method `BaseCommand.apply_defaults(self)`*:\n'    
 'Stub `apply_defaults` method.\n'    
 '\n'    
 'Subclasses can override this to set up the initial state of `self.options`.\n'    
 '\n'    
 '*Method `BaseCommand.apply_opt(self, *a, **kw)`*:\n'    
 'Handle an individual global command line option.\n'    
 '\n'    
 'This default implementation raises a `RuntimeError`.\n'    
 'It only fires if `getopt` actually gathered arguments\n'    
 'and would imply that a `GETOPT_SPEC` was supplied\n'    
 'without an `apply_opt` or `apply_opts` method to implement the options.\n'    
 '\n'    
 '*Method `BaseCommand.apply_opts(self, opts)`*:\n'    
 'Apply command line options.\n'    
 '\n'    
 '*Method `BaseCommand.apply_preargv(self, argv)`*:\n'    
 'Do any preparsing of `argv` before the subcommand/main-args.\n'    
 'Return the remaining arguments.\n'    
 '\n'    
 'This default implementation returns `argv` unchanged.\n'    
 '\n'    
 '*Method `BaseCommand.cmd_help(argv)`*:\n'    
 'Usage: {cmd} [-l] [subcommand-names...]\n'    
 'Print the full help for the named subcommands,\n'    
 'or for all subcommands if no names are specified.\n'    
 '-l  Long help even if no subcommand-names provided.\n'    
 '\n'    
 '*Method `BaseCommand.getopt_error_handler(cmd, options, e, usage, '    
 'subcmd=None)`*:\n'    
 'The `getopt_error_handler` method\n'    
 'is used to control the handling of `GetoptError`s raised\n'    
 'during the command line parse\n'    
 'or during the `main` or `cmd_`*subcmd*` calls.\n'    
 '\n'    
 'This default handler issues a warning containing the exception text,\n'    
 'prints the usage message to standard error,\n'    
 'and returns `True` to indicate that the error has been handled.\n'    
 '\n'    
 'The handler is called with these parameters:\n'    
 '* `cmd`: the command name\n'    
 '* `options`: the `options` object\n'    
 '* `e`: the `GetoptError` exception\n'    
 '* `usage`: the command usage or `None` if this was not provided\n'    
 '* `subcmd`: optional subcommand name;\n'    
 '  if not `None`, is the name of the subcommand which caused the error\n'    
 '\n'    
 'It returns a true value if the exception is considered handled,\n'    
 'in which case the main `run` method returns 2.\n'    
 'It returns a false value if the exception is considered unhandled,\n'    
 'in which case the main `run` method reraises the `GetoptError`.\n'    
 '\n'    
 'To let the exceptions out unhandled\n'    
 'this can be overridden with a method which just returns `False`.\n'    
 '\n'    
 'Otherwise,\n'    
 'the handler may perform any suitable action\n'    
 'and return `True` to contain the exception\n'    
 'or `False` to cause the exception to be reraised.\n'    
 '\n'    
 '*Method `BaseCommand.run(self, **kw_options)`*:\n'    
 'Run a command.\n'    
 'Returns the exit status of the command.\n'    
 'May raise `GetoptError` from subcommands.\n'    
 '\n'    
 'Any keyword arguments are used to override `self.options` attributes\n'    
 'for the duration of the run,\n'    
 'for example to presupply a shared `RunState` from an outer context.\n'    
 '\n'    
 'If the first command line argument *foo*\n'    
 'has a corresponding method `cmd_`*foo*\n'    
 'then that argument is removed from the start of `argv`\n'    
 'and `self.cmd_`*foo*`(cmd=`*foo*`)` is called\n'    
 'and its value returned.\n'    
 'Otherwise `self.main(argv)` is called\n'    
 'and its value returned.\n'    
 '\n'    
 'If the command implementation requires some setup or teardown\n'    
 'then this may be provided by the `run_context`\n'    
 'context manager method,\n'    
 'called with `cmd=`*subcmd* for subcommands\n'    
 'and with `cmd=None` for `main`.\n'    
 '\n'    
 '*Method `BaseCommand.run_argv(argv, **kw)`*:\n'    
 'Create an instance for `argv` and call its `.run()` method.\n'    
 '\n'    
 '*Method `BaseCommand.run_context()`*:\n'    
 'Stub context manager which surrounds `main` or `cmd_`*subcmd*.\n'    
 '\n'    
 '*Method `BaseCommand.subcommand_usage_text(subcmd, '    
 'usage_format_mapping=None, short=False)`*:\n'    
 'Return the usage text for a subcommand.\n'    
 '\n'    
 'Parameters:\n'    
 '* `subcmd`: the subcommand name\n'    
 '* `short`: just include the first line of the usage message,\n'    
 '  intented for when there are many subcommands\n'    
 '\n'    
 '*Method `BaseCommand.subcommands()`*:\n'    
 'Return a mapping of subcommand names to subcommand specifications\n'    
 'for class attributes which commence with `cls.SUBCOMMAND_METHOD_PREFIX`\n'    
 "by default `'cmd_'`.\n"    
 '\n'    
 '*Method `BaseCommand.usage_text(*, cmd=None, format_mapping=None, '    
 'subcmd=None, short=False)`*:\n'    
 'Compute the "Usage:" message for this class\n'    
 'from the top level `USAGE_FORMAT`\n'    
 "and the `'Usage:'`-containing docstrings\n"    
 'from its `cmd_*` methods.\n'    
 '\n'    
 'Parameters:\n'    
 '* `cmd`: optional command name, default derived from the class name\n'    
 '* `format_mapping`: an optional format mapping for filling\n'    
 '  in format strings in the usage text\n'    
 '* `subcmd`: constrain the usage to a particular subcommand named `subcmd`;\n'    
 '  this is used to produce a shorter usage for subcommand usage failures\n'    
 '\n'    
 '## Function `docmd(dofunc)`\n'    
 '\n'    
 'Decorator for `cmd.Cmd` subclass methods\n'    
 'to supply some basic quality of service.\n'    
 '\n'    
 'This decorator:\n'    
 '- wraps the function call in a `cs.pfx.Pfx` for context\n'    
 '- intercepts `getopt.GetoptError`s, issues a `warning`\n'    
 '  and runs `self.do_help` with the method name,\n'    
 '  then returns `None`\n'    
 '- intercepts other `Exception`s,\n'    
 '  issues an `exception` log message\n'    
 '  and returns `None`\n'    
 '\n'    
 'The intended use is to decorate `cmd.Cmd` `do_`* methods:\n'    
 '\n'    
 '    from cmd import Cmd\n'    
 '    from cs.cmdutils import docmd\n'    
 '    ...\n'    
 '    class MyCmd(Cmd):\n'    
 '        @docmd\n'    
 '        def do_something(...):\n'    
 '            ... do something ...\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20220315*:\n'    
 '_BaseSubCommand.__init__: hook in the class USAGE_KEYWORDS for methods.\n'    
 '\n'    
 '*Release 20220311*:\n'    
 'BaseCommand: big refactor of subcommand internals and make the '    
 '"cmd_foo=FooCommand" implementation work properly.\n'    
 '\n'    
 '*Release 20211208*:\n'    
 'BaseCommand: better handle an unknown subcommand.\n'    
 '\n'    
 '*Release 20210927*:\n'    
 '* Usage: show only the per subcommand usage for in-subcommand GetoptError.\n'    
 '* Usage: show terse usage when the subcommand cannot be recognised.\n'    
 '* Usage: support bare -h, -help, --help.\n'    
 '\n'    
 '*Release 20210913*:\n'    
 'New BaseCommand.apply_preargv method to gather special arguments before '    
 'subcommands.\n'    
 '\n'    
 '*Release 20210906*:\n'    
 '* BaseCommand.cmd_help: bugfix obsolete parameter list.\n'    
 '* BaseCommand.SUBCOMMAND_ARGV_DEFAULT: support a single str value, turn into '    
 'list.\n'    
 '\n'    
 '*Release 20210809*:\n'    
 'Bugfix BaseCommand.cmd_help for modern API.\n'    
 '\n'    
 '*Release 20210731*:\n'    
 '* BaseCommand.run: apply optional keyword arguments to self.options during '    
 'the run.\n'    
 '* Look for self.SUBCOMMAND_ARGV_DEFAULT if no subcommand is supplied.\n'    
 '* Bugfix case for "main" method and no "cmd_*" methods.\n'    
 '* Bugfix BaseCommand.cmd_help.\n'    
 '\n'    
 '*Release 20210420*:\n'    
 '* BaseCommand.getopt_error_handler: replace error print() with warning().\n'    
 '* Docstring improvements.\n'    
 '\n'    
 '*Release 20210407.1*:\n'    
 'BaseCommand: bugfix for __init_subclass__ docstring update.\n'    
 '\n'    
 '*Release 20210407*:\n'    
 '* BaseCommand.__init_subclass__: behave sanely if the subclass has no '    
 'initial __doc__.\n'    
 '* BaseCommand: new .run_argv convenience method, obviates the "def main" '    
 'boilerplate.\n'    
 '\n'    
 '*Release 20210404*:\n'    
 'BaseCommand subclasses: automatically add the main usage message to the '    
 'subclass docstring.\n'    
 '\n'    
 '*Release 20210306*:\n'    
 '* BREAKING CHANGE: rework BaseCommand as a more normal class instantiated '    
 'with argv and with most methods being instance methods, getting the former '    
 '`options` parameter from self.options.\n'    
 '* BaseCommand: provide default `apply_opt` and `apply_opts` methods; '    
 'subclasses will generally just override the former.\n'    
 '\n'    
 '*Release 20210123*:\n'    
 'BaseCommand: propagate the format mapping (cmd, USAGE_KEYWORDS) to the '    
 'subusage generation.\n'    
 '\n'    
 '*Release 20201102*:\n'    
 '* BaseCommand.cmd_help: supply usage only for "all commands", full docstring '    
 'for specified commands.\n'    
 '* BaseCommand: honour presupplied options.log_level.\n'    
 '* BaseCommand.usage_text: handle missing USAGE_FORMAT better.\n'    
 '* BaseCommand.run: provide options.upd.\n'    
 '* BaseCommand subclasses may now override BaseCommand.OPTIONS_CLASS (default '    
 'SimpleNamespace) in order to provide convenience methods on the options.\n'    
 '* BaseCommand.run: separate variable for subcmd with dash translated to '    
 'underscore to match method names.\n'    
 '* Minor fixes.\n'    
 '\n'    
 '*Release 20200615*:\n'    
 'BaseCommand.usage_text: do not mention the "help" command if it is the only '    
 "subcommand (it won't be available if there are no other subcommands).\n"    
 '\n'    
 '*Release 20200521.1*:\n'    
 'Fix DISTINFO.install_requires.\n'    
 '\n'    
 '*Release 20200521*:\n'    
 '* BaseCommand.run: support using BaseCommand subclasses as cmd_* names to '    
 'make it easy to nest BaseCommands.\n'    
 '* BaseCommand: new hack_postopts_argv method called after parsing the main '    
 'command line options, for inferring subcommands or the like.\n'    
 '* BaseCommand: extract "Usage:" paragraphs from subcommand method docstrings '    
 'to build the main usage message.\n'    
 '* BaseCommand: new cmd_help default command.\n'    
 '* Assorted bugfixes and small improvements.\n'    
 '\n'    
 '*Release 20200318*:\n'    
 '* BaseCommand.run: make argv optional, get additional usage keywords from '    
 'self.USAGE_KEYWORDS.\n'    
 '* @BaseCommand.add_usage_to_docstring: honour cls.USAGE_KEYWORDS.\n'    
 '* BaseCommand: do not require GETOPT_SPEC for commands with no defined '    
 'options.\n'    
 '* BaseCommand.run: call cs.logutils.setup_logging.\n'    
 '\n'    
 '*Release 20200229*:\n'    
 'Improve subcommand selection logic, replace StackableValues with stackattrs, '    
 'drop `cmd` from arguments passed to main/cmd_* methods (present in '    
 '`options`).\n'    
 '\n'    
 '*Release 20200210*:\n'    
 '* New BaseCommand.add_usage_to_docstring class method to be called after '    
 'class setup, to append the usage message to the class docstring.\n'    
 '* BaseCommand.run: remove spurious Pfx(cmd), as logutils does this for us '    
 'already.\n'    
 '\n'    
 '*Release 20190729*:\n'    
 'BaseCommand: support for a USAGE_FORMAT usage message format string and a '    
 'getopt_error_handler method.\n'    
 '\n'    
 '*Release 20190619.1*:\n'    
 'Another niggling docstring formatting fix.\n'    
 '\n'    
 '*Release 20190619*:\n'    
 'Minor documentation updates.\n'    
 '\n'    
 '*Release 20190617.2*:\n'    
 'Lint.\n'    
 '\n'    
 '*Release 20190617.1*:\n'    
 'Initial release with @docmd decorator and alpha quality BaseCommand command '    
 'line assistance class.'),
  install_requires = ['cs.context', 'cs.gimmicks', 'cs.lex', 'cs.logutils', 'cs.pfx', 'cs.py.doc', 'cs.resources'],
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.cmdutils'],
)
