import * as cdk from '@aws-cdk/core';
import { CfnVirtualRouter } from './appmesh.generated';
/**
 * (experimental) Properties for a VirtualRouter listener.
 *
 * @experimental
 */
export interface VirtualRouterListenerConfig {
    /**
     * (experimental) Single listener config for a VirtualRouter.
     *
     * @experimental
     */
    readonly listener: CfnVirtualRouter.VirtualRouterListenerProperty;
}
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualRouter.
 *
 * @experimental
 */
export declare abstract class VirtualRouterListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http(port?: number): VirtualRouterListener;
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http2(port?: number): VirtualRouterListener;
    /**
     * (experimental) Returns a GRPC Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static grpc(port?: number): VirtualRouterListener;
    /**
     * (experimental) Returns a TCP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static tcp(port?: number): VirtualRouterListener;
    /**
     * (experimental) Called when the VirtualRouterListener type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity
     *
     * @experimental
     */
    abstract bind(scope: cdk.Construct): VirtualRouterListenerConfig;
}
