from abc import abstractmethod, ABCMeta


class InterfaceTransform(metaclass=ABCMeta):

    def __init__(self, name: str = "", args: any = None):
        self.name = name

    def __eq__(self, profile: "InterfaceTransform"):
        return self.name == profile.name  # I made it up the id property.

    def __hash__(self):
        return hash(self.name)

    @classmethod
    def __subclasshook__(cls, C):
        if C.__abstractmethods__:
            print(C.__abstractmethods__)
            return False
        else:
            return True

    @abstractmethod
    def autoFileName(self) -> str:
        """Generation of language file format"""
        pass

    @abstractmethod
    def autoGeneratedTag(self) -> str:
        """AUTO-GENERATED - DO NOT EDIT THE LINES BELOW"""
        pass

    @abstractmethod
    def transformComment(self, comment: str) -> str:
        """transform for the comment inline.

        write it as comment line
        """
        pass

    @abstractmethod
    def transformKeyValue(self, key: str, value: str, isLast: bool = False) -> str:
        """transform the key and value

        transform the key for each line
        """
        pass

    @abstractmethod
    def wrap_file(self, input: str, newValues: list) -> list:
        """ transform the input to output

        insert the format of the file from the start to the end
        """
        pass
