# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['solquery']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.22.3,<2.0.0', 'pandas>=1.4.2,<2.0.0', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'solana-data-scraper',
    'version': '0.0.4',
    'description': 'Python library for scraping blockchain data from Bitquery',
    'long_description': '# Scrape Solana Blockchain Data\n\nThis python library scrapes blockchain from https://bitquery.io/ from their GraphQL endpoints.\n\nThis requires you to supply your own Bitquery API token.\n\nCopyright (c) 2022 Friktion Labs\n\n# Setup\n\n1. `pip install solquery`\n2. Create an account at https://bitquery.io/\n3. Retrieve API Key\n4. In command line, `export BITQUERY_API_KEY=XXXXXXX`\n\n# Functionalities\n\n- Queries Bitquery for blockchain data\n- Batches queries to get around compute limits\n- Returns output as a pandas dataframe or saves data to a specified csv\n',
    'author': 'thiccythot',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://app.friktion.fi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
