"""
Copyright (c) 2022 Windhover Labs, L.L.C. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in
 the documentation and/or other materials provided with the
 distribution.
3. Neither the name Windhover Labs nor the names of its
 contributors may be used to endorse or promote products derived
 from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

"""
#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Sep 14 16:23:36 2020 by generateDS.py version 2.36.2.
# Python 3.5.2 (default, Jul 17 2020, 14:04:10)  [GCC 5.4.0 20160609]
#
# Command line options:
#   ('-o', 'xtce.py')
#
# Command line arguments:
#   /home/vagrant/SpaceSystem.xsd
#
# Command line:
#   /home/vagrant/.local/bin/generateDS -o "xtce.py" /home/vagrant/SpaceSystem.xsd
#
# Current working directory (os.getcwd()):
#   xtce_classes
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_

try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_

Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc


def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))

#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')

        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def gds_format_string(self, input_data, input_name=''):
            return input_data

        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)

        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data

        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival

        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value

        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values

        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')

        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_

        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value

        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values

        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value

        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value

        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value

        def gds_format_decimal_list(self, input_data, input_name=''):
            return ' '.join([self.gds_format_decimal(item) for item in input_data])

        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values

        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data

        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_

        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value

        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values

        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()

        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval

        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0,):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0,):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"),)
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()

        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None:
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))

        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r'\{.*\}')

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')

            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))

        def __ne__(self, other):
            return not self.__eq__(other)

        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass

        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass

        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None

        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass

        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""


    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None


#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name,))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline,)
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))

    def to_etree(self, element, mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self, mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
              self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
              self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
                 optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class BasisType(str, Enum):
    """Defines to type of update rates: perSecond and perContainerUpdate. See
    RateInStreamType."""
    PER_SECOND = 'perSecond'
    PER_CONTAINER_UPDATE = 'perContainerUpdate'


class BitOrderType(str, Enum):
    """Defines two bit-order types: most significant bit first and least
    significant bit first. See DataEncodingType."""
    LEAST_SIGNIFICANT_BIT_FIRST = 'leastSignificantBitFirst'
    MOST_SIGNIFICANT_BIT_FIRST = 'mostSignificantBitFirst'


class ByteOrderCommonType(str, Enum):
    """Common byte orderings: most significant byte first (also known as big
    endian) and least significant byte first (also known as little
    endian)."""
    MOST_SIGNIFICANT_BYTE_FIRST = 'mostSignificantByteFirst'
    LEAST_SIGNIFICANT_BYTE_FIRST = 'leastSignificantByteFirst'


class ChangeBasisType(str, Enum):
    """Defines absoluteChange and percentageChange for use in rate of change
    alarms. Used by ChangeAlarmRangesType."""
    ABSOLUTE_CHANGE = 'absoluteChange'
    PERCENTAGE_CHANGE = 'percentageChange'


class ChangeSpanType(str, Enum):
    """Defines a changePerSecond and changePerSample for use in rate of change
    alarms. Used by ChangeAlarmRangesType."""
    CHANGE_PER_SECOND = 'changePerSecond'
    CHANGE_PER_SAMPLE = 'changePerSample'


class CharacterWidthType(str, Enum):
    _8 = '8'
    _1_6 = '16'


class ComparisonOperatorsType(str, Enum):
    """Operators to use when testing a boolean condition for a validity
    check"""
    _ = '=='
    __1 = '!='
    __2 = '<'
    __3 = '<='
    __4 = '>'
    __5 = '>='


class ConcernLevelsType(str, Enum):
    """Defines six levels: Normal, Watch, Warning, Distress, Critical and
    Severe. Typical implementations color the "normal" level as green,
    "warning" level as yellow, and "critical" level as red. These level
    definitions are used throughout the alarm definitions. Some systems
    provide a greater fidelity with the additional levels provided here.
    The "normal" level is not typically needed because "normal" should be
    construed as none of the concern levels evaluating to true. For cases
    where definiing "normal" is needed, refer to the specific alarm
    definition types."""
    NORMAL = 'normal'
    WATCH = 'watch'
    WARNING = 'warning'
    DISTRESS = 'distress'
    CRITICAL = 'critical'
    SEVERE = 'severe'


class ConsequenceLevelType(str, Enum):
    """Defines the criticality level of a command. Criticality levels follow
    ISO 14950."""
    NORMAL = 'normal'  # Normal command. Corresponds to ISO 14950 Level D telecommand criticality.
    VITAL = 'vital'  # Command that is not a critical command but is essential to the success of the mission and, if sent at the wrong time, could cause momentary loss of the mission. Corresponds to ISO 14950 Level C telecommand criticality.
    CRITICAL = 'critical'  # Command that, if executed at the wrong time or in the wrong configuration, could cause irreversible loss or damage for the mission. Corresponds to ISO 14950 Level B telecommand criticality. Some space programs have called this "restricted" and may be implemented with a secondary confirmation before transmission.
    FORBIDDEN = 'forbidden'  # Command that is not expected to be used for nominal or foreseeable contingency operations, that is included for unforeseen contingency operations, and that could cause irreversible damage if executed at the wrong time or in the wrong configuration. Corresponds to ISO 14950 Level A telecommand criticality. Some space programs have called this "prohibited".
    USER_1 = 'user1'  # In the event that a program uses this value, that program will need to define the meaning of this value to their system.
    USER_2 = 'user2'  # In the event that a program uses this value, that program will need to define the meaning of this value to their system.


class EpochTimeEnumsType(str, Enum):
    """Union values of common epoch definitions for document convenience."""
    TAI = 'TAI'
    J_2000 = 'J2000'
    UNIX = 'UNIX'
    GPS = 'GPS'


class FlagBitType(str, Enum):
    ZEROS = 'zeros'
    ONES = 'ones'


class FloatEncodingSizeInBitsType(str, Enum):
    _1_6 = '16'  # At the time of this writing, 16 bit encoding size is only valid in cases of IEEE754 and vendor specific MILSTD_1750A variation that is not a part of the standard. This is not meant to preclude use in the event that future floating point formats may also define this value.
    _3_2 = '32'  # At the time of this writing, 32 bit encoding size is only valid in cases of IEEE754_1985, IEEE754, MILSTD_1750A, DEC, IBM, and TI. This is not meant to preclude use in the event that future floating point formats may also define this value. The IEEE754 enumeration and the IEEE754_1985 enumeration are allowed in this case and the interpretation is the same.
    _4_0 = '40'  # At the time of this writing, 40 bit encoding size is only valid in the case of TI. This is not meant to preclude use in the event that future floating point formats may also define this value.
    _4_8 = '48'  # At the time of this writing, 48 bit encoding size is only valid in the case of MILSTD_1750A. This is not meant to preclude use in the event that future floating point formats may also define this value.
    _6_4 = '64'  # At the time of this writing, 64 bit encoding size is only valid in cases of IEEE754_1985, IEEE754, DEC, and IBM. This is not meant to preclude use in the event that future floating point formats may also define this value. The IEEE754 enumeration and the IEEE754_1985 enumeration are allowed in this case and the interpretation is the same.
    _8_0 = '80'  # At the time of this writing, 80 bit encoding size is only valid in the case of IEEE754_1985. This is not meant to preclude use in the event that future floating point formats may also define this value.
    _1_28 = '128'  # At the time of this writing, 128 bit encoding size is only valid in the case of IEEE754_1985 and IEEE754. This is not meant to preclude use in the event that future floating point formats may also define this value. The IEEE754 enumeration and the IEEE754_1985 enumeration are allowed in this case and the interpretation is the same.


class FloatEncodingType(str, Enum):
    IEEE_754__1985 = 'IEEE754_1985'
    IEEE_754 = 'IEEE754'
    MILSTD__1750_A = 'MILSTD_1750A'
    DEC = 'DEC'
    IBM = 'IBM'
    TI = 'TI'


class FloatSizeInBitsType(str, Enum):
    _3_2 = '32'
    _6_4 = '64'
    _1_28 = '128'


class FloatingPointNotationType(str, Enum):
    NORMAL = 'normal'
    SCIENTIFIC = 'scientific'
    ENGINEERING = 'engineering'


class IntegerEncodingType(str, Enum):
    UNSIGNED = 'unsigned'
    SIGN_MAGNITUDE = 'signMagnitude'
    TWOS_COMPLEMENT = 'twosComplement'
    ONES_COMPLEMENT = 'onesComplement'
    BCD = 'BCD'
    PACKED_BCD = 'packedBCD'


class MathOperatorsType(str, Enum):
    """Mathematical operators used in the math operation. Behavior of each
    operator on the stack is described using notation (before -- after),
    where "before" represents the stack before execution of the operator
    and "after" represent the stack after execution."""
    _ = '+'  # addition (x1 x2 -- x1+x2)
    __1 = '-'  # subtraction (x1 x2 -- x1-x2)
    __2 = '*'  # multiplication (x1 x2 -- x1*x2)
    __3 = '/'  # division (x1 x2 -- x1/x2)
    __4 = '%'  # modulo (x1 x2 -- x3) Divide x1 by x2, giving the modulo x3
    __5 = '^'  # power function (x1 x2 -- x1**x2)
    YX = 'y^x'  # reverse power function (x1 x2 -- x2**x1)
    LN = 'ln'  # natural (base e) logarithm (x -- ln(x))
    LOG = 'log'  # base-10 logarithm (x-- log(x))
    EX = 'e^x'  # exponentiation (x -- exp(x))
    _1X = '1/x'  # inversion (x -- 1/x)
    X = 'x!'  # factorial (x -- x!)
    TAN = 'tan'  # tangent (x -- tan(x)) radians
    COS = 'cos'  # cosine (x -- cos(x)) radians
    SIN = 'sin'  # sine (x -- sin(x)) radians
    ATAN = 'atan'  # arctangent (x -- atan(x)) radians
    ATAN_2 = 'atan2'  # arctangent (x1 x2 -- atan2(x2, x1)) radians
    ACOS = 'acos'  # arccosine (x -- acos(x)) radians
    ASIN = 'asin'  # arcsine (x -- asin(x)) radians
    TANH = 'tanh'  # hyperbolic tangent (x -- tanh(x))
    COSH = 'cosh'  # hyperbolic cosine (x -- cosh(x))
    SINH = 'sinh'  # hyperbolic sine (x -- sinh(x))
    ATANH = 'atanh'  # hyperbolic arctangent (x -- atanh(x))
    ACOSH = 'acosh'  # hyperbolic arccosine (x -- acosh(x))
    ASINH = 'asinh'  # hyperbolic arcsine (x -- asinh(x))
    SWAP = 'swap'  # swap the top two stack items (x1 x2 -- x2 x1)
    DROP = 'drop'  # Remove top item from the stack (x -- )
    DUP = 'dup'  # Duplicate top item on the stack (x -- x x)
    OVER = 'over'  # Duplicate top item on the stack (x1 x2 -- x1 x2 x1)
    __6 = '<<'  # signed bitwise left shift (x1 x2 -- x1 << x2)
    __7 = '>>'  # signed bitwise right shift (x1 x2 -- x1 >> x2)
    __8 = '&'  # bitwise and (x1 x2 -- x1 & x2)
    __9 = '|'  # bitwise or (x1 x2 -- x1 | x2)
    __10 = '&&'  # logical and (x1 x2 -- x1 && x2)
    __11 = '||'  # logical or (x1 x2 -- x1 || x2)
    __12 = '!'  # logical not (x1 x2 -- x1 ! x2)
    ABS = 'abs'  # absolute value (x1 -- abs(x1))
    DIV = 'div'  # Euclidean division quotient (x1 -- div(x1))
    INT = 'int'  # integer part (x1 -- int(x1))
    __13 = '>'  # greater than x,y (x1 x2 -- x1 > x2)
    __14 = '>='  # greater than or equal x,y (x1 x2 -- x1 >= x2)
    __15 = '<'  # less than x,y (x1 x2 -- x1 < x2)
    __16 = '<='  # less than or equal x,y (x1 x2 -- x1 <= x2)
    __17 = '=='  # equal x,y (x1 x2 -- x1 == x2)
    __18 = '!='  # not equal x,y (x1 x2 -- x1 != x2)
    MIN = 'min'  # minimum of x,y (x1 x2 -- min(x1, x2))
    MAX = 'max'  # maximum of x,y (x1 x2 -- max(x1, x2))
    XOR = 'xor'  # Bitwise exclusive or (XOR) (x1 x2 -- x1 xor x2)
    __19 = '~'  # Bitwise not operation (x1 x2 -- x1 ~ x2) The result of this can only be 0 or 1


class PCMType(str, Enum):
    NRZL = 'NRZL'
    NRZM = 'NRZM'
    NRZS = 'NRZS'
    BI_PHASE_L = 'BiPhaseL'
    BI_PHASE_M = 'BiPhaseM'
    BI_PHASE_S = 'BiPhaseS'


class ParityFormType(str, Enum):
    EVEN = 'Even'
    ODD = 'Odd'


class RadixType(str, Enum):
    """Specifies the number base"""
    DECIMAL = 'Decimal'
    HEXADECIMAL = 'Hexadecimal'
    OCTAL = 'Octal'
    BINARY = 'Binary'


class RangeFormType(str, Enum):
    """Defines whether the defined range between the minimum and maximum is the
    outside or inside the range being defined. The default, outside matches
    values less than the minimum and greater than the maximum. Inside
    matches values between the minimum and maximum."""
    OUTSIDE = 'outside'
    INSIDE = 'inside'


class ReferenceLocationType(str, Enum):
    """The location may be relative to the start of the container
    (containerStart), relative to the end of the previous entry
    (previousEntry), relative to the end of the container (containerEnd),
    or relative to the entry that follows this one (nextEntry). If going
    forward (containerStart and previousEntry) then the location refers to
    the start of the Entry. If going backwards (containerEnd and nextEntry)
    then, the location refers to the end of the entry."""
    CONTAINER_START = 'containerStart'
    CONTAINER_END = 'containerEnd'
    PREVIOUS_ENTRY = 'previousEntry'
    NEXT_ENTRY = 'nextEntry'


class ReferencePointType(str, Enum):
    START = 'start'
    END = 'end'


class StringEncodingType(str, Enum):
    """Defines string encodings. US-ASCII (7-bit), ISO-8859-1 (8-bit Extended
    ASCII), Windows-1252 (8-bit Extended ASCII), UTF-8 (Unicode), UTF-16
    (Unicode with Byte Order Mark), UTF-16LE (Unicode Little Endian),
    UTF-16BE (Unicode Big Endian). See StringDataEncodingType."""
    USASCII = 'US-ASCII'
    ISO_8859_1 = 'ISO-8859-1'
    WINDOWS_1252 = 'Windows-1252'
    UTF_8 = 'UTF-8'
    UTF_16 = 'UTF-16'  # With UTF-16, encoded bits must be prepended with a Byte Order Mark. This mark indicates whether the data is encoded in big or little endian.
    UTF_16_LE = 'UTF-16LE'  # With UTF-16LE, encoded bits will always be represented as little endian. Bits are not prepended with a Byte Order Mark.
    UTF_16_BE = 'UTF-16BE'  # With UTF-16BE, encoded bits will always be represented as big endian. Bits are not prepended with a Byte Order Mark.
    UTF_32 = 'UTF-32'  # With UTF-32, encoded bits must be prepended with a Byte Order Mark. This mark indicates whether the data is encoded in big or little endian.
    UTF_32_LE = 'UTF-32LE'  # With UTF-32LE, encoded bits will always be represented as little endian. Bits are not prepended with a Byte Order Mark.
    UTF_32_BE = 'UTF-32BE'  # With UTF-32BE, encoded bits will always be represented as big endian. Bits are not prepended with a Byte Order Mark.


class TelemetryDataSourceType(str, Enum):
    """A telemetered Parameter is one that will have values in telemetry. A
    derived Parameter is one that is calculated, usually by an Algorithm. A
    constant Parameter is one that is used as a constant in the system
    (e.g. a vehicle id). A local Parameter is one that is used purely by
    the software locally (e.g. a ground command counter). A ground
    Parameter is one that is generated by an asset which is not the
    spacecraft."""
    TELEMETERED = 'telemetered'
    DERIVED = 'derived'
    CONSTANT = 'constant'
    LOCAL = 'local'
    GROUND = 'ground'


class TimeAssociationUnitType(str, Enum):
    """Time units the time association decimal value is in."""
    SI_NANOSECOND = 'si_nanosecond'
    SI_MICROSECOND = 'si_microsecond'
    SI_MILLSECOND = 'si_millsecond'
    SI_SECOND = 'si_second'
    MINUTE = 'minute'
    DAY = 'day'
    JULIAN_YEAR = 'julianYear'


class TimeUnitsType(str, Enum):
    """base time units. days, months, years have obvoius ambiguity and should
    be avoided"""
    SECONDS = 'seconds'
    PICO_SECONDS = 'picoSeconds'
    DAYS = 'days'
    MONTHS = 'months'
    YEARS = 'years'


class TimeWindowIsRelativeToType(str, Enum):
    COMMAND_RELEASE = 'commandRelease'
    TIME_LAST_VERIFIER_PASSED = 'timeLastVerifierPassed'


class UnitFormType(str, Enum):
    """Optionally specify if this information pertains to something other than
    the calibrated/engineering value."""
    CALIBRATED = 'calibrated'
    UNCALIBRATED = 'uncalibrated'
    RAW = 'raw'


class ValidationStatusType(str, Enum):
    UNKNOWN = 'Unknown'
    WORKING = 'Working'
    DRAFT = 'Draft'
    TEST = 'Test'
    VALIDATED = 'Validated'
    RELEASED = 'Released'
    WITHDRAWN = 'Withdrawn'


class VerifierEnumerationType(str, Enum):
    """An enumerated list of verifier types"""
    RELEASE = 'release'
    TRANSFERRED_TO_RANGE = 'transferredToRange'
    SENT_FROM_RANGE = 'sentFromRange'
    RECEIVED = 'received'
    ACCEPTED = 'accepted'
    QUEUED = 'queued'
    EXECUTING = 'executing'
    COMPLETE = 'complete'
    FAILED = 'failed'


class nameType(str, Enum):
    """Qualified list of name checksum algorithms. If custom is chosen,
    InputAlgorithm must be set."""
    UNIX_SUM = 'unix_sum'
    SUM_8 = 'sum8'
    SUM_16 = 'sum16'
    SUM_24 = 'sum24'
    SUM_32 = 'sum32'
    FLETCHER_4 = 'fletcher4'
    FLETCHER_8 = 'fletcher8'
    FLETCHER_16 = 'fletcher16'
    FLETCHER_32 = 'fletcher32'
    ADLER_32 = 'adler32'
    LUHN = 'luhn'
    VERHOEFF = 'verhoeff'
    DAMM = 'damm'
    CUSTOM = 'custom'  # Document a custom checksum algorithm


class CommandMetaDataType(GeneratedsSuper):
    """Describe command related metadata. Items defined in this area may refer
    to items defined in TelemetryMetaData. See TelemetryMetaDataType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterTypeSet=None, ParameterSet=None, ArgumentTypeSet=None, MetaCommandSet=None,
                 CommandContainerSet=None, StreamSet=None, AlgorithmSet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ParameterTypeSet = ParameterTypeSet
        self.ParameterTypeSet_nsprefix_ = None
        self.ParameterSet = ParameterSet
        self.ParameterSet_nsprefix_ = None
        self.ArgumentTypeSet = ArgumentTypeSet
        self.ArgumentTypeSet_nsprefix_ = None
        self.MetaCommandSet = MetaCommandSet
        self.MetaCommandSet_nsprefix_ = None
        self.CommandContainerSet = CommandContainerSet
        self.CommandContainerSet_nsprefix_ = None
        self.StreamSet = StreamSet
        self.StreamSet_nsprefix_ = None
        self.AlgorithmSet = AlgorithmSet
        self.AlgorithmSet_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CommandMetaDataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CommandMetaDataType.subclass:
            return CommandMetaDataType.subclass(*args_, **kwargs_)
        else:
            return CommandMetaDataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterTypeSet(self):
        return self.ParameterTypeSet

    def set_ParameterTypeSet(self, ParameterTypeSet):
        self.ParameterTypeSet = ParameterTypeSet

    def get_ParameterSet(self):
        return self.ParameterSet

    def set_ParameterSet(self, ParameterSet):
        self.ParameterSet = ParameterSet

    def get_ArgumentTypeSet(self)->'ArgumentTypeSetType':
        return self.ArgumentTypeSet

    def set_ArgumentTypeSet(self, ArgumentTypeSet):
        self.ArgumentTypeSet = ArgumentTypeSet

    def get_MetaCommandSet(self) -> 'MetaCommandSetType':
        return self.MetaCommandSet

    def set_MetaCommandSet(self, MetaCommandSet):
        self.MetaCommandSet = MetaCommandSet

    def get_CommandContainerSet(self):
        return self.CommandContainerSet

    def set_CommandContainerSet(self, CommandContainerSet):
        self.CommandContainerSet = CommandContainerSet

    def get_StreamSet(self):
        return self.StreamSet

    def set_StreamSet(self, StreamSet):
        self.StreamSet = StreamSet

    def get_AlgorithmSet(self):
        return self.AlgorithmSet

    def set_AlgorithmSet(self, AlgorithmSet):
        self.AlgorithmSet = AlgorithmSet

    def hasContent_(self):
        if (
                self.ParameterTypeSet is not None or
                self.ParameterSet is not None or
                self.ArgumentTypeSet is not None or
                self.MetaCommandSet is not None or
                self.CommandContainerSet is not None or
                self.StreamSet is not None or
                self.AlgorithmSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CommandMetaDataType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CommandMetaDataType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CommandMetaDataType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CommandMetaDataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CommandMetaDataType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CommandMetaDataType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CommandMetaDataType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ParameterTypeSet is not None:
            namespaceprefix_ = self.ParameterTypeSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterTypeSet_nsprefix_) else ''
            self.ParameterTypeSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterTypeSet',
                                         pretty_print=pretty_print)
        if self.ParameterSet is not None:
            namespaceprefix_ = self.ParameterSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterSet_nsprefix_) else ''
            self.ParameterSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterSet',
                                     pretty_print=pretty_print)
        if self.ArgumentTypeSet is not None:
            namespaceprefix_ = self.ArgumentTypeSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentTypeSet_nsprefix_) else ''
            self.ArgumentTypeSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ArgumentTypeSet',
                                        pretty_print=pretty_print)
        if self.MetaCommandSet is not None:
            namespaceprefix_ = self.MetaCommandSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.MetaCommandSet_nsprefix_) else ''
            self.MetaCommandSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MetaCommandSet',
                                       pretty_print=pretty_print)
        if self.CommandContainerSet is not None:
            namespaceprefix_ = self.CommandContainerSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CommandContainerSet_nsprefix_) else ''
            self.CommandContainerSet.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='CommandContainerSet', pretty_print=pretty_print)
        if self.StreamSet is not None:
            namespaceprefix_ = self.StreamSet_nsprefix_ + ':' if (UseCapturedNS_ and self.StreamSet_nsprefix_) else ''
            self.StreamSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StreamSet',
                                  pretty_print=pretty_print)
        if self.AlgorithmSet is not None:
            namespaceprefix_ = self.AlgorithmSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AlgorithmSet_nsprefix_) else ''
            self.AlgorithmSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AlgorithmSet',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterTypeSet':
            obj_ = ParameterTypeSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterTypeSet = obj_
            obj_.original_tagname_ = 'ParameterTypeSet'
        elif nodeName_ == 'ParameterSet':
            obj_ = ParameterSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterSet = obj_
            obj_.original_tagname_ = 'ParameterSet'
        elif nodeName_ == 'ArgumentTypeSet':
            obj_ = ArgumentTypeSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentTypeSet = obj_
            obj_.original_tagname_ = 'ArgumentTypeSet'
        elif nodeName_ == 'MetaCommandSet':
            obj_ = MetaCommandSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MetaCommandSet = obj_
            obj_.original_tagname_ = 'MetaCommandSet'
        elif nodeName_ == 'CommandContainerSet':
            obj_ = CommandContainerSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CommandContainerSet = obj_
            obj_.original_tagname_ = 'CommandContainerSet'
        elif nodeName_ == 'StreamSet':
            obj_ = StreamSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StreamSet = obj_
            obj_.original_tagname_ = 'StreamSet'
        elif nodeName_ == 'AlgorithmSet':
            obj_ = AlgorithmSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AlgorithmSet = obj_
            obj_.original_tagname_ = 'AlgorithmSet'


# end class CommandMetaDataType


class TelemetryMetaDataType(GeneratedsSuper):
    """All the data about telemetry is contained in TelemetryMetaData"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterTypeSet=None, ParameterSet=None, ContainerSet=None, MessageSet=None, StreamSet=None,
                 AlgorithmSet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ParameterTypeSet = ParameterTypeSet
        self.ParameterTypeSet_nsprefix_ = None
        self.ParameterSet = ParameterSet
        self.ParameterSet_nsprefix_ = None
        self.ContainerSet = ContainerSet
        self.ContainerSet_nsprefix_ = None
        self.MessageSet = MessageSet
        self.MessageSet_nsprefix_ = None
        self.StreamSet = StreamSet
        self.StreamSet_nsprefix_ = None
        self.AlgorithmSet = AlgorithmSet
        self.AlgorithmSet_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TelemetryMetaDataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TelemetryMetaDataType.subclass:
            return TelemetryMetaDataType.subclass(*args_, **kwargs_)
        else:
            return TelemetryMetaDataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterTypeSet(self)->'ParameterTypeSetType':
        return self.ParameterTypeSet

    def set_ParameterTypeSet(self, ParameterTypeSet):
        self.ParameterTypeSet = ParameterTypeSet

    def get_ParameterSet(self)->'ParameterSetType':
        return self.ParameterSet

    def set_ParameterSet(self, ParameterSet):
        self.ParameterSet = ParameterSet

    def get_ContainerSet(self) -> 'ContainerSetType':
        return self.ContainerSet

    def set_ContainerSet(self, ContainerSet):
        self.ContainerSet = ContainerSet

    def get_MessageSet(self):
        return self.MessageSet

    def set_MessageSet(self, MessageSet):
        self.MessageSet = MessageSet

    def get_StreamSet(self):
        return self.StreamSet

    def set_StreamSet(self, StreamSet):
        self.StreamSet = StreamSet

    def get_AlgorithmSet(self):
        return self.AlgorithmSet

    def set_AlgorithmSet(self, AlgorithmSet):
        self.AlgorithmSet = AlgorithmSet

    def hasContent_(self):
        if (
                self.ParameterTypeSet is not None or
                self.ParameterSet is not None or
                self.ContainerSet is not None or
                self.MessageSet is not None or
                self.StreamSet is not None or
                self.AlgorithmSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='TelemetryMetaDataType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TelemetryMetaDataType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TelemetryMetaDataType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TelemetryMetaDataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TelemetryMetaDataType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TelemetryMetaDataType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='TelemetryMetaDataType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ParameterTypeSet is not None:
            namespaceprefix_ = self.ParameterTypeSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterTypeSet_nsprefix_) else ''
            self.ParameterTypeSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterTypeSet',
                                         pretty_print=pretty_print)
        if self.ParameterSet is not None:
            namespaceprefix_ = self.ParameterSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterSet_nsprefix_) else ''
            self.ParameterSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterSet',
                                     pretty_print=pretty_print)
        if self.ContainerSet is not None:
            namespaceprefix_ = self.ContainerSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContainerSet_nsprefix_) else ''
            self.ContainerSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContainerSet',
                                     pretty_print=pretty_print)
        if self.MessageSet is not None:
            namespaceprefix_ = self.MessageSet_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageSet_nsprefix_) else ''
            self.MessageSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MessageSet',
                                   pretty_print=pretty_print)
        if self.StreamSet is not None:
            namespaceprefix_ = self.StreamSet_nsprefix_ + ':' if (UseCapturedNS_ and self.StreamSet_nsprefix_) else ''
            self.StreamSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StreamSet',
                                  pretty_print=pretty_print)
        if self.AlgorithmSet is not None:
            namespaceprefix_ = self.AlgorithmSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AlgorithmSet_nsprefix_) else ''
            self.AlgorithmSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AlgorithmSet',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterTypeSet':
            obj_ = ParameterTypeSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterTypeSet = obj_
            obj_.original_tagname_ = 'ParameterTypeSet'
        elif nodeName_ == 'ParameterSet':
            obj_ = ParameterSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterSet = obj_
            obj_.original_tagname_ = 'ParameterSet'
        elif nodeName_ == 'ContainerSet':
            obj_ = ContainerSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContainerSet = obj_
            obj_.original_tagname_ = 'ContainerSet'
        elif nodeName_ == 'MessageSet':
            obj_ = MessageSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MessageSet = obj_
            obj_.original_tagname_ = 'MessageSet'
        elif nodeName_ == 'StreamSet':
            obj_ = StreamSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StreamSet = obj_
            obj_.original_tagname_ = 'StreamSet'
        elif nodeName_ == 'AlgorithmSet':
            obj_ = AlgorithmSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AlgorithmSet = obj_
            obj_.original_tagname_ = 'AlgorithmSet'


# end class TelemetryMetaDataType


class BaseAlarmType(GeneratedsSuper):
    """Supplies an optional non-reference-able name and short description for
    alarms. Also includes an optional ancillary data for any special local
    flags, note that these may not necessarily transfer to another
    recipient of an instance document.The alarm definition may be named.An
    optional brief description of this alarm definition."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, extensiontype_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.shortDescription = _cast(None, shortDescription)
        self.shortDescription_nsprefix_ = None
        self.AncillaryDataSet = AncillaryDataSet
        self.AncillaryDataSet_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseAlarmType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseAlarmType.subclass:
            return BaseAlarmType.subclass(*args_, **kwargs_)
        else:
            return BaseAlarmType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_AncillaryDataSet(self):
        return self.AncillaryDataSet

    def set_AncillaryDataSet(self, AncillaryDataSet):
        self.AncillaryDataSet = AncillaryDataSet

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_shortDescription(self):
        return self.shortDescription

    def set_shortDescription(self, shortDescription):
        self.shortDescription = shortDescription

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_ShortDescriptionType(self, value):
        # Validate type xtce:ShortDescriptionType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def hasContent_(self):
        if (
                self.AncillaryDataSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseAlarmType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BaseAlarmType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BaseAlarmType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BaseAlarmType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BaseAlarmType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BaseAlarmType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.shortDescription is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            outfile.write(' shortDescription=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.shortDescription), input_name='shortDescription')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseAlarmType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AncillaryDataSet is not None:
            namespaceprefix_ = self.AncillaryDataSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AncillaryDataSet_nsprefix_) else ''
            self.AncillaryDataSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AncillaryDataSet',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('shortDescription', node)
        if value is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            self.shortDescription = value
            self.validate_ShortDescriptionType(self.shortDescription)  # validate type ShortDescriptionType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AncillaryDataSet':
            obj_ = AncillaryDataSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AncillaryDataSet = obj_
            obj_.original_tagname_ = 'AncillaryDataSet'


# end class BaseAlarmType


class BaseContainerType(GeneratedsSuper):
    """Describe a child/parent container inheritance relationship. Describe
    constraints with RestrictionCriteria, conditions that must be true for
    this container to be an extension of the parent container. A constraint
    can be used to convey the identifying features of the telemetry format
    such as the CCSDS application id or minor-frame id. See
    RestrictionCriteriaType and SequenceContainerType.Reference to the
    container that this container extends."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, containerRef=None, RestrictionCriteria=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.containerRef = _cast(None, containerRef)
        self.containerRef_nsprefix_ = None
        self.RestrictionCriteria = RestrictionCriteria
        self.RestrictionCriteria_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseContainerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseContainerType.subclass:
            return BaseContainerType.subclass(*args_, **kwargs_)
        else:
            return BaseContainerType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_RestrictionCriteria(self):
        return self.RestrictionCriteria

    def set_RestrictionCriteria(self, RestrictionCriteria):
        self.RestrictionCriteria = RestrictionCriteria

    def get_containerRef(self):
        return self.containerRef

    def set_containerRef(self, containerRef):
        self.containerRef = containerRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                self.RestrictionCriteria is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseContainerType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BaseContainerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BaseContainerType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BaseContainerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BaseContainerType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BaseContainerType'):
        if self.containerRef is not None and 'containerRef' not in already_processed:
            already_processed.add('containerRef')
            outfile.write(' containerRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.containerRef), input_name='containerRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseContainerType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.RestrictionCriteria is not None:
            namespaceprefix_ = self.RestrictionCriteria_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RestrictionCriteria_nsprefix_) else ''
            self.RestrictionCriteria.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='RestrictionCriteria', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('containerRef', node)
        if value is not None and 'containerRef' not in already_processed:
            already_processed.add('containerRef')
            self.containerRef = value
            self.validate_NameReferenceType(self.containerRef)  # validate type NameReferenceType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'RestrictionCriteria':
            obj_ = RestrictionCriteriaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RestrictionCriteria = obj_
            obj_.original_tagname_ = 'RestrictionCriteria'


# end class BaseContainerType


class ContainerRefSetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContainerRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ContainerRef is None:
            self.ContainerRef = []
        else:
            self.ContainerRef = ContainerRef
        self.ContainerRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContainerRefSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContainerRefSetType.subclass:
            return ContainerRefSetType.subclass(*args_, **kwargs_)
        else:
            return ContainerRefSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContainerRef(self):
        return self.ContainerRef

    def set_ContainerRef(self, ContainerRef):
        self.ContainerRef = ContainerRef

    def add_ContainerRef(self, value):
        self.ContainerRef.append(value)

    def insert_ContainerRef_at(self, index, value):
        self.ContainerRef.insert(index, value)

    def replace_ContainerRef_at(self, index, value):
        self.ContainerRef[index] = value

    def hasContent_(self):
        if (
                self.ContainerRef
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContainerRefSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContainerRefSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContainerRefSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContainerRefSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContainerRefSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContainerRefSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContainerRefSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ContainerRef_ in self.ContainerRef:
            namespaceprefix_ = self.ContainerRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContainerRef_nsprefix_) else ''
            ContainerRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContainerRef',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContainerRef':
            obj_ = ContainerRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContainerRef.append(obj_)
            obj_.original_tagname_ = 'ContainerRef'


# end class ContainerRefSetType


class ContainerRefType(GeneratedsSuper):
    """Holds a reference to a containername of container"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, containerRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.containerRef = _cast(None, containerRef)
        self.containerRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContainerRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContainerRefType.subclass:
            return ContainerRefType.subclass(*args_, **kwargs_)
        else:
            return ContainerRefType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_containerRef(self):
        return self.containerRef

    def set_containerRef(self, containerRef):
        self.containerRef = containerRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContainerRefType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContainerRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContainerRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContainerRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContainerRefType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContainerRefType'):
        if self.containerRef is not None and 'containerRef' not in already_processed:
            already_processed.add('containerRef')
            outfile.write(' containerRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.containerRef), input_name='containerRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContainerRefType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('containerRef', node)
        if value is not None and 'containerRef' not in already_processed:
            already_processed.add('containerRef')
            self.containerRef = value
            self.validate_NameReferenceType(self.containerRef)  # validate type NameReferenceType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ContainerRefType


class ContainerSetType(GeneratedsSuper):
    """Unordered Set of Containers"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, SequenceContainer=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if SequenceContainer is None:
            self.SequenceContainer = []
        else:
            self.SequenceContainer = SequenceContainer
        self.SequenceContainer_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContainerSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContainerSetType.subclass:
            return ContainerSetType.subclass(*args_, **kwargs_)
        else:
            return ContainerSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SequenceContainer(self)  -> ['SequenceContainer']:
        return self.SequenceContainer

    def set_SequenceContainer(self, SequenceContainer):
        self.SequenceContainer = SequenceContainer

    def add_SequenceContainer(self, value):
        self.SequenceContainer.append(value)

    def insert_SequenceContainer_at(self, index, value):
        self.SequenceContainer.insert(index, value)

    def replace_SequenceContainer_at(self, index, value):
        self.SequenceContainer[index] = value

    def hasContent_(self):
        if (
                self.SequenceContainer
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContainerSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContainerSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContainerSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContainerSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContainerSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContainerSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContainerSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for SequenceContainer_ in self.SequenceContainer:
            namespaceprefix_ = self.SequenceContainer_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.SequenceContainer_nsprefix_) else ''
            SequenceContainer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SequenceContainer',
                                      pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SequenceContainer':
            obj_ = SequenceContainerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SequenceContainer.append(obj_)
            obj_.original_tagname_ = 'SequenceContainer'


# end class ContainerSetType


class EntryListType(GeneratedsSuper):
    """Contains an ordered list of Entries. Used in Sequence Container"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterRefEntry=None, ParameterSegmentRefEntry=None, ContainerRefEntry=None,
                 ContainerSegmentRefEntry=None, StreamSegmentEntry=None, IndirectParameterRefEntry=None,
                 ArrayParameterRefEntry=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ParameterRefEntry is None:
            self.ParameterRefEntry = []
        else:
            self.ParameterRefEntry = ParameterRefEntry
        self.ParameterRefEntry_nsprefix_ = None
        if ParameterSegmentRefEntry is None:
            self.ParameterSegmentRefEntry = []
        else:
            self.ParameterSegmentRefEntry = ParameterSegmentRefEntry
        self.ParameterSegmentRefEntry_nsprefix_ = None
        if ContainerRefEntry is None:
            self.ContainerRefEntry = []
        else:
            self.ContainerRefEntry = ContainerRefEntry
        self.ContainerRefEntry_nsprefix_ = None
        if ContainerSegmentRefEntry is None:
            self.ContainerSegmentRefEntry = []
        else:
            self.ContainerSegmentRefEntry = ContainerSegmentRefEntry
        self.ContainerSegmentRefEntry_nsprefix_ = None
        if StreamSegmentEntry is None:
            self.StreamSegmentEntry = []
        else:
            self.StreamSegmentEntry = StreamSegmentEntry
        self.StreamSegmentEntry_nsprefix_ = None
        if IndirectParameterRefEntry is None:
            self.IndirectParameterRefEntry = []
        else:
            self.IndirectParameterRefEntry = IndirectParameterRefEntry
        self.IndirectParameterRefEntry_nsprefix_ = None
        if ArrayParameterRefEntry is None:
            self.ArrayParameterRefEntry = []
        else:
            self.ArrayParameterRefEntry = ArrayParameterRefEntry
        self.ArrayParameterRefEntry_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EntryListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EntryListType.subclass:
            return EntryListType.subclass(*args_, **kwargs_)
        else:
            return EntryListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterRefEntry(self) -> '[ParameterRefEntryType]':
        return self.ParameterRefEntry

    def set_ParameterRefEntry(self, ParameterRefEntry):
        self.ParameterRefEntry = ParameterRefEntry

    def add_ParameterRefEntry(self, value):
        self.ParameterRefEntry.append(value)

    def insert_ParameterRefEntry_at(self, index, value):
        self.ParameterRefEntry.insert(index, value)

    def replace_ParameterRefEntry_at(self, index, value):
        self.ParameterRefEntry[index] = value

    def get_ParameterSegmentRefEntry(self):
        return self.ParameterSegmentRefEntry

    def set_ParameterSegmentRefEntry(self, ParameterSegmentRefEntry):
        self.ParameterSegmentRefEntry = ParameterSegmentRefEntry

    def add_ParameterSegmentRefEntry(self, value):
        self.ParameterSegmentRefEntry.append(value)

    def insert_ParameterSegmentRefEntry_at(self, index, value):
        self.ParameterSegmentRefEntry.insert(index, value)

    def replace_ParameterSegmentRefEntry_at(self, index, value):
        self.ParameterSegmentRefEntry[index] = value

    def get_ContainerRefEntry(self):
        return self.ContainerRefEntry

    def set_ContainerRefEntry(self, ContainerRefEntry):
        self.ContainerRefEntry = ContainerRefEntry

    def add_ContainerRefEntry(self, value):
        self.ContainerRefEntry.append(value)

    def insert_ContainerRefEntry_at(self, index, value):
        self.ContainerRefEntry.insert(index, value)

    def replace_ContainerRefEntry_at(self, index, value):
        self.ContainerRefEntry[index] = value

    def get_ContainerSegmentRefEntry(self):
        return self.ContainerSegmentRefEntry

    def set_ContainerSegmentRefEntry(self, ContainerSegmentRefEntry):
        self.ContainerSegmentRefEntry = ContainerSegmentRefEntry

    def add_ContainerSegmentRefEntry(self, value):
        self.ContainerSegmentRefEntry.append(value)

    def insert_ContainerSegmentRefEntry_at(self, index, value):
        self.ContainerSegmentRefEntry.insert(index, value)

    def replace_ContainerSegmentRefEntry_at(self, index, value):
        self.ContainerSegmentRefEntry[index] = value

    def get_StreamSegmentEntry(self):
        return self.StreamSegmentEntry

    def set_StreamSegmentEntry(self, StreamSegmentEntry):
        self.StreamSegmentEntry = StreamSegmentEntry

    def add_StreamSegmentEntry(self, value):
        self.StreamSegmentEntry.append(value)

    def insert_StreamSegmentEntry_at(self, index, value):
        self.StreamSegmentEntry.insert(index, value)

    def replace_StreamSegmentEntry_at(self, index, value):
        self.StreamSegmentEntry[index] = value

    def get_IndirectParameterRefEntry(self):
        return self.IndirectParameterRefEntry

    def set_IndirectParameterRefEntry(self, IndirectParameterRefEntry):
        self.IndirectParameterRefEntry = IndirectParameterRefEntry

    def add_IndirectParameterRefEntry(self, value):
        self.IndirectParameterRefEntry.append(value)

    def insert_IndirectParameterRefEntry_at(self, index, value):
        self.IndirectParameterRefEntry.insert(index, value)

    def replace_IndirectParameterRefEntry_at(self, index, value):
        self.IndirectParameterRefEntry[index] = value

    def get_ArrayParameterRefEntry(self):
        return self.ArrayParameterRefEntry

    def set_ArrayParameterRefEntry(self, ArrayParameterRefEntry):
        self.ArrayParameterRefEntry = ArrayParameterRefEntry

    def add_ArrayParameterRefEntry(self, value):
        self.ArrayParameterRefEntry.append(value)

    def insert_ArrayParameterRefEntry_at(self, index, value):
        self.ArrayParameterRefEntry.insert(index, value)

    def replace_ArrayParameterRefEntry_at(self, index, value):
        self.ArrayParameterRefEntry[index] = value

    def hasContent_(self):
        if (
                self.ParameterRefEntry or
                self.ParameterSegmentRefEntry or
                self.ContainerRefEntry or
                self.ContainerSegmentRefEntry or
                self.StreamSegmentEntry or
                self.IndirectParameterRefEntry or
                self.ArrayParameterRefEntry
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='EntryListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EntryListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EntryListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EntryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='EntryListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EntryListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='EntryListType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ParameterRefEntry_ in self.ParameterRefEntry:
            namespaceprefix_ = self.ParameterRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterRefEntry_nsprefix_) else ''
            ParameterRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterRefEntry',
                                      pretty_print=pretty_print)
        for ParameterSegmentRefEntry_ in self.ParameterSegmentRefEntry:
            namespaceprefix_ = self.ParameterSegmentRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterSegmentRefEntry_nsprefix_) else ''
            ParameterSegmentRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ParameterSegmentRefEntry', pretty_print=pretty_print)
        for ContainerRefEntry_ in self.ContainerRefEntry:
            namespaceprefix_ = self.ContainerRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContainerRefEntry_nsprefix_) else ''
            ContainerRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContainerRefEntry',
                                      pretty_print=pretty_print)
        for ContainerSegmentRefEntry_ in self.ContainerSegmentRefEntry:
            namespaceprefix_ = self.ContainerSegmentRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContainerSegmentRefEntry_nsprefix_) else ''
            ContainerSegmentRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ContainerSegmentRefEntry', pretty_print=pretty_print)
        for StreamSegmentEntry_ in self.StreamSegmentEntry:
            namespaceprefix_ = self.StreamSegmentEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StreamSegmentEntry_nsprefix_) else ''
            StreamSegmentEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StreamSegmentEntry',
                                       pretty_print=pretty_print)
        for IndirectParameterRefEntry_ in self.IndirectParameterRefEntry:
            namespaceprefix_ = self.IndirectParameterRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IndirectParameterRefEntry_nsprefix_) else ''
            IndirectParameterRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='IndirectParameterRefEntry', pretty_print=pretty_print)
        for ArrayParameterRefEntry_ in self.ArrayParameterRefEntry:
            namespaceprefix_ = self.ArrayParameterRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArrayParameterRefEntry_nsprefix_) else ''
            ArrayParameterRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='ArrayParameterRefEntry', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterRefEntry':
            obj_ = ParameterRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterRefEntry.append(obj_)
            obj_.original_tagname_ = 'ParameterRefEntry'
        elif nodeName_ == 'ParameterSegmentRefEntry':
            obj_ = ParameterSegmentRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterSegmentRefEntry.append(obj_)
            obj_.original_tagname_ = 'ParameterSegmentRefEntry'
        elif nodeName_ == 'ContainerRefEntry':
            obj_ = ContainerRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContainerRefEntry.append(obj_)
            obj_.original_tagname_ = 'ContainerRefEntry'
        elif nodeName_ == 'ContainerSegmentRefEntry':
            obj_ = ContainerSegmentRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContainerSegmentRefEntry.append(obj_)
            obj_.original_tagname_ = 'ContainerSegmentRefEntry'
        elif nodeName_ == 'StreamSegmentEntry':
            obj_ = StreamSegmentEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StreamSegmentEntry.append(obj_)
            obj_.original_tagname_ = 'StreamSegmentEntry'
        elif nodeName_ == 'IndirectParameterRefEntry':
            obj_ = IndirectParameterRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IndirectParameterRefEntry.append(obj_)
            obj_.original_tagname_ = 'IndirectParameterRefEntry'
        elif nodeName_ == 'ArrayParameterRefEntry':
            obj_ = ArrayParameterRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArrayParameterRefEntry.append(obj_)
            obj_.original_tagname_ = 'ArrayParameterRefEntry'


# end class EntryListType


class MessageRefType(GeneratedsSuper):
    """Holds a reference to a messagename of message"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, messageRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.messageRef = _cast(None, messageRef)
        self.messageRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MessageRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MessageRefType.subclass:
            return MessageRefType.subclass(*args_, **kwargs_)
        else:
            return MessageRefType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_messageRef(self):
        return self.messageRef

    def set_messageRef(self, messageRef):
        self.messageRef = messageRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MessageRefType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MessageRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MessageRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MessageRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MessageRefType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MessageRefType'):
        if self.messageRef is not None and 'messageRef' not in already_processed:
            already_processed.add('messageRef')
            outfile.write(' messageRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.messageRef), input_name='messageRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MessageRefType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('messageRef', node)
        if value is not None and 'messageRef' not in already_processed:
            already_processed.add('messageRef')
            self.messageRef = value
            self.validate_NameReferenceType(self.messageRef)  # validate type NameReferenceType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class MessageRefType


class SequenceEntryType(GeneratedsSuper):
    """Defines an abstract schema type used to create other entry types.
    Describe an entry’s location in the container (See
    LocationInContainerInBitsType). The location may be fixed or dynamic,
    absolute or relative. Entries may be included depending on the value of
    a condition (See IncludeConditionType), and entries may also repeat
    (see RepeatEntryType). The entry’s IncludeCondition resolves to true,
    it is fully-resolved when its size is computable after RepeatEntry has
    been accounted for and then offset by LocationInContainer. See
    EntryListType, IncludeConditionType, RepeatEntryType and
    LocationInContainerInBitsType.Optional short description for this entry
    element."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, shortDescription=None, LocationInContainerInBits=None, RepeatEntry=None, IncludeCondition=None,
                 TimeAssociation=None, AncillaryDataSet=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.shortDescription = _cast(None, shortDescription)
        self.shortDescription_nsprefix_ = None
        self.LocationInContainerInBits = LocationInContainerInBits
        self.LocationInContainerInBits_nsprefix_ = None
        self.RepeatEntry = RepeatEntry
        self.RepeatEntry_nsprefix_ = None
        self.IncludeCondition = IncludeCondition
        self.IncludeCondition_nsprefix_ = None
        self.TimeAssociation = TimeAssociation
        self.TimeAssociation_nsprefix_ = None
        self.AncillaryDataSet = AncillaryDataSet
        self.AncillaryDataSet_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SequenceEntryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SequenceEntryType.subclass:
            return SequenceEntryType.subclass(*args_, **kwargs_)
        else:
            return SequenceEntryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_LocationInContainerInBits(self):
        return self.LocationInContainerInBits

    def set_LocationInContainerInBits(self, LocationInContainerInBits):
        self.LocationInContainerInBits = LocationInContainerInBits

    def get_RepeatEntry(self):
        return self.RepeatEntry

    def set_RepeatEntry(self, RepeatEntry):
        self.RepeatEntry = RepeatEntry

    def get_IncludeCondition(self):
        return self.IncludeCondition

    def set_IncludeCondition(self, IncludeCondition):
        self.IncludeCondition = IncludeCondition

    def get_TimeAssociation(self):
        return self.TimeAssociation

    def set_TimeAssociation(self, TimeAssociation):
        self.TimeAssociation = TimeAssociation

    def get_AncillaryDataSet(self):
        return self.AncillaryDataSet

    def set_AncillaryDataSet(self, AncillaryDataSet):
        self.AncillaryDataSet = AncillaryDataSet

    def get_shortDescription(self):
        return self.shortDescription

    def set_shortDescription(self, shortDescription):
        self.shortDescription = shortDescription

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_ShortDescriptionType(self, value):
        # Validate type xtce:ShortDescriptionType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def hasContent_(self):
        if (
                self.LocationInContainerInBits is not None or
                self.RepeatEntry is not None or
                self.IncludeCondition is not None or
                self.TimeAssociation is not None or
                self.AncillaryDataSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SequenceEntryType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SequenceEntryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SequenceEntryType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SequenceEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SequenceEntryType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SequenceEntryType'):
        if self.shortDescription is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            outfile.write(' shortDescription=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.shortDescription), input_name='shortDescription')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SequenceEntryType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LocationInContainerInBits is not None:
            namespaceprefix_ = self.LocationInContainerInBits_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LocationInContainerInBits_nsprefix_) else ''
            self.LocationInContainerInBits.export(outfile, level, namespaceprefix_, namespacedef_='',
                                                  name_='LocationInContainerInBits', pretty_print=pretty_print)
        if self.RepeatEntry is not None:
            namespaceprefix_ = self.RepeatEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RepeatEntry_nsprefix_) else ''
            self.RepeatEntry.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RepeatEntry',
                                    pretty_print=pretty_print)
        if self.IncludeCondition is not None:
            namespaceprefix_ = self.IncludeCondition_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IncludeCondition_nsprefix_) else ''
            self.IncludeCondition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IncludeCondition',
                                         pretty_print=pretty_print)
        if self.TimeAssociation is not None:
            namespaceprefix_ = self.TimeAssociation_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TimeAssociation_nsprefix_) else ''
            self.TimeAssociation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TimeAssociation',
                                        pretty_print=pretty_print)
        if self.AncillaryDataSet is not None:
            namespaceprefix_ = self.AncillaryDataSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AncillaryDataSet_nsprefix_) else ''
            self.AncillaryDataSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AncillaryDataSet',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('shortDescription', node)
        if value is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            self.shortDescription = value
            self.validate_ShortDescriptionType(self.shortDescription)  # validate type ShortDescriptionType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LocationInContainerInBits':
            obj_ = LocationInContainerInBitsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LocationInContainerInBits = obj_
            obj_.original_tagname_ = 'LocationInContainerInBits'
        elif nodeName_ == 'RepeatEntry':
            obj_ = RepeatType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RepeatEntry = obj_
            obj_.original_tagname_ = 'RepeatEntry'
        elif nodeName_ == 'IncludeCondition':
            class_obj_ = self.get_class_obj_(child_, MatchCriteriaType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IncludeCondition = obj_
            obj_.original_tagname_ = 'IncludeCondition'
        elif nodeName_ == 'TimeAssociation':
            obj_ = TimeAssociationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TimeAssociation = obj_
            obj_.original_tagname_ = 'TimeAssociation'
        elif nodeName_ == 'AncillaryDataSet':
            obj_ = AncillaryDataSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AncillaryDataSet = obj_
            obj_.original_tagname_ = 'AncillaryDataSet'


# end class SequenceEntryType


class ArgumentSequenceEntryType(GeneratedsSuper):
    """Identical to a SequenceEntryType but supports argument instance
    references.Optional short description for this entry element."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, shortDescription=None, LocationInContainerInBits=None, RepeatEntry=None, IncludeCondition=None,
                 AncillaryDataSet=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.shortDescription = _cast(None, shortDescription)
        self.shortDescription_nsprefix_ = None
        self.LocationInContainerInBits = LocationInContainerInBits
        self.LocationInContainerInBits_nsprefix_ = None
        self.RepeatEntry = RepeatEntry
        self.RepeatEntry_nsprefix_ = None
        self.IncludeCondition = IncludeCondition
        self.IncludeCondition_nsprefix_ = None
        self.AncillaryDataSet = AncillaryDataSet
        self.AncillaryDataSet_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentSequenceEntryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentSequenceEntryType.subclass:
            return ArgumentSequenceEntryType.subclass(*args_, **kwargs_)
        else:
            return ArgumentSequenceEntryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_LocationInContainerInBits(self):
        return self.LocationInContainerInBits

    def set_LocationInContainerInBits(self, LocationInContainerInBits):
        self.LocationInContainerInBits = LocationInContainerInBits

    def get_RepeatEntry(self):
        return self.RepeatEntry

    def set_RepeatEntry(self, RepeatEntry):
        self.RepeatEntry = RepeatEntry

    def get_IncludeCondition(self):
        return self.IncludeCondition

    def set_IncludeCondition(self, IncludeCondition):
        self.IncludeCondition = IncludeCondition

    def get_AncillaryDataSet(self):
        return self.AncillaryDataSet

    def set_AncillaryDataSet(self, AncillaryDataSet):
        self.AncillaryDataSet = AncillaryDataSet

    def get_shortDescription(self):
        return self.shortDescription

    def set_shortDescription(self, shortDescription):
        self.shortDescription = shortDescription

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_ShortDescriptionType(self, value):
        # Validate type xtce:ShortDescriptionType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def hasContent_(self):
        if (
                self.LocationInContainerInBits is not None or
                self.RepeatEntry is not None or
                self.IncludeCondition is not None or
                self.AncillaryDataSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentSequenceEntryType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentSequenceEntryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentSequenceEntryType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentSequenceEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentSequenceEntryType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentSequenceEntryType'):
        if self.shortDescription is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            outfile.write(' shortDescription=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.shortDescription), input_name='shortDescription')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentSequenceEntryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LocationInContainerInBits is not None:
            namespaceprefix_ = self.LocationInContainerInBits_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LocationInContainerInBits_nsprefix_) else ''
            self.LocationInContainerInBits.export(outfile, level, namespaceprefix_, namespacedef_='',
                                                  name_='LocationInContainerInBits', pretty_print=pretty_print)
        if self.RepeatEntry is not None:
            namespaceprefix_ = self.RepeatEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RepeatEntry_nsprefix_) else ''
            self.RepeatEntry.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RepeatEntry',
                                    pretty_print=pretty_print)
        if self.IncludeCondition is not None:
            namespaceprefix_ = self.IncludeCondition_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IncludeCondition_nsprefix_) else ''
            self.IncludeCondition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IncludeCondition',
                                         pretty_print=pretty_print)
        if self.AncillaryDataSet is not None:
            namespaceprefix_ = self.AncillaryDataSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AncillaryDataSet_nsprefix_) else ''
            self.AncillaryDataSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AncillaryDataSet',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('shortDescription', node)
        if value is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            self.shortDescription = value
            self.validate_ShortDescriptionType(self.shortDescription)  # validate type ShortDescriptionType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LocationInContainerInBits':
            obj_ = ArgumentLocationInContainerInBitsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LocationInContainerInBits = obj_
            obj_.original_tagname_ = 'LocationInContainerInBits'
        elif nodeName_ == 'RepeatEntry':
            obj_ = ArgumentRepeatType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RepeatEntry = obj_
            obj_.original_tagname_ = 'RepeatEntry'
        elif nodeName_ == 'IncludeCondition':
            class_obj_ = self.get_class_obj_(child_, ArgumentMatchCriteriaType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IncludeCondition = obj_
            obj_.original_tagname_ = 'IncludeCondition'
        elif nodeName_ == 'AncillaryDataSet':
            obj_ = AncillaryDataSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AncillaryDataSet = obj_
            obj_.original_tagname_ = 'AncillaryDataSet'


# end class ArgumentSequenceEntryType


class StreamSegmentEntryType(SequenceEntryType):
    """An entry that is a portion of a stream (streams are by definition,
    assumed continuous) It is assumed that stream segments happen
    sequentially in time, that is the first part if a steam first, however,
    if this is not the case the order of the stream segments may be
    supplied with the order attribute where the first segment order="0"."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = SequenceEntryType

    def __init__(self, shortDescription=None, LocationInContainerInBits=None, RepeatEntry=None, IncludeCondition=None,
                 TimeAssociation=None, AncillaryDataSet=None, streamRef=None, order=None, sizeInBits=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(StreamSegmentEntryType, self).__init__(shortDescription, LocationInContainerInBits, RepeatEntry,
                                                     IncludeCondition, TimeAssociation, AncillaryDataSet, **kwargs_)
        self.streamRef = _cast(None, streamRef)
        self.streamRef_nsprefix_ = None
        self.order = _cast(int, order)
        self.order_nsprefix_ = None
        self.sizeInBits = _cast(int, sizeInBits)
        self.sizeInBits_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamSegmentEntryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamSegmentEntryType.subclass:
            return StreamSegmentEntryType.subclass(*args_, **kwargs_)
        else:
            return StreamSegmentEntryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_streamRef(self):
        return self.streamRef

    def set_streamRef(self, streamRef):
        self.streamRef = streamRef

    def get_order(self):
        return self.order

    def set_order(self, order):
        self.order = order

    def get_sizeInBits(self):
        return self.sizeInBits

    def set_sizeInBits(self, sizeInBits):
        self.sizeInBits = sizeInBits

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                super(StreamSegmentEntryType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='StreamSegmentEntryType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('StreamSegmentEntryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'StreamSegmentEntryType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='StreamSegmentEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='StreamSegmentEntryType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='StreamSegmentEntryType'):
        super(StreamSegmentEntryType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                             name_='StreamSegmentEntryType')
        if self.streamRef is not None and 'streamRef' not in already_processed:
            already_processed.add('streamRef')
            outfile.write(' streamRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.streamRef), input_name='streamRef')),))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
        if self.sizeInBits is not None and 'sizeInBits' not in already_processed:
            already_processed.add('sizeInBits')
            outfile.write(' sizeInBits="%s"' % self.gds_format_integer(self.sizeInBits, input_name='sizeInBits'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='StreamSegmentEntryType', fromsubclass_=False, pretty_print=True):
        super(StreamSegmentEntryType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                           pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('streamRef', node)
        if value is not None and 'streamRef' not in already_processed:
            already_processed.add('streamRef')
            self.streamRef = value
            self.validate_NameReferenceType(self.streamRef)  # validate type NameReferenceType
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            self.order = self.gds_parse_integer(value, node, 'order')
            self.validate_PositiveLongType(self.order)  # validate type PositiveLongType
        value = find_attr_value_('sizeInBits', node)
        if value is not None and 'sizeInBits' not in already_processed:
            already_processed.add('sizeInBits')
            self.sizeInBits = self.gds_parse_integer(value, node, 'sizeInBits')
            self.validate_PositiveLongType(self.sizeInBits)  # validate type PositiveLongType
        super(StreamSegmentEntryType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(StreamSegmentEntryType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class StreamSegmentEntryType


class RateInStreamSetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, RateInStream=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if RateInStream is None:
            self.RateInStream = []
        else:
            self.RateInStream = RateInStream
        self.RateInStream_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RateInStreamSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RateInStreamSetType.subclass:
            return RateInStreamSetType.subclass(*args_, **kwargs_)
        else:
            return RateInStreamSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_RateInStream(self):
        return self.RateInStream

    def set_RateInStream(self, RateInStream):
        self.RateInStream = RateInStream

    def add_RateInStream(self, value):
        self.RateInStream.append(value)

    def insert_RateInStream_at(self, index, value):
        self.RateInStream.insert(index, value)

    def replace_RateInStream_at(self, index, value):
        self.RateInStream[index] = value

    def hasContent_(self):
        if (
                self.RateInStream
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='RateInStreamSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RateInStreamSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RateInStreamSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RateInStreamSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RateInStreamSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RateInStreamSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='RateInStreamSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for RateInStream_ in self.RateInStream:
            namespaceprefix_ = self.RateInStream_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RateInStream_nsprefix_) else ''
            RateInStream_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RateInStream',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'RateInStream':
            obj_ = RateInStreamWithStreamNameType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RateInStream.append(obj_)
            obj_.original_tagname_ = 'RateInStream'


# end class RateInStreamSetType


class RateInStreamType(GeneratedsSuper):
    """Define the expected appearance (rate) of a container in a stream where
    the rate is defined on either a perSecond or perContainer update basis.
    Many programs and platforms have variable reporting rates for
    containers and these can be commanded. As a result, this element is
    only useful to some users and generally does not affect the processing
    of the received containers themselves. See ContainerType.The
    measurement unit basis for the minimum and maximum appearance count
    values.The minimum rate for the specified basis for which this
    container should appear in the stream.The maximum rate for the
    specified basis for which this container should appear in the
    stream."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, basis='perSecond', minimumValue=None, maximumValue=None, extensiontype_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.basis = _cast(None, basis)
        self.basis_nsprefix_ = None
        self.minimumValue = _cast(float, minimumValue)
        self.minimumValue_nsprefix_ = None
        self.maximumValue = _cast(float, maximumValue)
        self.maximumValue_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RateInStreamType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RateInStreamType.subclass:
            return RateInStreamType.subclass(*args_, **kwargs_)
        else:
            return RateInStreamType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_basis(self):
        return self.basis

    def set_basis(self, basis):
        self.basis = basis

    def get_minimumValue(self):
        return self.minimumValue

    def set_minimumValue(self, minimumValue):
        self.minimumValue = minimumValue

    def get_maximumValue(self):
        return self.maximumValue

    def set_maximumValue(self, maximumValue):
        self.maximumValue = maximumValue

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_BasisType(self, value):
        # Validate type xtce:BasisType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['perSecond', 'perContainerUpdate']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BasisType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='RateInStreamType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RateInStreamType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RateInStreamType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RateInStreamType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RateInStreamType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RateInStreamType'):
        if self.basis != "perSecond" and 'basis' not in already_processed:
            already_processed.add('basis')
            outfile.write(
                ' basis=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.basis), input_name='basis')),))
        if self.minimumValue is not None and 'minimumValue' not in already_processed:
            already_processed.add('minimumValue')
            outfile.write(' minimumValue="%s"' % self.gds_format_double(self.minimumValue, input_name='minimumValue'))
        if self.maximumValue is not None and 'maximumValue' not in already_processed:
            already_processed.add('maximumValue')
            outfile.write(' maximumValue="%s"' % self.gds_format_double(self.maximumValue, input_name='maximumValue'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='RateInStreamType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('basis', node)
        if value is not None and 'basis' not in already_processed:
            already_processed.add('basis')
            self.basis = value
            self.validate_BasisType(self.basis)  # validate type BasisType
        value = find_attr_value_('minimumValue', node)
        if value is not None and 'minimumValue' not in already_processed:
            already_processed.add('minimumValue')
            value = self.gds_parse_double(value, node, 'minimumValue')
            self.minimumValue = value
        value = find_attr_value_('maximumValue', node)
        if value is not None and 'maximumValue' not in already_processed:
            already_processed.add('maximumValue')
            value = self.gds_parse_double(value, node, 'maximumValue')
            self.maximumValue = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class RateInStreamType


class RateInStreamWithStreamNameType(RateInStreamType):
    """Define the expected appearance (rate) of a container in a named stream
    where the rate is defined on either a perSecond or perContainer update
    basis. Many programs and platforms have variable reporting rates for
    containers and these can be commanded. As a result, this element is
    only useful to some users and generally does not affect the processing
    of the received containers themselves. See ContainerType and
    RateInStreamType.Reference to a named stream for which this rate
    specification applies."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = RateInStreamType

    def __init__(self, basis='perSecond', minimumValue=None, maximumValue=None, streamRef=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(RateInStreamWithStreamNameType, self).__init__(basis, minimumValue, maximumValue, **kwargs_)
        self.streamRef = _cast(None, streamRef)
        self.streamRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RateInStreamWithStreamNameType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RateInStreamWithStreamNameType.subclass:
            return RateInStreamWithStreamNameType.subclass(*args_, **kwargs_)
        else:
            return RateInStreamWithStreamNameType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_streamRef(self):
        return self.streamRef

    def set_streamRef(self, streamRef):
        self.streamRef = streamRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                super(RateInStreamWithStreamNameType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='RateInStreamWithStreamNameType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RateInStreamWithStreamNameType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RateInStreamWithStreamNameType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='RateInStreamWithStreamNameType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='RateInStreamWithStreamNameType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='RateInStreamWithStreamNameType'):
        super(RateInStreamWithStreamNameType, self).exportAttributes(outfile, level, already_processed,
                                                                     namespaceprefix_,
                                                                     name_='RateInStreamWithStreamNameType')
        if self.streamRef is not None and 'streamRef' not in already_processed:
            already_processed.add('streamRef')
            outfile.write(' streamRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.streamRef), input_name='streamRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='RateInStreamWithStreamNameType', fromsubclass_=False, pretty_print=True):
        super(RateInStreamWithStreamNameType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_,
                                                                   name_, True, pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('streamRef', node)
        if value is not None and 'streamRef' not in already_processed:
            already_processed.add('streamRef')
            self.streamRef = value
            self.validate_NameReferenceType(self.streamRef)  # validate type NameReferenceType
        super(RateInStreamWithStreamNameType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(RateInStreamWithStreamNameType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class RateInStreamWithStreamNameType


class EnumerationContextAlarmListType(GeneratedsSuper):
    """Describe an ordered collection of context enumeration alarms, duplicates
    are valid. Process the contexts in list order. See
    EnumerationContextAlarmType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContextAlarm=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ContextAlarm is None:
            self.ContextAlarm = []
        else:
            self.ContextAlarm = ContextAlarm
        self.ContextAlarm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EnumerationContextAlarmListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EnumerationContextAlarmListType.subclass:
            return EnumerationContextAlarmListType.subclass(*args_, **kwargs_)
        else:
            return EnumerationContextAlarmListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContextAlarm(self):
        return self.ContextAlarm

    def set_ContextAlarm(self, ContextAlarm):
        self.ContextAlarm = ContextAlarm

    def add_ContextAlarm(self, value):
        self.ContextAlarm.append(value)

    def insert_ContextAlarm_at(self, index, value):
        self.ContextAlarm.insert(index, value)

    def replace_ContextAlarm_at(self, index, value):
        self.ContextAlarm[index] = value

    def hasContent_(self):
        if (
                self.ContextAlarm
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='EnumerationContextAlarmListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EnumerationContextAlarmListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EnumerationContextAlarmListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='EnumerationContextAlarmListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='EnumerationContextAlarmListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='EnumerationContextAlarmListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='EnumerationContextAlarmListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ContextAlarm_ in self.ContextAlarm:
            namespaceprefix_ = self.ContextAlarm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextAlarm_nsprefix_) else ''
            ContextAlarm_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContextAlarm',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContextAlarm':
            obj_ = EnumerationContextAlarmType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextAlarm.append(obj_)
            obj_.original_tagname_ = 'ContextAlarm'


# end class EnumerationContextAlarmListType


class MessageRefSetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, MessageRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if MessageRef is None:
            self.MessageRef = []
        else:
            self.MessageRef = MessageRef
        self.MessageRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MessageRefSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MessageRefSetType.subclass:
            return MessageRefSetType.subclass(*args_, **kwargs_)
        else:
            return MessageRefSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_MessageRef(self):
        return self.MessageRef

    def set_MessageRef(self, MessageRef):
        self.MessageRef = MessageRef

    def add_MessageRef(self, value):
        self.MessageRef.append(value)

    def insert_MessageRef_at(self, index, value):
        self.MessageRef.insert(index, value)

    def replace_MessageRef_at(self, index, value):
        self.MessageRef[index] = value

    def hasContent_(self):
        if (
                self.MessageRef
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MessageRefSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MessageRefSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MessageRefSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MessageRefSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MessageRefSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MessageRefSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MessageRefSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MessageRef_ in self.MessageRef:
            namespaceprefix_ = self.MessageRef_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageRef_nsprefix_) else ''
            MessageRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MessageRef',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'MessageRef':
            obj_ = MessageRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MessageRef.append(obj_)
            obj_.original_tagname_ = 'MessageRef'


# end class MessageRefSetType


class NumericContextAlarmListType(GeneratedsSuper):
    """An ordered collection of numeric alarms associated with a context. A
    context is an alarm definition on a parameter which is valid only in
    the case of a test on the value of other parameters. Process the
    contexts in list order. Used by both FloatParameterType and
    IntegerParameterType. See NumericContextAlarmType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContextAlarm=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ContextAlarm is None:
            self.ContextAlarm = []
        else:
            self.ContextAlarm = ContextAlarm
        self.ContextAlarm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NumericContextAlarmListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NumericContextAlarmListType.subclass:
            return NumericContextAlarmListType.subclass(*args_, **kwargs_)
        else:
            return NumericContextAlarmListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContextAlarm(self):
        return self.ContextAlarm

    def set_ContextAlarm(self, ContextAlarm):
        self.ContextAlarm = ContextAlarm

    def add_ContextAlarm(self, value):
        self.ContextAlarm.append(value)

    def insert_ContextAlarm_at(self, index, value):
        self.ContextAlarm.insert(index, value)

    def replace_ContextAlarm_at(self, index, value):
        self.ContextAlarm[index] = value

    def hasContent_(self):
        if (
                self.ContextAlarm
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='NumericContextAlarmListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NumericContextAlarmListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'NumericContextAlarmListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NumericContextAlarmListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='NumericContextAlarmListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='NumericContextAlarmListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='NumericContextAlarmListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ContextAlarm_ in self.ContextAlarm:
            namespaceprefix_ = self.ContextAlarm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextAlarm_nsprefix_) else ''
            ContextAlarm_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContextAlarm',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContextAlarm':
            obj_ = NumericContextAlarmType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextAlarm.append(obj_)
            obj_.original_tagname_ = 'ContextAlarm'


# end class NumericContextAlarmListType


class ParameterPropertiesType(GeneratedsSuper):
    """Describes extended properties/attributes of Parameter definitions.This
    attribute describes the nature of the source entity for which this
    parameter receives a value. Implementations assign different
    attributes/properties internally to a parameter based on the
    anticipated data source.A Parameter marked as 'readOnly' true is non-
    settable by users and applications/services that do not represent the
    data source itself. Note that a slight conceptual overlap exists here
    between the 'dataSource' attribute and this attribute when the data
    source is 'constant'. For a constant data source, then 'readOnly'
    should be 'true'. Application implementations may choose to implicitly
    enforce this. Some implementations have both concepts of a Parameter
    that is settable or non-settable and a Constant in different parts of
    their internal data model.A Parameter marked to persist should retain
    the latest value through resets/restarts to the extent that is possible
    or defined in the implementation. The net effect is that the
    initial/default value on a Parameter is only seen once or when the
    system has a reset to revert to initial/default values."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, dataSource=None, readOnly=False, persistence=True, SystemName=None, ValidityCondition=None,
                 PhysicalAddressSet=None, TimeAssociation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dataSource = _cast(None, dataSource)
        self.dataSource_nsprefix_ = None
        self.readOnly = _cast(bool, readOnly)
        self.readOnly_nsprefix_ = None
        self.persistence = _cast(bool, persistence)
        self.persistence_nsprefix_ = None
        self.SystemName = SystemName
        self.SystemName_nsprefix_ = None
        self.ValidityCondition = ValidityCondition
        self.ValidityCondition_nsprefix_ = None
        self.PhysicalAddressSet = PhysicalAddressSet
        self.PhysicalAddressSet_nsprefix_ = None
        self.TimeAssociation = TimeAssociation
        self.TimeAssociation_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterPropertiesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterPropertiesType.subclass:
            return ParameterPropertiesType.subclass(*args_, **kwargs_)
        else:
            return ParameterPropertiesType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SystemName(self):
        return self.SystemName

    def set_SystemName(self, SystemName):
        self.SystemName = SystemName

    def get_ValidityCondition(self):
        return self.ValidityCondition

    def set_ValidityCondition(self, ValidityCondition):
        self.ValidityCondition = ValidityCondition

    def get_PhysicalAddressSet(self):
        return self.PhysicalAddressSet

    def set_PhysicalAddressSet(self, PhysicalAddressSet):
        self.PhysicalAddressSet = PhysicalAddressSet

    def get_TimeAssociation(self):
        return self.TimeAssociation

    def set_TimeAssociation(self, TimeAssociation):
        self.TimeAssociation = TimeAssociation

    def get_dataSource(self):
        return self.dataSource

    def set_dataSource(self, dataSource):
        self.dataSource = dataSource

    def get_readOnly(self):
        return self.readOnly

    def set_readOnly(self, readOnly):
        self.readOnly = readOnly

    def get_persistence(self):
        return self.persistence

    def set_persistence(self, persistence):
        self.persistence = persistence

    def validate_TelemetryDataSourceType(self, value):
        # Validate type xtce:TelemetryDataSourceType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['telemetered', 'derived', 'constant', 'local', 'ground']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TelemetryDataSourceType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.SystemName is not None or
                self.ValidityCondition is not None or
                self.PhysicalAddressSet is not None or
                self.TimeAssociation is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='ParameterPropertiesType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterPropertiesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterPropertiesType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterPropertiesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterPropertiesType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParameterPropertiesType'):
        if self.dataSource is not None and 'dataSource' not in already_processed:
            already_processed.add('dataSource')
            outfile.write(' dataSource=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.dataSource), input_name='dataSource')),))
        if self.readOnly and 'readOnly' not in already_processed:
            already_processed.add('readOnly')
            outfile.write(' readOnly="%s"' % self.gds_format_boolean(self.readOnly, input_name='readOnly'))
        if not self.persistence and 'persistence' not in already_processed:
            already_processed.add('persistence')
            outfile.write(' persistence="%s"' % self.gds_format_boolean(self.persistence, input_name='persistence'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='ParameterPropertiesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SystemName is not None:
            namespaceprefix_ = self.SystemName_nsprefix_ + ':' if (UseCapturedNS_ and self.SystemName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSystemName>%s</%sSystemName>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.SystemName), input_name='SystemName')), namespaceprefix_, eol_))
        if self.ValidityCondition is not None:
            namespaceprefix_ = self.ValidityCondition_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ValidityCondition_nsprefix_) else ''
            self.ValidityCondition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValidityCondition',
                                          pretty_print=pretty_print)
        if self.PhysicalAddressSet is not None:
            namespaceprefix_ = self.PhysicalAddressSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.PhysicalAddressSet_nsprefix_) else ''
            self.PhysicalAddressSet.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='PhysicalAddressSet', pretty_print=pretty_print)
        if self.TimeAssociation is not None:
            namespaceprefix_ = self.TimeAssociation_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TimeAssociation_nsprefix_) else ''
            self.TimeAssociation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TimeAssociation',
                                        pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dataSource', node)
        if value is not None and 'dataSource' not in already_processed:
            already_processed.add('dataSource')
            self.dataSource = value
            self.validate_TelemetryDataSourceType(self.dataSource)  # validate type TelemetryDataSourceType
        value = find_attr_value_('readOnly', node)
        if value is not None and 'readOnly' not in already_processed:
            already_processed.add('readOnly')
            if value in ('true', '1'):
                self.readOnly = True
            elif value in ('false', '0'):
                self.readOnly = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('persistence', node)
        if value is not None and 'persistence' not in already_processed:
            already_processed.add('persistence')
            if value in ('true', '1'):
                self.persistence = True
            elif value in ('false', '0'):
                self.persistence = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SystemName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SystemName')
            value_ = self.gds_validate_string(value_, node, 'SystemName')
            self.SystemName = value_
            self.SystemName_nsprefix_ = child_.prefix
        elif nodeName_ == 'ValidityCondition':
            class_obj_ = self.get_class_obj_(child_, MatchCriteriaType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValidityCondition = obj_
            obj_.original_tagname_ = 'ValidityCondition'
        elif nodeName_ == 'PhysicalAddressSet':
            obj_ = PhysicalAddressSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PhysicalAddressSet = obj_
            obj_.original_tagname_ = 'PhysicalAddressSet'
        elif nodeName_ == 'TimeAssociation':
            obj_ = TimeAssociationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TimeAssociation = obj_
            obj_.original_tagname_ = 'TimeAssociation'


# end class ParameterPropertiesType


class ParameterTypeSetType(GeneratedsSuper):
    """Describe an unordered collection of parameter type definitions. These
    types named for the engineering/calibrated type of the parameter. See
    BaseDataType and BaseTimeDataType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, StringParameterType=None, EnumeratedParameterType=None, IntegerParameterType=None,
                 BinaryParameterType=None, FloatParameterType=None, BooleanParameterType=None,
                 RelativeTimeParameterType=None, AbsoluteTimeParameterType=None, ArrayParameterType=None,
                 AggregateParameterType=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if StringParameterType is None:
            self.StringParameterType = []
        else:
            self.StringParameterType = StringParameterType
        self.StringParameterType_nsprefix_ = None
        if EnumeratedParameterType is None:
            self.EnumeratedParameterType = []
        else:
            self.EnumeratedParameterType = EnumeratedParameterType
        self.EnumeratedParameterType_nsprefix_ = None
        if IntegerParameterType is None:
            self.IntegerParameterType = []
        else:
            self.IntegerParameterType = IntegerParameterType
        self.IntegerParameterType_nsprefix_ = None
        if BinaryParameterType is None:
            self.BinaryParameterType = []
        else:
            self.BinaryParameterType = BinaryParameterType
        self.BinaryParameterType_nsprefix_ = None
        if FloatParameterType is None:
            self.FloatParameterType = []
        else:
            self.FloatParameterType = FloatParameterType
        self.FloatParameterType_nsprefix_ = None
        if BooleanParameterType is None:
            self.BooleanParameterType = []
        else:
            self.BooleanParameterType = BooleanParameterType
        self.BooleanParameterType_nsprefix_ = None
        if RelativeTimeParameterType is None:
            self.RelativeTimeParameterType = []
        else:
            self.RelativeTimeParameterType = RelativeTimeParameterType
        self.RelativeTimeParameterType_nsprefix_ = None
        if AbsoluteTimeParameterType is None:
            self.AbsoluteTimeParameterType = []
        else:
            self.AbsoluteTimeParameterType = AbsoluteTimeParameterType
        self.AbsoluteTimeParameterType_nsprefix_ = None
        if ArrayParameterType is None:
            self.ArrayParameterType = []
        else:
            self.ArrayParameterType = ArrayParameterType
        self.ArrayParameterType_nsprefix_ = None
        if AggregateParameterType is None:
            self.AggregateParameterType = []
        else:
            self.AggregateParameterType = AggregateParameterType
        self.AggregateParameterType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterTypeSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterTypeSetType.subclass:
            return ParameterTypeSetType.subclass(*args_, **kwargs_)
        else:
            return ParameterTypeSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_StringParameterType(self):
        return self.StringParameterType

    def set_StringParameterType(self, StringParameterType):
        self.StringParameterType = StringParameterType

    def add_StringParameterType(self, value):
        self.StringParameterType.append(value)

    def insert_StringParameterType_at(self, index, value):
        self.StringParameterType.insert(index, value)

    def replace_StringParameterType_at(self, index, value):
        self.StringParameterType[index] = value

    def get_EnumeratedParameterType(self):
        return self.EnumeratedParameterType

    def set_EnumeratedParameterType(self, EnumeratedParameterType):
        self.EnumeratedParameterType = EnumeratedParameterType

    def add_EnumeratedParameterType(self, value):
        self.EnumeratedParameterType.append(value)

    def insert_EnumeratedParameterType_at(self, index, value):
        self.EnumeratedParameterType.insert(index, value)

    def replace_EnumeratedParameterType_at(self, index, value):
        self.EnumeratedParameterType[index] = value

    def get_IntegerParameterType(self):
        return self.IntegerParameterType

    def set_IntegerParameterType(self, IntegerParameterType):
        self.IntegerParameterType = IntegerParameterType

    def add_IntegerParameterType(self, value):
        self.IntegerParameterType.append(value)

    def insert_IntegerParameterType_at(self, index, value):
        self.IntegerParameterType.insert(index, value)

    def replace_IntegerParameterType_at(self, index, value):
        self.IntegerParameterType[index] = value

    def get_BinaryParameterType(self):
        return self.BinaryParameterType

    def set_BinaryParameterType(self, BinaryParameterType):
        self.BinaryParameterType = BinaryParameterType

    def add_BinaryParameterType(self, value):
        self.BinaryParameterType.append(value)

    def insert_BinaryParameterType_at(self, index, value):
        self.BinaryParameterType.insert(index, value)

    def replace_BinaryParameterType_at(self, index, value):
        self.BinaryParameterType[index] = value

    def get_FloatParameterType(self):
        return self.FloatParameterType

    def set_FloatParameterType(self, FloatParameterType):
        self.FloatParameterType = FloatParameterType

    def add_FloatParameterType(self, value):
        self.FloatParameterType.append(value)

    def insert_FloatParameterType_at(self, index, value):
        self.FloatParameterType.insert(index, value)

    def replace_FloatParameterType_at(self, index, value):
        self.FloatParameterType[index] = value

    def get_BooleanParameterType(self):
        return self.BooleanParameterType

    def set_BooleanParameterType(self, BooleanParameterType):
        self.BooleanParameterType = BooleanParameterType

    def add_BooleanParameterType(self, value):
        self.BooleanParameterType.append(value)

    def insert_BooleanParameterType_at(self, index, value):
        self.BooleanParameterType.insert(index, value)

    def replace_BooleanParameterType_at(self, index, value):
        self.BooleanParameterType[index] = value

    def get_RelativeTimeParameterType(self):
        return self.RelativeTimeParameterTypeF

    def set_RelativeTimeParameterType(self, RelativeTimeParameterType):
        self.RelativeTimeParameterType = RelativeTimeParameterType

    def add_RelativeTimeParameterType(self, value):
        self.RelativeTimeParameterType.append(value)

    def insert_RelativeTimeParameterType_at(self, index, value):
        self.RelativeTimeParameterType.insert(index, value)

    def replace_RelativeTimeParameterType_at(self, index, value):
        self.RelativeTimeParameterType[index] = value

    def get_AbsoluteTimeParameterType(self):
        return self.AbsoluteTimeParameterType

    def set_AbsoluteTimeParameterType(self, AbsoluteTimeParameterType):
        self.AbsoluteTimeParameterType = AbsoluteTimeParameterType

    def add_AbsoluteTimeParameterType(self, value):
        self.AbsoluteTimeParameterType.append(value)

    def insert_AbsoluteTimeParameterType_at(self, index, value):
        self.AbsoluteTimeParameterType.insert(index, value)

    def replace_AbsoluteTimeParameterType_at(self, index, value):
        self.AbsoluteTimeParameterType[index] = value

    def get_ArrayParameterType(self):
        return self.ArrayParameterType

    def set_ArrayParameterType(self, ArrayParameterType):
        self.ArrayParameterType = ArrayParameterType

    def add_ArrayParameterType(self, value):
        self.ArrayParameterType.append(value)

    def insert_ArrayParameterType_at(self, index, value):
        self.ArrayParameterType.insert(index, value)

    def replace_ArrayParameterType_at(self, index, value):
        self.ArrayParameterType[index] = value

    def get_AggregateParameterType(self) -> list:
        return self.AggregateParameterType

    def set_AggregateParameterType(self, AggregateParameterType):
        self.AggregateParameterType = AggregateParameterType

    def add_AggregateParameterType(self, value):
        self.AggregateParameterType.append(value)

    def insert_AggregateParameterType_at(self, index, value):
        self.AggregateParameterType.insert(index, value)

    def replace_AggregateParameterType_at(self, index, value):
        self.AggregateParameterType[index] = value

    def hasContent_(self):
        if (
                self.StringParameterType or
                self.EnumeratedParameterType or
                self.IntegerParameterType or
                self.BinaryParameterType or
                self.FloatParameterType or
                self.BooleanParameterType or
                self.RelativeTimeParameterType or
                self.AbsoluteTimeParameterType or
                self.ArrayParameterType or
                self.AggregateParameterType
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParameterTypeSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterTypeSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterTypeSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterTypeSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterTypeSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParameterTypeSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParameterTypeSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for StringParameterType_ in self.StringParameterType:
            namespaceprefix_ = self.StringParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StringParameterType_nsprefix_) else ''
            StringParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StringParameterType',
                                        pretty_print=pretty_print)
        for EnumeratedParameterType_ in self.EnumeratedParameterType:
            namespaceprefix_ = self.EnumeratedParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.EnumeratedParameterType_nsprefix_) else ''
            EnumeratedParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='EnumeratedParameterType', pretty_print=pretty_print)
        for IntegerParameterType_ in self.IntegerParameterType:
            namespaceprefix_ = self.IntegerParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IntegerParameterType_nsprefix_) else ''
            IntegerParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                         name_='IntegerParameterType', pretty_print=pretty_print)
        for BinaryParameterType_ in self.BinaryParameterType:
            namespaceprefix_ = self.BinaryParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BinaryParameterType_nsprefix_) else ''
            BinaryParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BinaryParameterType',
                                        pretty_print=pretty_print)
        for FloatParameterType_ in self.FloatParameterType:
            namespaceprefix_ = self.FloatParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FloatParameterType_nsprefix_) else ''
            FloatParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FloatParameterType',
                                       pretty_print=pretty_print)
        for BooleanParameterType_ in self.BooleanParameterType:
            namespaceprefix_ = self.BooleanParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BooleanParameterType_nsprefix_) else ''
            BooleanParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                         name_='BooleanParameterType', pretty_print=pretty_print)
        for RelativeTimeParameterType_ in self.RelativeTimeParameterType:
            namespaceprefix_ = self.RelativeTimeParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RelativeTimeParameterType_nsprefix_) else ''
            RelativeTimeParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='RelativeTimeParameterType', pretty_print=pretty_print)
        for AbsoluteTimeParameterType_ in self.AbsoluteTimeParameterType:
            namespaceprefix_ = self.AbsoluteTimeParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AbsoluteTimeParameterType_nsprefix_) else ''
            AbsoluteTimeParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='AbsoluteTimeParameterType', pretty_print=pretty_print)
        for ArrayParameterType_ in self.ArrayParameterType:
            namespaceprefix_ = self.ArrayParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArrayParameterType_nsprefix_) else ''
            ArrayParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ArrayParameterType',
                                       pretty_print=pretty_print)
        for AggregateParameterType_ in self.AggregateParameterType:
            namespaceprefix_ = self.AggregateParameterType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AggregateParameterType_nsprefix_) else ''
            AggregateParameterType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='AggregateParameterType', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'StringParameterType':
            obj_ = StringParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StringParameterType.append(obj_)
            obj_.original_tagname_ = 'StringParameterType'
        elif nodeName_ == 'EnumeratedParameterType':
            obj_ = EnumeratedParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EnumeratedParameterType.append(obj_)
            obj_.original_tagname_ = 'EnumeratedParameterType'
        elif nodeName_ == 'IntegerParameterType':
            obj_ = IntegerParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IntegerParameterType.append(obj_)
            obj_.original_tagname_ = 'IntegerParameterType'
        elif nodeName_ == 'BinaryParameterType':
            obj_ = BinaryParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BinaryParameterType.append(obj_)
            obj_.original_tagname_ = 'BinaryParameterType'
        elif nodeName_ == 'FloatParameterType':
            obj_ = FloatParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FloatParameterType.append(obj_)
            obj_.original_tagname_ = 'FloatParameterType'
        elif nodeName_ == 'BooleanParameterType':
            obj_ = BooleanParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BooleanParameterType.append(obj_)
            obj_.original_tagname_ = 'BooleanParameterType'
        elif nodeName_ == 'RelativeTimeParameterType':
            obj_ = RelativeTimeParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RelativeTimeParameterType.append(obj_)
            obj_.original_tagname_ = 'RelativeTimeParameterType'
        elif nodeName_ == 'AbsoluteTimeParameterType':
            obj_ = AbsoluteTimeParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AbsoluteTimeParameterType.append(obj_)
            obj_.original_tagname_ = 'AbsoluteTimeParameterType'
        elif nodeName_ == 'ArrayParameterType':
            obj_ = ArrayParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArrayParameterType.append(obj_)
            obj_.original_tagname_ = 'ArrayParameterType'
        elif nodeName_ == 'AggregateParameterType':
            obj_ = AggregateParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AggregateParameterType.append(obj_)
            obj_.original_tagname_ = 'AggregateParameterType'


# end class ParameterTypeSetType


class ParameterRefType(GeneratedsSuper):
    """A reference to a Parameter. Uses Unix ‘like’ naming across the
    SpaceSystem Tree (e.g., SimpleSat/Bus/EPDS/BatteryOne/Voltage). To
    reference an individual member of an array use the zero based bracket
    notation commonly used in languages like C, C++, and Java."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, parameterRef=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.parameterRef = _cast(None, parameterRef)
        self.parameterRef_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterRefType.subclass:
            return ParameterRefType.subclass(*args_, **kwargs_)
        else:
            return ParameterRefType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_parameterRef(self):
        return self.parameterRef

    def set_parameterRef(self, parameterRef):
        self.parameterRef = parameterRef

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParameterRefType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterRefType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParameterRefType'):
        if self.parameterRef is not None and 'parameterRef' not in already_processed:
            already_processed.add('parameterRef')
            outfile.write(' parameterRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.parameterRef), input_name='parameterRef')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParameterRefType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('parameterRef', node)
        if value is not None and 'parameterRef' not in already_processed:
            already_processed.add('parameterRef')
            self.parameterRef = value
            self.validate_NameReferenceType(self.parameterRef)  # validate type NameReferenceType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ParameterRefType


class PhysicalAddressSetType(GeneratedsSuper):
    """One or more physical addresses may be associated with each Parameter.
    Examples of physical addresses include a location on the spacecraft or
    a location on a data collection bus."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, PhysicalAddress=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if PhysicalAddress is None:
            self.PhysicalAddress = []
        else:
            self.PhysicalAddress = PhysicalAddress
        self.PhysicalAddress_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PhysicalAddressSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PhysicalAddressSetType.subclass:
            return PhysicalAddressSetType.subclass(*args_, **kwargs_)
        else:
            return PhysicalAddressSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_PhysicalAddress(self):
        return self.PhysicalAddress

    def set_PhysicalAddress(self, PhysicalAddress):
        self.PhysicalAddress = PhysicalAddress

    def add_PhysicalAddress(self, value):
        self.PhysicalAddress.append(value)

    def insert_PhysicalAddress_at(self, index, value):
        self.PhysicalAddress.insert(index, value)

    def replace_PhysicalAddress_at(self, index, value):
        self.PhysicalAddress[index] = value

    def hasContent_(self):
        if (
                self.PhysicalAddress
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='PhysicalAddressSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PhysicalAddressSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PhysicalAddressSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PhysicalAddressSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PhysicalAddressSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PhysicalAddressSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='PhysicalAddressSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for PhysicalAddress_ in self.PhysicalAddress:
            namespaceprefix_ = self.PhysicalAddress_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.PhysicalAddress_nsprefix_) else ''
            PhysicalAddress_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PhysicalAddress',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PhysicalAddress':
            obj_ = PhysicalAddressType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PhysicalAddress.append(obj_)
            obj_.original_tagname_ = 'PhysicalAddress'


# end class PhysicalAddressSetType


class PhysicalAddressType(GeneratedsSuper):
    """Describe the physical address(s) that this parameter is collected from.
    Examples of physical addresses include a memory location on the
    spacecraft or a location on a data collection bus, with the source
    identified with a descriptive name for the region of memory, such as
    RAM, Flash, EEPROM, and other possibilities that can be adapted for
    program specific usage.A descriptive name for the location, such as a
    memory type, where this address is located.The address within the
    memory location. This specification does not specify program and
    hardware specific attributes, such as address size and address region
    starting location. These are part of the spacecraft hardware
    properties."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, sourceName=None, sourceAddress=None, SubAddress=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.sourceName = _cast(None, sourceName)
        self.sourceName_nsprefix_ = None
        self.sourceAddress = _cast(None, sourceAddress)
        self.sourceAddress_nsprefix_ = None
        self.SubAddress = SubAddress
        self.SubAddress_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PhysicalAddressType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PhysicalAddressType.subclass:
            return PhysicalAddressType.subclass(*args_, **kwargs_)
        else:
            return PhysicalAddressType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SubAddress(self):
        return self.SubAddress

    def set_SubAddress(self, SubAddress):
        self.SubAddress = SubAddress

    def get_sourceName(self):
        return self.sourceName

    def set_sourceName(self, sourceName):
        self.sourceName = sourceName

    def get_sourceAddress(self):
        return self.sourceAddress

    def set_sourceAddress(self, sourceAddress):
        self.sourceAddress = sourceAddress

    def hasContent_(self):
        if (
                self.SubAddress is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='PhysicalAddressType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PhysicalAddressType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PhysicalAddressType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PhysicalAddressType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PhysicalAddressType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PhysicalAddressType'):
        if self.sourceName is not None and 'sourceName' not in already_processed:
            already_processed.add('sourceName')
            outfile.write(' sourceName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.sourceName), input_name='sourceName')),))
        if self.sourceAddress is not None and 'sourceAddress' not in already_processed:
            already_processed.add('sourceAddress')
            outfile.write(' sourceAddress=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.sourceAddress), input_name='sourceAddress')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='PhysicalAddressType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SubAddress is not None:
            namespaceprefix_ = self.SubAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.SubAddress_nsprefix_) else ''
            self.SubAddress.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubAddress',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sourceName', node)
        if value is not None and 'sourceName' not in already_processed:
            already_processed.add('sourceName')
            self.sourceName = value
        value = find_attr_value_('sourceAddress', node)
        if value is not None and 'sourceAddress' not in already_processed:
            already_processed.add('sourceAddress')
            self.sourceAddress = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SubAddress':
            obj_ = PhysicalAddressType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubAddress = obj_
            obj_.original_tagname_ = 'SubAddress'


# end class PhysicalAddressType


class ServiceSetType(GeneratedsSuper):
    """A service is a logical grouping of container and/or messages."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Service=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Service is None:
            self.Service = []
        else:
            self.Service = Service
        self.Service_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ServiceSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceSetType.subclass:
            return ServiceSetType.subclass(*args_, **kwargs_)
        else:
            return ServiceSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Service(self):
        return self.Service

    def set_Service(self, Service):
        self.Service = Service

    def add_Service(self, value):
        self.Service.append(value)

    def insert_Service_at(self, index, value):
        self.Service.insert(index, value)

    def replace_Service_at(self, index, value):
        self.Service[index] = value

    def hasContent_(self):
        if (
                self.Service
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ServiceSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ServiceSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ServiceSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ServiceSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ServiceSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ServiceSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ServiceSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Service_ in self.Service:
            namespaceprefix_ = self.Service_nsprefix_ + ':' if (UseCapturedNS_ and self.Service_nsprefix_) else ''
            Service_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Service',
                            pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Service':
            obj_ = ServiceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Service.append(obj_)
            obj_.original_tagname_ = 'Service'


# end class ServiceSetType


class ArgumentAssignmentListType(GeneratedsSuper):
    """Argument Assignments specialize a MetaCommand or BlockMetaCommand when
    inheriting from another MetaCommand. General argument values can be
    restricted to specific values to further specialize the MetaCommand.
    Use it to ‘narrow’ a MetaCommand from its base MetaCommand by
    specifying values of arguments for example, a power command may be
    narrowed to a power on’ command by assigning the value of an argument
    to ‘on’. See ArgumentAssignmentType and MetaCommandType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ArgumentAssignment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ArgumentAssignment is None:
            self.ArgumentAssignment = []
        else:
            self.ArgumentAssignment = ArgumentAssignment
        self.ArgumentAssignment_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentAssignmentListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentAssignmentListType.subclass:
            return ArgumentAssignmentListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentAssignmentListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ArgumentAssignment(self):
        return self.ArgumentAssignment

    def set_ArgumentAssignment(self, ArgumentAssignment):
        self.ArgumentAssignment = ArgumentAssignment

    def add_ArgumentAssignment(self, value):
        self.ArgumentAssignment.append(value)

    def insert_ArgumentAssignment_at(self, index, value):
        self.ArgumentAssignment.insert(index, value)

    def replace_ArgumentAssignment_at(self, index, value):
        self.ArgumentAssignment[index] = value

    def hasContent_(self):
        if (
                self.ArgumentAssignment
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentAssignmentListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentAssignmentListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentAssignmentListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentAssignmentListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentAssignmentListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentAssignmentListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentAssignmentListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ArgumentAssignment_ in self.ArgumentAssignment:
            namespaceprefix_ = self.ArgumentAssignment_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentAssignment_nsprefix_) else ''
            ArgumentAssignment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ArgumentAssignment',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ArgumentAssignment':
            obj_ = ArgumentAssignmentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentAssignment.append(obj_)
            obj_.original_tagname_ = 'ArgumentAssignment'


# end class ArgumentAssignmentListType


class ArgumentAssignmentType(GeneratedsSuper):
    """Describe an assignment of an argument with a calibrated/engineering
    value. See ArgumentAssignmentListType.The named argument from the base
    MetaCommand to assign/restrict with a value.Specify value as a string
    compliant with the XML schema (xs) type specified for each XTCE type:
    integer=xs:integer; float=xs:double; string=xs:string;
    boolean=xs:boolean; binary=xs:hexBinary; enum=xs:string from
    EnumerationList; relative time=xs:duration; absolute time=xs:dateTime.
    Supplied value must be within the ValidRange specified for the type."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, argumentName=None, argumentValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.argumentName = _cast(None, argumentName)
        self.argumentName_nsprefix_ = None
        self.argumentValue = _cast(None, argumentValue)
        self.argumentValue_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentAssignmentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentAssignmentType.subclass:
            return ArgumentAssignmentType.subclass(*args_, **kwargs_)
        else:
            return ArgumentAssignmentType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_argumentName(self):
        return self.argumentName

    def set_argumentName(self, argumentName):
        self.argumentName = argumentName

    def get_argumentValue(self):
        return self.argumentValue

    def set_argumentValue(self, argumentValue):
        self.argumentValue = argumentValue

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentAssignmentType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentAssignmentType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentAssignmentType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentAssignmentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentAssignmentType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentAssignmentType'):
        if self.argumentName is not None and 'argumentName' not in already_processed:
            already_processed.add('argumentName')
            outfile.write(' argumentName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.argumentName), input_name='argumentName')),))
        if self.argumentValue is not None and 'argumentValue' not in already_processed:
            already_processed.add('argumentValue')
            outfile.write(' argumentValue=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.argumentValue), input_name='argumentValue')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentAssignmentType', fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('argumentName', node)
        if value is not None and 'argumentName' not in already_processed:
            already_processed.add('argumentName')
            self.argumentName = value
            self.validate_NameReferenceType(self.argumentName)  # validate type NameReferenceType
        value = find_attr_value_('argumentValue', node)
        if value is not None and 'argumentValue' not in already_processed:
            already_processed.add('argumentValue')
            self.argumentValue = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ArgumentAssignmentType


class ArgumentComparisonType(GeneratedsSuper):
    """Identical to ComparisonType but supports argument instance
    references.Comparison operator to use with equality being the common
    default.Specify as: integer data type using xs:integer, float data type
    using xs:double, string data type using xs:string, boolean data type
    using xs:boolean, binary data type using xs:hexBinary, enum data type
    using label name, relative time data type using xs:duration, absolute
    time data type using xs:dateTime. Values must not exceed the
    characteristics for the data type or this is a validation error. Takes
    precedence over an initial value given in the data type. Values are
    calibrated unless there is an option to override it."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, comparisonOperator='==', value=None, ParameterInstanceRef=None, ArgumentInstanceRef=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.comparisonOperator = _cast(None, comparisonOperator)
        self.comparisonOperator_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.ParameterInstanceRef = ParameterInstanceRef
        self.ParameterInstanceRef_nsprefix_ = None
        self.ArgumentInstanceRef = ArgumentInstanceRef
        self.ArgumentInstanceRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentComparisonType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentComparisonType.subclass:
            return ArgumentComparisonType.subclass(*args_, **kwargs_)
        else:
            return ArgumentComparisonType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterInstanceRef(self):
        return self.ParameterInstanceRef

    def set_ParameterInstanceRef(self, ParameterInstanceRef):
        self.ParameterInstanceRef = ParameterInstanceRef

    def get_ArgumentInstanceRef(self):
        return self.ArgumentInstanceRef

    def set_ArgumentInstanceRef(self, ArgumentInstanceRef):
        self.ArgumentInstanceRef = ArgumentInstanceRef

    def get_comparisonOperator(self):
        return self.comparisonOperator

    def set_comparisonOperator(self, comparisonOperator):
        self.comparisonOperator = comparisonOperator

    def get_value(self):
        return self.value

    def set_value(self, value):
        self.value = value

    def validate_ComparisonOperatorsType(self, value):
        # Validate type xtce:ComparisonOperatorsType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['==', '!=', '<', '<=', '>', '>=']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ComparisonOperatorsType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.ParameterInstanceRef is not None or
                self.ArgumentInstanceRef is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentComparisonType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentComparisonType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentComparisonType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentComparisonType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentComparisonType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentComparisonType'):
        if self.comparisonOperator != "==" and 'comparisonOperator' not in already_processed:
            already_processed.add('comparisonOperator')
            outfile.write(' comparisonOperator=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.comparisonOperator), input_name='comparisonOperator')),))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(
                ' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentComparisonType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ParameterInstanceRef is not None:
            namespaceprefix_ = self.ParameterInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterInstanceRef_nsprefix_) else ''
            self.ParameterInstanceRef.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ParameterInstanceRef', pretty_print=pretty_print)
        if self.ArgumentInstanceRef is not None:
            namespaceprefix_ = self.ArgumentInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentInstanceRef_nsprefix_) else ''
            self.ArgumentInstanceRef.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='ArgumentInstanceRef', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('comparisonOperator', node)
        if value is not None and 'comparisonOperator' not in already_processed:
            already_processed.add('comparisonOperator')
            self.comparisonOperator = value
            self.validate_ComparisonOperatorsType(self.comparisonOperator)  # validate type ComparisonOperatorsType
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterInstanceRef':
            class_obj_ = self.get_class_obj_(child_, ParameterInstanceRefType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterInstanceRef = obj_
            obj_.original_tagname_ = 'ParameterInstanceRef'
        elif nodeName_ == 'ArgumentInstanceRef':
            obj_ = ArgumentInstanceRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentInstanceRef = obj_
            obj_.original_tagname_ = 'ArgumentInstanceRef'


# end class ArgumentComparisonType


class ArgumentComparisonListType(GeneratedsSuper):
    """Identical to ComparisonListType but supports argument instance
    references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Comparison=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Comparison is None:
            self.Comparison = []
        else:
            self.Comparison = Comparison
        self.Comparison_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentComparisonListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentComparisonListType.subclass:
            return ArgumentComparisonListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentComparisonListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Comparison(self):
        return self.Comparison

    def set_Comparison(self, Comparison):
        self.Comparison = Comparison

    def add_Comparison(self, value):
        self.Comparison.append(value)

    def insert_Comparison_at(self, index, value):
        self.Comparison.insert(index, value)

    def replace_Comparison_at(self, index, value):
        self.Comparison[index] = value

    def hasContent_(self):
        if (
                self.Comparison
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentComparisonListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentComparisonListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentComparisonListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentComparisonListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentComparisonListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentComparisonListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentComparisonListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Comparison_ in self.Comparison:
            namespaceprefix_ = self.Comparison_nsprefix_ + ':' if (UseCapturedNS_ and self.Comparison_nsprefix_) else ''
            Comparison_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Comparison',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Comparison':
            obj_ = ArgumentComparisonType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Comparison.append(obj_)
            obj_.original_tagname_ = 'Comparison'


# end class ArgumentComparisonListType


class ArgumentDiscreteLookupListType(GeneratedsSuper):
    """Identical to DiscreteLookupListType but supports argument instance
    references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, DiscreteLookup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DiscreteLookup is None:
            self.DiscreteLookup = []
        else:
            self.DiscreteLookup = DiscreteLookup
        self.DiscreteLookup_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentDiscreteLookupListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentDiscreteLookupListType.subclass:
            return ArgumentDiscreteLookupListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentDiscreteLookupListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_DiscreteLookup(self):
        return self.DiscreteLookup

    def set_DiscreteLookup(self, DiscreteLookup):
        self.DiscreteLookup = DiscreteLookup

    def add_DiscreteLookup(self, value):
        self.DiscreteLookup.append(value)

    def insert_DiscreteLookup_at(self, index, value):
        self.DiscreteLookup.insert(index, value)

    def replace_DiscreteLookup_at(self, index, value):
        self.DiscreteLookup[index] = value

    def hasContent_(self):
        if (
                self.DiscreteLookup
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='ArgumentDiscreteLookupListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentDiscreteLookupListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentDiscreteLookupListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='ArgumentDiscreteLookupListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='ArgumentDiscreteLookupListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentDiscreteLookupListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentDiscreteLookupListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DiscreteLookup_ in self.DiscreteLookup:
            namespaceprefix_ = self.DiscreteLookup_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DiscreteLookup_nsprefix_) else ''
            DiscreteLookup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DiscreteLookup',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DiscreteLookup':
            obj_ = ArgumentDiscreteLookupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DiscreteLookup.append(obj_)
            obj_.original_tagname_ = 'DiscreteLookup'


# end class ArgumentDiscreteLookupListType


class ArgumentDynamicValueType(GeneratedsSuper):
    """Identical to DynamicValueType but supports argument instance
    references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ArgumentInstanceRef=None, ParameterInstanceRef=None, LinearAdjustment=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ArgumentInstanceRef = ArgumentInstanceRef
        self.ArgumentInstanceRef_nsprefix_ = None
        self.ParameterInstanceRef = ParameterInstanceRef
        self.ParameterInstanceRef_nsprefix_ = None
        self.LinearAdjustment = LinearAdjustment
        self.LinearAdjustment_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentDynamicValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentDynamicValueType.subclass:
            return ArgumentDynamicValueType.subclass(*args_, **kwargs_)
        else:
            return ArgumentDynamicValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ArgumentInstanceRef(self):
        return self.ArgumentInstanceRef

    def set_ArgumentInstanceRef(self, ArgumentInstanceRef):
        self.ArgumentInstanceRef = ArgumentInstanceRef

    def get_ParameterInstanceRef(self):
        return self.ParameterInstanceRef

    def set_ParameterInstanceRef(self, ParameterInstanceRef):
        self.ParameterInstanceRef = ParameterInstanceRef

    def get_LinearAdjustment(self):
        return self.LinearAdjustment

    def set_LinearAdjustment(self, LinearAdjustment):
        self.LinearAdjustment = LinearAdjustment

    def hasContent_(self):
        if (
                self.ArgumentInstanceRef is not None or
                self.ParameterInstanceRef is not None or
                self.LinearAdjustment is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentDynamicValueType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentDynamicValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentDynamicValueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentDynamicValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentDynamicValueType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentDynamicValueType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentDynamicValueType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ArgumentInstanceRef is not None:
            namespaceprefix_ = self.ArgumentInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentInstanceRef_nsprefix_) else ''
            self.ArgumentInstanceRef.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='ArgumentInstanceRef', pretty_print=pretty_print)
        if self.ParameterInstanceRef is not None:
            namespaceprefix_ = self.ParameterInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterInstanceRef_nsprefix_) else ''
            self.ParameterInstanceRef.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ParameterInstanceRef', pretty_print=pretty_print)
        if self.LinearAdjustment is not None:
            namespaceprefix_ = self.LinearAdjustment_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LinearAdjustment_nsprefix_) else ''
            self.LinearAdjustment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LinearAdjustment',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ArgumentInstanceRef':
            obj_ = ArgumentInstanceRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentInstanceRef = obj_
            obj_.original_tagname_ = 'ArgumentInstanceRef'
        elif nodeName_ == 'ParameterInstanceRef':
            class_obj_ = self.get_class_obj_(child_, ParameterInstanceRefType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterInstanceRef = obj_
            obj_.original_tagname_ = 'ParameterInstanceRef'
        elif nodeName_ == 'LinearAdjustment':
            obj_ = LinearAdjustmentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LinearAdjustment = obj_
            obj_.original_tagname_ = 'LinearAdjustment'


# end class ArgumentDynamicValueType


class ArgumentInputSetType(GeneratedsSuper):
    """Identical to InputSetType but supports argument instance references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, InputParameterInstanceRef=None, InputArgumentInstanceRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if InputParameterInstanceRef is None:
            self.InputParameterInstanceRef = []
        else:
            self.InputParameterInstanceRef = InputParameterInstanceRef
        self.InputParameterInstanceRef_nsprefix_ = None
        if InputArgumentInstanceRef is None:
            self.InputArgumentInstanceRef = []
        else:
            self.InputArgumentInstanceRef = InputArgumentInstanceRef
        self.InputArgumentInstanceRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentInputSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentInputSetType.subclass:
            return ArgumentInputSetType.subclass(*args_, **kwargs_)
        else:
            return ArgumentInputSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_InputParameterInstanceRef(self):
        return self.InputParameterInstanceRef

    def set_InputParameterInstanceRef(self, InputParameterInstanceRef):
        self.InputParameterInstanceRef = InputParameterInstanceRef

    def add_InputParameterInstanceRef(self, value):
        self.InputParameterInstanceRef.append(value)

    def insert_InputParameterInstanceRef_at(self, index, value):
        self.InputParameterInstanceRef.insert(index, value)

    def replace_InputParameterInstanceRef_at(self, index, value):
        self.InputParameterInstanceRef[index] = value

    def get_InputArgumentInstanceRef(self):
        return self.InputArgumentInstanceRef

    def set_InputArgumentInstanceRef(self, InputArgumentInstanceRef):
        self.InputArgumentInstanceRef = InputArgumentInstanceRef

    def add_InputArgumentInstanceRef(self, value):
        self.InputArgumentInstanceRef.append(value)

    def insert_InputArgumentInstanceRef_at(self, index, value):
        self.InputArgumentInstanceRef.insert(index, value)

    def replace_InputArgumentInstanceRef_at(self, index, value):
        self.InputArgumentInstanceRef[index] = value

    def hasContent_(self):
        if (
                self.InputParameterInstanceRef or
                self.InputArgumentInstanceRef
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentInputSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentInputSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentInputSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentInputSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentInputSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentInputSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentInputSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for InputParameterInstanceRef_ in self.InputParameterInstanceRef:
            namespaceprefix_ = self.InputParameterInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InputParameterInstanceRef_nsprefix_) else ''
            InputParameterInstanceRef_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='InputParameterInstanceRef', pretty_print=pretty_print)
        for InputArgumentInstanceRef_ in self.InputArgumentInstanceRef:
            namespaceprefix_ = self.InputArgumentInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InputArgumentInstanceRef_nsprefix_) else ''
            InputArgumentInstanceRef_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='InputArgumentInstanceRef', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InputParameterInstanceRef':
            obj_ = InputParameterInstanceRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InputParameterInstanceRef.append(obj_)
            obj_.original_tagname_ = 'InputParameterInstanceRef'
        elif nodeName_ == 'InputArgumentInstanceRef':
            obj_ = ArgumentInstanceRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InputArgumentInstanceRef.append(obj_)
            obj_.original_tagname_ = 'InputArgumentInstanceRef'


# end class ArgumentInputSetType


class ArgumentInstanceRefType(GeneratedsSuper):
    """An argument instance is the name of an argument as the reference is
    always resolved locally to the metacommand.Give the name of the
    argument. There is no path, this is a local reference.Typically the
    calibrated/engineering value is used and that is the default."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, argumentRef=None, useCalibratedValue=True, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.argumentRef = _cast(None, argumentRef)
        self.argumentRef_nsprefix_ = None
        self.useCalibratedValue = _cast(bool, useCalibratedValue)
        self.useCalibratedValue_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentInstanceRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentInstanceRefType.subclass:
            return ArgumentInstanceRefType.subclass(*args_, **kwargs_)
        else:
            return ArgumentInstanceRefType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_argumentRef(self):
        return self.argumentRef

    def set_argumentRef(self, argumentRef):
        self.argumentRef = argumentRef

    def get_useCalibratedValue(self):
        return self.useCalibratedValue

    def set_useCalibratedValue(self, useCalibratedValue):
        self.useCalibratedValue = useCalibratedValue

    def validate_NameType(self, value):
        # Validate type xtce:NameType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameType_patterns_,))

    validate_NameType_patterns_ = [['^([^./:\\[\\] ]+)$']]

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentInstanceRefType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentInstanceRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentInstanceRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentInstanceRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentInstanceRefType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentInstanceRefType'):
        if self.argumentRef is not None and 'argumentRef' not in already_processed:
            already_processed.add('argumentRef')
            outfile.write(' argumentRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.argumentRef), input_name='argumentRef')),))
        if not self.useCalibratedValue and 'useCalibratedValue' not in already_processed:
            already_processed.add('useCalibratedValue')
            outfile.write(' useCalibratedValue="%s"' % self.gds_format_boolean(self.useCalibratedValue,
                                                                               input_name='useCalibratedValue'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentInstanceRefType', fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('argumentRef', node)
        if value is not None and 'argumentRef' not in already_processed:
            already_processed.add('argumentRef')
            self.argumentRef = value
            self.validate_NameType(self.argumentRef)  # validate type NameType
        value = find_attr_value_('useCalibratedValue', node)
        if value is not None and 'useCalibratedValue' not in already_processed:
            already_processed.add('useCalibratedValue')
            if value in ('true', '1'):
                self.useCalibratedValue = True
            elif value in ('false', '0'):
                self.useCalibratedValue = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ArgumentInstanceRefType


class ArgumentListType(GeneratedsSuper):
    """Defines a list of Arguments for a command definition."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Argument=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Argument is None:
            self.Argument = []
        else:
            self.Argument = Argument
        self.Argument_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentListType.subclass:
            return ArgumentListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Argument(self):
        return self.Argument

    def set_Argument(self, Argument):
        self.Argument = Argument

    def add_Argument(self, value):
        self.Argument.append(value)

    def insert_Argument_at(self, index, value):
        self.Argument.insert(index, value)

    def replace_Argument_at(self, index, value):
        self.Argument[index] = value

    def hasContent_(self):
        if (
                self.Argument
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentListType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Argument_ in self.Argument:
            namespaceprefix_ = self.Argument_nsprefix_ + ':' if (UseCapturedNS_ and self.Argument_nsprefix_) else ''
            Argument_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Argument',
                             pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Argument':
            obj_ = ArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Argument.append(obj_)
            obj_.original_tagname_ = 'Argument'


# end class ArgumentListType


class ArgumentBooleanExpressionType(GeneratedsSuper):
    """Identical to BooleanExpressionType but supports argument instance
    references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Condition=None, ANDedConditions=None, ORedConditions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Condition = Condition
        self.Condition_nsprefix_ = None
        self.ANDedConditions = ANDedConditions
        self.ANDedConditions_nsprefix_ = None
        self.ORedConditions = ORedConditions
        self.ORedConditions_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentBooleanExpressionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentBooleanExpressionType.subclass:
            return ArgumentBooleanExpressionType.subclass(*args_, **kwargs_)
        else:
            return ArgumentBooleanExpressionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Condition(self):
        return self.Condition

    def set_Condition(self, Condition):
        self.Condition = Condition

    def get_ANDedConditions(self):
        return self.ANDedConditions

    def set_ANDedConditions(self, ANDedConditions):
        self.ANDedConditions = ANDedConditions

    def get_ORedConditions(self):
        return self.ORedConditions

    def set_ORedConditions(self, ORedConditions):
        self.ORedConditions = ORedConditions

    def hasContent_(self):
        if (
                self.Condition is not None or
                self.ANDedConditions is not None or
                self.ORedConditions is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='ArgumentBooleanExpressionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentBooleanExpressionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentBooleanExpressionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='ArgumentBooleanExpressionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='ArgumentBooleanExpressionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentBooleanExpressionType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentBooleanExpressionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Condition is not None:
            namespaceprefix_ = self.Condition_nsprefix_ + ':' if (UseCapturedNS_ and self.Condition_nsprefix_) else ''
            self.Condition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Condition',
                                  pretty_print=pretty_print)
        if self.ANDedConditions is not None:
            namespaceprefix_ = self.ANDedConditions_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ANDedConditions_nsprefix_) else ''
            self.ANDedConditions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ANDedConditions',
                                        pretty_print=pretty_print)
        if self.ORedConditions is not None:
            namespaceprefix_ = self.ORedConditions_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ORedConditions_nsprefix_) else ''
            self.ORedConditions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ORedConditions',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Condition':
            obj_ = ArgumentComparisonCheckType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Condition = obj_
            obj_.original_tagname_ = 'Condition'
        elif nodeName_ == 'ANDedConditions':
            obj_ = ArgumentANDedConditionsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ANDedConditions = obj_
            obj_.original_tagname_ = 'ANDedConditions'
        elif nodeName_ == 'ORedConditions':
            obj_ = ArgumentORedConditionsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ORedConditions = obj_
            obj_.original_tagname_ = 'ORedConditions'


# end class ArgumentBooleanExpressionType


class ArgumentMatchCriteriaType(GeneratedsSuper):
    """Identical to MatchCriteriaType but supports argument instance
    references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Comparison=None, ComparisonList=None, BooleanExpression=None, CustomAlgorithm=None,
                 extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Comparison = Comparison
        self.Comparison_nsprefix_ = None
        self.ComparisonList = ComparisonList
        self.ComparisonList_nsprefix_ = None
        self.BooleanExpression = BooleanExpression
        self.BooleanExpression_nsprefix_ = None
        self.CustomAlgorithm = CustomAlgorithm
        self.CustomAlgorithm_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentMatchCriteriaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentMatchCriteriaType.subclass:
            return ArgumentMatchCriteriaType.subclass(*args_, **kwargs_)
        else:
            return ArgumentMatchCriteriaType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Comparison(self):
        return self.Comparison

    def set_Comparison(self, Comparison):
        self.Comparison = Comparison

    def get_ComparisonList(self):
        return self.ComparisonList

    def set_ComparisonList(self, ComparisonList):
        self.ComparisonList = ComparisonList

    def get_BooleanExpression(self):
        return self.BooleanExpression

    def set_BooleanExpression(self, BooleanExpression):
        self.BooleanExpression = BooleanExpression

    def get_CustomAlgorithm(self):
        return self.CustomAlgorithm

    def set_CustomAlgorithm(self, CustomAlgorithm):
        self.CustomAlgorithm = CustomAlgorithm

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
                self.Comparison is not None or
                self.ComparisonList is not None or
                self.BooleanExpression is not None or
                self.CustomAlgorithm is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentMatchCriteriaType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentMatchCriteriaType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentMatchCriteriaType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentMatchCriteriaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentMatchCriteriaType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentMatchCriteriaType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentMatchCriteriaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Comparison is not None:
            namespaceprefix_ = self.Comparison_nsprefix_ + ':' if (UseCapturedNS_ and self.Comparison_nsprefix_) else ''
            self.Comparison.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Comparison',
                                   pretty_print=pretty_print)
        if self.ComparisonList is not None:
            namespaceprefix_ = self.ComparisonList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ComparisonList_nsprefix_) else ''
            self.ComparisonList.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ComparisonList',
                                       pretty_print=pretty_print)
        if self.BooleanExpression is not None:
            namespaceprefix_ = self.BooleanExpression_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BooleanExpression_nsprefix_) else ''
            self.BooleanExpression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BooleanExpression',
                                          pretty_print=pretty_print)
        if self.CustomAlgorithm is not None:
            namespaceprefix_ = self.CustomAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CustomAlgorithm_nsprefix_) else ''
            self.CustomAlgorithm.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomAlgorithm',
                                        pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Comparison':
            obj_ = ArgumentComparisonType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Comparison = obj_
            obj_.original_tagname_ = 'Comparison'
        elif nodeName_ == 'ComparisonList':
            obj_ = ArgumentComparisonListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ComparisonList = obj_
            obj_.original_tagname_ = 'ComparisonList'
        elif nodeName_ == 'BooleanExpression':
            obj_ = ArgumentBooleanExpressionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BooleanExpression = obj_
            obj_.original_tagname_ = 'BooleanExpression'
        elif nodeName_ == 'CustomAlgorithm':
            obj_ = ArgumentInputAlgorithmType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomAlgorithm = obj_
            obj_.original_tagname_ = 'CustomAlgorithm'


# end class ArgumentMatchCriteriaType


class ArgumentTypeSetType(GeneratedsSuper):
    """Describe an unordered collection of argument type definitions. These
    types named for the engineering/calibrated type of the argument. See
    BaseDataType and BaseTimeDataType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, StringArgumentType=None, EnumeratedArgumentType=None, IntegerArgumentType=None,
                 BinaryArgumentType=None, FloatArgumentType=None, BooleanArgumentType=None,
                 RelativeTimeAgumentType=None, AbsoluteTimeArgumentType=None, ArrayArgumentType=None,
                 AggregateArgumentType=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if StringArgumentType is None:
            self.StringArgumentType = []
        else:
            self.StringArgumentType = StringArgumentType
        self.StringArgumentType_nsprefix_ = None
        if EnumeratedArgumentType is None:
            self.EnumeratedArgumentType = []
        else:
            self.EnumeratedArgumentType = EnumeratedArgumentType
        self.EnumeratedArgumentType_nsprefix_ = None
        if IntegerArgumentType is None:
            self.IntegerArgumentType = []
        else:
            self.IntegerArgumentType = IntegerArgumentType
        self.IntegerArgumentType_nsprefix_ = None
        if BinaryArgumentType is None:
            self.BinaryArgumentType = []
        else:
            self.BinaryArgumentType = BinaryArgumentType
        self.BinaryArgumentType_nsprefix_ = None
        if FloatArgumentType is None:
            self.FloatArgumentType = []
        else:
            self.FloatArgumentType = FloatArgumentType
        self.FloatArgumentType_nsprefix_ = None
        if BooleanArgumentType is None:
            self.BooleanArgumentType = []
        else:
            self.BooleanArgumentType = BooleanArgumentType
        self.BooleanArgumentType_nsprefix_ = None
        if RelativeTimeAgumentType is None:
            self.RelativeTimeAgumentType = []
        else:
            self.RelativeTimeAgumentType = RelativeTimeAgumentType
        self.RelativeTimeAgumentType_nsprefix_ = None
        if AbsoluteTimeArgumentType is None:
            self.AbsoluteTimeArgumentType = []
        else:
            self.AbsoluteTimeArgumentType = AbsoluteTimeArgumentType
        self.AbsoluteTimeArgumentType_nsprefix_ = None
        if ArrayArgumentType is None:
            self.ArrayArgumentType = []
        else:
            self.ArrayArgumentType = ArrayArgumentType
        self.ArrayArgumentType_nsprefix_ = None
        if AggregateArgumentType is None:
            self.AggregateArgumentType = []
        else:
            self.AggregateArgumentType = AggregateArgumentType
        self.AggregateArgumentType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentTypeSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentTypeSetType.subclass:
            return ArgumentTypeSetType.subclass(*args_, **kwargs_)
        else:
            return ArgumentTypeSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_StringArgumentType(self):
        return self.StringArgumentType

    def set_StringArgumentType(self, StringArgumentType):
        self.StringArgumentType = StringArgumentType

    def add_StringArgumentType(self, value):
        self.StringArgumentType.append(value)

    def insert_StringArgumentType_at(self, index, value):
        self.StringArgumentType.insert(index, value)

    def replace_StringArgumentType_at(self, index, value):
        self.StringArgumentType[index] = value

    def get_EnumeratedArgumentType(self):
        return self.EnumeratedArgumentType

    def set_EnumeratedArgumentType(self, EnumeratedArgumentType):
        self.EnumeratedArgumentType = EnumeratedArgumentType

    def add_EnumeratedArgumentType(self, value):
        self.EnumeratedArgumentType.append(value)

    def insert_EnumeratedArgumentType_at(self, index, value):
        self.EnumeratedArgumentType.insert(index, value)

    def replace_EnumeratedArgumentType_at(self, index, value):
        self.EnumeratedArgumentType[index] = value

    def get_IntegerArgumentType(self):
        return self.IntegerArgumentType

    def set_IntegerArgumentType(self, IntegerArgumentType):
        self.IntegerArgumentType = IntegerArgumentType

    def add_IntegerArgumentType(self, value):
        self.IntegerArgumentType.append(value)

    def insert_IntegerArgumentType_at(self, index, value):
        self.IntegerArgumentType.insert(index, value)

    def replace_IntegerArgumentType_at(self, index, value):
        self.IntegerArgumentType[index] = value

    def get_BinaryArgumentType(self):
        return self.BinaryArgumentType

    def set_BinaryArgumentType(self, BinaryArgumentType):
        self.BinaryArgumentType = BinaryArgumentType

    def add_BinaryArgumentType(self, value):
        self.BinaryArgumentType.append(value)

    def insert_BinaryArgumentType_at(self, index, value):
        self.BinaryArgumentType.insert(index, value)

    def replace_BinaryArgumentType_at(self, index, value):
        self.BinaryArgumentType[index] = value

    def get_FloatArgumentType(self):
        return self.FloatArgumentType

    def set_FloatArgumentType(self, FloatArgumentType):
        self.FloatArgumentType = FloatArgumentType

    def add_FloatArgumentType(self, value):
        self.FloatArgumentType.append(value)

    def insert_FloatArgumentType_at(self, index, value):
        self.FloatArgumentType.insert(index, value)

    def replace_FloatArgumentType_at(self, index, value):
        self.FloatArgumentType[index] = value

    def get_BooleanArgumentType(self):
        return self.BooleanArgumentType

    def set_BooleanArgumentType(self, BooleanArgumentType):
        self.BooleanArgumentType = BooleanArgumentType

    def add_BooleanArgumentType(self, value):
        self.BooleanArgumentType.append(value)

    def insert_BooleanArgumentType_at(self, index, value):
        self.BooleanArgumentType.insert(index, value)

    def replace_BooleanArgumentType_at(self, index, value):
        self.BooleanArgumentType[index] = value

    def get_RelativeTimeAgumentType(self):
        return self.RelativeTimeAgumentType

    def set_RelativeTimeAgumentType(self, RelativeTimeAgumentType):
        self.RelativeTimeAgumentType = RelativeTimeAgumentType

    def add_RelativeTimeAgumentType(self, value):
        self.RelativeTimeAgumentType.append(value)

    def insert_RelativeTimeAgumentType_at(self, index, value):
        self.RelativeTimeAgumentType.insert(index, value)

    def replace_RelativeTimeAgumentType_at(self, index, value):
        self.RelativeTimeAgumentType[index] = value

    def get_AbsoluteTimeArgumentType(self):
        return self.AbsoluteTimeArgumentType

    def set_AbsoluteTimeArgumentType(self, AbsoluteTimeArgumentType):
        self.AbsoluteTimeArgumentType = AbsoluteTimeArgumentType

    def add_AbsoluteTimeArgumentType(self, value):
        self.AbsoluteTimeArgumentType.append(value)

    def insert_AbsoluteTimeArgumentType_at(self, index, value):
        self.AbsoluteTimeArgumentType.insert(index, value)

    def replace_AbsoluteTimeArgumentType_at(self, index, value):
        self.AbsoluteTimeArgumentType[index] = value

    def get_ArrayArgumentType(self):
        return self.ArrayArgumentType

    def set_ArrayArgumentType(self, ArrayArgumentType):
        self.ArrayArgumentType = ArrayArgumentType

    def add_ArrayArgumentType(self, value):
        self.ArrayArgumentType.append(value)

    def insert_ArrayArgumentType_at(self, index, value):
        self.ArrayArgumentType.insert(index, value)

    def replace_ArrayArgumentType_at(self, index, value):
        self.ArrayArgumentType[index] = value

    def get_AggregateArgumentType(self):
        return self.AggregateArgumentType

    def set_AggregateArgumentType(self, AggregateArgumentType):
        self.AggregateArgumentType = AggregateArgumentType

    def add_AggregateArgumentType(self, value):
        self.AggregateArgumentType.append(value)

    def insert_AggregateArgumentType_at(self, index, value):
        self.AggregateArgumentType.insert(index, value)

    def replace_AggregateArgumentType_at(self, index, value):
        self.AggregateArgumentType[index] = value

    def hasContent_(self):
        if (
                self.StringArgumentType or
                self.EnumeratedArgumentType or
                self.IntegerArgumentType or
                self.BinaryArgumentType or
                self.FloatArgumentType or
                self.BooleanArgumentType or
                self.RelativeTimeAgumentType or
                self.AbsoluteTimeArgumentType or
                self.ArrayArgumentType or
                self.AggregateArgumentType
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentTypeSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentTypeSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentTypeSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentTypeSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentTypeSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentTypeSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentTypeSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for StringArgumentType_ in self.StringArgumentType:
            namespaceprefix_ = self.StringArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StringArgumentType_nsprefix_) else ''
            StringArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StringArgumentType',
                                       pretty_print=pretty_print)
        for EnumeratedArgumentType_ in self.EnumeratedArgumentType:
            namespaceprefix_ = self.EnumeratedArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.EnumeratedArgumentType_nsprefix_) else ''
            EnumeratedArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='EnumeratedArgumentType', pretty_print=pretty_print)
        for IntegerArgumentType_ in self.IntegerArgumentType:
            namespaceprefix_ = self.IntegerArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IntegerArgumentType_nsprefix_) else ''
            IntegerArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IntegerArgumentType',
                                        pretty_print=pretty_print)
        for BinaryArgumentType_ in self.BinaryArgumentType:
            namespaceprefix_ = self.BinaryArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BinaryArgumentType_nsprefix_) else ''
            BinaryArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BinaryArgumentType',
                                       pretty_print=pretty_print)
        for FloatArgumentType_ in self.FloatArgumentType:
            namespaceprefix_ = self.FloatArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FloatArgumentType_nsprefix_) else ''
            FloatArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FloatArgumentType',
                                      pretty_print=pretty_print)
        for BooleanArgumentType_ in self.BooleanArgumentType:
            namespaceprefix_ = self.BooleanArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BooleanArgumentType_nsprefix_) else ''
            BooleanArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BooleanArgumentType',
                                        pretty_print=pretty_print)
        for RelativeTimeAgumentType_ in self.RelativeTimeAgumentType:
            namespaceprefix_ = self.RelativeTimeAgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RelativeTimeAgumentType_nsprefix_) else ''
            RelativeTimeAgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='RelativeTimeAgumentType', pretty_print=pretty_print)
        for AbsoluteTimeArgumentType_ in self.AbsoluteTimeArgumentType:
            namespaceprefix_ = self.AbsoluteTimeArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AbsoluteTimeArgumentType_nsprefix_) else ''
            AbsoluteTimeArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='AbsoluteTimeArgumentType', pretty_print=pretty_print)
        for ArrayArgumentType_ in self.ArrayArgumentType:
            namespaceprefix_ = self.ArrayArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArrayArgumentType_nsprefix_) else ''
            ArrayArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ArrayArgumentType',
                                      pretty_print=pretty_print)
        for AggregateArgumentType_ in self.AggregateArgumentType:
            namespaceprefix_ = self.AggregateArgumentType_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AggregateArgumentType_nsprefix_) else ''
            AggregateArgumentType_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                          name_='AggregateArgumentType', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'StringArgumentType':
            obj_ = StringArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StringArgumentType.append(obj_)
            obj_.original_tagname_ = 'StringArgumentType'
        elif nodeName_ == 'EnumeratedArgumentType':
            obj_ = EnumeratedArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EnumeratedArgumentType.append(obj_)
            obj_.original_tagname_ = 'EnumeratedArgumentType'
        elif nodeName_ == 'IntegerArgumentType':
            obj_ = IntegerArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IntegerArgumentType.append(obj_)
            obj_.original_tagname_ = 'IntegerArgumentType'
        elif nodeName_ == 'BinaryArgumentType':
            obj_ = BinaryArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BinaryArgumentType.append(obj_)
            obj_.original_tagname_ = 'BinaryArgumentType'
        elif nodeName_ == 'FloatArgumentType':
            obj_ = FloatArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FloatArgumentType.append(obj_)
            obj_.original_tagname_ = 'FloatArgumentType'
        elif nodeName_ == 'BooleanArgumentType':
            obj_ = BooleanArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BooleanArgumentType.append(obj_)
            obj_.original_tagname_ = 'BooleanArgumentType'
        elif nodeName_ == 'RelativeTimeAgumentType':
            obj_ = RelativeTimeArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RelativeTimeAgumentType.append(obj_)
            obj_.original_tagname_ = 'RelativeTimeAgumentType'
        elif nodeName_ == 'AbsoluteTimeArgumentType':
            obj_ = AbsoluteTimeArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AbsoluteTimeArgumentType.append(obj_)
            obj_.original_tagname_ = 'AbsoluteTimeArgumentType'
        elif nodeName_ == 'ArrayArgumentType':
            obj_ = ArrayArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArrayArgumentType.append(obj_)
            obj_.original_tagname_ = 'ArrayArgumentType'
        elif nodeName_ == 'AggregateArgumentType':
            obj_ = AggregateArgumentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AggregateArgumentType.append(obj_)
            obj_.original_tagname_ = 'AggregateArgumentType'


# end class ArgumentTypeSetType


class BaseMetaCommandType(GeneratedsSuper):
    """When specified, a BaseMetaCommand element identifies that this
    MetaCommand inherits (extends) another MetaCommand. It’s required
    ArgumentAssignmentList narrows or this command from the parent. This is
    typically used when specializing a generic MetaCommand to a specific
    MetaCommand. See MetaCommandType.Reference to the MetaCommand
    definition that this MetaCommand extends."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, metaCommandRef=None, ArgumentAssignmentList=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.metaCommandRef = _cast(None, metaCommandRef)
        self.metaCommandRef_nsprefix_ = None
        self.ArgumentAssignmentList = ArgumentAssignmentList
        self.ArgumentAssignmentList_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseMetaCommandType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseMetaCommandType.subclass:
            return BaseMetaCommandType.subclass(*args_, **kwargs_)
        else:
            return BaseMetaCommandType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ArgumentAssignmentList(self):
        return self.ArgumentAssignmentList

    def set_ArgumentAssignmentList(self, ArgumentAssignmentList):
        self.ArgumentAssignmentList = ArgumentAssignmentList

    def get_metaCommandRef(self):
        return self.metaCommandRef

    def set_metaCommandRef(self, metaCommandRef):
        self.metaCommandRef = metaCommandRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                self.ArgumentAssignmentList is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseMetaCommandType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BaseMetaCommandType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BaseMetaCommandType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BaseMetaCommandType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BaseMetaCommandType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BaseMetaCommandType'):
        if self.metaCommandRef is not None and 'metaCommandRef' not in already_processed:
            already_processed.add('metaCommandRef')
            outfile.write(' metaCommandRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.metaCommandRef), input_name='metaCommandRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseMetaCommandType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ArgumentAssignmentList is not None:
            namespaceprefix_ = self.ArgumentAssignmentList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentAssignmentList_nsprefix_) else ''
            self.ArgumentAssignmentList.export(outfile, level, namespaceprefix_, namespacedef_='',
                                               name_='ArgumentAssignmentList', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('metaCommandRef', node)
        if value is not None and 'metaCommandRef' not in already_processed:
            already_processed.add('metaCommandRef')
            self.metaCommandRef = value
            self.validate_NameReferenceType(self.metaCommandRef)  # validate type NameReferenceType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ArgumentAssignmentList':
            obj_ = ArgumentAssignmentListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentAssignmentList = obj_
            obj_.original_tagname_ = 'ArgumentAssignmentList'


# end class BaseMetaCommandType


class CommandContainerEntryListType(GeneratedsSuper):
    """Describe an entry list for a CommandContainer which is associated with a
    MetaCommand. The entry list for a MetaCommand CommandContainer element
    operates in a similar fashion as the entry list element for a
    SequenceContainer element. It adds fixed value and argument entries to
    the entry list not present in sequence containers. See MetaCommandType,
    CommandContainerType and EntryListType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterRefEntry=None, ParameterSegmentRefEntry=None, ContainerRefEntry=None,
                 ContainerSegmentRefEntry=None, StreamSegmentEntry=None, IndirectParameterRefEntry=None,
                 ArrayParameterRefEntry=None, ArgumentRefEntry=None, ArrayArgumentRefEntry=None, FixedValueEntry=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ParameterRefEntry is None:
            self.ParameterRefEntry = []
        else:
            self.ParameterRefEntry = ParameterRefEntry
        self.ParameterRefEntry_nsprefix_ = None
        if ParameterSegmentRefEntry is None:
            self.ParameterSegmentRefEntry = []
        else:
            self.ParameterSegmentRefEntry = ParameterSegmentRefEntry
        self.ParameterSegmentRefEntry_nsprefix_ = None
        if ContainerRefEntry is None:
            self.ContainerRefEntry = []
        else:
            self.ContainerRefEntry = ContainerRefEntry
        self.ContainerRefEntry_nsprefix_ = None
        if ContainerSegmentRefEntry is None:
            self.ContainerSegmentRefEntry = []
        else:
            self.ContainerSegmentRefEntry = ContainerSegmentRefEntry
        self.ContainerSegmentRefEntry_nsprefix_ = None
        if StreamSegmentEntry is None:
            self.StreamSegmentEntry = []
        else:
            self.StreamSegmentEntry = StreamSegmentEntry
        self.StreamSegmentEntry_nsprefix_ = None
        if IndirectParameterRefEntry is None:
            self.IndirectParameterRefEntry = []
        else:
            self.IndirectParameterRefEntry = IndirectParameterRefEntry
        self.IndirectParameterRefEntry_nsprefix_ = None
        if ArrayParameterRefEntry is None:
            self.ArrayParameterRefEntry = []
        else:
            self.ArrayParameterRefEntry = ArrayParameterRefEntry
        self.ArrayParameterRefEntry_nsprefix_ = None
        if ArgumentRefEntry is None:
            self.ArgumentRefEntry = []
        else:
            self.ArgumentRefEntry = ArgumentRefEntry
        self.ArgumentRefEntry_nsprefix_ = None
        if ArrayArgumentRefEntry is None:
            self.ArrayArgumentRefEntry = []
        else:
            self.ArrayArgumentRefEntry = ArrayArgumentRefEntry
        self.ArrayArgumentRefEntry_nsprefix_ = None
        if FixedValueEntry is None:
            self.FixedValueEntry = []
        else:
            self.FixedValueEntry = FixedValueEntry
        self.FixedValueEntry_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CommandContainerEntryListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CommandContainerEntryListType.subclass:
            return CommandContainerEntryListType.subclass(*args_, **kwargs_)
        else:
            return CommandContainerEntryListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterRefEntry(self):
        return self.ParameterRefEntry

    def set_ParameterRefEntry(self, ParameterRefEntry):
        self.ParameterRefEntry = ParameterRefEntry

    def add_ParameterRefEntry(self, value):
        self.ParameterRefEntry.append(value)

    def insert_ParameterRefEntry_at(self, index, value):
        self.ParameterRefEntry.insert(index, value)

    def replace_ParameterRefEntry_at(self, index, value):
        self.ParameterRefEntry[index] = value

    def get_ParameterSegmentRefEntry(self):
        return self.ParameterSegmentRefEntry

    def set_ParameterSegmentRefEntry(self, ParameterSegmentRefEntry):
        self.ParameterSegmentRefEntry = ParameterSegmentRefEntry

    def add_ParameterSegmentRefEntry(self, value):
        self.ParameterSegmentRefEntry.append(value)

    def insert_ParameterSegmentRefEntry_at(self, index, value):
        self.ParameterSegmentRefEntry.insert(index, value)

    def replace_ParameterSegmentRefEntry_at(self, index, value):
        self.ParameterSegmentRefEntry[index] = value

    def get_ContainerRefEntry(self):
        return self.ContainerRefEntry

    def set_ContainerRefEntry(self, ContainerRefEntry):
        self.ContainerRefEntry = ContainerRefEntry

    def add_ContainerRefEntry(self, value):
        self.ContainerRefEntry.append(value)

    def insert_ContainerRefEntry_at(self, index, value):
        self.ContainerRefEntry.insert(index, value)

    def replace_ContainerRefEntry_at(self, index, value):
        self.ContainerRefEntry[index] = value

    def get_ContainerSegmentRefEntry(self):
        return self.ContainerSegmentRefEntry

    def set_ContainerSegmentRefEntry(self, ContainerSegmentRefEntry):
        self.ContainerSegmentRefEntry = ContainerSegmentRefEntry

    def add_ContainerSegmentRefEntry(self, value):
        self.ContainerSegmentRefEntry.append(value)

    def insert_ContainerSegmentRefEntry_at(self, index, value):
        self.ContainerSegmentRefEntry.insert(index, value)

    def replace_ContainerSegmentRefEntry_at(self, index, value):
        self.ContainerSegmentRefEntry[index] = value

    def get_StreamSegmentEntry(self):
        return self.StreamSegmentEntry

    def set_StreamSegmentEntry(self, StreamSegmentEntry):
        self.StreamSegmentEntry = StreamSegmentEntry

    def add_StreamSegmentEntry(self, value):
        self.StreamSegmentEntry.append(value)

    def insert_StreamSegmentEntry_at(self, index, value):
        self.StreamSegmentEntry.insert(index, value)

    def replace_StreamSegmentEntry_at(self, index, value):
        self.StreamSegmentEntry[index] = value

    def get_IndirectParameterRefEntry(self):
        return self.IndirectParameterRefEntry

    def set_IndirectParameterRefEntry(self, IndirectParameterRefEntry):
        self.IndirectParameterRefEntry = IndirectParameterRefEntry

    def add_IndirectParameterRefEntry(self, value):
        self.IndirectParameterRefEntry.append(value)

    def insert_IndirectParameterRefEntry_at(self, index, value):
        self.IndirectParameterRefEntry.insert(index, value)

    def replace_IndirectParameterRefEntry_at(self, index, value):
        self.IndirectParameterRefEntry[index] = value

    def get_ArrayParameterRefEntry(self):
        return self.ArrayParameterRefEntry

    def set_ArrayParameterRefEntry(self, ArrayParameterRefEntry):
        self.ArrayParameterRefEntry = ArrayParameterRefEntry

    def add_ArrayParameterRefEntry(self, value):
        self.ArrayParameterRefEntry.append(value)

    def insert_ArrayParameterRefEntry_at(self, index, value):
        self.ArrayParameterRefEntry.insert(index, value)

    def replace_ArrayParameterRefEntry_at(self, index, value):
        self.ArrayParameterRefEntry[index] = value

    def get_ArgumentRefEntry(self) -> 'ArgumentArgumentRefEntryType':
        return self.ArgumentRefEntry

    def set_ArgumentRefEntry(self, ArgumentRefEntry):
        self.ArgumentRefEntry = ArgumentRefEntry

    def add_ArgumentRefEntry(self, value):
        self.ArgumentRefEntry.append(value)

    def insert_ArgumentRefEntry_at(self, index, value):
        self.ArgumentRefEntry.insert(index, value)

    def replace_ArgumentRefEntry_at(self, index, value):
        self.ArgumentRefEntry[index] = value

    def get_ArrayArgumentRefEntry(self):
        return self.ArrayArgumentRefEntry

    def set_ArrayArgumentRefEntry(self, ArrayArgumentRefEntry):
        self.ArrayArgumentRefEntry = ArrayArgumentRefEntry

    def add_ArrayArgumentRefEntry(self, value):
        self.ArrayArgumentRefEntry.append(value)

    def insert_ArrayArgumentRefEntry_at(self, index, value):
        self.ArrayArgumentRefEntry.insert(index, value)

    def replace_ArrayArgumentRefEntry_at(self, index, value):
        self.ArrayArgumentRefEntry[index] = value

    def get_FixedValueEntry(self):
        return self.FixedValueEntry

    def set_FixedValueEntry(self, FixedValueEntry):
        self.FixedValueEntry = FixedValueEntry

    def add_FixedValueEntry(self, value):
        self.FixedValueEntry.append(value)

    def insert_FixedValueEntry_at(self, index, value):
        self.FixedValueEntry.insert(index, value)

    def replace_FixedValueEntry_at(self, index, value):
        self.FixedValueEntry[index] = value

    def hasContent_(self):
        if (
                self.ParameterRefEntry or
                self.ParameterSegmentRefEntry or
                self.ContainerRefEntry or
                self.ContainerSegmentRefEntry or
                self.StreamSegmentEntry or
                self.IndirectParameterRefEntry or
                self.ArrayParameterRefEntry or
                self.ArgumentRefEntry or
                self.ArrayArgumentRefEntry or
                self.FixedValueEntry
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='CommandContainerEntryListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CommandContainerEntryListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CommandContainerEntryListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='CommandContainerEntryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='CommandContainerEntryListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='CommandContainerEntryListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='CommandContainerEntryListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ParameterRefEntry_ in self.ParameterRefEntry:
            namespaceprefix_ = self.ParameterRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterRefEntry_nsprefix_) else ''
            ParameterRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterRefEntry',
                                      pretty_print=pretty_print)
        for ParameterSegmentRefEntry_ in self.ParameterSegmentRefEntry:
            namespaceprefix_ = self.ParameterSegmentRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterSegmentRefEntry_nsprefix_) else ''
            ParameterSegmentRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ParameterSegmentRefEntry', pretty_print=pretty_print)
        for ContainerRefEntry_ in self.ContainerRefEntry:
            namespaceprefix_ = self.ContainerRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContainerRefEntry_nsprefix_) else ''
            ContainerRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContainerRefEntry',
                                      pretty_print=pretty_print)
        for ContainerSegmentRefEntry_ in self.ContainerSegmentRefEntry:
            namespaceprefix_ = self.ContainerSegmentRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContainerSegmentRefEntry_nsprefix_) else ''
            ContainerSegmentRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ContainerSegmentRefEntry', pretty_print=pretty_print)
        for StreamSegmentEntry_ in self.StreamSegmentEntry:
            namespaceprefix_ = self.StreamSegmentEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StreamSegmentEntry_nsprefix_) else ''
            StreamSegmentEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StreamSegmentEntry',
                                       pretty_print=pretty_print)
        for IndirectParameterRefEntry_ in self.IndirectParameterRefEntry:
            namespaceprefix_ = self.IndirectParameterRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IndirectParameterRefEntry_nsprefix_) else ''
            IndirectParameterRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='IndirectParameterRefEntry', pretty_print=pretty_print)
        for ArrayParameterRefEntry_ in self.ArrayParameterRefEntry:
            namespaceprefix_ = self.ArrayParameterRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArrayParameterRefEntry_nsprefix_) else ''
            ArrayParameterRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='ArrayParameterRefEntry', pretty_print=pretty_print)
        for ArgumentRefEntry_ in self.ArgumentRefEntry:
            namespaceprefix_ = self.ArgumentRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentRefEntry_nsprefix_) else ''
            ArgumentRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ArgumentRefEntry',
                                     pretty_print=pretty_print)
        for ArrayArgumentRefEntry_ in self.ArrayArgumentRefEntry:
            namespaceprefix_ = self.ArrayArgumentRefEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArrayArgumentRefEntry_nsprefix_) else ''
            ArrayArgumentRefEntry_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                          name_='ArrayArgumentRefEntry', pretty_print=pretty_print)
        for FixedValueEntry_ in self.FixedValueEntry:
            namespaceprefix_ = self.FixedValueEntry_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FixedValueEntry_nsprefix_) else ''
            FixedValueEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FixedValueEntry',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterRefEntry':
            obj_ = ArgumentParameterRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterRefEntry.append(obj_)
            obj_.original_tagname_ = 'ParameterRefEntry'
        elif nodeName_ == 'ParameterSegmentRefEntry':
            obj_ = ArgumentParameterSegmentRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterSegmentRefEntry.append(obj_)
            obj_.original_tagname_ = 'ParameterSegmentRefEntry'
        elif nodeName_ == 'ContainerRefEntry':
            obj_ = ArgumentContainerRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContainerRefEntry.append(obj_)
            obj_.original_tagname_ = 'ContainerRefEntry'
        elif nodeName_ == 'ContainerSegmentRefEntry':
            obj_ = ArgumentContainerSegmentRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContainerSegmentRefEntry.append(obj_)
            obj_.original_tagname_ = 'ContainerSegmentRefEntry'
        elif nodeName_ == 'StreamSegmentEntry':
            obj_ = ArgumentStreamSegmentEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StreamSegmentEntry.append(obj_)
            obj_.original_tagname_ = 'StreamSegmentEntry'
        elif nodeName_ == 'IndirectParameterRefEntry':
            obj_ = ArgumentIndirectParameterRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IndirectParameterRefEntry.append(obj_)
            obj_.original_tagname_ = 'IndirectParameterRefEntry'
        elif nodeName_ == 'ArrayParameterRefEntry':
            obj_ = ArgumentArrayParameterRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArrayParameterRefEntry.append(obj_)
            obj_.original_tagname_ = 'ArrayParameterRefEntry'
        elif nodeName_ == 'ArgumentRefEntry':
            obj_ = ArgumentArgumentRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentRefEntry.append(obj_)
            obj_.original_tagname_ = 'ArgumentRefEntry'
        elif nodeName_ == 'ArrayArgumentRefEntry':
            obj_ = ArgumentArrayArgumentRefEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArrayArgumentRefEntry.append(obj_)
            obj_.original_tagname_ = 'ArrayArgumentRefEntry'
        elif nodeName_ == 'FixedValueEntry':
            obj_ = ArgumentFixedValueEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FixedValueEntry.append(obj_)
            obj_.original_tagname_ = 'FixedValueEntry'


# end class CommandContainerEntryListType


class CommandContainerSetType(GeneratedsSuper):
    """Contains an unordered Set of Command Containers"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, CommandContainer=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CommandContainer is None:
            self.CommandContainer = []
        else:
            self.CommandContainer = CommandContainer
        self.CommandContainer_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CommandContainerSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CommandContainerSetType.subclass:
            return CommandContainerSetType.subclass(*args_, **kwargs_)
        else:
            return CommandContainerSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_CommandContainer(self):
        return self.CommandContainer

    def set_CommandContainer(self, CommandContainer):
        self.CommandContainer = CommandContainer

    def add_CommandContainer(self, value):
        self.CommandContainer.append(value)

    def insert_CommandContainer_at(self, index, value):
        self.CommandContainer.insert(index, value)

    def replace_CommandContainer_at(self, index, value):
        self.CommandContainer[index] = value

    def hasContent_(self):
        if (
                self.CommandContainer
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CommandContainerSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CommandContainerSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CommandContainerSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CommandContainerSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CommandContainerSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CommandContainerSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='CommandContainerSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CommandContainer_ in self.CommandContainer:
            namespaceprefix_ = self.CommandContainer_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CommandContainer_nsprefix_) else ''
            CommandContainer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CommandContainer',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CommandContainer':
            obj_ = SequenceContainerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CommandContainer.append(obj_)
            obj_.original_tagname_ = 'CommandContainer'


# end class CommandContainerSetType


class MetaCommandSetType(GeneratedsSuper):
    """Describes an unordered collection of command definitions. Duplicates are
    invalid based on the name attribute of MetaCommand and
    BlockMetaCommand. See MetaCommandType and BlockMetaCommandType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, MetaCommand=None, MetaCommandRef=None, BlockMetaCommand=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if MetaCommand is None:
            self.MetaCommand = []
        else:
            self.MetaCommand = MetaCommand
        self.MetaCommand_nsprefix_ = None
        if MetaCommandRef is None:
            self.MetaCommandRef = []
        else:
            self.MetaCommandRef = MetaCommandRef
        self.MetaCommandRef_nsprefix_ = None
        if BlockMetaCommand is None:
            self.BlockMetaCommand = []
        else:
            self.BlockMetaCommand = BlockMetaCommand
        self.BlockMetaCommand_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MetaCommandSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MetaCommandSetType.subclass:
            return MetaCommandSetType.subclass(*args_, **kwargs_)
        else:
            return MetaCommandSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_MetaCommand(self):
        return self.MetaCommand

    def set_MetaCommand(self, MetaCommand):
        self.MetaCommand = MetaCommand

    def add_MetaCommand(self, value):
        self.MetaCommand.append(value)

    def insert_MetaCommand_at(self, index, value):
        self.MetaCommand.insert(index, value)

    def replace_MetaCommand_at(self, index, value):
        self.MetaCommand[index] = value

    def get_MetaCommandRef(self):
        return self.MetaCommandRef

    def set_MetaCommandRef(self, MetaCommandRef):
        self.MetaCommandRef = MetaCommandRef

    def add_MetaCommandRef(self, value):
        self.MetaCommandRef.append(value)

    def insert_MetaCommandRef_at(self, index, value):
        self.MetaCommandRef.insert(index, value)

    def replace_MetaCommandRef_at(self, index, value):
        self.MetaCommandRef[index] = value

    def get_BlockMetaCommand(self):
        return self.BlockMetaCommand

    def set_BlockMetaCommand(self, BlockMetaCommand):
        self.BlockMetaCommand = BlockMetaCommand

    def add_BlockMetaCommand(self, value):
        self.BlockMetaCommand.append(value)

    def insert_BlockMetaCommand_at(self, index, value):
        self.BlockMetaCommand.insert(index, value)

    def replace_BlockMetaCommand_at(self, index, value):
        self.BlockMetaCommand[index] = value

    def validate_NameReferenceType(self, value):
        result = True
        # Validate type NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))
                result = False
        return result

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                self.MetaCommand or
                self.MetaCommandRef or
                self.BlockMetaCommand
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MetaCommandSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MetaCommandSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MetaCommandSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MetaCommandSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MetaCommandSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MetaCommandSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MetaCommandSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MetaCommand_ in self.MetaCommand:
            namespaceprefix_ = self.MetaCommand_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.MetaCommand_nsprefix_) else ''
            MetaCommand_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MetaCommand',
                                pretty_print=pretty_print)
        for MetaCommandRef_ in self.MetaCommandRef:
            namespaceprefix_ = self.MetaCommandRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.MetaCommandRef_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMetaCommandRef>%s</%sMetaCommandRef>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(MetaCommandRef_), input_name='MetaCommandRef')), namespaceprefix_,
                                                                         eol_))
        for BlockMetaCommand_ in self.BlockMetaCommand:
            namespaceprefix_ = self.BlockMetaCommand_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BlockMetaCommand_nsprefix_) else ''
            BlockMetaCommand_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BlockMetaCommand',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'MetaCommand':
            obj_ = MetaCommandType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MetaCommand.append(obj_)
            obj_.original_tagname_ = 'MetaCommand'
        elif nodeName_ == 'MetaCommandRef':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'MetaCommandRef')
            value_ = self.gds_validate_string(value_, node, 'MetaCommandRef')
            self.MetaCommandRef.append(value_)
            self.MetaCommandRef_nsprefix_ = child_.prefix
            # validate type NameReferenceType
            self.validate_NameReferenceType(self.MetaCommandRef[-1])
        elif nodeName_ == 'BlockMetaCommand':
            obj_ = BlockMetaCommandType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BlockMetaCommand.append(obj_)
            obj_.original_tagname_ = 'BlockMetaCommand'


# end class MetaCommandSetType


class MetaCommandStepListType(GeneratedsSuper):
    """Describe the list of MetaCommand definitions that form the block
    command. Contains an ordered list of MetaCommandSteps where each step
    is a MetaCommand with associated arguments, duplicates are valid. See
    BlockMetaCommandType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, MetaCommandStep=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if MetaCommandStep is None:
            self.MetaCommandStep = []
        else:
            self.MetaCommandStep = MetaCommandStep
        self.MetaCommandStep_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MetaCommandStepListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MetaCommandStepListType.subclass:
            return MetaCommandStepListType.subclass(*args_, **kwargs_)
        else:
            return MetaCommandStepListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_MetaCommandStep(self):
        return self.MetaCommandStep

    def set_MetaCommandStep(self, MetaCommandStep):
        self.MetaCommandStep = MetaCommandStep

    def add_MetaCommandStep(self, value):
        self.MetaCommandStep.append(value)

    def insert_MetaCommandStep_at(self, index, value):
        self.MetaCommandStep.insert(index, value)

    def replace_MetaCommandStep_at(self, index, value):
        self.MetaCommandStep[index] = value

    def hasContent_(self):
        if (
                self.MetaCommandStep
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MetaCommandStepListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MetaCommandStepListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MetaCommandStepListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MetaCommandStepListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MetaCommandStepListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MetaCommandStepListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='MetaCommandStepListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MetaCommandStep_ in self.MetaCommandStep:
            namespaceprefix_ = self.MetaCommandStep_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.MetaCommandStep_nsprefix_) else ''
            MetaCommandStep_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MetaCommandStep',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'MetaCommandStep':
            obj_ = MetaCommandStepType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MetaCommandStep.append(obj_)
            obj_.original_tagname_ = 'MetaCommandStep'


# end class MetaCommandStepListType


class MetaCommandStepType(GeneratedsSuper):
    """Describe a MetaCommand step, consisting MetaCommand reference and
    argument list. See MetaCommandStepListType and NameReferenceType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, metaCommandRef=None, ArgumentAssigmentList=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.metaCommandRef = _cast(None, metaCommandRef)
        self.metaCommandRef_nsprefix_ = None
        self.ArgumentAssigmentList = ArgumentAssigmentList
        self.ArgumentAssigmentList_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MetaCommandStepType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MetaCommandStepType.subclass:
            return MetaCommandStepType.subclass(*args_, **kwargs_)
        else:
            return MetaCommandStepType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ArgumentAssigmentList(self):
        return self.ArgumentAssigmentList

    def set_ArgumentAssigmentList(self, ArgumentAssigmentList):
        self.ArgumentAssigmentList = ArgumentAssigmentList

    def get_metaCommandRef(self):
        return self.metaCommandRef

    def set_metaCommandRef(self, metaCommandRef):
        self.metaCommandRef = metaCommandRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                self.ArgumentAssigmentList is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MetaCommandStepType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MetaCommandStepType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MetaCommandStepType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MetaCommandStepType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MetaCommandStepType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MetaCommandStepType'):
        if self.metaCommandRef is not None and 'metaCommandRef' not in already_processed:
            already_processed.add('metaCommandRef')
            outfile.write(' metaCommandRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.metaCommandRef), input_name='metaCommandRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MetaCommandStepType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ArgumentAssigmentList is not None:
            namespaceprefix_ = self.ArgumentAssigmentList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ArgumentAssigmentList_nsprefix_) else ''
            self.ArgumentAssigmentList.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='ArgumentAssigmentList', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('metaCommandRef', node)
        if value is not None and 'metaCommandRef' not in already_processed:
            already_processed.add('metaCommandRef')
            self.metaCommandRef = value
            self.validate_NameReferenceType(self.metaCommandRef)  # validate type NameReferenceType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ArgumentAssigmentList':
            obj_ = ArgumentAssignmentListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArgumentAssigmentList = obj_
            obj_.original_tagname_ = 'ArgumentAssigmentList'


# end class MetaCommandStepType


class SignificanceType(GeneratedsSuper):
    """Significance provides some cautionary information about the potential
    consequence of each MetaCommand.If none is supplied, then the current
    SpaceSystem is assumed to be the one at risk by the issuance of this
    command"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, spaceSystemAtRisk=None, reasonForWarning=None, consequenceLevel='normal', gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.spaceSystemAtRisk = _cast(None, spaceSystemAtRisk)
        self.spaceSystemAtRisk_nsprefix_ = None
        self.reasonForWarning = _cast(None, reasonForWarning)
        self.reasonForWarning_nsprefix_ = None
        self.consequenceLevel = _cast(None, consequenceLevel)
        self.consequenceLevel_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignificanceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignificanceType.subclass:
            return SignificanceType.subclass(*args_, **kwargs_)
        else:
            return SignificanceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_spaceSystemAtRisk(self):
        return self.spaceSystemAtRisk

    def set_spaceSystemAtRisk(self, spaceSystemAtRisk):
        self.spaceSystemAtRisk = spaceSystemAtRisk

    def get_reasonForWarning(self):
        return self.reasonForWarning

    def set_reasonForWarning(self, reasonForWarning):
        self.reasonForWarning = reasonForWarning

    def get_consequenceLevel(self):
        return self.consequenceLevel

    def set_consequenceLevel(self, consequenceLevel):
        self.consequenceLevel = consequenceLevel

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def validate_ConsequenceLevelType(self, value):
        # Validate type xtce:ConsequenceLevelType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['normal', 'vital', 'critical', 'forbidden', 'user1', 'user2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ConsequenceLevelType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SignificanceType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignificanceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignificanceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignificanceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignificanceType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SignificanceType'):
        if self.spaceSystemAtRisk is not None and 'spaceSystemAtRisk' not in already_processed:
            already_processed.add('spaceSystemAtRisk')
            outfile.write(' spaceSystemAtRisk=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.spaceSystemAtRisk), input_name='spaceSystemAtRisk')),))
        if self.reasonForWarning is not None and 'reasonForWarning' not in already_processed:
            already_processed.add('reasonForWarning')
            outfile.write(' reasonForWarning=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.reasonForWarning), input_name='reasonForWarning')),))
        if self.consequenceLevel != "normal" and 'consequenceLevel' not in already_processed:
            already_processed.add('consequenceLevel')
            outfile.write(' consequenceLevel=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.consequenceLevel), input_name='consequenceLevel')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SignificanceType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('spaceSystemAtRisk', node)
        if value is not None and 'spaceSystemAtRisk' not in already_processed:
            already_processed.add('spaceSystemAtRisk')
            self.spaceSystemAtRisk = value
            self.validate_NameReferenceType(self.spaceSystemAtRisk)  # validate type NameReferenceType
        value = find_attr_value_('reasonForWarning', node)
        if value is not None and 'reasonForWarning' not in already_processed:
            already_processed.add('reasonForWarning')
            self.reasonForWarning = value
        value = find_attr_value_('consequenceLevel', node)
        if value is not None and 'consequenceLevel' not in already_processed:
            already_processed.add('consequenceLevel')
            self.consequenceLevel = value
            self.validate_ConsequenceLevelType(self.consequenceLevel)  # validate type ConsequenceLevelType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class SignificanceType


class CheckWindowType(GeneratedsSuper):
    """Used by CommandVerifiers to limit the time allocated to check for the
    verification. See CheckWindowAlgorithmsType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, timeToStartChecking=None, timeToStopChecking=None,
                 timeWindowIsRelativeTo='timeLastVerifierPassed', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.timeToStartChecking = _cast(None, timeToStartChecking)
        self.timeToStartChecking_nsprefix_ = None
        self.timeToStopChecking = _cast(None, timeToStopChecking)
        self.timeToStopChecking_nsprefix_ = None
        self.timeWindowIsRelativeTo = _cast(None, timeWindowIsRelativeTo)
        self.timeWindowIsRelativeTo_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CheckWindowType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CheckWindowType.subclass:
            return CheckWindowType.subclass(*args_, **kwargs_)
        else:
            return CheckWindowType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_timeToStartChecking(self):
        return self.timeToStartChecking

    def set_timeToStartChecking(self, timeToStartChecking):
        self.timeToStartChecking = timeToStartChecking

    def get_timeToStopChecking(self):
        return self.timeToStopChecking

    def set_timeToStopChecking(self, timeToStopChecking):
        self.timeToStopChecking = timeToStopChecking

    def get_timeWindowIsRelativeTo(self):
        return self.timeWindowIsRelativeTo

    def set_timeWindowIsRelativeTo(self, timeWindowIsRelativeTo):
        self.timeWindowIsRelativeTo = timeWindowIsRelativeTo

    def validate_RelativeTimeType(self, value):
        # Validate type xtce:RelativeTimeType, a restriction on duration.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def validate_TimeWindowIsRelativeToType(self, value):
        # Validate type xtce:TimeWindowIsRelativeToType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['commandRelease', 'timeLastVerifierPassed']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TimeWindowIsRelativeToType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CheckWindowType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CheckWindowType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CheckWindowType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CheckWindowType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CheckWindowType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CheckWindowType'):
        if self.timeToStartChecking is not None and 'timeToStartChecking' not in already_processed:
            already_processed.add('timeToStartChecking')
            outfile.write(' timeToStartChecking=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.timeToStartChecking), input_name='timeToStartChecking')),))
        if self.timeToStopChecking is not None and 'timeToStopChecking' not in already_processed:
            already_processed.add('timeToStopChecking')
            outfile.write(' timeToStopChecking=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.timeToStopChecking), input_name='timeToStopChecking')),))
        if self.timeWindowIsRelativeTo != "timeLastVerifierPassed" and 'timeWindowIsRelativeTo' not in already_processed:
            already_processed.add('timeWindowIsRelativeTo')
            outfile.write(' timeWindowIsRelativeTo=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.timeWindowIsRelativeTo),
                                       input_name='timeWindowIsRelativeTo')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CheckWindowType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('timeToStartChecking', node)
        if value is not None and 'timeToStartChecking' not in already_processed:
            already_processed.add('timeToStartChecking')
            self.timeToStartChecking = value
            self.validate_RelativeTimeType(self.timeToStartChecking)  # validate type RelativeTimeType
        value = find_attr_value_('timeToStopChecking', node)
        if value is not None and 'timeToStopChecking' not in already_processed:
            already_processed.add('timeToStopChecking')
            self.timeToStopChecking = value
            self.validate_RelativeTimeType(self.timeToStopChecking)  # validate type RelativeTimeType
        value = find_attr_value_('timeWindowIsRelativeTo', node)
        if value is not None and 'timeWindowIsRelativeTo' not in already_processed:
            already_processed.add('timeWindowIsRelativeTo')
            self.timeWindowIsRelativeTo = value
            self.validate_TimeWindowIsRelativeToType(
                self.timeWindowIsRelativeTo)  # validate type TimeWindowIsRelativeToType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class CheckWindowType


class CheckWindowAlgorithmsType(GeneratedsSuper):
    """Used by CommandVerifiers to limit the time allocated to check for the
    verification. See CommandVerifierType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, StartCheck=None, StopTime=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.StartCheck = StartCheck
        self.StartCheck_nsprefix_ = None
        self.StopTime = StopTime
        self.StopTime_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CheckWindowAlgorithmsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CheckWindowAlgorithmsType.subclass:
            return CheckWindowAlgorithmsType.subclass(*args_, **kwargs_)
        else:
            return CheckWindowAlgorithmsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_StartCheck(self):
        return self.StartCheck

    def set_StartCheck(self, StartCheck):
        self.StartCheck = StartCheck

    def get_StopTime(self):
        return self.StopTime

    def set_StopTime(self, StopTime):
        self.StopTime = StopTime

    def hasContent_(self):
        if (
                self.StartCheck is not None or
                self.StopTime is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CheckWindowAlgorithmsType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CheckWindowAlgorithmsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CheckWindowAlgorithmsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CheckWindowAlgorithmsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CheckWindowAlgorithmsType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='CheckWindowAlgorithmsType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='CheckWindowAlgorithmsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.StartCheck is not None:
            namespaceprefix_ = self.StartCheck_nsprefix_ + ':' if (UseCapturedNS_ and self.StartCheck_nsprefix_) else ''
            self.StartCheck.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StartCheck',
                                   pretty_print=pretty_print)
        if self.StopTime is not None:
            namespaceprefix_ = self.StopTime_nsprefix_ + ':' if (UseCapturedNS_ and self.StopTime_nsprefix_) else ''
            self.StopTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StopTime',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'StartCheck':
            class_obj_ = self.get_class_obj_(child_, InputAlgorithmType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StartCheck = obj_
            obj_.original_tagname_ = 'StartCheck'
        elif nodeName_ == 'StopTime':
            class_obj_ = self.get_class_obj_(child_, InputAlgorithmType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StopTime = obj_
            obj_.original_tagname_ = 'StopTime'


# end class CheckWindowAlgorithmsType


class ContextSignificanceType(GeneratedsSuper):
    """Describe a significance level for a MetaCommand definition where the
    significance level depends on matching a context value. See
    ContextMatchType and SignificanceType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContextMatch=None, Significance=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ContextMatch = ContextMatch
        self.ContextMatch_nsprefix_ = None
        self.Significance = Significance
        self.Significance_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContextSignificanceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContextSignificanceType.subclass:
            return ContextSignificanceType.subclass(*args_, **kwargs_)
        else:
            return ContextSignificanceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContextMatch(self):
        return self.ContextMatch

    def set_ContextMatch(self, ContextMatch):
        self.ContextMatch = ContextMatch

    def get_Significance(self):
        return self.Significance

    def set_Significance(self, Significance):
        self.Significance = Significance

    def hasContent_(self):
        if (
                self.ContextMatch is not None or
                self.Significance is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContextSignificanceType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContextSignificanceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContextSignificanceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContextSignificanceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContextSignificanceType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContextSignificanceType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ContextSignificanceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ContextMatch is not None:
            namespaceprefix_ = self.ContextMatch_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextMatch_nsprefix_) else ''
            self.ContextMatch.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContextMatch',
                                     pretty_print=pretty_print)
        if self.Significance is not None:
            namespaceprefix_ = self.Significance_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.Significance_nsprefix_) else ''
            self.Significance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Significance',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContextMatch':
            obj_ = ContextMatchType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextMatch = obj_
            obj_.original_tagname_ = 'ContextMatch'
        elif nodeName_ == 'Significance':
            obj_ = SignificanceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Significance = obj_
            obj_.original_tagname_ = 'Significance'


# end class ContextSignificanceType


class ContextSignificanceListType(GeneratedsSuper):
    """Describe an ordered list of ContextSignificance elements where the
    significance on the first context match to test true is used as the
    significance of the MetaCommand. If there is a DefaultSignificance, it
    is overrideen by the matching context. See ContextSignificantType and
    MetaCommandType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContextSignificance=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ContextSignificance is None:
            self.ContextSignificance = []
        else:
            self.ContextSignificance = ContextSignificance
        self.ContextSignificance_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContextSignificanceListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContextSignificanceListType.subclass:
            return ContextSignificanceListType.subclass(*args_, **kwargs_)
        else:
            return ContextSignificanceListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContextSignificance(self):
        return self.ContextSignificance

    def set_ContextSignificance(self, ContextSignificance):
        self.ContextSignificance = ContextSignificance

    def add_ContextSignificance(self, value):
        self.ContextSignificance.append(value)

    def insert_ContextSignificance_at(self, index, value):
        self.ContextSignificance.insert(index, value)

    def replace_ContextSignificance_at(self, index, value):
        self.ContextSignificance[index] = value

    def hasContent_(self):
        if (
                self.ContextSignificance
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContextSignificanceListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContextSignificanceListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContextSignificanceListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContextSignificanceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='ContextSignificanceListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ContextSignificanceListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ContextSignificanceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ContextSignificance_ in self.ContextSignificance:
            namespaceprefix_ = self.ContextSignificance_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextSignificance_nsprefix_) else ''
            ContextSignificance_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContextSignificance',
                                        pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContextSignificance':
            obj_ = ContextSignificanceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextSignificance.append(obj_)
            obj_.original_tagname_ = 'ContextSignificance'


# end class ContextSignificanceListType


class InterlockType(GeneratedsSuper):
    """Describe a type of constraint on the next command, rather than this
    command. Interlocks apply only to the next command. An interlock will
    block successive commands until this command has reached a certain
    stage of verifier. Interlocks are scoped to a SpaceSystem basis: they
    by default apply to the SpaceSystem the MetaCommand is defined in but
    this may be overridden. See MetaCommandType and VerifierSetType.The
    name of a SpaceSystem this Interlock applies to. By default, it only
    applies to the SpaceSystem that contains this MetaCommand.The
    verification stage of the command that releases the interlock, with the
    default being complete.Only applies when the verificationToWaitFor
    attribute is 'queued' or 'executing'.A flag that indicates that under
    special circumstances, this Interlock can be suspended."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, scopeToSpaceSystem=None, verificationToWaitFor='complete', verificationProgressPercentage=None,
                 suspendable=False, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.scopeToSpaceSystem = _cast(None, scopeToSpaceSystem)
        self.scopeToSpaceSystem_nsprefix_ = None
        self.verificationToWaitFor = _cast(None, verificationToWaitFor)
        self.verificationToWaitFor_nsprefix_ = None
        self.verificationProgressPercentage = _cast(float, verificationProgressPercentage)
        self.verificationProgressPercentage_nsprefix_ = None
        self.suspendable = _cast(bool, suspendable)
        self.suspendable_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InterlockType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InterlockType.subclass:
            return InterlockType.subclass(*args_, **kwargs_)
        else:
            return InterlockType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_scopeToSpaceSystem(self):
        return self.scopeToSpaceSystem

    def set_scopeToSpaceSystem(self, scopeToSpaceSystem):
        self.scopeToSpaceSystem = scopeToSpaceSystem

    def get_verificationToWaitFor(self):
        return self.verificationToWaitFor

    def set_verificationToWaitFor(self, verificationToWaitFor):
        self.verificationToWaitFor = verificationToWaitFor

    def get_verificationProgressPercentage(self):
        return self.verificationProgressPercentage

    def set_verificationProgressPercentage(self, verificationProgressPercentage):
        self.verificationProgressPercentage = verificationProgressPercentage

    def get_suspendable(self):
        return self.suspendable

    def set_suspendable(self, suspendable):
        self.suspendable = suspendable

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def validate_VerifierEnumerationType(self, value):
        # Validate type xtce:VerifierEnumerationType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['release', 'transferredToRange', 'sentFromRange', 'received', 'accepted', 'queued',
                            'executing', 'complete', 'failed']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on VerifierEnumerationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='InterlockType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InterlockType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InterlockType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InterlockType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InterlockType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InterlockType'):
        if self.scopeToSpaceSystem is not None and 'scopeToSpaceSystem' not in already_processed:
            already_processed.add('scopeToSpaceSystem')
            outfile.write(' scopeToSpaceSystem=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.scopeToSpaceSystem), input_name='scopeToSpaceSystem')),))
        if self.verificationToWaitFor != "complete" and 'verificationToWaitFor' not in already_processed:
            already_processed.add('verificationToWaitFor')
            outfile.write(' verificationToWaitFor=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.verificationToWaitFor), input_name='verificationToWaitFor')),))
        if self.verificationProgressPercentage is not None and 'verificationProgressPercentage' not in already_processed:
            already_processed.add('verificationProgressPercentage')
            outfile.write(
                ' verificationProgressPercentage="%s"' % self.gds_format_double(self.verificationProgressPercentage,
                                                                                input_name='verificationProgressPercentage'))
        if self.suspendable and 'suspendable' not in already_processed:
            already_processed.add('suspendable')
            outfile.write(' suspendable="%s"' % self.gds_format_boolean(self.suspendable, input_name='suspendable'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='InterlockType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('scopeToSpaceSystem', node)
        if value is not None and 'scopeToSpaceSystem' not in already_processed:
            already_processed.add('scopeToSpaceSystem')
            self.scopeToSpaceSystem = value
            self.validate_NameReferenceType(self.scopeToSpaceSystem)  # validate type NameReferenceType
        value = find_attr_value_('verificationToWaitFor', node)
        if value is not None and 'verificationToWaitFor' not in already_processed:
            already_processed.add('verificationToWaitFor')
            self.verificationToWaitFor = value
            self.validate_VerifierEnumerationType(self.verificationToWaitFor)  # validate type VerifierEnumerationType
        value = find_attr_value_('verificationProgressPercentage', node)
        if value is not None and 'verificationProgressPercentage' not in already_processed:
            already_processed.add('verificationProgressPercentage')
            value = self.gds_parse_double(value, node, 'verificationProgressPercentage')
            self.verificationProgressPercentage = value
        value = find_attr_value_('suspendable', node)
        if value is not None and 'suspendable' not in already_processed:
            already_processed.add('suspendable')
            if value in ('true', '1'):
                self.suspendable = True
            elif value in ('false', '0'):
                self.suspendable = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class InterlockType


class ParameterToSetType(ParameterRefType):
    """Sets a Parameter to a new value (either from a derivation or explicitly)
    after the command has been verified (all verifications have
    passed).This attribute provides more specific control over when the
    Parameter value is set. By default, it is when the command have all
    verifications complete. See VerifierEnumerationType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = ParameterRefType

    def __init__(self, parameterRef=None, setOnVerification='complete', Derivation=None, NewValue=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(ParameterToSetType, self).__init__(parameterRef, **kwargs_)
        self.setOnVerification = _cast(None, setOnVerification)
        self.setOnVerification_nsprefix_ = None
        self.Derivation = Derivation
        self.Derivation_nsprefix_ = None
        self.NewValue = NewValue
        self.NewValue_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterToSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterToSetType.subclass:
            return ParameterToSetType.subclass(*args_, **kwargs_)
        else:
            return ParameterToSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Derivation(self):
        return self.Derivation

    def set_Derivation(self, Derivation):
        self.Derivation = Derivation

    def set_Derivation_with_type(self, value):
        self.Derivation = value
        value.original_tagname_ = 'Derivation'
        value.extensiontype_ = value.__class__.__name__

    def get_NewValue(self):
        return self.NewValue

    def set_NewValue(self, NewValue):
        self.NewValue = NewValue

    def get_setOnVerification(self):
        return self.setOnVerification

    def set_setOnVerification(self, setOnVerification):
        self.setOnVerification = setOnVerification

    def validate_VerifierEnumerationType(self, value):
        # Validate type xtce:VerifierEnumerationType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['release', 'transferredToRange', 'sentFromRange', 'received', 'accepted', 'queued',
                            'executing', 'complete', 'failed']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on VerifierEnumerationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Derivation is not None or
                self.NewValue is not None or
                super(ParameterToSetType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='ParameterToSetType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterToSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterToSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterToSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterToSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParameterToSetType'):
        super(ParameterToSetType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                         name_='ParameterToSetType')
        if self.setOnVerification != "complete" and 'setOnVerification' not in already_processed:
            already_processed.add('setOnVerification')
            outfile.write(' setOnVerification=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.setOnVerification), input_name='setOnVerification')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='ParameterToSetType', fromsubclass_=False, pretty_print=True):
        super(ParameterToSetType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                       pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Derivation is not None:
            self.Derivation.export(outfile, level, namespaceprefix_, namespacedef_='', pretty_print=pretty_print)
        if self.NewValue is not None:
            namespaceprefix_ = self.NewValue_nsprefix_ + ':' if (UseCapturedNS_ and self.NewValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNewValue>%s</%sNewValue>%s' % (
            namespaceprefix_, self.gds_encode(self.gds_format_string(quote_xml(self.NewValue), input_name='NewValue')),
            namespaceprefix_, eol_))

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('setOnVerification', node)
        if value is not None and 'setOnVerification' not in already_processed:
            already_processed.add('setOnVerification')
            self.setOnVerification = value
            self.validate_VerifierEnumerationType(self.setOnVerification)  # validate type VerifierEnumerationType
        super(ParameterToSetType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Derivation':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_, gds_collector_=gds_collector_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Derivation> element')
            self.Derivation = obj_
            obj_.original_tagname_ = 'Derivation'
        elif nodeName_ == 'NewValue':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'NewValue')
            value_ = self.gds_validate_string(value_, node, 'NewValue')
            self.NewValue = value_
            self.NewValue_nsprefix_ = child_.prefix
        super(ParameterToSetType, self).buildChildren(child_, node, nodeName_, True)


# end class ParameterToSetType


class ParameterToSetListType(GeneratedsSuper):
    """Parameters that are set with a new value after the command has been
    sent. Appended to the Base Command list"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterToSet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ParameterToSet is None:
            self.ParameterToSet = []
        else:
            self.ParameterToSet = ParameterToSet
        self.ParameterToSet_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterToSetListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterToSetListType.subclass:
            return ParameterToSetListType.subclass(*args_, **kwargs_)
        else:
            return ParameterToSetListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterToSet(self):
        return self.ParameterToSet

    def set_ParameterToSet(self, ParameterToSet):
        self.ParameterToSet = ParameterToSet

    def add_ParameterToSet(self, value):
        self.ParameterToSet.append(value)

    def insert_ParameterToSet_at(self, index, value):
        self.ParameterToSet.insert(index, value)

    def replace_ParameterToSet_at(self, index, value):
        self.ParameterToSet[index] = value

    def hasContent_(self):
        if (
                self.ParameterToSet
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParameterToSetListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterToSetListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterToSetListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterToSetListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterToSetListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParameterToSetListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ParameterToSetListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ParameterToSet_ in self.ParameterToSet:
            namespaceprefix_ = self.ParameterToSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterToSet_nsprefix_) else ''
            ParameterToSet_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterToSet',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterToSet':
            obj_ = ParameterToSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterToSet.append(obj_)
            obj_.original_tagname_ = 'ParameterToSet'


# end class ParameterToSetListType


class ParameterToSuspendAlarmsOnType(ParameterRefType):
    """Will suspend all Alarms associated with this Parameter for the given
    suspense time after the given verifier"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = ParameterRefType

    def __init__(self, parameterRef=None, suspenseTime=None, verifierToTriggerOn='release', gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(ParameterToSuspendAlarmsOnType, self).__init__(parameterRef, **kwargs_)
        self.suspenseTime = _cast(None, suspenseTime)
        self.suspenseTime_nsprefix_ = None
        self.verifierToTriggerOn = _cast(None, verifierToTriggerOn)
        self.verifierToTriggerOn_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterToSuspendAlarmsOnType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterToSuspendAlarmsOnType.subclass:
            return ParameterToSuspendAlarmsOnType.subclass(*args_, **kwargs_)
        else:
            return ParameterToSuspendAlarmsOnType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_suspenseTime(self):
        return self.suspenseTime

    def set_suspenseTime(self, suspenseTime):
        self.suspenseTime = suspenseTime

    def get_verifierToTriggerOn(self):
        return self.verifierToTriggerOn

    def set_verifierToTriggerOn(self, verifierToTriggerOn):
        self.verifierToTriggerOn = verifierToTriggerOn

    def validate_RelativeTimeType(self, value):
        # Validate type xtce:RelativeTimeType, a restriction on duration.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def validate_VerifierEnumerationType(self, value):
        # Validate type xtce:VerifierEnumerationType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['release', 'transferredToRange', 'sentFromRange', 'received', 'accepted', 'queued',
                            'executing', 'complete', 'failed']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on VerifierEnumerationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                super(ParameterToSuspendAlarmsOnType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='ParameterToSuspendAlarmsOnType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterToSuspendAlarmsOnType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterToSuspendAlarmsOnType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='ParameterToSuspendAlarmsOnType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='ParameterToSuspendAlarmsOnType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ParameterToSuspendAlarmsOnType'):
        super(ParameterToSuspendAlarmsOnType, self).exportAttributes(outfile, level, already_processed,
                                                                     namespaceprefix_,
                                                                     name_='ParameterToSuspendAlarmsOnType')
        if self.suspenseTime is not None and 'suspenseTime' not in already_processed:
            already_processed.add('suspenseTime')
            outfile.write(' suspenseTime=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.suspenseTime), input_name='suspenseTime')),))
        if self.verifierToTriggerOn != "release" and 'verifierToTriggerOn' not in already_processed:
            already_processed.add('verifierToTriggerOn')
            outfile.write(' verifierToTriggerOn=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.verifierToTriggerOn), input_name='verifierToTriggerOn')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ParameterToSuspendAlarmsOnType', fromsubclass_=False, pretty_print=True):
        super(ParameterToSuspendAlarmsOnType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_,
                                                                   name_, True, pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('suspenseTime', node)
        if value is not None and 'suspenseTime' not in already_processed:
            already_processed.add('suspenseTime')
            self.suspenseTime = value
            self.validate_RelativeTimeType(self.suspenseTime)  # validate type RelativeTimeType
        value = find_attr_value_('verifierToTriggerOn', node)
        if value is not None and 'verifierToTriggerOn' not in already_processed:
            already_processed.add('verifierToTriggerOn')
            self.verifierToTriggerOn = value
            self.validate_VerifierEnumerationType(self.verifierToTriggerOn)  # validate type VerifierEnumerationType
        super(ParameterToSuspendAlarmsOnType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ParameterToSuspendAlarmsOnType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class ParameterToSuspendAlarmsOnType


class ParametersToSuspendAlarmsOnSetType(GeneratedsSuper):
    """Sometimes it is necessary to suspend alarms - particularly 'change'
    alarms for commands that will change the value of a Parameter"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterToSuspendAlarmsOn=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ParameterToSuspendAlarmsOn is None:
            self.ParameterToSuspendAlarmsOn = []
        else:
            self.ParameterToSuspendAlarmsOn = ParameterToSuspendAlarmsOn
        self.ParameterToSuspendAlarmsOn_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParametersToSuspendAlarmsOnSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParametersToSuspendAlarmsOnSetType.subclass:
            return ParametersToSuspendAlarmsOnSetType.subclass(*args_, **kwargs_)
        else:
            return ParametersToSuspendAlarmsOnSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterToSuspendAlarmsOn(self):
        return self.ParameterToSuspendAlarmsOn

    def set_ParameterToSuspendAlarmsOn(self, ParameterToSuspendAlarmsOn):
        self.ParameterToSuspendAlarmsOn = ParameterToSuspendAlarmsOn

    def add_ParameterToSuspendAlarmsOn(self, value):
        self.ParameterToSuspendAlarmsOn.append(value)

    def insert_ParameterToSuspendAlarmsOn_at(self, index, value):
        self.ParameterToSuspendAlarmsOn.insert(index, value)

    def replace_ParameterToSuspendAlarmsOn_at(self, index, value):
        self.ParameterToSuspendAlarmsOn[index] = value

    def hasContent_(self):
        if (
                self.ParameterToSuspendAlarmsOn
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='ParametersToSuspendAlarmsOnSetType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParametersToSuspendAlarmsOnSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParametersToSuspendAlarmsOnSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='ParametersToSuspendAlarmsOnSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='ParametersToSuspendAlarmsOnSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ParametersToSuspendAlarmsOnSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ParametersToSuspendAlarmsOnSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ParameterToSuspendAlarmsOn_ in self.ParameterToSuspendAlarmsOn:
            namespaceprefix_ = self.ParameterToSuspendAlarmsOn_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterToSuspendAlarmsOn_nsprefix_) else ''
            ParameterToSuspendAlarmsOn_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                               name_='ParameterToSuspendAlarmsOn', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterToSuspendAlarmsOn':
            obj_ = ParameterToSuspendAlarmsOnType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterToSuspendAlarmsOn.append(obj_)
            obj_.original_tagname_ = 'ParameterToSuspendAlarmsOn'


# end class ParametersToSuspendAlarmsOnSetType


class ParameterValueChangeType(GeneratedsSuper):
    """A parameter change in value or specified delta change in value."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterRef=None, Change=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ParameterRef = ParameterRef
        self.ParameterRef_nsprefix_ = None
        self.Change = Change
        self.Change_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterValueChangeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterValueChangeType.subclass:
            return ParameterValueChangeType.subclass(*args_, **kwargs_)
        else:
            return ParameterValueChangeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterRef(self):
        return self.ParameterRef

    def set_ParameterRef(self, ParameterRef):
        self.ParameterRef = ParameterRef

    def get_Change(self):
        return self.Change

    def set_Change(self, Change):
        self.Change = Change

    def hasContent_(self):
        if (
                self.ParameterRef is not None or
                self.Change is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParameterValueChangeType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterValueChangeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterValueChangeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterValueChangeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterValueChangeType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ParameterValueChangeType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ParameterValueChangeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ParameterRef is not None:
            namespaceprefix_ = self.ParameterRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterRef_nsprefix_) else ''
            self.ParameterRef.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ParameterRef',
                                     pretty_print=pretty_print)
        if self.Change is not None:
            namespaceprefix_ = self.Change_nsprefix_ + ':' if (UseCapturedNS_ and self.Change_nsprefix_) else ''
            self.Change.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Change',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterRef':
            class_obj_ = self.get_class_obj_(child_, ParameterRefType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterRef = obj_
            obj_.original_tagname_ = 'ParameterRef'
        elif nodeName_ == 'Change':
            obj_ = ChangeValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Change = obj_
            obj_.original_tagname_ = 'Change'


# end class ParameterValueChangeType


class TransmissionConstraintListType(GeneratedsSuper):
    """Appended to the TramsmissionConstraint List of the base command.
    Constraints are checked in order."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, TransmissionConstraint=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if TransmissionConstraint is None:
            self.TransmissionConstraint = []
        else:
            self.TransmissionConstraint = TransmissionConstraint
        self.TransmissionConstraint_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransmissionConstraintListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransmissionConstraintListType.subclass:
            return TransmissionConstraintListType.subclass(*args_, **kwargs_)
        else:
            return TransmissionConstraintListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_TransmissionConstraint(self):
        return self.TransmissionConstraint

    def set_TransmissionConstraint(self, TransmissionConstraint):
        self.TransmissionConstraint = TransmissionConstraint

    def add_TransmissionConstraint(self, value):
        self.TransmissionConstraint.append(value)

    def insert_TransmissionConstraint_at(self, index, value):
        self.TransmissionConstraint.insert(index, value)

    def replace_TransmissionConstraint_at(self, index, value):
        self.TransmissionConstraint[index] = value

    def hasContent_(self):
        if (
                self.TransmissionConstraint
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='TransmissionConstraintListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TransmissionConstraintListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TransmissionConstraintListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='TransmissionConstraintListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='TransmissionConstraintListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='TransmissionConstraintListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='TransmissionConstraintListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for TransmissionConstraint_ in self.TransmissionConstraint:
            namespaceprefix_ = self.TransmissionConstraint_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TransmissionConstraint_nsprefix_) else ''
            TransmissionConstraint_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='TransmissionConstraint', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TransmissionConstraint':
            obj_ = TransmissionConstraintType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TransmissionConstraint.append(obj_)
            obj_.original_tagname_ = 'TransmissionConstraint'


# end class TransmissionConstraintListType


class VerifierSetType(GeneratedsSuper):
    """Describe a collection of unordered verifiers. A command verifier is a
    conditional check on the telemetry from a SpaceSystem that that
    provides positive indication on the processing state of a command.
    There are eight different verifiers each associated with difference
    states in command processing: TransferredToRange, TransferredFromRange,
    Received, Accepted, Queued, Execution, Complete, and Failed. There may
    be multiple ‘complete’ and 'execution' verifiers. If the MetaCommand is
    part of an inheritance relation (BaseMetaCommand), the 'complete' and
    'execution' verifier sets are appended to any defined in the parent
    MetaCommand. All others will override a verifier defined in a
    BaseMetaCommand. Duplicate verifiers in the list of CompleteVerifiers
    and ExecutionVerifiers before and after appending to the verifiers in
    BaseMetaCommand should be avoided. See MetaCommandType and
    BaseMetaCommandType for additional information."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, TransferredToRangeVerifier=None, SentFromRangeVerifier=None, ReceivedVerifier=None,
                 AcceptedVerifier=None, QueuedVerifier=None, ExecutionVerifier=None, CompleteVerifier=None,
                 FailedVerifier=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TransferredToRangeVerifier = TransferredToRangeVerifier
        self.TransferredToRangeVerifier_nsprefix_ = None
        self.SentFromRangeVerifier = SentFromRangeVerifier
        self.SentFromRangeVerifier_nsprefix_ = None
        self.ReceivedVerifier = ReceivedVerifier
        self.ReceivedVerifier_nsprefix_ = None
        self.AcceptedVerifier = AcceptedVerifier
        self.AcceptedVerifier_nsprefix_ = None
        self.QueuedVerifier = QueuedVerifier
        self.QueuedVerifier_nsprefix_ = None
        if ExecutionVerifier is None:
            self.ExecutionVerifier = []
        else:
            self.ExecutionVerifier = ExecutionVerifier
        self.ExecutionVerifier_nsprefix_ = None
        if CompleteVerifier is None:
            self.CompleteVerifier = []
        else:
            self.CompleteVerifier = CompleteVerifier
        self.CompleteVerifier_nsprefix_ = None
        self.FailedVerifier = FailedVerifier
        self.FailedVerifier_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VerifierSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VerifierSetType.subclass:
            return VerifierSetType.subclass(*args_, **kwargs_)
        else:
            return VerifierSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_TransferredToRangeVerifier(self):
        return self.TransferredToRangeVerifier

    def set_TransferredToRangeVerifier(self, TransferredToRangeVerifier):
        self.TransferredToRangeVerifier = TransferredToRangeVerifier

    def get_SentFromRangeVerifier(self):
        return self.SentFromRangeVerifier

    def set_SentFromRangeVerifier(self, SentFromRangeVerifier):
        self.SentFromRangeVerifier = SentFromRangeVerifier

    def get_ReceivedVerifier(self):
        return self.ReceivedVerifier

    def set_ReceivedVerifier(self, ReceivedVerifier):
        self.ReceivedVerifier = ReceivedVerifier

    def get_AcceptedVerifier(self):
        return self.AcceptedVerifier

    def set_AcceptedVerifier(self, AcceptedVerifier):
        self.AcceptedVerifier = AcceptedVerifier

    def get_QueuedVerifier(self):
        return self.QueuedVerifier

    def set_QueuedVerifier(self, QueuedVerifier):
        self.QueuedVerifier = QueuedVerifier

    def get_ExecutionVerifier(self):
        return self.ExecutionVerifier

    def set_ExecutionVerifier(self, ExecutionVerifier):
        self.ExecutionVerifier = ExecutionVerifier

    def add_ExecutionVerifier(self, value):
        self.ExecutionVerifier.append(value)

    def insert_ExecutionVerifier_at(self, index, value):
        self.ExecutionVerifier.insert(index, value)

    def replace_ExecutionVerifier_at(self, index, value):
        self.ExecutionVerifier[index] = value

    def get_CompleteVerifier(self):
        return self.CompleteVerifier

    def set_CompleteVerifier(self, CompleteVerifier):
        self.CompleteVerifier = CompleteVerifier

    def add_CompleteVerifier(self, value):
        self.CompleteVerifier.append(value)

    def insert_CompleteVerifier_at(self, index, value):
        self.CompleteVerifier.insert(index, value)

    def replace_CompleteVerifier_at(self, index, value):
        self.CompleteVerifier[index] = value

    def get_FailedVerifier(self):
        return self.FailedVerifier

    def set_FailedVerifier(self, FailedVerifier):
        self.FailedVerifier = FailedVerifier

    def hasContent_(self):
        if (
                self.TransferredToRangeVerifier is not None or
                self.SentFromRangeVerifier is not None or
                self.ReceivedVerifier is not None or
                self.AcceptedVerifier is not None or
                self.QueuedVerifier is not None or
                self.ExecutionVerifier or
                self.CompleteVerifier or
                self.FailedVerifier is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='VerifierSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VerifierSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VerifierSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VerifierSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VerifierSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VerifierSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='VerifierSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TransferredToRangeVerifier is not None:
            namespaceprefix_ = self.TransferredToRangeVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TransferredToRangeVerifier_nsprefix_) else ''
            self.TransferredToRangeVerifier.export(outfile, level, namespaceprefix_, namespacedef_='',
                                                   name_='TransferredToRangeVerifier', pretty_print=pretty_print)
        if self.SentFromRangeVerifier is not None:
            namespaceprefix_ = self.SentFromRangeVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.SentFromRangeVerifier_nsprefix_) else ''
            self.SentFromRangeVerifier.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='SentFromRangeVerifier', pretty_print=pretty_print)
        if self.ReceivedVerifier is not None:
            namespaceprefix_ = self.ReceivedVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ReceivedVerifier_nsprefix_) else ''
            self.ReceivedVerifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ReceivedVerifier',
                                         pretty_print=pretty_print)
        if self.AcceptedVerifier is not None:
            namespaceprefix_ = self.AcceptedVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AcceptedVerifier_nsprefix_) else ''
            self.AcceptedVerifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AcceptedVerifier',
                                         pretty_print=pretty_print)
        if self.QueuedVerifier is not None:
            namespaceprefix_ = self.QueuedVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.QueuedVerifier_nsprefix_) else ''
            self.QueuedVerifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='QueuedVerifier',
                                       pretty_print=pretty_print)
        for ExecutionVerifier_ in self.ExecutionVerifier:
            namespaceprefix_ = self.ExecutionVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ExecutionVerifier_nsprefix_) else ''
            ExecutionVerifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExecutionVerifier',
                                      pretty_print=pretty_print)
        for CompleteVerifier_ in self.CompleteVerifier:
            namespaceprefix_ = self.CompleteVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CompleteVerifier_nsprefix_) else ''
            CompleteVerifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CompleteVerifier',
                                     pretty_print=pretty_print)
        if self.FailedVerifier is not None:
            namespaceprefix_ = self.FailedVerifier_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FailedVerifier_nsprefix_) else ''
            self.FailedVerifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FailedVerifier',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TransferredToRangeVerifier':
            obj_ = TransferredToRangeVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TransferredToRangeVerifier = obj_
            obj_.original_tagname_ = 'TransferredToRangeVerifier'
        elif nodeName_ == 'SentFromRangeVerifier':
            obj_ = SentFromRangeVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SentFromRangeVerifier = obj_
            obj_.original_tagname_ = 'SentFromRangeVerifier'
        elif nodeName_ == 'ReceivedVerifier':
            obj_ = ReceivedVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ReceivedVerifier = obj_
            obj_.original_tagname_ = 'ReceivedVerifier'
        elif nodeName_ == 'AcceptedVerifier':
            obj_ = AcceptedVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AcceptedVerifier = obj_
            obj_.original_tagname_ = 'AcceptedVerifier'
        elif nodeName_ == 'QueuedVerifier':
            obj_ = QueuedVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.QueuedVerifier = obj_
            obj_.original_tagname_ = 'QueuedVerifier'
        elif nodeName_ == 'ExecutionVerifier':
            obj_ = ExecutionVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExecutionVerifier.append(obj_)
            obj_.original_tagname_ = 'ExecutionVerifier'
        elif nodeName_ == 'CompleteVerifier':
            obj_ = CompleteVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CompleteVerifier.append(obj_)
            obj_.original_tagname_ = 'CompleteVerifier'
        elif nodeName_ == 'FailedVerifier':
            obj_ = FailedVerifierType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FailedVerifier = obj_
            obj_.original_tagname_ = 'FailedVerifier'


# end class VerifierSetType


class AlgorithmTextType(GeneratedsSuper):
    """This optional element may be used to enter Pseudo or actual code for the
    algorithm. The language for the algorithm is specified with the
    language attribute"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, language='pseudo', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.language = _cast(None, language)
        self.language_nsprefix_ = None
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AlgorithmTextType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AlgorithmTextType.subclass:
            return AlgorithmTextType.subclass(*args_, **kwargs_)
        else:
            return AlgorithmTextType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_language(self):
        return self.language

    def set_language(self, language):
        self.language = language

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AlgorithmTextType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AlgorithmTextType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AlgorithmTextType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AlgorithmTextType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AlgorithmTextType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AlgorithmTextType'):
        if self.language != "pseudo" and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AlgorithmTextType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class AlgorithmTextType


class BaseTriggerType(GeneratedsSuper):
    """A base type for the various triggers, purely to improve the mappings
    created by data binding compilers."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseTriggerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseTriggerType.subclass:
            return BaseTriggerType.subclass(*args_, **kwargs_)
        else:
            return BaseTriggerType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseTriggerType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BaseTriggerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BaseTriggerType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BaseTriggerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BaseTriggerType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BaseTriggerType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseTriggerType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class BaseTriggerType


class ChecksumType(GeneratedsSuper):
    """Describe checksum information.Qualified list of name checksum
    algorithms. If custom is chosen, InputAlgorithm must be set."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, bitsFromReference=None, reference='start', name=None, hashSizeInBits=None, InputAlgorithm=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.bitsFromReference = _cast(int, bitsFromReference)
        self.bitsFromReference_nsprefix_ = None
        self.reference = _cast(None, reference)
        self.reference_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.hashSizeInBits = _cast(int, hashSizeInBits)
        self.hashSizeInBits_nsprefix_ = None
        self.InputAlgorithm = InputAlgorithm
        self.InputAlgorithm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChecksumType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChecksumType.subclass:
            return ChecksumType.subclass(*args_, **kwargs_)
        else:
            return ChecksumType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_InputAlgorithm(self):
        return self.InputAlgorithm

    def set_InputAlgorithm(self, InputAlgorithm):
        self.InputAlgorithm = InputAlgorithm

    def get_bitsFromReference(self):
        return self.bitsFromReference

    def set_bitsFromReference(self, bitsFromReference):
        self.bitsFromReference = bitsFromReference

    def get_reference(self):
        return self.reference

    def set_reference(self, reference):
        self.reference = reference

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_hashSizeInBits(self):
        return self.hashSizeInBits

    def set_hashSizeInBits(self, hashSizeInBits):
        self.hashSizeInBits = hashSizeInBits

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_ReferencePointType(self, value):
        # Validate type xtce:ReferencePointType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['start', 'end']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ReferencePointType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_nameType(self, value):
        # Validate type nameType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['unix_sum', 'sum8', 'sum16', 'sum24', 'sum32', 'fletcher4', 'fletcher8', 'fletcher16',
                            'fletcher32', 'adler32', 'luhn', 'verhoeff', 'damm', 'custom']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on nameType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.InputAlgorithm is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ChecksumType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ChecksumType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ChecksumType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ChecksumType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ChecksumType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ChecksumType'):
        if self.bitsFromReference is not None and 'bitsFromReference' not in already_processed:
            already_processed.add('bitsFromReference')
            outfile.write(' bitsFromReference="%s"' % self.gds_format_integer(self.bitsFromReference,
                                                                              input_name='bitsFromReference'))
        if self.reference != "start" and 'reference' not in already_processed:
            already_processed.add('reference')
            outfile.write(' reference=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.reference), input_name='reference')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.hashSizeInBits is not None and 'hashSizeInBits' not in already_processed:
            already_processed.add('hashSizeInBits')
            outfile.write(
                ' hashSizeInBits="%s"' % self.gds_format_integer(self.hashSizeInBits, input_name='hashSizeInBits'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ChecksumType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.InputAlgorithm is not None:
            namespaceprefix_ = self.InputAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InputAlgorithm_nsprefix_) else ''
            self.InputAlgorithm.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InputAlgorithm',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('bitsFromReference', node)
        if value is not None and 'bitsFromReference' not in already_processed:
            already_processed.add('bitsFromReference')
            self.bitsFromReference = self.gds_parse_integer(value, node, 'bitsFromReference')
            self.validate_NonNegativeLongType(self.bitsFromReference)  # validate type NonNegativeLongType
        value = find_attr_value_('reference', node)
        if value is not None and 'reference' not in already_processed:
            already_processed.add('reference')
            self.reference = value
            self.validate_ReferencePointType(self.reference)  # validate type ReferencePointType
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)  # validate type nameType
        value = find_attr_value_('hashSizeInBits', node)
        if value is not None and 'hashSizeInBits' not in already_processed:
            already_processed.add('hashSizeInBits')
            self.hashSizeInBits = self.gds_parse_integer(value, node, 'hashSizeInBits')
            self.validate_PositiveLongType(self.hashSizeInBits)  # validate type PositiveLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InputAlgorithm':
            class_obj_ = self.get_class_obj_(child_, InputAlgorithmType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InputAlgorithm = obj_
            obj_.original_tagname_ = 'InputAlgorithm'


# end class ChecksumType


class ConstantType(GeneratedsSuper):
    """Names and provides a value for a constant input to the algorithm. There
    are two attributes to Constant, constantName and value. constantName is
    a variable name in the algorithm to be executed. value is the value of
    the constant to be used."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, constantName=None, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.constantName = _cast(None, constantName)
        self.constantName_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConstantType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConstantType.subclass:
            return ConstantType.subclass(*args_, **kwargs_)
        else:
            return ConstantType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_constantName(self):
        return self.constantName

    def set_constantName(self, constantName):
        self.constantName = constantName

    def get_value(self):
        return self.value

    def set_value(self, value):
        self.value = value

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ConstantType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConstantType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ConstantType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConstantType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ConstantType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ConstantType'):
        if self.constantName is not None and 'constantName' not in already_processed:
            already_processed.add('constantName')
            outfile.write(' constantName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.constantName), input_name='constantName')),))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(
                ' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ConstantType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('constantName', node)
        if value is not None and 'constantName' not in already_processed:
            already_processed.add('constantName')
            self.constantName = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ConstantType


class ContextCalibratorListType(GeneratedsSuper):
    """Describe an ordered list of calibrators with a context match. Useful
    when different calibrations must be used depending on a matching value.
    The first context that matches determines which calibrator to use. See
    IntegerDataEncodingType and FloatDataEncodingType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContextCalibrator=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ContextCalibrator is None:
            self.ContextCalibrator = []
        else:
            self.ContextCalibrator = ContextCalibrator
        self.ContextCalibrator_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContextCalibratorListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContextCalibratorListType.subclass:
            return ContextCalibratorListType.subclass(*args_, **kwargs_)
        else:
            return ContextCalibratorListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContextCalibrator(self):
        return self.ContextCalibrator

    def set_ContextCalibrator(self, ContextCalibrator):
        self.ContextCalibrator = ContextCalibrator

    def add_ContextCalibrator(self, value):
        self.ContextCalibrator.append(value)

    def insert_ContextCalibrator_at(self, index, value):
        self.ContextCalibrator.insert(index, value)

    def replace_ContextCalibrator_at(self, index, value):
        self.ContextCalibrator[index] = value

    def hasContent_(self):
        if (
                self.ContextCalibrator
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContextCalibratorListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContextCalibratorListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContextCalibratorListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContextCalibratorListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContextCalibratorListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ContextCalibratorListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ContextCalibratorListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ContextCalibrator_ in self.ContextCalibrator:
            namespaceprefix_ = self.ContextCalibrator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextCalibrator_nsprefix_) else ''
            ContextCalibrator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContextCalibrator',
                                      pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContextCalibrator':
            obj_ = ContextCalibratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextCalibrator.append(obj_)
            obj_.original_tagname_ = 'ContextCalibrator'


# end class ContextCalibratorListType


class ExternalAlgorithmType(GeneratedsSuper):
    """This is the external algorithm. Multiple entries are provided so that
    the same database may be used for multiple implementation s"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, implementationName=None, algorithmLocation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.implementationName = _cast(None, implementationName)
        self.implementationName_nsprefix_ = None
        self.algorithmLocation = _cast(None, algorithmLocation)
        self.algorithmLocation_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExternalAlgorithmType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExternalAlgorithmType.subclass:
            return ExternalAlgorithmType.subclass(*args_, **kwargs_)
        else:
            return ExternalAlgorithmType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_implementationName(self):
        return self.implementationName

    def set_implementationName(self, implementationName):
        self.implementationName = implementationName

    def get_algorithmLocation(self):
        return self.algorithmLocation

    def set_algorithmLocation(self, algorithmLocation):
        self.algorithmLocation = algorithmLocation

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ExternalAlgorithmType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExternalAlgorithmType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExternalAlgorithmType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExternalAlgorithmType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExternalAlgorithmType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ExternalAlgorithmType'):
        if self.implementationName is not None and 'implementationName' not in already_processed:
            already_processed.add('implementationName')
            outfile.write(' implementationName=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.implementationName), input_name='implementationName')),))
        if self.algorithmLocation is not None and 'algorithmLocation' not in already_processed:
            already_processed.add('algorithmLocation')
            outfile.write(' algorithmLocation=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.algorithmLocation), input_name='algorithmLocation')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ExternalAlgorithmType', fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('implementationName', node)
        if value is not None and 'implementationName' not in already_processed:
            already_processed.add('implementationName')
            self.implementationName = value
        value = find_attr_value_('algorithmLocation', node)
        if value is not None and 'algorithmLocation' not in already_processed:
            already_processed.add('algorithmLocation')
            self.algorithmLocation = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ExternalAlgorithmType


class ExternalAlgorithmSetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ExternalAlgorithm=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ExternalAlgorithm is None:
            self.ExternalAlgorithm = []
        else:
            self.ExternalAlgorithm = ExternalAlgorithm
        self.ExternalAlgorithm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExternalAlgorithmSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExternalAlgorithmSetType.subclass:
            return ExternalAlgorithmSetType.subclass(*args_, **kwargs_)
        else:
            return ExternalAlgorithmSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ExternalAlgorithm(self):
        return self.ExternalAlgorithm

    def set_ExternalAlgorithm(self, ExternalAlgorithm):
        self.ExternalAlgorithm = ExternalAlgorithm

    def add_ExternalAlgorithm(self, value):
        self.ExternalAlgorithm.append(value)

    def insert_ExternalAlgorithm_at(self, index, value):
        self.ExternalAlgorithm.insert(index, value)

    def replace_ExternalAlgorithm_at(self, index, value):
        self.ExternalAlgorithm[index] = value

    def hasContent_(self):
        if (
                self.ExternalAlgorithm
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ExternalAlgorithmSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExternalAlgorithmSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExternalAlgorithmSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExternalAlgorithmSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExternalAlgorithmSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ExternalAlgorithmSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ExternalAlgorithmSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ExternalAlgorithm_ in self.ExternalAlgorithm:
            namespaceprefix_ = self.ExternalAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ExternalAlgorithm_nsprefix_) else ''
            ExternalAlgorithm_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExternalAlgorithm',
                                      pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ExternalAlgorithm':
            obj_ = ExternalAlgorithmType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExternalAlgorithm.append(obj_)
            obj_.original_tagname_ = 'ExternalAlgorithm'


# end class ExternalAlgorithmSetType


class InputSetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, InputParameterInstanceRef=None, Constant=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if InputParameterInstanceRef is None:
            self.InputParameterInstanceRef = []
        else:
            self.InputParameterInstanceRef = InputParameterInstanceRef
        self.InputParameterInstanceRef_nsprefix_ = None
        if Constant is None:
            self.Constant = []
        else:
            self.Constant = Constant
        self.Constant_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InputSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InputSetType.subclass:
            return InputSetType.subclass(*args_, **kwargs_)
        else:
            return InputSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_InputParameterInstanceRef(self):
        return self.InputParameterInstanceRef

    def set_InputParameterInstanceRef(self, InputParameterInstanceRef):
        self.InputParameterInstanceRef = InputParameterInstanceRef

    def add_InputParameterInstanceRef(self, value):
        self.InputParameterInstanceRef.append(value)

    def insert_InputParameterInstanceRef_at(self, index, value):
        self.InputParameterInstanceRef.insert(index, value)

    def replace_InputParameterInstanceRef_at(self, index, value):
        self.InputParameterInstanceRef[index] = value

    def get_Constant(self):
        return self.Constant

    def set_Constant(self, Constant):
        self.Constant = Constant

    def add_Constant(self, value):
        self.Constant.append(value)

    def insert_Constant_at(self, index, value):
        self.Constant.insert(index, value)

    def replace_Constant_at(self, index, value):
        self.Constant[index] = value

    def hasContent_(self):
        if (
                self.InputParameterInstanceRef or
                self.Constant
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='InputSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InputSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InputSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InputSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InputSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InputSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='InputSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for InputParameterInstanceRef_ in self.InputParameterInstanceRef:
            namespaceprefix_ = self.InputParameterInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InputParameterInstanceRef_nsprefix_) else ''
            InputParameterInstanceRef_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='InputParameterInstanceRef', pretty_print=pretty_print)
        for Constant_ in self.Constant:
            namespaceprefix_ = self.Constant_nsprefix_ + ':' if (UseCapturedNS_ and self.Constant_nsprefix_) else ''
            Constant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Constant',
                             pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InputParameterInstanceRef':
            obj_ = InputParameterInstanceRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InputParameterInstanceRef.append(obj_)
            obj_.original_tagname_ = 'InputParameterInstanceRef'
        elif nodeName_ == 'Constant':
            obj_ = ConstantType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Constant.append(obj_)
            obj_.original_tagname_ = 'Constant'


# end class InputSetType


class OnContainerUpdateTriggerType(BaseTriggerType):
    """Describe a reference to container that triggers an event when the
    telemetry container referred to is updated (processed). See
    TriggerSetType.Reference to the Container whose update/receipt triggers
    this algorithm to evaluate."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseTriggerType

    def __init__(self, containerRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(OnContainerUpdateTriggerType, self).__init__(**kwargs_)
        self.containerRef = _cast(None, containerRef)
        self.containerRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnContainerUpdateTriggerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnContainerUpdateTriggerType.subclass:
            return OnContainerUpdateTriggerType.subclass(*args_, **kwargs_)
        else:
            return OnContainerUpdateTriggerType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_containerRef(self):
        return self.containerRef

    def set_containerRef(self, containerRef):
        self.containerRef = containerRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                super(OnContainerUpdateTriggerType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='OnContainerUpdateTriggerType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OnContainerUpdateTriggerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OnContainerUpdateTriggerType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OnContainerUpdateTriggerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='OnContainerUpdateTriggerType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='OnContainerUpdateTriggerType'):
        super(OnContainerUpdateTriggerType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                                   name_='OnContainerUpdateTriggerType')
        if self.containerRef is not None and 'containerRef' not in already_processed:
            already_processed.add('containerRef')
            outfile.write(' containerRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.containerRef), input_name='containerRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='OnContainerUpdateTriggerType', fromsubclass_=False, pretty_print=True):
        super(OnContainerUpdateTriggerType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_,
                                                                 True, pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('containerRef', node)
        if value is not None and 'containerRef' not in already_processed:
            already_processed.add('containerRef')
            self.containerRef = value
            self.validate_NameReferenceType(self.containerRef)  # validate type NameReferenceType
        super(OnContainerUpdateTriggerType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(OnContainerUpdateTriggerType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class OnContainerUpdateTriggerType


class OnPeriodicRateTriggerType(BaseTriggerType):
    """Describe a periodic time basis to trigger an event. See
    TriggerSetType.The periodic rate in time in which this algorithm is
    triggered to evaluate."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseTriggerType

    def __init__(self, fireRateInSeconds=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(OnPeriodicRateTriggerType, self).__init__(**kwargs_)
        self.fireRateInSeconds = _cast(float, fireRateInSeconds)
        self.fireRateInSeconds_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnPeriodicRateTriggerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnPeriodicRateTriggerType.subclass:
            return OnPeriodicRateTriggerType.subclass(*args_, **kwargs_)
        else:
            return OnPeriodicRateTriggerType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_fireRateInSeconds(self):
        return self.fireRateInSeconds

    def set_fireRateInSeconds(self, fireRateInSeconds):
        self.fireRateInSeconds = fireRateInSeconds

    def hasContent_(self):
        if (
                super(OnPeriodicRateTriggerType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='OnPeriodicRateTriggerType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OnPeriodicRateTriggerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OnPeriodicRateTriggerType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OnPeriodicRateTriggerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OnPeriodicRateTriggerType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='OnPeriodicRateTriggerType'):
        super(OnPeriodicRateTriggerType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                                name_='OnPeriodicRateTriggerType')
        if self.fireRateInSeconds is not None and 'fireRateInSeconds' not in already_processed:
            already_processed.add('fireRateInSeconds')
            outfile.write(' fireRateInSeconds="%s"' % self.gds_format_double(self.fireRateInSeconds,
                                                                             input_name='fireRateInSeconds'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='OnPeriodicRateTriggerType', fromsubclass_=False, pretty_print=True):
        super(OnPeriodicRateTriggerType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_,
                                                              True, pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fireRateInSeconds', node)
        if value is not None and 'fireRateInSeconds' not in already_processed:
            already_processed.add('fireRateInSeconds')
            value = self.gds_parse_double(value, node, 'fireRateInSeconds')
            self.fireRateInSeconds = value
        super(OnPeriodicRateTriggerType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(OnPeriodicRateTriggerType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class OnPeriodicRateTriggerType


class OnParameterUpdateTriggerType(BaseTriggerType):
    """Describe a reference to parameter that triggers an event when the
    telemetry parameter referred to is updated (processed) with a new
    value. See TriggerSetType.Reference to the Parameter whose update
    triggers this algorithm to evaluate."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseTriggerType

    def __init__(self, parameterRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(OnParameterUpdateTriggerType, self).__init__(**kwargs_)
        self.parameterRef = _cast(None, parameterRef)
        self.parameterRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnParameterUpdateTriggerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnParameterUpdateTriggerType.subclass:
            return OnParameterUpdateTriggerType.subclass(*args_, **kwargs_)
        else:
            return OnParameterUpdateTriggerType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_parameterRef(self):
        return self.parameterRef

    def set_parameterRef(self, parameterRef):
        self.parameterRef = parameterRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (
                super(OnParameterUpdateTriggerType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='OnParameterUpdateTriggerType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OnParameterUpdateTriggerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OnParameterUpdateTriggerType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OnParameterUpdateTriggerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='OnParameterUpdateTriggerType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='OnParameterUpdateTriggerType'):
        super(OnParameterUpdateTriggerType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                                   name_='OnParameterUpdateTriggerType')
        if self.parameterRef is not None and 'parameterRef' not in already_processed:
            already_processed.add('parameterRef')
            outfile.write(' parameterRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.parameterRef), input_name='parameterRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='OnParameterUpdateTriggerType', fromsubclass_=False, pretty_print=True):
        super(OnParameterUpdateTriggerType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_,
                                                                 True, pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('parameterRef', node)
        if value is not None and 'parameterRef' not in already_processed:
            already_processed.add('parameterRef')
            self.parameterRef = value
            self.validate_NameReferenceType(self.parameterRef)  # validate type NameReferenceType
        super(OnParameterUpdateTriggerType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(OnParameterUpdateTriggerType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class OnParameterUpdateTriggerType


class OutputParameterRefType(ParameterRefType):
    """Names an output parameter to the algorithm. There are two attributes to
    OutputParm, outputName and parameterName. parameterName is a parameter
    reference name for a parameter that will be updated by this algorithm.
    outputName is an optional "friendly" name for the output parameter."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = ParameterRefType

    def __init__(self, parameterRef=None, outputName=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(OutputParameterRefType, self).__init__(parameterRef, **kwargs_)
        self.outputName = _cast(None, outputName)
        self.outputName_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OutputParameterRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OutputParameterRefType.subclass:
            return OutputParameterRefType.subclass(*args_, **kwargs_)
        else:
            return OutputParameterRefType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_outputName(self):
        return self.outputName

    def set_outputName(self, outputName):
        self.outputName = outputName

    def hasContent_(self):
        if (
                super(OutputParameterRefType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='OutputParameterRefType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OutputParameterRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OutputParameterRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OutputParameterRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OutputParameterRefType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OutputParameterRefType'):
        super(OutputParameterRefType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                             name_='OutputParameterRefType')
        if self.outputName is not None and 'outputName' not in already_processed:
            already_processed.add('outputName')
            outfile.write(' outputName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.outputName), input_name='outputName')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='OutputParameterRefType', fromsubclass_=False, pretty_print=True):
        super(OutputParameterRefType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                           pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('outputName', node)
        if value is not None and 'outputName' not in already_processed:
            already_processed.add('outputName')
            self.outputName = value
        super(OutputParameterRefType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(OutputParameterRefType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class OutputParameterRefType


class OutputSetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, OutputParameterRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if OutputParameterRef is None:
            self.OutputParameterRef = []
        else:
            self.OutputParameterRef = OutputParameterRef
        self.OutputParameterRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OutputSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OutputSetType.subclass:
            return OutputSetType.subclass(*args_, **kwargs_)
        else:
            return OutputSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_OutputParameterRef(self):
        return self.OutputParameterRef

    def set_OutputParameterRef(self, OutputParameterRef):
        self.OutputParameterRef = OutputParameterRef

    def add_OutputParameterRef(self, value):
        self.OutputParameterRef.append(value)

    def insert_OutputParameterRef_at(self, index, value):
        self.OutputParameterRef.insert(index, value)

    def replace_OutputParameterRef_at(self, index, value):
        self.OutputParameterRef[index] = value

    def hasContent_(self):
        if (
                self.OutputParameterRef
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='OutputSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OutputSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OutputSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OutputSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OutputSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OutputSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='OutputSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for OutputParameterRef_ in self.OutputParameterRef:
            namespaceprefix_ = self.OutputParameterRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.OutputParameterRef_nsprefix_) else ''
            OutputParameterRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OutputParameterRef',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OutputParameterRef':
            obj_ = OutputParameterRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OutputParameterRef.append(obj_)
            obj_.original_tagname_ = 'OutputParameterRef'


# end class OutputSetType


class TriggerSetType(GeneratedsSuper):
    """A trigger is used to initiate the processing of some algorithm. A
    trigger may be based on an update of a Parameter, receipt of a
    Container, or on a time basis. Triggers may also have a maximum rate
    that limits how often the trigger can be invoked.Triggers may
    optionally be named.This attribute is a maximum rate that constrains
    how quickly this trigger may evaluate the algorithm to avoid flooding
    the implementation. The default is once per second. Setting to 0
    results in no maximum."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, triggerRate='1', OnParameterUpdateTrigger=None, OnContainerUpdateTrigger=None,
                 OnPeriodicRateTrigger=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.triggerRate = _cast(int, triggerRate)
        self.triggerRate_nsprefix_ = None
        if OnParameterUpdateTrigger is None:
            self.OnParameterUpdateTrigger = []
        else:
            self.OnParameterUpdateTrigger = OnParameterUpdateTrigger
        self.OnParameterUpdateTrigger_nsprefix_ = None
        if OnContainerUpdateTrigger is None:
            self.OnContainerUpdateTrigger = []
        else:
            self.OnContainerUpdateTrigger = OnContainerUpdateTrigger
        self.OnContainerUpdateTrigger_nsprefix_ = None
        if OnPeriodicRateTrigger is None:
            self.OnPeriodicRateTrigger = []
        else:
            self.OnPeriodicRateTrigger = OnPeriodicRateTrigger
        self.OnPeriodicRateTrigger_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TriggerSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TriggerSetType.subclass:
            return TriggerSetType.subclass(*args_, **kwargs_)
        else:
            return TriggerSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_OnParameterUpdateTrigger(self):
        return self.OnParameterUpdateTrigger

    def set_OnParameterUpdateTrigger(self, OnParameterUpdateTrigger):
        self.OnParameterUpdateTrigger = OnParameterUpdateTrigger

    def add_OnParameterUpdateTrigger(self, value):
        self.OnParameterUpdateTrigger.append(value)

    def insert_OnParameterUpdateTrigger_at(self, index, value):
        self.OnParameterUpdateTrigger.insert(index, value)

    def replace_OnParameterUpdateTrigger_at(self, index, value):
        self.OnParameterUpdateTrigger[index] = value

    def get_OnContainerUpdateTrigger(self):
        return self.OnContainerUpdateTrigger

    def set_OnContainerUpdateTrigger(self, OnContainerUpdateTrigger):
        self.OnContainerUpdateTrigger = OnContainerUpdateTrigger

    def add_OnContainerUpdateTrigger(self, value):
        self.OnContainerUpdateTrigger.append(value)

    def insert_OnContainerUpdateTrigger_at(self, index, value):
        self.OnContainerUpdateTrigger.insert(index, value)

    def replace_OnContainerUpdateTrigger_at(self, index, value):
        self.OnContainerUpdateTrigger[index] = value

    def get_OnPeriodicRateTrigger(self):
        return self.OnPeriodicRateTrigger

    def set_OnPeriodicRateTrigger(self, OnPeriodicRateTrigger):
        self.OnPeriodicRateTrigger = OnPeriodicRateTrigger

    def add_OnPeriodicRateTrigger(self, value):
        self.OnPeriodicRateTrigger.append(value)

    def insert_OnPeriodicRateTrigger_at(self, index, value):
        self.OnPeriodicRateTrigger.insert(index, value)

    def replace_OnPeriodicRateTrigger_at(self, index, value):
        self.OnPeriodicRateTrigger[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_triggerRate(self):
        return self.triggerRate

    def set_triggerRate(self, triggerRate):
        self.triggerRate = triggerRate

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.OnParameterUpdateTrigger or
                self.OnContainerUpdateTrigger or
                self.OnPeriodicRateTrigger
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='TriggerSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TriggerSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TriggerSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TriggerSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TriggerSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TriggerSetType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.triggerRate != 1 and 'triggerRate' not in already_processed:
            already_processed.add('triggerRate')
            outfile.write(' triggerRate="%s"' % self.gds_format_integer(self.triggerRate, input_name='triggerRate'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='TriggerSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for OnParameterUpdateTrigger_ in self.OnParameterUpdateTrigger:
            namespaceprefix_ = self.OnParameterUpdateTrigger_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.OnParameterUpdateTrigger_nsprefix_) else ''
            OnParameterUpdateTrigger_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='OnParameterUpdateTrigger', pretty_print=pretty_print)
        for OnContainerUpdateTrigger_ in self.OnContainerUpdateTrigger:
            namespaceprefix_ = self.OnContainerUpdateTrigger_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.OnContainerUpdateTrigger_nsprefix_) else ''
            OnContainerUpdateTrigger_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='OnContainerUpdateTrigger', pretty_print=pretty_print)
        for OnPeriodicRateTrigger_ in self.OnPeriodicRateTrigger:
            namespaceprefix_ = self.OnPeriodicRateTrigger_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.OnPeriodicRateTrigger_nsprefix_) else ''
            OnPeriodicRateTrigger_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                          name_='OnPeriodicRateTrigger', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('triggerRate', node)
        if value is not None and 'triggerRate' not in already_processed:
            already_processed.add('triggerRate')
            self.triggerRate = self.gds_parse_integer(value, node, 'triggerRate')
            self.validate_NonNegativeLongType(self.triggerRate)  # validate type NonNegativeLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OnParameterUpdateTrigger':
            obj_ = OnParameterUpdateTriggerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OnParameterUpdateTrigger.append(obj_)
            obj_.original_tagname_ = 'OnParameterUpdateTrigger'
        elif nodeName_ == 'OnContainerUpdateTrigger':
            obj_ = OnContainerUpdateTriggerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OnContainerUpdateTrigger.append(obj_)
            obj_.original_tagname_ = 'OnContainerUpdateTrigger'
        elif nodeName_ == 'OnPeriodicRateTrigger':
            obj_ = OnPeriodicRateTriggerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OnPeriodicRateTrigger.append(obj_)
            obj_.original_tagname_ = 'OnPeriodicRateTrigger'


# end class TriggerSetType


class BaseCalibratorType(GeneratedsSuper):
    """Supplies an optional non-reference-able name and short description for
    calibrators. Also includes an optional ancillary data for any special
    local flags, note that these may not necessarily transfer to another
    recipient of an instance document.Optional name for this
    calibrator/algorithmOptional description for this
    calibrator/algorithm"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, extensiontype_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.shortDescription = _cast(None, shortDescription)
        self.shortDescription_nsprefix_ = None
        self.AncillaryDataSet = AncillaryDataSet
        self.AncillaryDataSet_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseCalibratorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseCalibratorType.subclass:
            return BaseCalibratorType.subclass(*args_, **kwargs_)
        else:
            return BaseCalibratorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_AncillaryDataSet(self):
        return self.AncillaryDataSet

    def set_AncillaryDataSet(self, AncillaryDataSet):
        self.AncillaryDataSet = AncillaryDataSet

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_shortDescription(self):
        return self.shortDescription

    def set_shortDescription(self, shortDescription):
        self.shortDescription = shortDescription

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_ShortDescriptionType(self, value):
        # Validate type xtce:ShortDescriptionType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def hasContent_(self):
        if (
                self.AncillaryDataSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseCalibratorType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BaseCalibratorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BaseCalibratorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BaseCalibratorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BaseCalibratorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BaseCalibratorType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.shortDescription is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            outfile.write(' shortDescription=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.shortDescription), input_name='shortDescription')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseCalibratorType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AncillaryDataSet is not None:
            namespaceprefix_ = self.AncillaryDataSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AncillaryDataSet_nsprefix_) else ''
            self.AncillaryDataSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AncillaryDataSet',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('shortDescription', node)
        if value is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            self.shortDescription = value
            self.validate_ShortDescriptionType(self.shortDescription)  # validate type ShortDescriptionType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AncillaryDataSet':
            obj_ = AncillaryDataSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AncillaryDataSet = obj_
            obj_.original_tagname_ = 'AncillaryDataSet'


# end class BaseCalibratorType


class CalibratorType(BaseCalibratorType):
    """Describe a calibrator to transform a source data type raw/uncalibrated
    value (e.g. an integer count from a spacecraft) to an engineering
    unit/calibrated value for users (e.g. a float)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseCalibratorType

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, SplineCalibrator=None,
                 PolynomialCalibrator=None, MathOperationCalibrator=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(CalibratorType, self).__init__(name, shortDescription, AncillaryDataSet, **kwargs_)
        self.SplineCalibrator = SplineCalibrator
        self.SplineCalibrator_nsprefix_ = None
        self.PolynomialCalibrator = PolynomialCalibrator
        self.PolynomialCalibrator_nsprefix_ = None
        self.MathOperationCalibrator = MathOperationCalibrator
        self.MathOperationCalibrator_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CalibratorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CalibratorType.subclass:
            return CalibratorType.subclass(*args_, **kwargs_)
        else:
            return CalibratorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SplineCalibrator(self):
        return self.SplineCalibrator

    def set_SplineCalibrator(self, SplineCalibrator):
        self.SplineCalibrator = SplineCalibrator

    def get_PolynomialCalibrator(self):
        return self.PolynomialCalibrator

    def set_PolynomialCalibrator(self, PolynomialCalibrator):
        self.PolynomialCalibrator = PolynomialCalibrator

    def get_MathOperationCalibrator(self):
        return self.MathOperationCalibrator

    def set_MathOperationCalibrator(self, MathOperationCalibrator):
        self.MathOperationCalibrator = MathOperationCalibrator

    def hasContent_(self):
        if (
                self.SplineCalibrator is not None or
                self.PolynomialCalibrator is not None or
                self.MathOperationCalibrator is not None or
                super(CalibratorType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CalibratorType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CalibratorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CalibratorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CalibratorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CalibratorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CalibratorType'):
        super(CalibratorType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                     name_='CalibratorType')

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CalibratorType',
                       fromsubclass_=False, pretty_print=True):
        super(CalibratorType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                   pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SplineCalibrator is not None:
            namespaceprefix_ = self.SplineCalibrator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.SplineCalibrator_nsprefix_) else ''
            self.SplineCalibrator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SplineCalibrator',
                                         pretty_print=pretty_print)
        if self.PolynomialCalibrator is not None:
            namespaceprefix_ = self.PolynomialCalibrator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.PolynomialCalibrator_nsprefix_) else ''
            self.PolynomialCalibrator.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='PolynomialCalibrator', pretty_print=pretty_print)
        if self.MathOperationCalibrator is not None:
            namespaceprefix_ = self.MathOperationCalibrator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.MathOperationCalibrator_nsprefix_) else ''
            self.MathOperationCalibrator.export(outfile, level, namespaceprefix_, namespacedef_='',
                                                name_='MathOperationCalibrator', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(CalibratorType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SplineCalibrator':
            obj_ = SplineCalibratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SplineCalibrator = obj_
            obj_.original_tagname_ = 'SplineCalibrator'
        elif nodeName_ == 'PolynomialCalibrator':
            obj_ = PolynomialCalibratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PolynomialCalibrator = obj_
            obj_.original_tagname_ = 'PolynomialCalibrator'
        elif nodeName_ == 'MathOperationCalibrator':
            class_obj_ = self.get_class_obj_(child_, MathOperationCalibratorType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MathOperationCalibrator = obj_
            obj_.original_tagname_ = 'MathOperationCalibrator'
        super(CalibratorType, self).buildChildren(child_, node, nodeName_, True)


# end class CalibratorType


class ChangeValueType(GeneratedsSuper):
    """Describe a change value used to test verification status. See
    CommandVerifierType.Value as a floating point number."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.value = _cast(float, value)
        self.value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChangeValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChangeValueType.subclass:
            return ChangeValueType.subclass(*args_, **kwargs_)
        else:
            return ChangeValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_value(self):
        return self.value

    def set_value(self, value):
        self.value = value

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ChangeValueType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ChangeValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ChangeValueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ChangeValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ChangeValueType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ChangeValueType'):
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value="%s"' % self.gds_format_double(self.value, input_name='value'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ChangeValueType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            value = self.gds_parse_double(value, node, 'value')
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ChangeValueType


class MathOperationCalibratorType(BaseCalibratorType):
    """Describe a mathematical function for calibration where the mathematical
    function is defined using the MathOperationType.Describe a postfix (aka
    Reverse Polish Notation (RPN)) expression for mathematical equations.
    It uses a stack where operands (either fixed values or
    ParameterInstances) are pushed onto the stack from first to last in the
    XML. As the operators are specified, each pops off operands as it
    evaluates them, and pushes the result back onto the stack. For example,
    the stack, 4 8 /, would result as 0.5. In this case postfix is used to
    avoid having to specify parenthesis. To convert from infix to postfix,
    use Dijkstra's "shunting yard" algorithm."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseCalibratorType

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, ValueOperand=None,
                 ThisParameterOperand=None, Operator=None, ParameterInstanceRefOperand=None, extensiontype_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(MathOperationCalibratorType, self).__init__(name, shortDescription, AncillaryDataSet, extensiontype_,
                                                          **kwargs_)
        if ValueOperand is None:
            self.ValueOperand = []
        else:
            self.ValueOperand = ValueOperand
        self.ValueOperand_nsprefix_ = None
        if ThisParameterOperand is None:
            self.ThisParameterOperand = []
        else:
            self.ThisParameterOperand = ThisParameterOperand
        self.ThisParameterOperand_nsprefix_ = None
        if Operator is None:
            self.Operator = []
        else:
            self.Operator = Operator
        self.Operator_nsprefix_ = None
        if ParameterInstanceRefOperand is None:
            self.ParameterInstanceRefOperand = []
        else:
            self.ParameterInstanceRefOperand = ParameterInstanceRefOperand
        self.ParameterInstanceRefOperand_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MathOperationCalibratorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MathOperationCalibratorType.subclass:
            return MathOperationCalibratorType.subclass(*args_, **kwargs_)
        else:
            return MathOperationCalibratorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ValueOperand(self):
        return self.ValueOperand

    def set_ValueOperand(self, ValueOperand):
        self.ValueOperand = ValueOperand

    def add_ValueOperand(self, value):
        self.ValueOperand.append(value)

    def insert_ValueOperand_at(self, index, value):
        self.ValueOperand.insert(index, value)

    def replace_ValueOperand_at(self, index, value):
        self.ValueOperand[index] = value

    def get_ThisParameterOperand(self):
        return self.ThisParameterOperand

    def set_ThisParameterOperand(self, ThisParameterOperand):
        self.ThisParameterOperand = ThisParameterOperand

    def add_ThisParameterOperand(self, value):
        self.ThisParameterOperand.append(value)

    def insert_ThisParameterOperand_at(self, index, value):
        self.ThisParameterOperand.insert(index, value)

    def replace_ThisParameterOperand_at(self, index, value):
        self.ThisParameterOperand[index] = value

    def get_Operator(self):
        return self.Operator

    def set_Operator(self, Operator):
        self.Operator = Operator

    def add_Operator(self, value):
        self.Operator.append(value)

    def insert_Operator_at(self, index, value):
        self.Operator.insert(index, value)

    def replace_Operator_at(self, index, value):
        self.Operator[index] = value

    def get_ParameterInstanceRefOperand(self):
        return self.ParameterInstanceRefOperand

    def set_ParameterInstanceRefOperand(self, ParameterInstanceRefOperand):
        self.ParameterInstanceRefOperand = ParameterInstanceRefOperand

    def add_ParameterInstanceRefOperand(self, value):
        self.ParameterInstanceRefOperand.append(value)

    def insert_ParameterInstanceRefOperand_at(self, index, value):
        self.ParameterInstanceRefOperand.insert(index, value)

    def replace_ParameterInstanceRefOperand_at(self, index, value):
        self.ParameterInstanceRefOperand[index] = value

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_MathOperatorsType(self, value):
        result = True
        # Validate type MathOperatorsType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['+', '-', '*', '/', '%', '^', 'y^x', 'ln', 'log', 'e^x', '1/x', 'x!', 'tan', 'cos', 'sin',
                            'atan', 'atan2', 'acos', 'asin', 'tanh', 'cosh', 'sinh', 'atanh', 'acosh', 'asinh', 'swap',
                            'drop', 'dup', 'over', '<<', '>>', '&', '|', '&&', '||', '!', 'abs', 'div', 'int', '>',
                            '>=', '<', '<=', '==', '!=', 'min', 'max', 'xor', '~']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on MathOperatorsType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False
        return result

    def hasContent_(self):
        if (
                self.ValueOperand or
                self.ThisParameterOperand or
                self.Operator or
                self.ParameterInstanceRefOperand or
                super(MathOperationCalibratorType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='MathOperationCalibratorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MathOperationCalibratorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MathOperationCalibratorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MathOperationCalibratorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='MathOperationCalibratorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='MathOperationCalibratorType'):
        super(MathOperationCalibratorType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                                  name_='MathOperationCalibratorType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='MathOperationCalibratorType', fromsubclass_=False, pretty_print=True):
        super(MathOperationCalibratorType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_,
                                                                True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ValueOperand_ in self.ValueOperand:
            namespaceprefix_ = self.ValueOperand_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ValueOperand_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValueOperand>%s</%sValueOperand>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(ValueOperand_), input_name='ValueOperand')), namespaceprefix_, eol_))
        for ThisParameterOperand_ in self.ThisParameterOperand:
            namespaceprefix_ = self.ThisParameterOperand_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ThisParameterOperand_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sThisParameterOperand>%s</%sThisParameterOperand>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(ThisParameterOperand_), input_name='ThisParameterOperand')),
                                                                                     namespaceprefix_, eol_))
        for Operator_ in self.Operator:
            namespaceprefix_ = self.Operator_nsprefix_ + ':' if (UseCapturedNS_ and self.Operator_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOperator>%s</%sOperator>%s' % (
            namespaceprefix_, self.gds_encode(self.gds_format_string(quote_xml(Operator_), input_name='Operator')),
            namespaceprefix_, eol_))
        for ParameterInstanceRefOperand_ in self.ParameterInstanceRefOperand:
            namespaceprefix_ = self.ParameterInstanceRefOperand_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterInstanceRefOperand_nsprefix_) else ''
            ParameterInstanceRefOperand_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                                name_='ParameterInstanceRefOperand', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(MathOperationCalibratorType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ValueOperand':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ValueOperand')
            value_ = self.gds_validate_string(value_, node, 'ValueOperand')
            self.ValueOperand.append(value_)
            self.ValueOperand_nsprefix_ = child_.prefix
        elif nodeName_ == 'ThisParameterOperand':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ThisParameterOperand')
            value_ = self.gds_validate_string(value_, node, 'ThisParameterOperand')
            self.ThisParameterOperand.append(value_)
            self.ThisParameterOperand_nsprefix_ = child_.prefix
        elif nodeName_ == 'Operator':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Operator')
            value_ = self.gds_validate_string(value_, node, 'Operator')
            self.Operator.append(value_)
            self.Operator_nsprefix_ = child_.prefix
            # validate type MathOperatorsType
            self.validate_MathOperatorsType(self.Operator[-1])
        elif nodeName_ == 'ParameterInstanceRefOperand':
            class_obj_ = self.get_class_obj_(child_, ParameterInstanceRefType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterInstanceRefOperand.append(obj_)
            obj_.original_tagname_ = 'ParameterInstanceRefOperand'
        super(MathOperationCalibratorType, self).buildChildren(child_, node, nodeName_, True)


# end class MathOperationCalibratorType


class PolynomialCalibratorType(BaseCalibratorType):
    """Describe a polynomial equation for calibration. This is a calibration
    type where a curve in a raw vs calibrated plane is described using a
    set of polynomial coefficients. Raw values are converted to calibrated
    values by finding a position on the curve corresponding to the raw
    value. The first coefficient belongs with the X^0 term, the next
    coefficient belongs to the X^1 term and so on. See CalibratorType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseCalibratorType

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, Term=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(PolynomialCalibratorType, self).__init__(name, shortDescription, AncillaryDataSet, **kwargs_)
        if Term is None:
            self.Term = []
        else:
            self.Term = Term
        self.Term_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PolynomialCalibratorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PolynomialCalibratorType.subclass:
            return PolynomialCalibratorType.subclass(*args_, **kwargs_)
        else:
            return PolynomialCalibratorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Term(self):
        return self.Term

    def set_Term(self, Term):
        self.Term = Term

    def add_Term(self, value):
        self.Term.append(value)

    def insert_Term_at(self, index, value):
        self.Term.insert(index, value)

    def replace_Term_at(self, index, value):
        self.Term[index] = value

    def hasContent_(self):
        if (
                self.Term or
                super(PolynomialCalibratorType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='PolynomialCalibratorType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PolynomialCalibratorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PolynomialCalibratorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PolynomialCalibratorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PolynomialCalibratorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='PolynomialCalibratorType'):
        super(PolynomialCalibratorType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                               name_='PolynomialCalibratorType')

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='PolynomialCalibratorType', fromsubclass_=False, pretty_print=True):
        super(PolynomialCalibratorType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_,
                                                             True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Term_ in self.Term:
            namespaceprefix_ = self.Term_nsprefix_ + ':' if (UseCapturedNS_ and self.Term_nsprefix_) else ''
            Term_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Term', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PolynomialCalibratorType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Term':
            obj_ = TermType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Term.append(obj_)
            obj_.original_tagname_ = 'Term'
        super(PolynomialCalibratorType, self).buildChildren(child_, node, nodeName_, True)


# end class PolynomialCalibratorType


class SplineCalibratorType(BaseCalibratorType):
    """Describe a spline function for calibration using a set of at least 2
    points. Raw values are converted to calibrated values by finding a
    position on the line corresponding to the raw value. The line may be
    interpolated and/or extrapolated as needed. The interpolation order may
    be specified for all the points and overridden on individual points.
    The algorithm triggers on the input parameter. See CalibratorType.The
    interpolation order to apply to the overall spline function. Order 0 is
    no slope between the points (flat). Order 1 is linear interpolation.
    Order 2 would be quadratic and in this special case, 3 points would be
    required, etc.Extrapolation allows the closest outside point and the
    associated interpolation to extend outside of the range of the points
    in the spline function."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseCalibratorType

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, order='1', extrapolate=False,
                 SplinePoint=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(SplineCalibratorType, self).__init__(name, shortDescription, AncillaryDataSet, **kwargs_)
        self.order = _cast(int, order)
        self.order_nsprefix_ = None
        self.extrapolate = _cast(bool, extrapolate)
        self.extrapolate_nsprefix_ = None
        if SplinePoint is None:
            self.SplinePoint = []
        else:
            self.SplinePoint = SplinePoint
        self.SplinePoint_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SplineCalibratorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SplineCalibratorType.subclass:
            return SplineCalibratorType.subclass(*args_, **kwargs_)
        else:
            return SplineCalibratorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SplinePoint(self):
        return self.SplinePoint

    def set_SplinePoint(self, SplinePoint):
        self.SplinePoint = SplinePoint

    def add_SplinePoint(self, value):
        self.SplinePoint.append(value)

    def insert_SplinePoint_at(self, index, value):
        self.SplinePoint.insert(index, value)

    def replace_SplinePoint_at(self, index, value):
        self.SplinePoint[index] = value

    def get_order(self):
        return self.order

    def set_order(self, order):
        self.order = order

    def get_extrapolate(self):
        return self.extrapolate

    def set_extrapolate(self, extrapolate):
        self.extrapolate = extrapolate

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.SplinePoint or
                super(SplineCalibratorType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SplineCalibratorType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SplineCalibratorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SplineCalibratorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SplineCalibratorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SplineCalibratorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SplineCalibratorType'):
        super(SplineCalibratorType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                           name_='SplineCalibratorType')
        if self.order != 1 and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
        if self.extrapolate and 'extrapolate' not in already_processed:
            already_processed.add('extrapolate')
            outfile.write(' extrapolate="%s"' % self.gds_format_boolean(self.extrapolate, input_name='extrapolate'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SplineCalibratorType',
                       fromsubclass_=False, pretty_print=True):
        super(SplineCalibratorType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                         pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for SplinePoint_ in self.SplinePoint:
            namespaceprefix_ = self.SplinePoint_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.SplinePoint_nsprefix_) else ''
            SplinePoint_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SplinePoint',
                                pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            self.order = self.gds_parse_integer(value, node, 'order')
            self.validate_NonNegativeLongType(self.order)  # validate type NonNegativeLongType
        value = find_attr_value_('extrapolate', node)
        if value is not None and 'extrapolate' not in already_processed:
            already_processed.add('extrapolate')
            if value in ('true', '1'):
                self.extrapolate = True
            elif value in ('false', '0'):
                self.extrapolate = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(SplineCalibratorType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SplinePoint':
            obj_ = SplinePointType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SplinePoint.append(obj_)
            obj_.original_tagname_ = 'SplinePoint'
        super(SplineCalibratorType, self).buildChildren(child_, node, nodeName_, True)


# end class SplineCalibratorType


class AutoInvertType(GeneratedsSuper):
    """After searching for the frame sync marker for some number of bits, it
    may be desirable to invert the incoming data, and then look for frame
    sync. In some cases this will require an external algorithm"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, badFramesToAutoInvert='1024', InvertAlgorithm=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.badFramesToAutoInvert = _cast(int, badFramesToAutoInvert)
        self.badFramesToAutoInvert_nsprefix_ = None
        self.InvertAlgorithm = InvertAlgorithm
        self.InvertAlgorithm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AutoInvertType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AutoInvertType.subclass:
            return AutoInvertType.subclass(*args_, **kwargs_)
        else:
            return AutoInvertType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_InvertAlgorithm(self):
        return self.InvertAlgorithm

    def set_InvertAlgorithm(self, InvertAlgorithm):
        self.InvertAlgorithm = InvertAlgorithm

    def get_badFramesToAutoInvert(self):
        return self.badFramesToAutoInvert

    def set_badFramesToAutoInvert(self, badFramesToAutoInvert):
        self.badFramesToAutoInvert = badFramesToAutoInvert

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.InvertAlgorithm is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AutoInvertType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AutoInvertType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AutoInvertType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutoInvertType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AutoInvertType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AutoInvertType'):
        if self.badFramesToAutoInvert != 1024 and 'badFramesToAutoInvert' not in already_processed:
            already_processed.add('badFramesToAutoInvert')
            outfile.write(' badFramesToAutoInvert="%s"' % self.gds_format_integer(self.badFramesToAutoInvert,
                                                                                  input_name='badFramesToAutoInvert'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AutoInvertType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.InvertAlgorithm is not None:
            namespaceprefix_ = self.InvertAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InvertAlgorithm_nsprefix_) else ''
            self.InvertAlgorithm.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InvertAlgorithm',
                                        pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('badFramesToAutoInvert', node)
        if value is not None and 'badFramesToAutoInvert' not in already_processed:
            already_processed.add('badFramesToAutoInvert')
            self.badFramesToAutoInvert = self.gds_parse_integer(value, node, 'badFramesToAutoInvert')
            self.validate_PositiveLongType(self.badFramesToAutoInvert)  # validate type PositiveLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InvertAlgorithm':
            class_obj_ = self.get_class_obj_(child_, InputAlgorithmType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InvertAlgorithm = obj_
            obj_.original_tagname_ = 'InvertAlgorithm'


# end class AutoInvertType


class FlagType(GeneratedsSuper):
    """The pattern of bits used to look for frame synchronization."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, flagSizeInBits='6', flagBitType='ones', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.flagSizeInBits = _cast(int, flagSizeInBits)
        self.flagSizeInBits_nsprefix_ = None
        self.flagBitType = _cast(None, flagBitType)
        self.flagBitType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FlagType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FlagType.subclass:
            return FlagType.subclass(*args_, **kwargs_)
        else:
            return FlagType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_flagSizeInBits(self):
        return self.flagSizeInBits

    def set_flagSizeInBits(self, flagSizeInBits):
        self.flagSizeInBits = flagSizeInBits

    def get_flagBitType(self):
        return self.flagBitType

    def set_flagBitType(self, flagBitType):
        self.flagBitType = flagBitType

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_FlagBitType(self, value):
        # Validate type xtce:FlagBitType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['zeros', 'ones']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on FlagBitType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='FlagType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FlagType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'FlagType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='FlagType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='FlagType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='FlagType'):
        if self.flagSizeInBits != 6 and 'flagSizeInBits' not in already_processed:
            already_processed.add('flagSizeInBits')
            outfile.write(
                ' flagSizeInBits="%s"' % self.gds_format_integer(self.flagSizeInBits, input_name='flagSizeInBits'))
        if self.flagBitType != "ones" and 'flagBitType' not in already_processed:
            already_processed.add('flagBitType')
            outfile.write(' flagBitType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.flagBitType), input_name='flagBitType')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='FlagType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('flagSizeInBits', node)
        if value is not None and 'flagSizeInBits' not in already_processed:
            already_processed.add('flagSizeInBits')
            self.flagSizeInBits = self.gds_parse_integer(value, node, 'flagSizeInBits')
            self.validate_PositiveLongType(self.flagSizeInBits)  # validate type PositiveLongType
        value = find_attr_value_('flagBitType', node)
        if value is not None and 'flagBitType' not in already_processed:
            already_processed.add('flagBitType')
            self.flagBitType = value
            self.validate_FlagBitType(self.flagBitType)  # validate type FlagBitType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class FlagType


class StreamRefType(GeneratedsSuper):
    """Holds a reference to a streamname of reference stream"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, streamRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.streamRef = _cast(None, streamRef)
        self.streamRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamRefType.subclass:
            return StreamRefType.subclass(*args_, **kwargs_)
        else:
            return StreamRefType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_streamRef(self):
        return self.streamRef

    def set_streamRef(self, streamRef):
        self.streamRef = streamRef

    def validate_NameReferenceType(self, value):
        # Validate type xtce:NameReferenceType, a restriction on normalizedString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameReferenceType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_NameReferenceType_patterns_,))

    validate_NameReferenceType_patterns_ = [['^(/?(([^./:\\[\\]]+|\\.|\\.\\.)/)*([^./:\\[\\]]+)+)$']]

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='StreamRefType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('StreamRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'StreamRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='StreamRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='StreamRefType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='StreamRefType'):
        if self.streamRef is not None and 'streamRef' not in already_processed:
            already_processed.add('streamRef')
            outfile.write(' streamRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.streamRef), input_name='streamRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='StreamRefType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('streamRef', node)
        if value is not None and 'streamRef' not in already_processed:
            already_processed.add('streamRef')
            self.streamRef = value
            self.validate_NameReferenceType(self.streamRef)  # validate type NameReferenceType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class StreamRefType


class StreamSetType(GeneratedsSuper):
    """Contains an unordered set of Streams."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, FixedFrameStream=None, VariableFrameStream=None, CustomStream=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if FixedFrameStream is None:
            self.FixedFrameStream = []
        else:
            self.FixedFrameStream = FixedFrameStream
        self.FixedFrameStream_nsprefix_ = None
        if VariableFrameStream is None:
            self.VariableFrameStream = []
        else:
            self.VariableFrameStream = VariableFrameStream
        self.VariableFrameStream_nsprefix_ = None
        if CustomStream is None:
            self.CustomStream = []
        else:
            self.CustomStream = CustomStream
        self.CustomStream_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamSetType.subclass:
            return StreamSetType.subclass(*args_, **kwargs_)
        else:
            return StreamSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_FixedFrameStream(self):
        return self.FixedFrameStream

    def set_FixedFrameStream(self, FixedFrameStream):
        self.FixedFrameStream = FixedFrameStream

    def add_FixedFrameStream(self, value):
        self.FixedFrameStream.append(value)

    def insert_FixedFrameStream_at(self, index, value):
        self.FixedFrameStream.insert(index, value)

    def replace_FixedFrameStream_at(self, index, value):
        self.FixedFrameStream[index] = value

    def get_VariableFrameStream(self):
        return self.VariableFrameStream

    def set_VariableFrameStream(self, VariableFrameStream):
        self.VariableFrameStream = VariableFrameStream

    def add_VariableFrameStream(self, value):
        self.VariableFrameStream.append(value)

    def insert_VariableFrameStream_at(self, index, value):
        self.VariableFrameStream.insert(index, value)

    def replace_VariableFrameStream_at(self, index, value):
        self.VariableFrameStream[index] = value

    def get_CustomStream(self):
        return self.CustomStream

    def set_CustomStream(self, CustomStream):
        self.CustomStream = CustomStream

    def add_CustomStream(self, value):
        self.CustomStream.append(value)

    def insert_CustomStream_at(self, index, value):
        self.CustomStream.insert(index, value)

    def replace_CustomStream_at(self, index, value):
        self.CustomStream[index] = value

    def hasContent_(self):
        if (
                self.FixedFrameStream or
                self.VariableFrameStream or
                self.CustomStream
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='StreamSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('StreamSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'StreamSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='StreamSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='StreamSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='StreamSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='StreamSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FixedFrameStream_ in self.FixedFrameStream:
            namespaceprefix_ = self.FixedFrameStream_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FixedFrameStream_nsprefix_) else ''
            FixedFrameStream_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FixedFrameStream',
                                     pretty_print=pretty_print)
        for VariableFrameStream_ in self.VariableFrameStream:
            namespaceprefix_ = self.VariableFrameStream_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.VariableFrameStream_nsprefix_) else ''
            VariableFrameStream_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='VariableFrameStream',
                                        pretty_print=pretty_print)
        for CustomStream_ in self.CustomStream:
            namespaceprefix_ = self.CustomStream_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CustomStream_nsprefix_) else ''
            CustomStream_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomStream',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FixedFrameStream':
            obj_ = FixedFrameStreamType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FixedFrameStream.append(obj_)
            obj_.original_tagname_ = 'FixedFrameStream'
        elif nodeName_ == 'VariableFrameStream':
            obj_ = VariableFrameStreamType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.VariableFrameStream.append(obj_)
            obj_.original_tagname_ = 'VariableFrameStream'
        elif nodeName_ == 'CustomStream':
            obj_ = CustomStreamType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomStream.append(obj_)
            obj_.original_tagname_ = 'CustomStream'


# end class StreamSetType


class SyncStrategyType(GeneratedsSuper):
    """A Sync Strategy specifies the strategy on how to find frames within a
    stream of PCM data. The sync strategy is based upon a state machine
    that begins in the 'Search' state until the first sync marker is found.
    Then it goes into the 'Verify' state until a specified number of
    successive good sync markers are found. Then, the state machine goes
    into the 'Lock' state, in the 'Lock' state frames are considered good.
    Should a sync marker be missed in the 'Lock' state, the state machine
    will transition into the 'Check' state, if the next sync marker is
    where it's expected within a specified number of frames, then the state
    machine will transition back to the 'Lock' state, it not it will
    transition back to 'Search'. Maximum number of bit errors in the sync
    pattern (marker)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, verifyToLockGoodFrames='4', checkToLockGoodFrames='1', maxBitErrorsInSyncPattern='0',
                 AutoInvert=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.verifyToLockGoodFrames = _cast(int, verifyToLockGoodFrames)
        self.verifyToLockGoodFrames_nsprefix_ = None
        self.checkToLockGoodFrames = _cast(int, checkToLockGoodFrames)
        self.checkToLockGoodFrames_nsprefix_ = None
        self.maxBitErrorsInSyncPattern = _cast(int, maxBitErrorsInSyncPattern)
        self.maxBitErrorsInSyncPattern_nsprefix_ = None
        self.AutoInvert = AutoInvert
        self.AutoInvert_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SyncStrategyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SyncStrategyType.subclass:
            return SyncStrategyType.subclass(*args_, **kwargs_)
        else:
            return SyncStrategyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_AutoInvert(self):
        return self.AutoInvert

    def set_AutoInvert(self, AutoInvert):
        self.AutoInvert = AutoInvert

    def get_verifyToLockGoodFrames(self):
        return self.verifyToLockGoodFrames

    def set_verifyToLockGoodFrames(self, verifyToLockGoodFrames):
        self.verifyToLockGoodFrames = verifyToLockGoodFrames

    def get_checkToLockGoodFrames(self):
        return self.checkToLockGoodFrames

    def set_checkToLockGoodFrames(self, checkToLockGoodFrames):
        self.checkToLockGoodFrames = checkToLockGoodFrames

    def get_maxBitErrorsInSyncPattern(self):
        return self.maxBitErrorsInSyncPattern

    def set_maxBitErrorsInSyncPattern(self, maxBitErrorsInSyncPattern):
        self.maxBitErrorsInSyncPattern = maxBitErrorsInSyncPattern

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.AutoInvert is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SyncStrategyType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SyncStrategyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SyncStrategyType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SyncStrategyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SyncStrategyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SyncStrategyType'):
        if self.verifyToLockGoodFrames != 4 and 'verifyToLockGoodFrames' not in already_processed:
            already_processed.add('verifyToLockGoodFrames')
            outfile.write(' verifyToLockGoodFrames="%s"' % self.gds_format_integer(self.verifyToLockGoodFrames,
                                                                                   input_name='verifyToLockGoodFrames'))
        if self.checkToLockGoodFrames != 1 and 'checkToLockGoodFrames' not in already_processed:
            already_processed.add('checkToLockGoodFrames')
            outfile.write(' checkToLockGoodFrames="%s"' % self.gds_format_integer(self.checkToLockGoodFrames,
                                                                                  input_name='checkToLockGoodFrames'))
        if self.maxBitErrorsInSyncPattern != 0 and 'maxBitErrorsInSyncPattern' not in already_processed:
            already_processed.add('maxBitErrorsInSyncPattern')
            outfile.write(' maxBitErrorsInSyncPattern="%s"' % self.gds_format_integer(self.maxBitErrorsInSyncPattern,
                                                                                      input_name='maxBitErrorsInSyncPattern'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SyncStrategyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AutoInvert is not None:
            namespaceprefix_ = self.AutoInvert_nsprefix_ + ':' if (UseCapturedNS_ and self.AutoInvert_nsprefix_) else ''
            self.AutoInvert.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AutoInvert',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('verifyToLockGoodFrames', node)
        if value is not None and 'verifyToLockGoodFrames' not in already_processed:
            already_processed.add('verifyToLockGoodFrames')
            self.verifyToLockGoodFrames = self.gds_parse_integer(value, node, 'verifyToLockGoodFrames')
            self.validate_NonNegativeLongType(self.verifyToLockGoodFrames)  # validate type NonNegativeLongType
        value = find_attr_value_('checkToLockGoodFrames', node)
        if value is not None and 'checkToLockGoodFrames' not in already_processed:
            already_processed.add('checkToLockGoodFrames')
            self.checkToLockGoodFrames = self.gds_parse_integer(value, node, 'checkToLockGoodFrames')
            self.validate_NonNegativeLongType(self.checkToLockGoodFrames)  # validate type NonNegativeLongType
        value = find_attr_value_('maxBitErrorsInSyncPattern', node)
        if value is not None and 'maxBitErrorsInSyncPattern' not in already_processed:
            already_processed.add('maxBitErrorsInSyncPattern')
            self.maxBitErrorsInSyncPattern = self.gds_parse_integer(value, node, 'maxBitErrorsInSyncPattern')
            self.validate_NonNegativeLongType(self.maxBitErrorsInSyncPattern)  # validate type NonNegativeLongType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AutoInvert':
            obj_ = AutoInvertType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AutoInvert = obj_
            obj_.original_tagname_ = 'AutoInvert'


# end class SyncStrategyType


class SyncPatternType(GeneratedsSuper):
    """The pattern of bits used to look for frame synchronization.CCSDS ASM for
    non-turbocoded frames = 1acffc1dtruncate the mask from the lefttruncate
    the pattern from the left"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, pattern=None, bitLocationFromStartOfContainer=0, mask=None, maskLengthInBits=None,
                 patternLengthInBits=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.pattern = _cast(None, pattern)
        self.pattern_nsprefix_ = None
        self.bitLocationFromStartOfContainer = _cast(int, bitLocationFromStartOfContainer)
        self.bitLocationFromStartOfContainer_nsprefix_ = None
        self.mask = _cast(None, mask)
        self.mask_nsprefix_ = None
        self.maskLengthInBits = _cast(int, maskLengthInBits)
        self.maskLengthInBits_nsprefix_ = None
        self.patternLengthInBits = _cast(int, patternLengthInBits)
        self.patternLengthInBits_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SyncPatternType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SyncPatternType.subclass:
            return SyncPatternType.subclass(*args_, **kwargs_)
        else:
            return SyncPatternType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_pattern(self):
        return self.pattern

    def set_pattern(self, pattern):
        self.pattern = pattern

    def get_bitLocationFromStartOfContainer(self):
        return self.bitLocationFromStartOfContainer

    def set_bitLocationFromStartOfContainer(self, bitLocationFromStartOfContainer):
        self.bitLocationFromStartOfContainer = bitLocationFromStartOfContainer

    def get_mask(self):
        return self.mask

    def set_mask(self, mask):
        self.mask = mask

    def get_maskLengthInBits(self):
        return self.maskLengthInBits

    def set_maskLengthInBits(self, maskLengthInBits):
        self.maskLengthInBits = maskLengthInBits

    def get_patternLengthInBits(self):
        return self.patternLengthInBits

    def set_patternLengthInBits(self, patternLengthInBits):
        self.patternLengthInBits = patternLengthInBits

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SyncPatternType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SyncPatternType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SyncPatternType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SyncPatternType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SyncPatternType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SyncPatternType'):
        if self.pattern is not None and 'pattern' not in already_processed:
            already_processed.add('pattern')
            outfile.write(' pattern=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pattern), input_name='pattern')),))
        if self.bitLocationFromStartOfContainer != 0 and 'bitLocationFromStartOfContainer' not in already_processed:
            already_processed.add('bitLocationFromStartOfContainer')
            outfile.write(
                ' bitLocationFromStartOfContainer="%s"' % self.gds_format_integer(self.bitLocationFromStartOfContainer,
                                                                                  input_name='bitLocationFromStartOfContainer'))
        if self.mask is not None and 'mask' not in already_processed:
            already_processed.add('mask')
            outfile.write(
                ' mask=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mask), input_name='mask')),))
        if self.maskLengthInBits is not None and 'maskLengthInBits' not in already_processed:
            already_processed.add('maskLengthInBits')
            outfile.write(' maskLengthInBits="%s"' % self.gds_format_integer(self.maskLengthInBits,
                                                                             input_name='maskLengthInBits'))
        if self.patternLengthInBits is not None and 'patternLengthInBits' not in already_processed:
            already_processed.add('patternLengthInBits')
            outfile.write(' patternLengthInBits="%s"' % self.gds_format_integer(self.patternLengthInBits,
                                                                                input_name='patternLengthInBits'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='SyncPatternType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('pattern', node)
        if value is not None and 'pattern' not in already_processed:
            already_processed.add('pattern')
            self.pattern = value
        value = find_attr_value_('bitLocationFromStartOfContainer', node)
        if value is not None and 'bitLocationFromStartOfContainer' not in already_processed:
            already_processed.add('bitLocationFromStartOfContainer')
            self.bitLocationFromStartOfContainer = self.gds_parse_integer(value, node,
                                                                          'bitLocationFromStartOfContainer')
        value = find_attr_value_('mask', node)
        if value is not None and 'mask' not in already_processed:
            already_processed.add('mask')
            self.mask = value
        value = find_attr_value_('maskLengthInBits', node)
        if value is not None and 'maskLengthInBits' not in already_processed:
            already_processed.add('maskLengthInBits')
            self.maskLengthInBits = self.gds_parse_integer(value, node, 'maskLengthInBits')
            self.validate_PositiveLongType(self.maskLengthInBits)  # validate type PositiveLongType
        value = find_attr_value_('patternLengthInBits', node)
        if value is not None and 'patternLengthInBits' not in already_processed:
            already_processed.add('patternLengthInBits')
            self.patternLengthInBits = self.gds_parse_integer(value, node, 'patternLengthInBits')
            self.validate_PositiveLongType(self.patternLengthInBits)  # validate type PositiveLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class SyncPatternType


class VariableFrameSyncStrategyType(SyncStrategyType):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = SyncStrategyType

    def __init__(self, verifyToLockGoodFrames='4', checkToLockGoodFrames='1', maxBitErrorsInSyncPattern='0',
                 AutoInvert=None, Flag=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(VariableFrameSyncStrategyType, self).__init__(verifyToLockGoodFrames, checkToLockGoodFrames,
                                                            maxBitErrorsInSyncPattern, AutoInvert, **kwargs_)
        self.Flag = Flag
        self.Flag_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VariableFrameSyncStrategyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VariableFrameSyncStrategyType.subclass:
            return VariableFrameSyncStrategyType.subclass(*args_, **kwargs_)
        else:
            return VariableFrameSyncStrategyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Flag(self):
        return self.Flag

    def set_Flag(self, Flag):
        self.Flag = Flag

    def hasContent_(self):
        if (
                self.Flag is not None or
                super(VariableFrameSyncStrategyType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='VariableFrameSyncStrategyType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VariableFrameSyncStrategyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VariableFrameSyncStrategyType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='VariableFrameSyncStrategyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='VariableFrameSyncStrategyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='VariableFrameSyncStrategyType'):
        super(VariableFrameSyncStrategyType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                                    name_='VariableFrameSyncStrategyType')

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='VariableFrameSyncStrategyType', fromsubclass_=False, pretty_print=True):
        super(VariableFrameSyncStrategyType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_,
                                                                  name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Flag is not None:
            namespaceprefix_ = self.Flag_nsprefix_ + ':' if (UseCapturedNS_ and self.Flag_nsprefix_) else ''
            self.Flag.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Flag',
                             pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(VariableFrameSyncStrategyType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Flag':
            obj_ = FlagType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Flag = obj_
            obj_.original_tagname_ = 'Flag'
        super(VariableFrameSyncStrategyType, self).buildChildren(child_, node, nodeName_, True)


# end class VariableFrameSyncStrategyType


class DimensionType(GeneratedsSuper):
    """For partial entries of an array, the starting and ending index for each
    dimension, OR the Size must be specified. Indexes are zero based."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, StartingIndex=None, EndingIndex=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.StartingIndex = StartingIndex
        self.StartingIndex_nsprefix_ = None
        self.EndingIndex = EndingIndex
        self.EndingIndex_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DimensionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DimensionType.subclass:
            return DimensionType.subclass(*args_, **kwargs_)
        else:
            return DimensionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_StartingIndex(self):
        return self.StartingIndex

    def set_StartingIndex(self, StartingIndex):
        self.StartingIndex = StartingIndex

    def get_EndingIndex(self):
        return self.EndingIndex

    def set_EndingIndex(self, EndingIndex):
        self.EndingIndex = EndingIndex

    def hasContent_(self):
        if (
                self.StartingIndex is not None or
                self.EndingIndex is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DimensionType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DimensionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DimensionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DimensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DimensionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DimensionType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DimensionType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.StartingIndex is not None:
            namespaceprefix_ = self.StartingIndex_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StartingIndex_nsprefix_) else ''
            self.StartingIndex.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StartingIndex',
                                      pretty_print=pretty_print)
        if self.EndingIndex is not None:
            namespaceprefix_ = self.EndingIndex_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.EndingIndex_nsprefix_) else ''
            self.EndingIndex.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EndingIndex',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'StartingIndex':
            class_obj_ = self.get_class_obj_(child_, IntegerValueType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StartingIndex = obj_
            obj_.original_tagname_ = 'StartingIndex'
        elif nodeName_ == 'EndingIndex':
            class_obj_ = self.get_class_obj_(child_, IntegerValueType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EndingIndex = obj_
            obj_.original_tagname_ = 'EndingIndex'


# end class DimensionType


class ArgumentDimensionType(GeneratedsSuper):
    """Identical to DimensionType but supports argument instance references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, StartingIndex=None, EndingIndex=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.StartingIndex = StartingIndex
        self.StartingIndex_nsprefix_ = None
        self.EndingIndex = EndingIndex
        self.EndingIndex_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentDimensionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentDimensionType.subclass:
            return ArgumentDimensionType.subclass(*args_, **kwargs_)
        else:
            return ArgumentDimensionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_StartingIndex(self):
        return self.StartingIndex

    def set_StartingIndex(self, StartingIndex):
        self.StartingIndex = StartingIndex

    def get_EndingIndex(self):
        return self.EndingIndex

    def set_EndingIndex(self, EndingIndex):
        self.EndingIndex = EndingIndex

    def hasContent_(self):
        if (
                self.StartingIndex is not None or
                self.EndingIndex is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentDimensionType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentDimensionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentDimensionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentDimensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentDimensionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArgumentDimensionType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentDimensionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.StartingIndex is not None:
            namespaceprefix_ = self.StartingIndex_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StartingIndex_nsprefix_) else ''
            self.StartingIndex.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StartingIndex',
                                      pretty_print=pretty_print)
        if self.EndingIndex is not None:
            namespaceprefix_ = self.EndingIndex_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.EndingIndex_nsprefix_) else ''
            self.EndingIndex.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EndingIndex',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'StartingIndex':
            class_obj_ = self.get_class_obj_(child_, ArgumentIntegerValueType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StartingIndex = obj_
            obj_.original_tagname_ = 'StartingIndex'
        elif nodeName_ == 'EndingIndex':
            class_obj_ = self.get_class_obj_(child_, ArgumentIntegerValueType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EndingIndex = obj_
            obj_.original_tagname_ = 'EndingIndex'


# end class ArgumentDimensionType


class DimensionListType(GeneratedsSuper):
    """Where the Dimension list is in this form:
    Array[1stDim][2ndDim][lastDim]. The last dimension is assumed to be the
    least significant - that is this dimension will cycle through its
    combination before the next to last dimension changes. The order MUST
    ascend or the array will need to be broken out entry by entry."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Dimension=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Dimension is None:
            self.Dimension = []
        else:
            self.Dimension = Dimension
        self.Dimension_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DimensionListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DimensionListType.subclass:
            return DimensionListType.subclass(*args_, **kwargs_)
        else:
            return DimensionListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Dimension(self):
        return self.Dimension

    def set_Dimension(self, Dimension):
        self.Dimension = Dimension

    def add_Dimension(self, value):
        self.Dimension.append(value)

    def insert_Dimension_at(self, index, value):
        self.Dimension.insert(index, value)

    def replace_Dimension_at(self, index, value):
        self.Dimension[index] = value

    def hasContent_(self):
        if (
                self.Dimension
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DimensionListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DimensionListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DimensionListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DimensionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DimensionListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DimensionListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DimensionListType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Dimension_ in self.Dimension:
            namespaceprefix_ = self.Dimension_nsprefix_ + ':' if (UseCapturedNS_ and self.Dimension_nsprefix_) else ''
            Dimension_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Dimension',
                              pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Dimension':
            obj_ = DimensionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Dimension.append(obj_)
            obj_.original_tagname_ = 'Dimension'


# end class DimensionListType


class ArgumentDimensionListType(GeneratedsSuper):
    """Identical to DimensionListType but supports argument instance
    references."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Dimension=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Dimension is None:
            self.Dimension = []
        else:
            self.Dimension = Dimension
        self.Dimension_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentDimensionListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentDimensionListType.subclass:
            return ArgumentDimensionListType.subclass(*args_, **kwargs_)
        else:
            return ArgumentDimensionListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Dimension(self):
        return self.Dimension

    def set_Dimension(self, Dimension):
        self.Dimension = Dimension

    def add_Dimension(self, value):
        self.Dimension.append(value)

    def insert_Dimension_at(self, index, value):
        self.Dimension.insert(index, value)

    def replace_Dimension_at(self, index, value):
        self.Dimension[index] = value

    def hasContent_(self):
        if (
                self.Dimension
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ArgumentDimensionListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentDimensionListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentDimensionListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentDimensionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentDimensionListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentDimensionListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentDimensionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Dimension_ in self.Dimension:
            namespaceprefix_ = self.Dimension_nsprefix_ + ':' if (UseCapturedNS_ and self.Dimension_nsprefix_) else ''
            Dimension_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Dimension',
                              pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Dimension':
            obj_ = ArgumentDimensionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Dimension.append(obj_)
            obj_.original_tagname_ = 'Dimension'


# end class ArgumentDimensionListType


class EnumerationListType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Enumeration=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Enumeration is None:
            self.Enumeration = []
        else:
            self.Enumeration = Enumeration
        self.Enumeration_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EnumerationListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EnumerationListType.subclass:
            return EnumerationListType.subclass(*args_, **kwargs_)
        else:
            return EnumerationListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Enumeration(self):
        return self.Enumeration

    def set_Enumeration(self, Enumeration):
        self.Enumeration = Enumeration

    def add_Enumeration(self, value):
        self.Enumeration.append(value)

    def insert_Enumeration_at(self, index, value):
        self.Enumeration.insert(index, value)

    def replace_Enumeration_at(self, index, value):
        self.Enumeration[index] = value

    def hasContent_(self):
        if (
                self.Enumeration
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='EnumerationListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EnumerationListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EnumerationListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EnumerationListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='EnumerationListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EnumerationListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='EnumerationListType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Enumeration_ in self.Enumeration:
            namespaceprefix_ = self.Enumeration_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.Enumeration_nsprefix_) else ''
            Enumeration_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Enumeration',
                                pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Enumeration':
            obj_ = ValueEnumerationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Enumeration.append(obj_)
            obj_.original_tagname_ = 'Enumeration'


# end class EnumerationListType


class MemberListType(GeneratedsSuper):
    """Order is important only if the name of the AggregateParameter or
    Aggregate Argument is directly referenced in SequenceContainers. In
    this case the members are assued to be added sequentially (in the order
    listed here) into the Container."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Member=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Member is None:
            self.Member = []
        else:
            self.Member = Member
        self.Member_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MemberListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MemberListType.subclass:
            return MemberListType.subclass(*args_, **kwargs_)
        else:
            return MemberListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Member(self):
        return self.Member

    def set_Member(self, Member):
        self.Member = Member

    def add_Member(self, value):
        self.Member.append(value)

    def insert_Member_at(self, index, value):
        self.Member.insert(index, value)

    def replace_Member_at(self, index, value):
        self.Member[index] = value

    def hasContent_(self):
        if (
                self.Member
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MemberListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MemberListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MemberListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MemberListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MemberListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MemberListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='MemberListType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Member_ in self.Member:
            namespaceprefix_ = self.Member_nsprefix_ + ':' if (UseCapturedNS_ and self.Member_nsprefix_) else ''
            Member_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Member',
                           pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Member':
            obj_ = MemberType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Member.append(obj_)
            obj_.original_tagname_ = 'Member'


# end class MemberListType


class UnitSetType(GeneratedsSuper):
    """Describe an ordered collection of units that form a unit-expression.
    Units may be described for both calibrated/engineering values and also
    potentially uncalibrated/raw values. See UnitType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Unit=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Unit is None:
            self.Unit = []
        else:
            self.Unit = Unit
        self.Unit_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnitSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnitSetType.subclass:
            return UnitSetType.subclass(*args_, **kwargs_)
        else:
            return UnitSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Unit(self):
        return self.Unit

    def set_Unit(self, Unit):
        self.Unit = Unit

    def add_Unit(self, value):
        self.Unit.append(value)

    def insert_Unit_at(self, index, value):
        self.Unit.insert(index, value)

    def replace_Unit_at(self, index, value):
        self.Unit[index] = value

    def hasContent_(self):
        if (
                self.Unit
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='UnitSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UnitSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UnitSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UnitSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UnitSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UnitSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='UnitSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Unit_ in self.Unit:
            namespaceprefix_ = self.Unit_nsprefix_ + ':' if (UseCapturedNS_ and self.Unit_nsprefix_) else ''
            Unit_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Unit', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Unit':
            obj_ = UnitType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Unit.append(obj_)
            obj_.original_tagname_ = 'Unit'


# end class UnitSetType


class ValidFloatRangeSetType(GeneratedsSuper):
    """Numerical ranges that define the universe of valid values for this
    argument. A single range is the most common, although it is possible to
    define multiple ranges when the valid values are not contiguous.By
    default and general recommendation, the valid range is specified in
    engineering/calibrated values, although this can be adjusted."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, validRangeAppliesToCalibrated=True, ValidRange=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.validRangeAppliesToCalibrated = _cast(bool, validRangeAppliesToCalibrated)
        self.validRangeAppliesToCalibrated_nsprefix_ = None
        if ValidRange is None:
            self.ValidRange = []
        else:
            self.ValidRange = ValidRange
        self.ValidRange_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValidFloatRangeSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValidFloatRangeSetType.subclass:
            return ValidFloatRangeSetType.subclass(*args_, **kwargs_)
        else:
            return ValidFloatRangeSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ValidRange(self):
        return self.ValidRange

    def set_ValidRange(self, ValidRange):
        self.ValidRange = ValidRange

    def add_ValidRange(self, value):
        self.ValidRange.append(value)

    def insert_ValidRange_at(self, index, value):
        self.ValidRange.insert(index, value)

    def replace_ValidRange_at(self, index, value):
        self.ValidRange[index] = value

    def get_validRangeAppliesToCalibrated(self):
        return self.validRangeAppliesToCalibrated

    def set_validRangeAppliesToCalibrated(self, validRangeAppliesToCalibrated):
        self.validRangeAppliesToCalibrated = validRangeAppliesToCalibrated

    def hasContent_(self):
        if (
                self.ValidRange
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ValidFloatRangeSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ValidFloatRangeSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ValidFloatRangeSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ValidFloatRangeSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ValidFloatRangeSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ValidFloatRangeSetType'):
        if not self.validRangeAppliesToCalibrated and 'validRangeAppliesToCalibrated' not in already_processed:
            already_processed.add('validRangeAppliesToCalibrated')
            outfile.write(
                ' validRangeAppliesToCalibrated="%s"' % self.gds_format_boolean(self.validRangeAppliesToCalibrated,
                                                                                input_name='validRangeAppliesToCalibrated'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ValidFloatRangeSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ValidRange_ in self.ValidRange:
            namespaceprefix_ = self.ValidRange_nsprefix_ + ':' if (UseCapturedNS_ and self.ValidRange_nsprefix_) else ''
            ValidRange_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValidRange',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('validRangeAppliesToCalibrated', node)
        if value is not None and 'validRangeAppliesToCalibrated' not in already_processed:
            already_processed.add('validRangeAppliesToCalibrated')
            if value in ('true', '1'):
                self.validRangeAppliesToCalibrated = True
            elif value in ('false', '0'):
                self.validRangeAppliesToCalibrated = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ValidRange':
            class_obj_ = self.get_class_obj_(child_, FloatRangeType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValidRange.append(obj_)
            obj_.original_tagname_ = 'ValidRange'


# end class ValidFloatRangeSetType


class ValidIntegerRangeSetType(GeneratedsSuper):
    """Numerical ranges that define the universe of valid values for this
    argument. A single range is the most common, although it is possible to
    define multiple ranges when the valid values are not contiguous.By
    default and general recommendation, the valid range is specified in
    engineering/calibrated values, although this can be adjusted."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, validRangeAppliesToCalibrated=True, ValidRange=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.validRangeAppliesToCalibrated = _cast(bool, validRangeAppliesToCalibrated)
        self.validRangeAppliesToCalibrated_nsprefix_ = None
        if ValidRange is None:
            self.ValidRange = []
        else:
            self.ValidRange = ValidRange
        self.ValidRange_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValidIntegerRangeSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValidIntegerRangeSetType.subclass:
            return ValidIntegerRangeSetType.subclass(*args_, **kwargs_)
        else:
            return ValidIntegerRangeSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ValidRange(self):
        return self.ValidRange

    def set_ValidRange(self, ValidRange):
        self.ValidRange = ValidRange

    def add_ValidRange(self, value):
        self.ValidRange.append(value)

    def insert_ValidRange_at(self, index, value):
        self.ValidRange.insert(index, value)

    def replace_ValidRange_at(self, index, value):
        self.ValidRange[index] = value

    def get_validRangeAppliesToCalibrated(self):
        return self.validRangeAppliesToCalibrated

    def set_validRangeAppliesToCalibrated(self, validRangeAppliesToCalibrated):
        self.validRangeAppliesToCalibrated = validRangeAppliesToCalibrated

    def hasContent_(self):
        if (
                self.ValidRange
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ValidIntegerRangeSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ValidIntegerRangeSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ValidIntegerRangeSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ValidIntegerRangeSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ValidIntegerRangeSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ValidIntegerRangeSetType'):
        if not self.validRangeAppliesToCalibrated and 'validRangeAppliesToCalibrated' not in already_processed:
            already_processed.add('validRangeAppliesToCalibrated')
            outfile.write(
                ' validRangeAppliesToCalibrated="%s"' % self.gds_format_boolean(self.validRangeAppliesToCalibrated,
                                                                                input_name='validRangeAppliesToCalibrated'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ValidIntegerRangeSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ValidRange_ in self.ValidRange:
            namespaceprefix_ = self.ValidRange_nsprefix_ + ':' if (UseCapturedNS_ and self.ValidRange_nsprefix_) else ''
            ValidRange_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValidRange',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('validRangeAppliesToCalibrated', node)
        if value is not None and 'validRangeAppliesToCalibrated' not in already_processed:
            already_processed.add('validRangeAppliesToCalibrated')
            if value in ('true', '1'):
                self.validRangeAppliesToCalibrated = True
            elif value in ('false', '0'):
                self.validRangeAppliesToCalibrated = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ValidRange':
            class_obj_ = self.get_class_obj_(child_, IntegerRangeType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValidRange.append(obj_)
            obj_.original_tagname_ = 'ValidRange'


# end class ValidIntegerRangeSetType


class ByteType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, byteSignificance=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.byteSignificance = _cast(int, byteSignificance)
        self.byteSignificance_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ByteType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ByteType.subclass:
            return ByteType.subclass(*args_, **kwargs_)
        else:
            return ByteType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_byteSignificance(self):
        return self.byteSignificance

    def set_byteSignificance(self, byteSignificance):
        self.byteSignificance = byteSignificance

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ByteType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ByteType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ByteType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ByteType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ByteType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ByteType'):
        if self.byteSignificance is not None and 'byteSignificance' not in already_processed:
            already_processed.add('byteSignificance')
            outfile.write(' byteSignificance="%s"' % self.gds_format_integer(self.byteSignificance,
                                                                             input_name='byteSignificance'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ByteType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('byteSignificance', node)
        if value is not None and 'byteSignificance' not in already_processed:
            already_processed.add('byteSignificance')
            self.byteSignificance = self.gds_parse_integer(value, node, 'byteSignificance')
            self.validate_NonNegativeLongType(self.byteSignificance)  # validate type NonNegativeLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ByteType


class CRCType(GeneratedsSuper):
    """Cyclic Redundancy Check (CRC) definition. The polynomial coefficients
    for the CRC
    are defined as a truncated hex value. The coefficient for the nth bit of an
    n-bit CRC will always be 1 and is not
    represented in the truncated hex value. For example, the truncated hex
    value of CRC-32 (width=32 bits) used in the
    Ethernet specification is 0x04C11DB7, where each non-zero bit of the
    truncated hex represents a coefficient of 1 in
    the polynomial and the bit position represents the exponent. There may also
    be an initial remainder "InitRemainder"
    and a final XOR "FinalXOR" to fully specify the CRC. reflectData and
    reflectRemainder may also be specified to
    reverse the bit order in the incoming data and/or the result."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, width=None, reflectData=False, reflectRemainder=False, bitsFromReference=None, reference='start',
                 Polynomial=None, InitRemainder=None, FinalXOR=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.width = _cast(int, width)
        self.width_nsprefix_ = None
        self.reflectData = _cast(bool, reflectData)
        self.reflectData_nsprefix_ = None
        self.reflectRemainder = _cast(bool, reflectRemainder)
        self.reflectRemainder_nsprefix_ = None
        self.bitsFromReference = _cast(int, bitsFromReference)
        self.bitsFromReference_nsprefix_ = None
        self.reference = _cast(None, reference)
        self.reference_nsprefix_ = None
        self.Polynomial = Polynomial
        self.Polynomial_nsprefix_ = None
        self.InitRemainder = InitRemainder
        self.InitRemainder_nsprefix_ = None
        self.FinalXOR = FinalXOR
        self.FinalXOR_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CRCType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CRCType.subclass:
            return CRCType.subclass(*args_, **kwargs_)
        else:
            return CRCType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Polynomial(self):
        return self.Polynomial

    def set_Polynomial(self, Polynomial):
        self.Polynomial = Polynomial

    def get_InitRemainder(self):
        return self.InitRemainder

    def set_InitRemainder(self, InitRemainder):
        self.InitRemainder = InitRemainder

    def get_FinalXOR(self):
        return self.FinalXOR

    def set_FinalXOR(self, FinalXOR):
        self.FinalXOR = FinalXOR

    def get_width(self):
        return self.width

    def set_width(self, width):
        self.width = width

    def get_reflectData(self):
        return self.reflectData

    def set_reflectData(self, reflectData):
        self.reflectData = reflectData

    def get_reflectRemainder(self):
        return self.reflectRemainder

    def set_reflectRemainder(self, reflectRemainder):
        self.reflectRemainder = reflectRemainder

    def get_bitsFromReference(self):
        return self.bitsFromReference

    def set_bitsFromReference(self, bitsFromReference):
        self.bitsFromReference = bitsFromReference

    def get_reference(self):
        return self.reference

    def set_reference(self, reference):
        self.reference = reference

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_ReferencePointType(self, value):
        # Validate type xtce:ReferencePointType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['start', 'end']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ReferencePointType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Polynomial is not None or
                self.InitRemainder is not None or
                self.FinalXOR is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='CRCType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CRCType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CRCType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CRCType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CRCType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CRCType'):
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            outfile.write(' width="%s"' % self.gds_format_integer(self.width, input_name='width'))
        if self.reflectData and 'reflectData' not in already_processed:
            already_processed.add('reflectData')
            outfile.write(' reflectData="%s"' % self.gds_format_boolean(self.reflectData, input_name='reflectData'))
        if self.reflectRemainder and 'reflectRemainder' not in already_processed:
            already_processed.add('reflectRemainder')
            outfile.write(' reflectRemainder="%s"' % self.gds_format_boolean(self.reflectRemainder,
                                                                             input_name='reflectRemainder'))
        if self.bitsFromReference is not None and 'bitsFromReference' not in already_processed:
            already_processed.add('bitsFromReference')
            outfile.write(' bitsFromReference="%s"' % self.gds_format_integer(self.bitsFromReference,
                                                                              input_name='bitsFromReference'))
        if self.reference != "start" and 'reference' not in already_processed:
            already_processed.add('reference')
            outfile.write(' reference=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.reference), input_name='reference')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='CRCType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Polynomial is not None:
            namespaceprefix_ = self.Polynomial_nsprefix_ + ':' if (UseCapturedNS_ and self.Polynomial_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPolynomial>%s</%sPolynomial>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.Polynomial), input_name='Polynomial')), namespaceprefix_, eol_))
        if self.InitRemainder is not None:
            namespaceprefix_ = self.InitRemainder_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InitRemainder_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInitRemainder>%s</%sInitRemainder>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.InitRemainder), input_name='InitRemainder')), namespaceprefix_,
                                                                       eol_))
        if self.FinalXOR is not None:
            namespaceprefix_ = self.FinalXOR_nsprefix_ + ':' if (UseCapturedNS_ and self.FinalXOR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFinalXOR>%s</%sFinalXOR>%s' % (
            namespaceprefix_, self.gds_encode(self.gds_format_string(quote_xml(self.FinalXOR), input_name='FinalXOR')),
            namespaceprefix_, eol_))

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('width', node)
        if value is not None and 'width' not in already_processed:
            already_processed.add('width')
            self.width = self.gds_parse_integer(value, node, 'width')
            self.validate_PositiveLongType(self.width)  # validate type PositiveLongType
        value = find_attr_value_('reflectData', node)
        if value is not None and 'reflectData' not in already_processed:
            already_processed.add('reflectData')
            if value in ('true', '1'):
                self.reflectData = True
            elif value in ('false', '0'):
                self.reflectData = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('reflectRemainder', node)
        if value is not None and 'reflectRemainder' not in already_processed:
            already_processed.add('reflectRemainder')
            if value in ('true', '1'):
                self.reflectRemainder = True
            elif value in ('false', '0'):
                self.reflectRemainder = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('bitsFromReference', node)
        if value is not None and 'bitsFromReference' not in already_processed:
            already_processed.add('bitsFromReference')
            self.bitsFromReference = self.gds_parse_integer(value, node, 'bitsFromReference')
            self.validate_NonNegativeLongType(self.bitsFromReference)  # validate type NonNegativeLongType
        value = find_attr_value_('reference', node)
        if value is not None and 'reference' not in already_processed:
            already_processed.add('reference')
            self.reference = value
            self.validate_ReferencePointType(self.reference)  # validate type ReferencePointType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Polynomial':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Polynomial')
            value_ = self.gds_validate_string(value_, node, 'Polynomial')
            self.Polynomial = value_
            self.Polynomial_nsprefix_ = child_.prefix
        elif nodeName_ == 'InitRemainder':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InitRemainder')
            value_ = self.gds_validate_string(value_, node, 'InitRemainder')
            self.InitRemainder = value_
            self.InitRemainder_nsprefix_ = child_.prefix
        elif nodeName_ == 'FinalXOR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FinalXOR')
            value_ = self.gds_validate_string(value_, node, 'FinalXOR')
            self.FinalXOR = value_
            self.FinalXOR_nsprefix_ = child_.prefix


# end class CRCType


class DataEncodingType(GeneratedsSuper):
    """Describes how a particular piece of data is sent or received from some
    non-native, off-platform device. (e.g. a spacecraft)"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, bitOrder='mostSignificantBitFirst', byteOrder='mostSignificantByteFirst',
                 ErrorDetectCorrect=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.bitOrder = _cast(None, bitOrder)
        self.bitOrder_nsprefix_ = None
        self.byteOrder = _cast(None, byteOrder)
        self.byteOrder_nsprefix_ = None
        self.ErrorDetectCorrect = ErrorDetectCorrect
        self.ErrorDetectCorrect_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DataEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DataEncodingType.subclass:
            return DataEncodingType.subclass(*args_, **kwargs_)
        else:
            return DataEncodingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ErrorDetectCorrect(self):
        return self.ErrorDetectCorrect

    def set_ErrorDetectCorrect(self, ErrorDetectCorrect):
        self.ErrorDetectCorrect = ErrorDetectCorrect

    def get_bitOrder(self):
        return self.bitOrder

    def set_bitOrder(self, bitOrder):
        self.bitOrder = bitOrder

    def get_byteOrder(self):
        return self.byteOrder

    def set_byteOrder(self, byteOrder):
        self.byteOrder = byteOrder

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_BitOrderType(self, value):
        # Validate type xtce:BitOrderType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['leastSignificantBitFirst', 'mostSignificantBitFirst']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BitOrderType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_ByteOrderType(self, value):
        # Validate type xtce:ByteOrderType, a restriction on None.
        pass

    def hasContent_(self):
        if (
                self.ErrorDetectCorrect is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DataEncodingType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DataEncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DataEncodingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DataEncodingType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DataEncodingType'):
        if self.bitOrder != "mostSignificantBitFirst" and 'bitOrder' not in already_processed:
            already_processed.add('bitOrder')
            outfile.write(' bitOrder=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.bitOrder), input_name='bitOrder')),))
        if self.byteOrder != "mostSignificantByteFirst" and 'byteOrder' not in already_processed:
            already_processed.add('byteOrder')
            outfile.write(' byteOrder=%s' % (quote_attrib(self.byteOrder),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DataEncodingType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ErrorDetectCorrect is not None:
            namespaceprefix_ = self.ErrorDetectCorrect_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ErrorDetectCorrect_nsprefix_) else ''
            self.ErrorDetectCorrect.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='ErrorDetectCorrect', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('bitOrder', node)
        if value is not None and 'bitOrder' not in already_processed:
            already_processed.add('bitOrder')
            self.bitOrder = value
            self.validate_BitOrderType(self.bitOrder)  # validate type BitOrderType
        value = find_attr_value_('byteOrder', node)
        if value is not None and 'byteOrder' not in already_processed:
            already_processed.add('byteOrder')
            self.byteOrder = value
            self.validate_ByteOrderType(self.byteOrder)  # validate type ByteOrderType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ErrorDetectCorrect':
            obj_ = ErrorDetectCorrectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ErrorDetectCorrect = obj_
            obj_.original_tagname_ = 'ErrorDetectCorrect'


# end class DataEncodingType


class EncodingType(GeneratedsSuper):
    """Describe the data encoding for a time data type. It includes the units
    and other attributes scale and offset. Use scale and offset to describe
    a y=mx+b relationship (where m is the slope/scale and b is the
    intercept/offset) to make adjustments to the encoded time value so that
    it matches the time units. For binary encoded time use transform
    algorithms to convert time data formats that are too difficult to
    describe in XTCE. See AbsoluteTimeDataType and
    RelativeTimeDataType.Time units, with the default being in
    seconds.Linear slope used as a shorter form of specifying a calibrator
    to convert between the raw value and the engineering units.Linear
    intercept used as a shorter form of specifying a calibrator to convert
    between the raw value and the engineering units."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, units='seconds', scale=1, offset=0, BinaryDataEncoding=None, FloatDataEncoding=None,
                 IntegerDataEncoding=None, StringDataEncoding=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.scale = _cast(float, scale)
        self.scale_nsprefix_ = None
        self.offset = _cast(float, offset)
        self.offset_nsprefix_ = None
        self.BinaryDataEncoding = BinaryDataEncoding
        self.BinaryDataEncoding_nsprefix_ = None
        self.FloatDataEncoding = FloatDataEncoding
        self.FloatDataEncoding_nsprefix_ = None
        self.IntegerDataEncoding = IntegerDataEncoding
        self.IntegerDataEncoding_nsprefix_ = None
        self.StringDataEncoding = StringDataEncoding
        self.StringDataEncoding_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EncodingType.subclass:
            return EncodingType.subclass(*args_, **kwargs_)
        else:
            return EncodingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_BinaryDataEncoding(self):
        return self.BinaryDataEncoding

    def set_BinaryDataEncoding(self, BinaryDataEncoding):
        self.BinaryDataEncoding = BinaryDataEncoding

    def get_FloatDataEncoding(self):
        return self.FloatDataEncoding

    def set_FloatDataEncoding(self, FloatDataEncoding):
        self.FloatDataEncoding = FloatDataEncoding

    def get_IntegerDataEncoding(self):
        return self.IntegerDataEncoding

    def set_IntegerDataEncoding(self, IntegerDataEncoding):
        self.IntegerDataEncoding = IntegerDataEncoding

    def get_StringDataEncoding(self):
        return self.StringDataEncoding

    def set_StringDataEncoding(self, StringDataEncoding):
        self.StringDataEncoding = StringDataEncoding

    def get_units(self):
        return self.units

    def set_units(self, units):
        self.units = units

    def get_scale(self):
        return self.scale

    def set_scale(self, scale):
        self.scale = scale

    def get_offset(self):
        return self.offset

    def set_offset(self, offset):
        self.offset = offset

    def validate_TimeUnitsType(self, value):
        # Validate type xtce:TimeUnitsType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['seconds', 'picoSeconds', 'days', 'months', 'years']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TimeUnitsType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.BinaryDataEncoding is not None or
                self.FloatDataEncoding is not None or
                self.IntegerDataEncoding is not None or
                self.StringDataEncoding is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='EncodingType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EncodingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='EncodingType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EncodingType'):
        if self.units != "seconds" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(
                ' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')),))
        if self.scale != 1 and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale="%s"' % self.gds_format_double(self.scale, input_name='scale'))
        if self.offset != 0 and 'offset' not in already_processed:
            already_processed.add('offset')
            outfile.write(' offset="%s"' % self.gds_format_double(self.offset, input_name='offset'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='EncodingType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.BinaryDataEncoding is not None:
            namespaceprefix_ = self.BinaryDataEncoding_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.BinaryDataEncoding_nsprefix_) else ''
            self.BinaryDataEncoding.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='BinaryDataEncoding', pretty_print=pretty_print)
        if self.FloatDataEncoding is not None:
            namespaceprefix_ = self.FloatDataEncoding_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FloatDataEncoding_nsprefix_) else ''
            self.FloatDataEncoding.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FloatDataEncoding',
                                          pretty_print=pretty_print)
        if self.IntegerDataEncoding is not None:
            namespaceprefix_ = self.IntegerDataEncoding_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.IntegerDataEncoding_nsprefix_) else ''
            self.IntegerDataEncoding.export(outfile, level, namespaceprefix_, namespacedef_='',
                                            name_='IntegerDataEncoding', pretty_print=pretty_print)
        if self.StringDataEncoding is not None:
            namespaceprefix_ = self.StringDataEncoding_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.StringDataEncoding_nsprefix_) else ''
            self.StringDataEncoding.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='StringDataEncoding', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.validate_TimeUnitsType(self.units)  # validate type TimeUnitsType
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            value = self.gds_parse_double(value, node, 'scale')
            self.scale = value
        value = find_attr_value_('offset', node)
        if value is not None and 'offset' not in already_processed:
            already_processed.add('offset')
            value = self.gds_parse_double(value, node, 'offset')
            self.offset = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'BinaryDataEncoding':
            obj_ = BinaryDataEncodingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BinaryDataEncoding = obj_
            obj_.original_tagname_ = 'BinaryDataEncoding'
        elif nodeName_ == 'FloatDataEncoding':
            obj_ = FloatDataEncodingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FloatDataEncoding = obj_
            obj_.original_tagname_ = 'FloatDataEncoding'
        elif nodeName_ == 'IntegerDataEncoding':
            obj_ = IntegerDataEncodingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IntegerDataEncoding = obj_
            obj_.original_tagname_ = 'IntegerDataEncoding'
        elif nodeName_ == 'StringDataEncoding':
            obj_ = StringDataEncodingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StringDataEncoding = obj_
            obj_.original_tagname_ = 'StringDataEncoding'


# end class EncodingType


class FloatDataEncodingType(DataEncodingType):
    """For common encodings of floating point dataSpecifies real/decimal
    numeric value to raw encoding method, with the default being
    "IEEE754_1985".Number of bits to use for the float raw encoding method,
    with 32 being the default. Not every number of bits is valid for each
    encoding method.A changeThreshold may optionally be specified to inform
    systems of the minimum change in value that is significant. This is
    used by some systems to limit the telemetry processing and/or recording
    requirements. If the value is unspecified or zero, any change is
    significant."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = DataEncodingType

    def __init__(self, bitOrder='mostSignificantBitFirst', byteOrder='mostSignificantByteFirst',
                 ErrorDetectCorrect=None, encoding='IEEE754_1985', sizeInBits='32', changeThreshold=None,
                 DefaultCalibrator=None, ContextCalibratorList=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(FloatDataEncodingType, self).__init__(bitOrder, byteOrder, ErrorDetectCorrect, **kwargs_)
        self.encoding = _cast(None, encoding)
        self.encoding_nsprefix_ = None
        self.sizeInBits = _cast(int, sizeInBits)
        self.sizeInBits_nsprefix_ = None
        self.changeThreshold = _cast(float, changeThreshold)
        self.changeThreshold_nsprefix_ = None
        self.DefaultCalibrator = DefaultCalibrator
        self.DefaultCalibrator_nsprefix_ = None
        self.ContextCalibratorList = ContextCalibratorList
        self.ContextCalibratorList_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FloatDataEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FloatDataEncodingType.subclass:
            return FloatDataEncodingType.subclass(*args_, **kwargs_)
        else:
            return FloatDataEncodingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_DefaultCalibrator(self):
        return self.DefaultCalibrator

    def set_DefaultCalibrator(self, DefaultCalibrator):
        self.DefaultCalibrator = DefaultCalibrator

    def get_ContextCalibratorList(self):
        return self.ContextCalibratorList

    def set_ContextCalibratorList(self, ContextCalibratorList):
        self.ContextCalibratorList = ContextCalibratorList

    def get_encoding(self):
        return self.encoding

    def set_encoding(self, encoding):
        self.encoding = encoding

    def get_sizeInBits(self):
        return self.sizeInBits

    def set_sizeInBits(self, sizeInBits):
        self.sizeInBits = sizeInBits

    def get_changeThreshold(self):
        return self.changeThreshold

    def set_changeThreshold(self, changeThreshold):
        self.changeThreshold = changeThreshold

    def validate_FloatEncodingType(self, value):
        # Validate type xtce:FloatEncodingType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['IEEE754_1985', 'IEEE754', 'MILSTD_1750A', 'DEC', 'IBM', 'TI']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on FloatEncodingType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_FloatEncodingSizeInBitsType(self, value):
        # Validate type xtce:FloatEncodingSizeInBitsType, a restriction on unsignedShort.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = [16, 32, 40, 48, 64, 80, 128]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on FloatEncodingSizeInBitsType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.DefaultCalibrator is not None or
                self.ContextCalibratorList is not None or
                super(FloatDataEncodingType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='FloatDataEncodingType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FloatDataEncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'FloatDataEncodingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='FloatDataEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='FloatDataEncodingType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='FloatDataEncodingType'):
        super(FloatDataEncodingType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                            name_='FloatDataEncodingType')
        if self.encoding != "IEEE754_1985" and 'encoding' not in already_processed:
            already_processed.add('encoding')
            outfile.write(' encoding=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.encoding), input_name='encoding')),))
        if self.sizeInBits != 32 and 'sizeInBits' not in already_processed:
            already_processed.add('sizeInBits')
            outfile.write(' sizeInBits="%s"' % self.gds_format_integer(self.sizeInBits, input_name='sizeInBits'))
        if self.changeThreshold is not None and 'changeThreshold' not in already_processed:
            already_processed.add('changeThreshold')
            outfile.write(
                ' changeThreshold="%s"' % self.gds_format_double(self.changeThreshold, input_name='changeThreshold'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='FloatDataEncodingType', fromsubclass_=False, pretty_print=True):
        super(FloatDataEncodingType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                          pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DefaultCalibrator is not None:
            namespaceprefix_ = self.DefaultCalibrator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DefaultCalibrator_nsprefix_) else ''
            self.DefaultCalibrator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DefaultCalibrator',
                                          pretty_print=pretty_print)
        if self.ContextCalibratorList is not None:
            namespaceprefix_ = self.ContextCalibratorList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextCalibratorList_nsprefix_) else ''
            self.ContextCalibratorList.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='ContextCalibratorList', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('encoding', node)
        if value is not None and 'encoding' not in already_processed:
            already_processed.add('encoding')
            self.encoding = value
            self.validate_FloatEncodingType(self.encoding)  # validate type FloatEncodingType
        value = find_attr_value_('sizeInBits', node)
        if value is not None and 'sizeInBits' not in already_processed:
            already_processed.add('sizeInBits')
            self.sizeInBits = self.gds_parse_integer(value, node, 'sizeInBits')
            self.validate_FloatEncodingSizeInBitsType(self.sizeInBits)  # validate type FloatEncodingSizeInBitsType
        value = find_attr_value_('changeThreshold', node)
        if value is not None and 'changeThreshold' not in already_processed:
            already_processed.add('changeThreshold')
            value = self.gds_parse_double(value, node, 'changeThreshold')
            self.changeThreshold = value
        super(FloatDataEncodingType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DefaultCalibrator':
            obj_ = CalibratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DefaultCalibrator = obj_
            obj_.original_tagname_ = 'DefaultCalibrator'
        elif nodeName_ == 'ContextCalibratorList':
            obj_ = ContextCalibratorListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextCalibratorList = obj_
            obj_.original_tagname_ = 'ContextCalibratorList'
        super(FloatDataEncodingType, self).buildChildren(child_, node, nodeName_, True)


# end class FloatDataEncodingType


class IntegerDataEncodingType(DataEncodingType):
    """For all major encodings of integer dataSpecifies integer numeric value
    to raw encoding method, with the default being "unsigned".Number of
    bits to use for the raw encoding, with 8 being the default.A
    changeThreshold may optionally be specified to inform systems of the
    minimum change in value that is significant. This is used by some
    systems to limit the telemetry processing and/or recording
    requirements, such as for an analog-to-digital converter that dithers
    in the least significant bit. If the value is unspecified or zero, any
    change is significant."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = DataEncodingType

    def __init__(self, bitOrder='mostSignificantBitFirst', byteOrder='mostSignificantByteFirst',
                 ErrorDetectCorrect=None, encoding='unsigned', sizeInBits='8', changeThreshold=None,
                 DefaultCalibrator=None, ContextCalibratorList=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(IntegerDataEncodingType, self).__init__(bitOrder, byteOrder, ErrorDetectCorrect, **kwargs_)
        self.encoding = _cast(None, encoding)
        self.encoding_nsprefix_ = None
        self.sizeInBits = _cast(int, sizeInBits)
        self.sizeInBits_nsprefix_ = None
        self.changeThreshold = _cast(int, changeThreshold)
        self.changeThreshold_nsprefix_ = None
        self.DefaultCalibrator = DefaultCalibrator
        self.DefaultCalibrator_nsprefix_ = None
        self.ContextCalibratorList = ContextCalibratorList
        self.ContextCalibratorList_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntegerDataEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntegerDataEncodingType.subclass:
            return IntegerDataEncodingType.subclass(*args_, **kwargs_)
        else:
            return IntegerDataEncodingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_DefaultCalibrator(self):
        return self.DefaultCalibrator

    def set_DefaultCalibrator(self, DefaultCalibrator):
        self.DefaultCalibrator = DefaultCalibrator

    def get_ContextCalibratorList(self):
        return self.ContextCalibratorList

    def set_ContextCalibratorList(self, ContextCalibratorList):
        self.ContextCalibratorList = ContextCalibratorList

    def get_encoding(self):
        return self.encoding

    def set_encoding(self, encoding):
        self.encoding = encoding

    def get_sizeInBits(self):
        return self.sizeInBits

    def set_sizeInBits(self, sizeInBits):
        self.sizeInBits = sizeInBits

    def get_changeThreshold(self):
        return self.changeThreshold

    def set_changeThreshold(self, changeThreshold):
        self.changeThreshold = changeThreshold

    def validate_IntegerEncodingType(self, value):
        # Validate type xtce:IntegerEncodingType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['unsigned', 'signMagnitude', 'twosComplement', 'onesComplement', 'BCD', 'packedBCD']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on IntegerEncodingType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.DefaultCalibrator is not None or
                self.ContextCalibratorList is not None or
                super(IntegerDataEncodingType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='IntegerDataEncodingType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IntegerDataEncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IntegerDataEncodingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IntegerDataEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IntegerDataEncodingType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IntegerDataEncodingType'):
        super(IntegerDataEncodingType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                              name_='IntegerDataEncodingType')
        if self.encoding != "unsigned" and 'encoding' not in already_processed:
            already_processed.add('encoding')
            outfile.write(' encoding=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.encoding), input_name='encoding')),))
        if self.sizeInBits != 8 and 'sizeInBits' not in already_processed:
            already_processed.add('sizeInBits')
            outfile.write(' sizeInBits="%s"' % self.gds_format_integer(self.sizeInBits, input_name='sizeInBits'))
        if self.changeThreshold is not None and 'changeThreshold' not in already_processed:
            already_processed.add('changeThreshold')
            outfile.write(
                ' changeThreshold="%s"' % self.gds_format_integer(self.changeThreshold, input_name='changeThreshold'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='IntegerDataEncodingType', fromsubclass_=False, pretty_print=True):
        super(IntegerDataEncodingType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_,
                                                            True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DefaultCalibrator is not None:
            namespaceprefix_ = self.DefaultCalibrator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DefaultCalibrator_nsprefix_) else ''
            self.DefaultCalibrator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DefaultCalibrator',
                                          pretty_print=pretty_print)
        if self.ContextCalibratorList is not None:
            namespaceprefix_ = self.ContextCalibratorList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextCalibratorList_nsprefix_) else ''
            self.ContextCalibratorList.export(outfile, level, namespaceprefix_, namespacedef_='',
                                              name_='ContextCalibratorList', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('encoding', node)
        if value is not None and 'encoding' not in already_processed:
            already_processed.add('encoding')
            self.encoding = value
            self.validate_IntegerEncodingType(self.encoding)  # validate type IntegerEncodingType
        value = find_attr_value_('sizeInBits', node)
        if value is not None and 'sizeInBits' not in already_processed:
            already_processed.add('sizeInBits')
            self.sizeInBits = self.gds_parse_integer(value, node, 'sizeInBits')
            self.validate_PositiveLongType(self.sizeInBits)  # validate type PositiveLongType
        value = find_attr_value_('changeThreshold', node)
        if value is not None and 'changeThreshold' not in already_processed:
            already_processed.add('changeThreshold')
            self.changeThreshold = self.gds_parse_integer(value, node, 'changeThreshold')
            self.validate_NonNegativeLongType(self.changeThreshold)  # validate type NonNegativeLongType
        super(IntegerDataEncodingType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DefaultCalibrator':
            obj_ = CalibratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DefaultCalibrator = obj_
            obj_.original_tagname_ = 'DefaultCalibrator'
        elif nodeName_ == 'ContextCalibratorList':
            obj_ = ContextCalibratorListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextCalibratorList = obj_
            obj_.original_tagname_ = 'ContextCalibratorList'
        super(IntegerDataEncodingType, self).buildChildren(child_, node, nodeName_, True)


# end class IntegerDataEncodingType


class LeadingSizeType(GeneratedsSuper):
    """Like PASCAL strings, the size of the string is given as an integer at
    the start of the string. SizeTag must be an unsigned Integer"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, sizeInBitsOfSizeTag='16', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.sizeInBitsOfSizeTag = _cast(int, sizeInBitsOfSizeTag)
        self.sizeInBitsOfSizeTag_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LeadingSizeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LeadingSizeType.subclass:
            return LeadingSizeType.subclass(*args_, **kwargs_)
        else:
            return LeadingSizeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_sizeInBitsOfSizeTag(self):
        return self.sizeInBitsOfSizeTag

    def set_sizeInBitsOfSizeTag(self, sizeInBitsOfSizeTag):
        self.sizeInBitsOfSizeTag = sizeInBitsOfSizeTag

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='LeadingSizeType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LeadingSizeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LeadingSizeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LeadingSizeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LeadingSizeType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LeadingSizeType'):
        if self.sizeInBitsOfSizeTag != 16 and 'sizeInBitsOfSizeTag' not in already_processed:
            already_processed.add('sizeInBitsOfSizeTag')
            outfile.write(' sizeInBitsOfSizeTag="%s"' % self.gds_format_integer(self.sizeInBitsOfSizeTag,
                                                                                input_name='sizeInBitsOfSizeTag'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='LeadingSizeType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sizeInBitsOfSizeTag', node)
        if value is not None and 'sizeInBitsOfSizeTag' not in already_processed:
            already_processed.add('sizeInBitsOfSizeTag')
            self.sizeInBitsOfSizeTag = self.gds_parse_integer(value, node, 'sizeInBitsOfSizeTag')
            self.validate_PositiveLongType(self.sizeInBitsOfSizeTag)  # validate type PositiveLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class LeadingSizeType


class ParityType(GeneratedsSuper):
    """Bit position starts with 'zero'."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, type_=None, bitsFromReference=None, reference='start', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.bitsFromReference = _cast(int, bitsFromReference)
        self.bitsFromReference_nsprefix_ = None
        self.reference = _cast(None, reference)
        self.reference_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParityType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParityType.subclass:
            return ParityType.subclass(*args_, **kwargs_)
        else:
            return ParityType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_bitsFromReference(self):
        return self.bitsFromReference

    def set_bitsFromReference(self, bitsFromReference):
        self.bitsFromReference = bitsFromReference

    def get_reference(self):
        return self.reference

    def set_reference(self, reference):
        self.reference = reference

    def validate_ParityFormType(self, value):
        # Validate type xtce:ParityFormType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Even', 'Odd']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParityFormType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_NonNegativeLongType(self, value):
        # Validate type xtce:NonNegativeLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on NonNegativeLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_ReferencePointType(self, value):
        # Validate type xtce:ReferencePointType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['start', 'end']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ReferencePointType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParityType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParityType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParityType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParityType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParityType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(
                ' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')),))
        if self.bitsFromReference is not None and 'bitsFromReference' not in already_processed:
            already_processed.add('bitsFromReference')
            outfile.write(' bitsFromReference="%s"' % self.gds_format_integer(self.bitsFromReference,
                                                                              input_name='bitsFromReference'))
        if self.reference != "start" and 'reference' not in already_processed:
            already_processed.add('reference')
            outfile.write(' reference=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.reference), input_name='reference')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ParityType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_ParityFormType(self.type_)  # validate type ParityFormType
        value = find_attr_value_('bitsFromReference', node)
        if value is not None and 'bitsFromReference' not in already_processed:
            already_processed.add('bitsFromReference')
            self.bitsFromReference = self.gds_parse_integer(value, node, 'bitsFromReference')
            self.validate_NonNegativeLongType(self.bitsFromReference)  # validate type NonNegativeLongType
        value = find_attr_value_('reference', node)
        if value is not None and 'reference' not in already_processed:
            already_processed.add('reference')
            self.reference = value
            self.validate_ReferencePointType(self.reference)  # validate type ReferencePointType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ParityType


class SizeInBitsType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Fixed=None, TerminationChar='00', LeadingSize=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Fixed = Fixed
        self.Fixed_nsprefix_ = None
        self.TerminationChar = TerminationChar
        self.TerminationChar_nsprefix_ = None
        self.LeadingSize = LeadingSize
        self.LeadingSize_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SizeInBitsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SizeInBitsType.subclass:
            return SizeInBitsType.subclass(*args_, **kwargs_)
        else:
            return SizeInBitsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Fixed(self):
        return self.Fixed

    def set_Fixed(self, Fixed):
        self.Fixed = Fixed

    def get_TerminationChar(self):
        return self.TerminationChar

    def set_TerminationChar(self, TerminationChar):
        self.TerminationChar = TerminationChar

    def get_LeadingSize(self):
        return self.LeadingSize

    def set_LeadingSize(self, LeadingSize):
        self.LeadingSize = LeadingSize

    def hasContent_(self):
        if (
                self.Fixed is not None or
                self.TerminationChar != "" or
                self.LeadingSize is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='SizeInBitsType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SizeInBitsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SizeInBitsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SizeInBitsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SizeInBitsType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SizeInBitsType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='SizeInBitsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Fixed is not None:
            namespaceprefix_ = self.Fixed_nsprefix_ + ':' if (UseCapturedNS_ and self.Fixed_nsprefix_) else ''
            self.Fixed.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Fixed',
                              pretty_print=pretty_print)
        if self.TerminationChar != "":
            namespaceprefix_ = self.TerminationChar_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TerminationChar_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTerminationChar>%s</%sTerminationChar>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.TerminationChar), input_name='TerminationChar')),
                                                                           namespaceprefix_, eol_))
        if self.LeadingSize is not None:
            namespaceprefix_ = self.LeadingSize_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LeadingSize_nsprefix_) else ''
            self.LeadingSize.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LeadingSize',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Fixed':
            obj_ = FixedType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Fixed = obj_
            obj_.original_tagname_ = 'Fixed'
        elif nodeName_ == 'TerminationChar':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TerminationChar')
            value_ = self.gds_validate_string(value_, node, 'TerminationChar')
            self.TerminationChar = value_
            self.TerminationChar_nsprefix_ = child_.prefix
        elif nodeName_ == 'LeadingSize':
            obj_ = LeadingSizeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LeadingSize = obj_
            obj_.original_tagname_ = 'LeadingSize'


# end class SizeInBitsType


class ArgumentVariableStringType(GeneratedsSuper):
    """Identical to VariableStringType but supports argument instance
    references.The upper bound of the size of this string data type so that
    the implementation can reserve/allocate enough memory to capture all
    reported instances of the string."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, maxSizeInBits=None, DynamicValue=None, DiscreteLookupList=None, LeadingSize=None,
                 TerminationChar='00', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.maxSizeInBits = _cast(int, maxSizeInBits)
        self.maxSizeInBits_nsprefix_ = None
        self.DynamicValue = DynamicValue
        self.DynamicValue_nsprefix_ = None
        self.DiscreteLookupList = DiscreteLookupList
        self.DiscreteLookupList_nsprefix_ = None
        self.LeadingSize = LeadingSize
        self.LeadingSize_nsprefix_ = None
        self.TerminationChar = TerminationChar
        self.TerminationChar_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentVariableStringType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentVariableStringType.subclass:
            return ArgumentVariableStringType.subclass(*args_, **kwargs_)
        else:
            return ArgumentVariableStringType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_DynamicValue(self):
        return self.DynamicValue

    def set_DynamicValue(self, DynamicValue):
        self.DynamicValue = DynamicValue

    def get_DiscreteLookupList(self):
        return self.DiscreteLookupList

    def set_DiscreteLookupList(self, DiscreteLookupList):
        self.DiscreteLookupList = DiscreteLookupList

    def get_LeadingSize(self):
        return self.LeadingSize

    def set_LeadingSize(self, LeadingSize):
        self.LeadingSize = LeadingSize

    def get_TerminationChar(self):
        return self.TerminationChar

    def set_TerminationChar(self, TerminationChar):
        self.TerminationChar = TerminationChar

    def get_maxSizeInBits(self):
        return self.maxSizeInBits

    def set_maxSizeInBits(self, maxSizeInBits):
        self.maxSizeInBits = maxSizeInBits

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.DynamicValue is not None or
                self.DiscreteLookupList is not None or
                self.LeadingSize is not None or
                self.TerminationChar != ""
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='ArgumentVariableStringType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentVariableStringType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentVariableStringType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArgumentVariableStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArgumentVariableStringType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentVariableStringType'):
        if self.maxSizeInBits is not None and 'maxSizeInBits' not in already_processed:
            already_processed.add('maxSizeInBits')
            outfile.write(
                ' maxSizeInBits="%s"' % self.gds_format_integer(self.maxSizeInBits, input_name='maxSizeInBits'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='ArgumentVariableStringType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DynamicValue is not None:
            namespaceprefix_ = self.DynamicValue_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DynamicValue_nsprefix_) else ''
            self.DynamicValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DynamicValue',
                                     pretty_print=pretty_print)
        if self.DiscreteLookupList is not None:
            namespaceprefix_ = self.DiscreteLookupList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DiscreteLookupList_nsprefix_) else ''
            self.DiscreteLookupList.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='DiscreteLookupList', pretty_print=pretty_print)
        if self.LeadingSize is not None:
            namespaceprefix_ = self.LeadingSize_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LeadingSize_nsprefix_) else ''
            self.LeadingSize.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LeadingSize',
                                    pretty_print=pretty_print)
        if self.TerminationChar != "":
            namespaceprefix_ = self.TerminationChar_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TerminationChar_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTerminationChar>%s</%sTerminationChar>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.TerminationChar), input_name='TerminationChar')),
                                                                           namespaceprefix_, eol_))

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('maxSizeInBits', node)
        if value is not None and 'maxSizeInBits' not in already_processed:
            already_processed.add('maxSizeInBits')
            self.maxSizeInBits = self.gds_parse_integer(value, node, 'maxSizeInBits')
            self.validate_PositiveLongType(self.maxSizeInBits)  # validate type PositiveLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DynamicValue':
            obj_ = ArgumentDynamicValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DynamicValue = obj_
            obj_.original_tagname_ = 'DynamicValue'
        elif nodeName_ == 'DiscreteLookupList':
            obj_ = ArgumentDiscreteLookupListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DiscreteLookupList = obj_
            obj_.original_tagname_ = 'DiscreteLookupList'
        elif nodeName_ == 'LeadingSize':
            obj_ = LeadingSizeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LeadingSize = obj_
            obj_.original_tagname_ = 'LeadingSize'
        elif nodeName_ == 'TerminationChar':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TerminationChar')
            value_ = self.gds_validate_string(value_, node, 'TerminationChar')
            self.TerminationChar = value_
            self.TerminationChar_nsprefix_ = child_.prefix


# end class ArgumentVariableStringType


class VariableStringType(GeneratedsSuper):
    """Describe a variable string whose length may change between samples.The
    upper bound of the size of this string data type so that the
    implementation can reserve/allocate enough memory to capture all
    reported instances of the string."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, maxSizeInBits=None, DynamicValue=None, DiscreteLookupList=None, LeadingSize=None,
                 TerminationChar='00', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.maxSizeInBits = _cast(int, maxSizeInBits)
        self.maxSizeInBits_nsprefix_ = None
        self.DynamicValue = DynamicValue
        self.DynamicValue_nsprefix_ = None
        self.DiscreteLookupList = DiscreteLookupList
        self.DiscreteLookupList_nsprefix_ = None
        self.LeadingSize = LeadingSize
        self.LeadingSize_nsprefix_ = None
        self.TerminationChar = TerminationChar
        self.TerminationChar_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VariableStringType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VariableStringType.subclass:
            return VariableStringType.subclass(*args_, **kwargs_)
        else:
            return VariableStringType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_DynamicValue(self):
        return self.DynamicValue

    def set_DynamicValue(self, DynamicValue):
        self.DynamicValue = DynamicValue

    def get_DiscreteLookupList(self):
        return self.DiscreteLookupList

    def set_DiscreteLookupList(self, DiscreteLookupList):
        self.DiscreteLookupList = DiscreteLookupList

    def get_LeadingSize(self):
        return self.LeadingSize

    def set_LeadingSize(self, LeadingSize):
        self.LeadingSize = LeadingSize

    def get_TerminationChar(self):
        return self.TerminationChar

    def set_TerminationChar(self, TerminationChar):
        self.TerminationChar = TerminationChar

    def get_maxSizeInBits(self):
        return self.maxSizeInBits

    def set_maxSizeInBits(self, maxSizeInBits):
        self.maxSizeInBits = maxSizeInBits

    def validate_PositiveLongType(self, value):
        # Validate type xtce:PositiveLongType, a restriction on long.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on PositiveLongType' % {
                        "value": value, "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.DynamicValue is not None or
                self.DiscreteLookupList is not None or
                self.LeadingSize is not None or
                self.TerminationChar != ""
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='VariableStringType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VariableStringType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VariableStringType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VariableStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VariableStringType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VariableStringType'):
        if self.maxSizeInBits is not None and 'maxSizeInBits' not in already_processed:
            already_processed.add('maxSizeInBits')
            outfile.write(
                ' maxSizeInBits="%s"' % self.gds_format_integer(self.maxSizeInBits, input_name='maxSizeInBits'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='VariableStringType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DynamicValue is not None:
            namespaceprefix_ = self.DynamicValue_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DynamicValue_nsprefix_) else ''
            self.DynamicValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DynamicValue',
                                     pretty_print=pretty_print)
        if self.DiscreteLookupList is not None:
            namespaceprefix_ = self.DiscreteLookupList_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DiscreteLookupList_nsprefix_) else ''
            self.DiscreteLookupList.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='DiscreteLookupList', pretty_print=pretty_print)
        if self.LeadingSize is not None:
            namespaceprefix_ = self.LeadingSize_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LeadingSize_nsprefix_) else ''
            self.LeadingSize.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LeadingSize',
                                    pretty_print=pretty_print)
        if self.TerminationChar != "":
            namespaceprefix_ = self.TerminationChar_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.TerminationChar_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTerminationChar>%s</%sTerminationChar>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.TerminationChar), input_name='TerminationChar')),
                                                                           namespaceprefix_, eol_))

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('maxSizeInBits', node)
        if value is not None and 'maxSizeInBits' not in already_processed:
            already_processed.add('maxSizeInBits')
            self.maxSizeInBits = self.gds_parse_integer(value, node, 'maxSizeInBits')
            self.validate_PositiveLongType(self.maxSizeInBits)  # validate type PositiveLongType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DynamicValue':
            obj_ = DynamicValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DynamicValue = obj_
            obj_.original_tagname_ = 'DynamicValue'
        elif nodeName_ == 'DiscreteLookupList':
            obj_ = DiscreteLookupListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DiscreteLookupList = obj_
            obj_.original_tagname_ = 'DiscreteLookupList'
        elif nodeName_ == 'LeadingSize':
            obj_ = LeadingSizeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LeadingSize = obj_
            obj_.original_tagname_ = 'LeadingSize'
        elif nodeName_ == 'TerminationChar':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TerminationChar')
            value_ = self.gds_validate_string(value_, node, 'TerminationChar')
            self.TerminationChar = value_
            self.TerminationChar_nsprefix_ = child_.prefix


# end class VariableStringType


class ArgumentStringDataEncodingType(DataEncodingType):
    """Identical to StringDataEncodingType but supports argument instance
    references.The character set encoding of this string data type."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = DataEncodingType

    def __init__(self, bitOrder='mostSignificantBitFirst', byteOrder='mostSignificantByteFirst',
                 ErrorDetectCorrect=None, encoding='UTF-8', SizeInBits=None, Variable=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(ArgumentStringDataEncodingType, self).__init__(bitOrder, byteOrder, ErrorDetectCorrect, **kwargs_)
        self.encoding = _cast(None, encoding)
        self.encoding_nsprefix_ = None
        self.SizeInBits = SizeInBits
        self.SizeInBits_nsprefix_ = None
        self.Variable = Variable
        self.Variable_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArgumentStringDataEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArgumentStringDataEncodingType.subclass:
            return ArgumentStringDataEncodingType.subclass(*args_, **kwargs_)
        else:
            return ArgumentStringDataEncodingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SizeInBits(self):
        return self.SizeInBits

    def set_SizeInBits(self, SizeInBits):
        self.SizeInBits = SizeInBits

    def get_Variable(self):
        return self.Variable

    def set_Variable(self, Variable):
        self.Variable = Variable

    def get_encoding(self):
        return self.encoding

    def set_encoding(self, encoding):
        self.encoding = encoding

    def validate_StringEncodingType(self, value):
        # Validate type xtce:StringEncodingType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['US-ASCII', 'ISO-8859-1', 'Windows-1252', 'UTF-8', 'UTF-16', 'UTF-16LE', 'UTF-16BE',
                            'UTF-32', 'UTF-32LE', 'UTF-32BE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on StringEncodingType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.SizeInBits is not None or
                self.Variable is not None or
                super(ArgumentStringDataEncodingType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
               name_='ArgumentStringDataEncodingType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArgumentStringDataEncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArgumentStringDataEncodingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_,
                              name_='ArgumentStringDataEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_,
                                name_='ArgumentStringDataEncodingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='',
                         name_='ArgumentStringDataEncodingType'):
        super(ArgumentStringDataEncodingType, self).exportAttributes(outfile, level, already_processed,
                                                                     namespaceprefix_,
                                                                     name_='ArgumentStringDataEncodingType')
        if self.encoding != "UTF-8" and 'encoding' not in already_processed:
            already_processed.add('encoding')
            outfile.write(' encoding=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.encoding), input_name='encoding')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ArgumentStringDataEncodingType', fromsubclass_=False, pretty_print=True):
        super(ArgumentStringDataEncodingType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_,
                                                                   name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SizeInBits is not None:
            namespaceprefix_ = self.SizeInBits_nsprefix_ + ':' if (UseCapturedNS_ and self.SizeInBits_nsprefix_) else ''
            self.SizeInBits.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SizeInBits',
                                   pretty_print=pretty_print)
        if self.Variable is not None:
            namespaceprefix_ = self.Variable_nsprefix_ + ':' if (UseCapturedNS_ and self.Variable_nsprefix_) else ''
            self.Variable.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Variable',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('encoding', node)
        if value is not None and 'encoding' not in already_processed:
            already_processed.add('encoding')
            self.encoding = value
            self.validate_StringEncodingType(self.encoding)  # validate type StringEncodingType
        super(ArgumentStringDataEncodingType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SizeInBits':
            obj_ = SizeInBitsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SizeInBits = obj_
            obj_.original_tagname_ = 'SizeInBits'
        elif nodeName_ == 'Variable':
            obj_ = ArgumentVariableStringType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Variable = obj_
            obj_.original_tagname_ = 'Variable'
        super(ArgumentStringDataEncodingType, self).buildChildren(child_, node, nodeName_, True)


# end class ArgumentStringDataEncodingType


class StringDataEncodingType(DataEncodingType):
    """Describe common encodings of string data: UTF-8 and UTF-16. See
    StringDataType.The character set encoding of this string data type."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = DataEncodingType

    def __init__(self, bitOrder='mostSignificantBitFirst', byteOrder='mostSignificantByteFirst',
                 ErrorDetectCorrect=None, encoding='UTF-8', SizeInBits=None, Variable=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(StringDataEncodingType, self).__init__(bitOrder, byteOrder, ErrorDetectCorrect, **kwargs_)
        self.encoding = _cast(None, encoding)
        self.encoding_nsprefix_ = None
        self.SizeInBits = SizeInBits
        self.SizeInBits_nsprefix_ = None
        self.Variable = Variable
        self.Variable_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StringDataEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StringDataEncodingType.subclass:
            return StringDataEncodingType.subclass(*args_, **kwargs_)
        else:
            return StringDataEncodingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SizeInBits(self):
        return self.SizeInBits

    def set_SizeInBits(self, SizeInBits):
        self.SizeInBits = SizeInBits

    def get_Variable(self):
        return self.Variable

    def set_Variable(self, Variable):
        self.Variable = Variable

    def get_encoding(self):
        return self.encoding

    def set_encoding(self, encoding):
        self.encoding = encoding

    def validate_StringEncodingType(self, value):
        # Validate type xtce:StringEncodingType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['US-ASCII', 'ISO-8859-1', 'Windows-1252', 'UTF-8', 'UTF-16', 'UTF-16LE', 'UTF-16BE',
                            'UTF-32', 'UTF-32LE', 'UTF-32BE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on StringEncodingType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.SizeInBits is not None or
                self.Variable is not None or
                super(StringDataEncodingType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='StringDataEncodingType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('StringDataEncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'StringDataEncodingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='StringDataEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='StringDataEncodingType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='StringDataEncodingType'):
        super(StringDataEncodingType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                             name_='StringDataEncodingType')
        if self.encoding != "UTF-8" and 'encoding' not in already_processed:
            already_processed.add('encoding')
            outfile.write(' encoding=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.encoding), input_name='encoding')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='StringDataEncodingType', fromsubclass_=False, pretty_print=True):
        super(StringDataEncodingType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                           pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SizeInBits is not None:
            namespaceprefix_ = self.SizeInBits_nsprefix_ + ':' if (UseCapturedNS_ and self.SizeInBits_nsprefix_) else ''
            self.SizeInBits.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SizeInBits',
                                   pretty_print=pretty_print)
        if self.Variable is not None:
            namespaceprefix_ = self.Variable_nsprefix_ + ':' if (UseCapturedNS_ and self.Variable_nsprefix_) else ''
            self.Variable.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Variable',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('encoding', node)
        if value is not None and 'encoding' not in already_processed:
            already_processed.add('encoding')
            self.encoding = value
            self.validate_StringEncodingType(self.encoding)  # validate type StringEncodingType
        super(StringDataEncodingType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SizeInBits':
            obj_ = SizeInBitsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SizeInBits = obj_
            obj_.original_tagname_ = 'SizeInBits'
        elif nodeName_ == 'Variable':
            obj_ = VariableStringType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Variable = obj_
            obj_.original_tagname_ = 'Variable'
        super(StringDataEncodingType, self).buildChildren(child_, node, nodeName_, True)


# end class StringDataEncodingType


class ToStringType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, NumberFormat=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.NumberFormat = NumberFormat
        self.NumberFormat_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ToStringType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ToStringType.subclass:
            return ToStringType.subclass(*args_, **kwargs_)
        else:
            return ToStringType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_NumberFormat(self):
        return self.NumberFormat

    def set_NumberFormat(self, NumberFormat):
        self.NumberFormat = NumberFormat

    def hasContent_(self):
        if (
                self.NumberFormat is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ToStringType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ToStringType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ToStringType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ToStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ToStringType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ToStringType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ToStringType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NumberFormat is not None:
            namespaceprefix_ = self.NumberFormat_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.NumberFormat_nsprefix_) else ''
            self.NumberFormat.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NumberFormat',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'NumberFormat':
            obj_ = NumberFormatType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NumberFormat = obj_
            obj_.original_tagname_ = 'NumberFormat'


# end class ToStringType


class AlgorithmSetType(GeneratedsSuper):
    """An unordered collection of algorithms"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, CustomAlgorithm=None, MathAlgorithm=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CustomAlgorithm is None:
            self.CustomAlgorithm = []
        else:
            self.CustomAlgorithm = CustomAlgorithm
        self.CustomAlgorithm_nsprefix_ = None
        if MathAlgorithm is None:
            self.MathAlgorithm = []
        else:
            self.MathAlgorithm = MathAlgorithm
        self.MathAlgorithm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AlgorithmSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AlgorithmSetType.subclass:
            return AlgorithmSetType.subclass(*args_, **kwargs_)
        else:
            return AlgorithmSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_CustomAlgorithm(self):
        return self.CustomAlgorithm

    def set_CustomAlgorithm(self, CustomAlgorithm):
        self.CustomAlgorithm = CustomAlgorithm

    def add_CustomAlgorithm(self, value):
        self.CustomAlgorithm.append(value)

    def insert_CustomAlgorithm_at(self, index, value):
        self.CustomAlgorithm.insert(index, value)

    def replace_CustomAlgorithm_at(self, index, value):
        self.CustomAlgorithm[index] = value

    def get_MathAlgorithm(self):
        return self.MathAlgorithm

    def set_MathAlgorithm(self, MathAlgorithm):
        self.MathAlgorithm = MathAlgorithm

    def add_MathAlgorithm(self, value):
        self.MathAlgorithm.append(value)

    def insert_MathAlgorithm_at(self, index, value):
        self.MathAlgorithm.insert(index, value)

    def replace_MathAlgorithm_at(self, index, value):
        self.MathAlgorithm[index] = value

    def hasContent_(self):
        if (
                self.CustomAlgorithm or
                self.MathAlgorithm
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AlgorithmSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AlgorithmSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AlgorithmSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AlgorithmSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AlgorithmSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AlgorithmSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AlgorithmSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CustomAlgorithm_ in self.CustomAlgorithm:
            namespaceprefix_ = self.CustomAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CustomAlgorithm_nsprefix_) else ''
            CustomAlgorithm_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomAlgorithm',
                                    pretty_print=pretty_print)
        for MathAlgorithm_ in self.MathAlgorithm:
            namespaceprefix_ = self.MathAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.MathAlgorithm_nsprefix_) else ''
            MathAlgorithm_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MathAlgorithm',
                                  pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomAlgorithm':
            obj_ = InputOutputTriggerAlgorithmType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomAlgorithm.append(obj_)
            obj_.original_tagname_ = 'CustomAlgorithm'
        elif nodeName_ == 'MathAlgorithm':
            obj_ = MathAlgorithmType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MathAlgorithm.append(obj_)
            obj_.original_tagname_ = 'MathAlgorithm'


# end class AlgorithmSetType


class AliasSetType(GeneratedsSuper):
    """Contains an unordered collection of Alias elements to describe alternate
    names or IDs for this named item."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Alias=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Alias is None:
            self.Alias = []
        else:
            self.Alias = Alias
        self.Alias_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AliasSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AliasSetType.subclass:
            return AliasSetType.subclass(*args_, **kwargs_)
        else:
            return AliasSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Alias(self):
        return self.Alias

    def set_Alias(self, Alias):
        self.Alias = Alias

    def add_Alias(self, value):
        self.Alias.append(value)

    def insert_Alias_at(self, index, value):
        self.Alias.insert(index, value)

    def replace_Alias_at(self, index, value):
        self.Alias[index] = value

    def hasContent_(self):
        if (
                self.Alias
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AliasSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AliasSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AliasSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AliasSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AliasSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AliasSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AliasSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Alias_ in self.Alias:
            namespaceprefix_ = self.Alias_nsprefix_ + ':' if (UseCapturedNS_ and self.Alias_nsprefix_) else ''
            Alias_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Alias', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Alias':
            obj_ = AliasType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Alias.append(obj_)
            obj_.original_tagname_ = 'Alias'


# end class AliasSetType


class AliasType(GeneratedsSuper):
    """Used to contain an alias (alternate) name or ID for the object. For
    example, a parameter may have a mnemonic, an on-board id, and special
    IDs used by various ground software applications; all of these are
    alias's. Some ground system processing equipment has some severe naming
    restrictions on parameters (e.g., names must less then 12 characters,
    single case or integral id's only); their alias's provide a means of
    capturing each name in a "nameSpace". Note: the name is not reference-
    able (it cannot be used in a name reference substituting for the name
    of the item of interest). See NameDescriptionType.Aliases should be
    grouped together in a "namespace" so that they can be switched in and
    out of data extractions. The namespace generally identifies the purpose
    of the alternate name, whether for software variable names, additional
    operator names, or whatever the purpose.The alternate name or ID to
    use. The alias does not have the restrictions that apply to name
    attributes. This is useful for capturing legacy identifiers for systems
    with unusual naming conventions. It is also useful for capturing
    variable names in software, amongst other things."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, nameSpace=None, alias=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nameSpace = _cast(None, nameSpace)
        self.nameSpace_nsprefix_ = None
        self.alias = _cast(None, alias)
        self.alias_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AliasType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AliasType.subclass:
            return AliasType.subclass(*args_, **kwargs_)
        else:
            return AliasType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_nameSpace(self):
        return self.nameSpace

    def set_nameSpace(self, nameSpace):
        self.nameSpace = nameSpace

    def get_alias(self):
        return self.alias

    def set_alias(self, alias):
        self.alias = alias

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AliasType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AliasType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AliasType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AliasType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AliasType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AliasType'):
        if self.nameSpace is not None and 'nameSpace' not in already_processed:
            already_processed.add('nameSpace')
            outfile.write(' nameSpace=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.nameSpace), input_name='nameSpace')),))
        if self.alias is not None and 'alias' not in already_processed:
            already_processed.add('alias')
            outfile.write(
                ' alias=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.alias), input_name='alias')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AliasType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nameSpace', node)
        if value is not None and 'nameSpace' not in already_processed:
            already_processed.add('nameSpace')
            self.nameSpace = value
        value = find_attr_value_('alias', node)
        if value is not None and 'alias' not in already_processed:
            already_processed.add('alias')
            self.alias = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class AliasType


class AncillaryDataType(GeneratedsSuper):
    """Use for any other data associated with a named item. May be used to
    include administrative data (e.g., version, CM or tags) or potentially
    any MIME type. Data may be included or given as an href.Identifier for
    this Ancillary Data characteristic, feature, or data.Optional text
    encoding method for the element text content of this element. The
    default is "text/plain".Optional Uniform Resource Identifier for this
    characteristic, feature, or data."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, mimeType='text/plain', href=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.mimeType = _cast(None, mimeType)
        self.mimeType_nsprefix_ = None
        self.href = _cast(None, href)
        self.href_nsprefix_ = None
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AncillaryDataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AncillaryDataType.subclass:
            return AncillaryDataType.subclass(*args_, **kwargs_)
        else:
            return AncillaryDataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_mimeType(self):
        return self.mimeType

    def set_mimeType(self, mimeType):
        self.mimeType = mimeType

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AncillaryDataType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AncillaryDataType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AncillaryDataType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AncillaryDataType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AncillaryDataType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AncillaryDataType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.mimeType != "text/plain" and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            outfile.write(' mimeType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.mimeType), input_name='mimeType')),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(
                ' href=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.href), input_name='href')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AncillaryDataType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('mimeType', node)
        if value is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            self.mimeType = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class AncillaryDataType


class AncillaryDataSetType(GeneratedsSuper):
    """Describe an unordered collection of ancillary data. AncillaryData
    elements capture platform/program/implementation specific data about
    the parent element object that is non-standard and would not fit into
    the schema. See AncillaryDataType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, AncillaryData=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if AncillaryData is None:
            self.AncillaryData = []
        else:
            self.AncillaryData = AncillaryData
        self.AncillaryData_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AncillaryDataSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AncillaryDataSetType.subclass:
            return AncillaryDataSetType.subclass(*args_, **kwargs_)
        else:
            return AncillaryDataSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_AncillaryData(self):
        return self.AncillaryData

    def set_AncillaryData(self, AncillaryData):
        self.AncillaryData = AncillaryData

    def add_AncillaryData(self, value):
        self.AncillaryData.append(value)

    def insert_AncillaryData_at(self, index, value):
        self.AncillaryData.insert(index, value)

    def replace_AncillaryData_at(self, index, value):
        self.AncillaryData[index] = value

    def hasContent_(self):
        if (
                self.AncillaryData
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AncillaryDataSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AncillaryDataSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AncillaryDataSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AncillaryDataSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AncillaryDataSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AncillaryDataSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AncillaryDataSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AncillaryData_ in self.AncillaryData:
            namespaceprefix_ = self.AncillaryData_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AncillaryData_nsprefix_) else ''
            AncillaryData_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AncillaryData',
                                  pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AncillaryData':
            obj_ = AncillaryDataType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AncillaryData.append(obj_)
            obj_.original_tagname_ = 'AncillaryData'


# end class AncillaryDataSetType


class AuthorSetType(GeneratedsSuper):
    """Describe an unordered collection of authors. See AuthorType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Author=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Author is None:
            self.Author = []
        else:
            self.Author = Author
        self.Author_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AuthorSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AuthorSetType.subclass:
            return AuthorSetType.subclass(*args_, **kwargs_)
        else:
            return AuthorSetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Author(self):
        return self.Author

    def set_Author(self, Author):
        self.Author = Author

    def add_Author(self, value):
        self.Author.append(value)

    def insert_Author_at(self, index, value):
        self.Author.insert(index, value)

    def replace_Author_at(self, index, value):
        self.Author[index] = value

    def validate_AuthorType(self, value):
        result = True
        # Validate type AuthorType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass
        return result

    def hasContent_(self):
        if (
                self.Author
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AuthorSetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AuthorSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AuthorSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuthorSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AuthorSetType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AuthorSetType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='AuthorSetType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Author_ in self.Author:
            namespaceprefix_ = self.Author_nsprefix_ + ':' if (UseCapturedNS_ and self.Author_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAuthor>%s</%sAuthor>%s' % (
            namespaceprefix_, self.gds_encode(self.gds_format_string(quote_xml(Author_), input_name='Author')),
            namespaceprefix_, eol_))

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Author':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Author')
            value_ = self.gds_validate_string(value_, node, 'Author')
            self.Author.append(value_)
            self.Author_nsprefix_ = child_.prefix
            # validate type AuthorType
            self.validate_AuthorType(self.Author[-1])


# end class AuthorSetType


class BaseConditionsType(GeneratedsSuper):
    """A base type for boolean expression related elements that improves the
    mapping produced by data binding tools."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseConditionsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConditionsType.subclass:
            return BaseConditionsType.subclass(*args_, **kwargs_)
        else:
            return BaseConditionsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseConditionsType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BaseConditionsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BaseConditionsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BaseConditionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BaseConditionsType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BaseConditionsType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BaseConditionsType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class BaseConditionsType


class BooleanExpressionType(GeneratedsSuper):
    """Holds an arbitrarily complex boolean expression"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Condition=None, ANDedConditions=None, ORedConditions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Condition = Condition
        self.Condition_nsprefix_ = None
        self.ANDedConditions = ANDedConditions
        self.ANDedConditions_nsprefix_ = None
        self.ORedConditions = ORedConditions
        self.ORedConditions_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BooleanExpressionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BooleanExpressionType.subclass:
            return BooleanExpressionType.subclass(*args_, **kwargs_)
        else:
            return BooleanExpressionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Condition(self):
        return self.Condition

    def set_Condition(self, Condition):
        self.Condition = Condition

    def get_ANDedConditions(self):
        return self.ANDedConditions

    def set_ANDedConditions(self, ANDedConditions):
        self.ANDedConditions = ANDedConditions

    def get_ORedConditions(self):
        return self.ORedConditions

    def set_ORedConditions(self, ORedConditions):
        self.ORedConditions = ORedConditions

    def hasContent_(self):
        if (
                self.Condition is not None or
                self.ANDedConditions is not None or
                self.ORedConditions is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='BooleanExpressionType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BooleanExpressionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BooleanExpressionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BooleanExpressionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BooleanExpressionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BooleanExpressionType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='BooleanExpressionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Condition is not None:
            namespaceprefix_ = self.Condition_nsprefix_ + ':' if (UseCapturedNS_ and self.Condition_nsprefix_) else ''
            self.Condition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Condition',
                                  pretty_print=pretty_print)
        if self.ANDedConditions is not None:
            namespaceprefix_ = self.ANDedConditions_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ANDedConditions_nsprefix_) else ''
            self.ANDedConditions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ANDedConditions',
                                        pretty_print=pretty_print)
        if self.ORedConditions is not None:
            namespaceprefix_ = self.ORedConditions_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ORedConditions_nsprefix_) else ''
            self.ORedConditions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ORedConditions',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Condition':
            obj_ = ComparisonCheckType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Condition = obj_
            obj_.original_tagname_ = 'Condition'
        elif nodeName_ == 'ANDedConditions':
            obj_ = ANDedConditionsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ANDedConditions = obj_
            obj_.original_tagname_ = 'ANDedConditions'
        elif nodeName_ == 'ORedConditions':
            obj_ = ORedConditionsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ORedConditions = obj_
            obj_.original_tagname_ = 'ORedConditions'


# end class BooleanExpressionType


class ComparisonCheckType(BaseConditionsType):
    """Describe the comparison between the instance (value) of a parameter
    against either a specified value or another parameter instance."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseConditionsType

    def __init__(self, ComparisonOperator=None, ParameterInstanceRef=None, Value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(ComparisonCheckType, self).__init__(**kwargs_)
        self.ComparisonOperator = ComparisonOperator
        self.validate_ComparisonOperatorsType(self.ComparisonOperator)
        self.ComparisonOperator_nsprefix_ = None
        self.ParameterInstanceRef = ParameterInstanceRef
        self.ParameterInstanceRef_nsprefix_ = None
        self.Value = Value
        self.Value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ComparisonCheckType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComparisonCheckType.subclass:
            return ComparisonCheckType.subclass(*args_, **kwargs_)
        else:
            return ComparisonCheckType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ComparisonOperator(self):
        return self.ComparisonOperator

    def set_ComparisonOperator(self, ComparisonOperator):
        self.ComparisonOperator = ComparisonOperator

    def get_ParameterInstanceRef(self):
        return self.ParameterInstanceRef

    def set_ParameterInstanceRef(self, ParameterInstanceRef):
        self.ParameterInstanceRef = ParameterInstanceRef

    def get_Value(self):
        return self.Value

    def set_Value(self, Value):
        self.Value = Value

    def validate_ComparisonOperatorsType(self, value):
        result = True
        # Validate type ComparisonOperatorsType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['==', '!=', '<', '<=', '>', '>=']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ComparisonOperatorsType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False
        return result

    def hasContent_(self):
        if (
                self.ComparisonOperator is not None or
                self.ParameterInstanceRef is not None or
                self.Value is not None or
                super(ComparisonCheckType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='ComparisonCheckType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ComparisonCheckType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ComparisonCheckType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ComparisonCheckType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ComparisonCheckType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ComparisonCheckType'):
        super(ComparisonCheckType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                          name_='ComparisonCheckType')

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='ComparisonCheckType', fromsubclass_=False, pretty_print=True):
        super(ComparisonCheckType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                        pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ComparisonOperator is not None:
            namespaceprefix_ = self.ComparisonOperator_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ComparisonOperator_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sComparisonOperator>%s</%sComparisonOperator>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.ComparisonOperator), input_name='ComparisonOperator')),
                                                                                 namespaceprefix_, eol_))
        if self.ParameterInstanceRef is not None:
            namespaceprefix_ = self.ParameterInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterInstanceRef_nsprefix_) else ''
            self.ParameterInstanceRef.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ParameterInstanceRef', pretty_print=pretty_print)
        if self.Value is not None:
            namespaceprefix_ = self.Value_nsprefix_ + ':' if (UseCapturedNS_ and self.Value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (
            namespaceprefix_, self.gds_encode(self.gds_format_string(quote_xml(self.Value), input_name='Value')),
            namespaceprefix_, eol_))

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(ComparisonCheckType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ComparisonOperator':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ComparisonOperator')
            value_ = self.gds_validate_string(value_, node, 'ComparisonOperator')
            self.ComparisonOperator = value_
            self.ComparisonOperator_nsprefix_ = child_.prefix
            # validate type ComparisonOperatorsType
            self.validate_ComparisonOperatorsType(self.ComparisonOperator)
        elif nodeName_ == 'ParameterInstanceRef':
            class_obj_ = self.get_class_obj_(child_, ParameterInstanceRefType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterInstanceRef = obj_
            obj_.original_tagname_ = 'ParameterInstanceRef'
        elif nodeName_ == 'Value':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Value')
            value_ = self.gds_validate_string(value_, node, 'Value')
            self.Value = value_
            self.Value_nsprefix_ = child_.prefix
        super(ComparisonCheckType, self).buildChildren(child_, node, nodeName_, True)


# end class ComparisonCheckType


class ComparisonListType(GeneratedsSuper):
    """All comparisons must be true"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Comparison=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Comparison is None:
            self.Comparison = []
        else:
            self.Comparison = Comparison
        self.Comparison_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ComparisonListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComparisonListType.subclass:
            return ComparisonListType.subclass(*args_, **kwargs_)
        else:
            return ComparisonListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Comparison(self):
        return self.Comparison

    def set_Comparison(self, Comparison):
        self.Comparison = Comparison

    def add_Comparison(self, value):
        self.Comparison.append(value)

    def insert_Comparison_at(self, index, value):
        self.Comparison.insert(index, value)

    def replace_Comparison_at(self, index, value):
        self.Comparison[index] = value

    def hasContent_(self):
        if (
                self.Comparison
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ComparisonListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ComparisonListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ComparisonListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ComparisonListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ComparisonListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ComparisonListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ComparisonListType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Comparison_ in self.Comparison:
            namespaceprefix_ = self.Comparison_nsprefix_ + ':' if (UseCapturedNS_ and self.Comparison_nsprefix_) else ''
            Comparison_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Comparison',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Comparison':
            obj_ = ComparisonType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Comparison.append(obj_)
            obj_.original_tagname_ = 'Comparison'


# end class ComparisonListType


class ContextCalibratorType(GeneratedsSuper):
    """Context calibrations are applied when the ContextMatch is true. Context
    calibrators overide Default calibrators"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ContextMatch=None, Calibrator=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ContextMatch = ContextMatch
        self.ContextMatch_nsprefix_ = None
        self.Calibrator = Calibrator
        self.Calibrator_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContextCalibratorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContextCalibratorType.subclass:
            return ContextCalibratorType.subclass(*args_, **kwargs_)
        else:
            return ContextCalibratorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ContextMatch(self):
        return self.ContextMatch

    def set_ContextMatch(self, ContextMatch):
        self.ContextMatch = ContextMatch

    def get_Calibrator(self):
        return self.Calibrator

    def set_Calibrator(self, Calibrator):
        self.Calibrator = Calibrator

    def hasContent_(self):
        if (
                self.ContextMatch is not None or
                self.Calibrator is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ContextCalibratorType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContextCalibratorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContextCalibratorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContextCalibratorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContextCalibratorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContextCalibratorType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ContextCalibratorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ContextMatch is not None:
            namespaceprefix_ = self.ContextMatch_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ContextMatch_nsprefix_) else ''
            self.ContextMatch.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ContextMatch',
                                     pretty_print=pretty_print)
        if self.Calibrator is not None:
            namespaceprefix_ = self.Calibrator_nsprefix_ + ':' if (UseCapturedNS_ and self.Calibrator_nsprefix_) else ''
            self.Calibrator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Calibrator',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ContextMatch':
            obj_ = ContextMatchType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ContextMatch = obj_
            obj_.original_tagname_ = 'ContextMatch'
        elif nodeName_ == 'Calibrator':
            obj_ = CalibratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Calibrator = obj_
            obj_.original_tagname_ = 'Calibrator'


# end class ContextCalibratorType


class CustomAlarmType(BaseAlarmType):
    """Describe a custom, algorithmic alarm condition. The algorithm is assumed
    to return a boolean value: true or false. See AlarmType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = BaseAlarmType

    def __init__(self, name=None, shortDescription=None, AncillaryDataSet=None, InputAlgorithm=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(CustomAlarmType, self).__init__(name, shortDescription, AncillaryDataSet, **kwargs_)
        self.InputAlgorithm = InputAlgorithm
        self.InputAlgorithm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomAlarmType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomAlarmType.subclass:
            return CustomAlarmType.subclass(*args_, **kwargs_)
        else:
            return CustomAlarmType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_InputAlgorithm(self):
        return self.InputAlgorithm

    def set_InputAlgorithm(self, InputAlgorithm):
        self.InputAlgorithm = InputAlgorithm

    def hasContent_(self):
        if (
                self.InputAlgorithm is not None or
                super(CustomAlarmType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CustomAlarmType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomAlarmType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomAlarmType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomAlarmType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomAlarmType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomAlarmType'):
        super(CustomAlarmType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                      name_='CustomAlarmType')

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='CustomAlarmType',
                       fromsubclass_=False, pretty_print=True):
        super(CustomAlarmType, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                    pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.InputAlgorithm is not None:
            namespaceprefix_ = self.InputAlgorithm_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InputAlgorithm_nsprefix_) else ''
            self.InputAlgorithm.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InputAlgorithm',
                                       pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(CustomAlarmType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InputAlgorithm':
            class_obj_ = self.get_class_obj_(child_, InputAlgorithmType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InputAlgorithm = obj_
            obj_.original_tagname_ = 'InputAlgorithm'
        super(CustomAlarmType, self).buildChildren(child_, node, nodeName_, True)


# end class CustomAlarmType


class PercentCompleteType(GeneratedsSuper):
    """Describe a percentage complete that is fixed from 0 to 100, or as value
    from a parameter. See ExecutionVerifierType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, FixedValue=None, DynamicValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.FixedValue = FixedValue
        self.validate_FixedValueType(self.FixedValue)
        self.FixedValue_nsprefix_ = None
        self.DynamicValue = DynamicValue
        self.DynamicValue_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PercentCompleteType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PercentCompleteType.subclass:
            return PercentCompleteType.subclass(*args_, **kwargs_)
        else:
            return PercentCompleteType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_FixedValue(self):
        return self.FixedValue

    def set_FixedValue(self, FixedValue):
        self.FixedValue = FixedValue

    def get_DynamicValue(self):
        return self.DynamicValue

    def set_DynamicValue(self, DynamicValue):
        self.DynamicValue = DynamicValue

    def validate_FixedValueType(self, value):
        result = True
        # Validate type FixedValueType, a restriction on double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            if value < 0.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on FixedValueType' % {
                        "value": value, "lineno": lineno})
                result = False
            if value > 100.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on FixedValueType' % {
                        "value": value, "lineno": lineno})
                result = False
        return result

    def hasContent_(self):
        if (
                self.FixedValue is not None or
                self.DynamicValue is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
               name_='PercentCompleteType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PercentCompleteType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PercentCompleteType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PercentCompleteType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PercentCompleteType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PercentCompleteType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204" xmlns:None="http://www.w3.org/2001/XMLSchema" ',
                       name_='PercentCompleteType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.FixedValue is not None:
            namespaceprefix_ = self.FixedValue_nsprefix_ + ':' if (UseCapturedNS_ and self.FixedValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFixedValue>%s</%sFixedValue>%s' % (
            namespaceprefix_, self.gds_format_double(self.FixedValue, input_name='FixedValue'), namespaceprefix_, eol_))
        if self.DynamicValue is not None:
            namespaceprefix_ = self.DynamicValue_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DynamicValue_nsprefix_) else ''
            self.DynamicValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DynamicValue',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FixedValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'FixedValue')
            fval_ = self.gds_validate_double(fval_, node, 'FixedValue')
            self.FixedValue = fval_
            self.FixedValue_nsprefix_ = child_.prefix
            # validate type FixedValueType
            self.validate_FixedValueType(self.FixedValue)
        elif nodeName_ == 'DynamicValue':
            obj_ = DynamicValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DynamicValue = obj_
            obj_.original_tagname_ = 'DynamicValue'


# end class PercentCompleteType


class DescriptionType(GeneratedsSuper):
    """Defines an abstract schema type used as basis for NameDescriptionType
    and OptionalNameDescriptionType, includes an attribute for a short
    description and an element for a longer unbounded description. This
    type also provides alias set and ancillary data set See AliasSetType
    and AncillaryDataSetType.Optional short description to be used for
    explanation of this item. It is recommended that the short description
    be kept under 80 characters in length."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, shortDescription=None, LongDescription=None, AliasSet=None, AncillaryDataSet=None,
                 extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.shortDescription = _cast(None, shortDescription)
        self.shortDescription_nsprefix_ = None
        self.LongDescription = LongDescription
        self.validate_LongDescriptionType(self.LongDescription)
        self.LongDescription_nsprefix_ = None
        self.AliasSet = AliasSet
        self.AliasSet_nsprefix_ = None
        self.AncillaryDataSet = AncillaryDataSet
        self.AncillaryDataSet_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DescriptionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DescriptionType.subclass:
            return DescriptionType.subclass(*args_, **kwargs_)
        else:
            return DescriptionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_LongDescription(self):
        return self.LongDescription

    def set_LongDescription(self, LongDescription):
        self.LongDescription = LongDescription

    def get_AliasSet(self):
        return self.AliasSet

    def set_AliasSet(self, AliasSet):
        self.AliasSet = AliasSet

    def get_AncillaryDataSet(self):
        return self.AncillaryDataSet

    def set_AncillaryDataSet(self, AncillaryDataSet):
        self.AncillaryDataSet = AncillaryDataSet

    def get_shortDescription(self):
        return self.shortDescription

    def set_shortDescription(self, shortDescription):
        self.shortDescription = shortDescription

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_LongDescriptionType(self, value):
        result = True
        # Validate type LongDescriptionType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass
        return result

    def validate_ShortDescriptionType(self, value):
        # Validate type xtce:ShortDescriptionType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def hasContent_(self):
        if (
                self.LongDescription is not None or
                self.AliasSet is not None or
                self.AncillaryDataSet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DescriptionType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DescriptionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DescriptionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DescriptionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DescriptionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DescriptionType'):
        if self.shortDescription is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            outfile.write(' shortDescription=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.shortDescription), input_name='shortDescription')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DescriptionType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LongDescription is not None:
            namespaceprefix_ = self.LongDescription_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LongDescription_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLongDescription>%s</%sLongDescription>%s' % (namespaceprefix_, self.gds_encode(
                self.gds_format_string(quote_xml(self.LongDescription), input_name='LongDescription')),
                                                                           namespaceprefix_, eol_))
        if self.AliasSet is not None:
            namespaceprefix_ = self.AliasSet_nsprefix_ + ':' if (UseCapturedNS_ and self.AliasSet_nsprefix_) else ''
            self.AliasSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AliasSet',
                                 pretty_print=pretty_print)
        if self.AncillaryDataSet is not None:
            namespaceprefix_ = self.AncillaryDataSet_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AncillaryDataSet_nsprefix_) else ''
            self.AncillaryDataSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AncillaryDataSet',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('shortDescription', node)
        if value is not None and 'shortDescription' not in already_processed:
            already_processed.add('shortDescription')
            self.shortDescription = value
            self.validate_ShortDescriptionType(self.shortDescription)  # validate type ShortDescriptionType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LongDescription':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LongDescription')
            value_ = self.gds_validate_string(value_, node, 'LongDescription')
            self.LongDescription = value_
            self.LongDescription_nsprefix_ = child_.prefix
            # validate type LongDescriptionType
            self.validate_LongDescriptionType(self.LongDescription)
        elif nodeName_ == 'AliasSet':
            obj_ = AliasSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AliasSet = obj_
            obj_.original_tagname_ = 'AliasSet'
        elif nodeName_ == 'AncillaryDataSet':
            obj_ = AncillaryDataSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AncillaryDataSet = obj_
            obj_.original_tagname_ = 'AncillaryDataSet'


# end class DescriptionType


class DiscreteLookupListType(GeneratedsSuper):
    """Describe an ordered table of integer values and associated conditions,
    forming a lookup table. The list may have duplicates. The table is
    evaluated from first to last, the first condition to be true returns
    the value associated with it. See DiscreteLookupType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, DiscreteLookup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DiscreteLookup is None:
            self.DiscreteLookup = []
        else:
            self.DiscreteLookup = DiscreteLookup
        self.DiscreteLookup_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiscreteLookupListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiscreteLookupListType.subclass:
            return DiscreteLookupListType.subclass(*args_, **kwargs_)
        else:
            return DiscreteLookupListType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_DiscreteLookup(self):
        return self.DiscreteLookup

    def set_DiscreteLookup(self, DiscreteLookup):
        self.DiscreteLookup = DiscreteLookup

    def add_DiscreteLookup(self, value):
        self.DiscreteLookup.append(value)

    def insert_DiscreteLookup_at(self, index, value):
        self.DiscreteLookup.insert(index, value)

    def replace_DiscreteLookup_at(self, index, value):
        self.DiscreteLookup[index] = value

    def hasContent_(self):
        if (
                self.DiscreteLookup
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DiscreteLookupListType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DiscreteLookupListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DiscreteLookupListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DiscreteLookupListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DiscreteLookupListType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DiscreteLookupListType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='DiscreteLookupListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DiscreteLookup_ in self.DiscreteLookup:
            namespaceprefix_ = self.DiscreteLookup_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.DiscreteLookup_nsprefix_) else ''
            DiscreteLookup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DiscreteLookup',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DiscreteLookup':
            obj_ = DiscreteLookupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DiscreteLookup.append(obj_)
            obj_.original_tagname_ = 'DiscreteLookup'


# end class DiscreteLookupListType


class DynamicValueType(GeneratedsSuper):
    """Uses a parameter instance to obtain the value. The parameter value may
    be optionally adjusted by a Linear function or use a series of boolean
    expressions to lookup the value. Anything more complex and a
    DynamicValue with a CustomAlgorithm may be used"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, ParameterInstanceRef=None, LinearAdjustment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ParameterInstanceRef = ParameterInstanceRef
        self.ParameterInstanceRef_nsprefix_ = None
        self.LinearAdjustment = LinearAdjustment
        self.LinearAdjustment_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DynamicValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DynamicValueType.subclass:
            return DynamicValueType.subclass(*args_, **kwargs_)
        else:
            return DynamicValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ParameterInstanceRef(self):
        return self.ParameterInstanceRef

    def set_ParameterInstanceRef(self, ParameterInstanceRef):
        self.ParameterInstanceRef = ParameterInstanceRef

    def get_LinearAdjustment(self):
        return self.LinearAdjustment

    def set_LinearAdjustment(self, LinearAdjustment):
        self.LinearAdjustment = LinearAdjustment

    def hasContent_(self):
        if (
                self.ParameterInstanceRef is not None or
                self.LinearAdjustment is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DynamicValueType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DynamicValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DynamicValueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DynamicValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DynamicValueType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DynamicValueType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='DynamicValueType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ParameterInstanceRef is not None:
            namespaceprefix_ = self.ParameterInstanceRef_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ParameterInstanceRef_nsprefix_) else ''
            self.ParameterInstanceRef.export(outfile, level, namespaceprefix_, namespacedef_='',
                                             name_='ParameterInstanceRef', pretty_print=pretty_print)
        if self.LinearAdjustment is not None:
            namespaceprefix_ = self.LinearAdjustment_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LinearAdjustment_nsprefix_) else ''
            self.LinearAdjustment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LinearAdjustment',
                                         pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ParameterInstanceRef':
            class_obj_ = self.get_class_obj_(child_, ParameterInstanceRefType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ParameterInstanceRef = obj_
            obj_.original_tagname_ = 'ParameterInstanceRef'
        elif nodeName_ == 'LinearAdjustment':
            obj_ = LinearAdjustmentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LinearAdjustment = obj_
            obj_.original_tagname_ = 'LinearAdjustment'


# end class DynamicValueType


class ErrorDetectCorrectType(GeneratedsSuper):
    """Describe error detection/correction algorithm."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Checksum=None, CRC=None, Parity=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Checksum = Checksum
        self.Checksum_nsprefix_ = None
        self.CRC = CRC
        self.CRC_nsprefix_ = None
        self.Parity = Parity
        self.Parity_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ErrorDetectCorrectType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ErrorDetectCorrectType.subclass:
            return ErrorDetectCorrectType.subclass(*args_, **kwargs_)
        else:
            return ErrorDetectCorrectType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Checksum(self):
        return self.Checksum

    def set_Checksum(self, Checksum):
        self.Checksum = Checksum

    def get_CRC(self):
        return self.CRC

    def set_CRC(self, CRC):
        self.CRC = CRC

    def get_Parity(self):
        return self.Parity

    def set_Parity(self, Parity):
        self.Parity = Parity

    def hasContent_(self):
        if (
                self.Checksum is not None or
                self.CRC is not None or
                self.Parity is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='ErrorDetectCorrectType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ErrorDetectCorrectType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ErrorDetectCorrectType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ErrorDetectCorrectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ErrorDetectCorrectType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ErrorDetectCorrectType'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"',
                       name_='ErrorDetectCorrectType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Checksum is not None:
            namespaceprefix_ = self.Checksum_nsprefix_ + ':' if (UseCapturedNS_ and self.Checksum_nsprefix_) else ''
            self.Checksum.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Checksum',
                                 pretty_print=pretty_print)
        if self.CRC is not None:
            namespaceprefix_ = self.CRC_nsprefix_ + ':' if (UseCapturedNS_ and self.CRC_nsprefix_) else ''
            self.CRC.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CRC', pretty_print=pretty_print)
        if self.Parity is not None:
            namespaceprefix_ = self.Parity_nsprefix_ + ':' if (UseCapturedNS_ and self.Parity_nsprefix_) else ''
            self.Parity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parity',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Checksum':
            obj_ = ChecksumType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Checksum = obj_
            obj_.original_tagname_ = 'Checksum'
        elif nodeName_ == 'CRC':
            obj_ = CRCType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CRC = obj_
            obj_.original_tagname_ = 'CRC'
        elif nodeName_ == 'Parity':
            obj_ = ParityType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parity = obj_
            obj_.original_tagname_ = 'Parity'


# end class ErrorDetectCorrectType


class HeaderType(GeneratedsSuper):
    """Schema for a Header record. A header contains general information about
    the system or subsystem.This attribute contains an optional version
    descriptor for this document.This attribute contains an optional date
    to be associated with this document.This attribute contains optional
    classification status for use by programs for which that is
    applicable.This attribute contains an optional additional instructions
    attribute to be interpreted by programs that use this attribute.This
    attribute contains a flag describing the state of this document in the
    evolution of the project using it."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, version=None, date=None, classification='NotClassified', classificationInstructions=None,
                 validationStatus=None, AuthorSet=None, NoteSet=None, HistorySet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
        self.date = _cast(None, date)
        self.date_nsprefix_ = None
        self.classification = _cast(None, classification)
        self.classification_nsprefix_ = None
        self.classificationInstructions = _cast(None, classificationInstructions)
        self.classificationInstructions_nsprefix_ = None
        self.validationStatus = _cast(None, validationStatus)
        self.validationStatus_nsprefix_ = None
        self.AuthorSet = AuthorSet
        self.AuthorSet_nsprefix_ = None
        self.NoteSet = NoteSet
        self.NoteSet_nsprefix_ = None
        self.HistorySet = HistorySet
        self.HistorySet_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HeaderType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HeaderType.subclass:
            return HeaderType.subclass(*args_, **kwargs_)
        else:
            return HeaderType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_AuthorSet(self):
        return self.AuthorSet

    def set_AuthorSet(self, AuthorSet):
        self.AuthorSet = AuthorSet

    def get_NoteSet(self):
        return self.NoteSet

    def set_NoteSet(self, NoteSet):
        self.NoteSet = NoteSet

    def get_HistorySet(self):
        return self.HistorySet

    def set_HistorySet(self, HistorySet):
        self.HistorySet = HistorySet

    def get_version(self):
        return self.version

    def set_version(self, version):
        self.version = version

    def get_date(self):
        return self.date

    def set_date(self, date):
        self.date = date

    def get_classification(self):
        return self.classification

    def set_classification(self, classification):
        self.classification = classification

    def get_classificationInstructions(self):
        return self.classificationInstructions

    def set_classificationInstructions(self, classificationInstructions):
        self.classificationInstructions = classificationInstructions

    def get_validationStatus(self):
        return self.validationStatus

    def set_validationStatus(self, validationStatus):
        self.validationStatus = validationStatus

    def validate_ValidationStatusType(self, value):
        # Validate type xtce:ValidationStatusType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Unknown', 'Working', 'Draft', 'Test', 'Validated', 'Released', 'Withdrawn']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ValidationStatusType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.AuthorSet is not None or
                self.NoteSet is not None or
                self.HistorySet is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='HeaderType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HeaderType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HeaderType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='HeaderType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HeaderType'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')),))
        if self.date is not None and 'date' not in already_processed:
            already_processed.add('date')
            outfile.write(
                ' date=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.date), input_name='date')),))
        if self.classification != "NotClassified" and 'classification' not in already_processed:
            already_processed.add('classification')
            outfile.write(' classification=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.classification), input_name='classification')),))
        if self.classificationInstructions is not None and 'classificationInstructions' not in already_processed:
            already_processed.add('classificationInstructions')
            outfile.write(' classificationInstructions=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.classificationInstructions),
                                       input_name='classificationInstructions')),))
        if self.validationStatus is not None and 'validationStatus' not in already_processed:
            already_processed.add('validationStatus')
            outfile.write(' validationStatus=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.validationStatus), input_name='validationStatus')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='HeaderType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthorSet is not None:
            namespaceprefix_ = self.AuthorSet_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthorSet_nsprefix_) else ''
            self.AuthorSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthorSet',
                                  pretty_print=pretty_print)
        if self.NoteSet is not None:
            namespaceprefix_ = self.NoteSet_nsprefix_ + ':' if (UseCapturedNS_ and self.NoteSet_nsprefix_) else ''
            self.NoteSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NoteSet',
                                pretty_print=pretty_print)
        if self.HistorySet is not None:
            namespaceprefix_ = self.HistorySet_nsprefix_ + ':' if (UseCapturedNS_ and self.HistorySet_nsprefix_) else ''
            self.HistorySet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HistorySet',
                                   pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('date', node)
        if value is not None and 'date' not in already_processed:
            already_processed.add('date')
            self.date = value
        value = find_attr_value_('classification', node)
        if value is not None and 'classification' not in already_processed:
            already_processed.add('classification')
            self.classification = value
        value = find_attr_value_('classificationInstructions', node)
        if value is not None and 'classificationInstructions' not in already_processed:
            already_processed.add('classificationInstructions')
            self.classificationInstructions = value
        value = find_attr_value_('validationStatus', node)
        if value is not None and 'validationStatus' not in already_processed:
            already_processed.add('validationStatus')
            self.validationStatus = value
            self.validate_ValidationStatusType(self.validationStatus)  # validate type ValidationStatusType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthorSet':
            obj_ = AuthorSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthorSet = obj_
            obj_.original_tagname_ = 'AuthorSet'
        elif nodeName_ == 'NoteSet':
            obj_ = NoteSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NoteSet = obj_
            obj_.original_tagname_ = 'NoteSet'
        elif nodeName_ == 'HistorySet':
            obj_ = HistorySetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HistorySet = obj_
            obj_.original_tagname_ = 'HistorySet'


# end class HeaderType


class HistorySetType(GeneratedsSuper):
    """Describe an unordered collection of History elements. Usage is user
    defined. See HistoryType."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, History=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if History is None:
            self.History = []
        else:
            self.History = History
        self.History_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HistorySetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HistorySetType.subclass:
            return HistorySetType.subclass(*args_, **kwargs_)
        else:
            return HistorySetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_History(self):
        return self.History

    def set_History(self, History):
        self.History = History

    def add_History(self, value):
        self.History.append(value)

    def insert_History_at(self, index, value):
        self.History.insert(index, value)

    def replace_History_at(self, index, value):
        self.History[index] = value

    def validate_HistoryType(self, value):
        result = True
        # Validate type HistoryType, a restriction on string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass
        return result

    def hasContent_(self):
        if (
                self.History
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:xtce="http://www.omg.org/spec/XTCE/20180204"', name_='HistorySetType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HistorySetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HistorySetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HistorySetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfi