/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.results.data;

import com.github.viclovsky.swagger.coverage.core.model.OperationKey;
import com.github.viclovsky.swagger.coverage.core.results.data.ConditionCounter;
import com.github.viclovsky.swagger.coverage.core.results.data.CoverageCounter;
import com.github.viclovsky.swagger.coverage.core.results.data.CoverageState;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.HashSet;
import java.util.Set;

public class TagCoverage {
    private Tag tag;
    private Set<OperationKey> operations = new HashSet<OperationKey>();
    private CoverageCounter coverageCounter = new CoverageCounter();
    private ConditionCounter conditionCounter = new ConditionCounter();
    private long callCounts = 0L;
    private CoverageState state = CoverageState.EMPTY;

    public TagCoverage(Tag tag) {
        this.tag = tag;
    }

    public TagCoverage updateState() {
        this.state = this.conditionCounter.getCovered() == 0L ? CoverageState.EMPTY : (this.conditionCounter.getAll() == this.conditionCounter.getCovered() ? CoverageState.FULL : CoverageState.PARTY);
        return this;
    }

    public TagCoverage addOperation(OperationKey operation) {
        this.operations.add(operation);
        return this;
    }

    public TagCoverage updateCallCount(long callCounts) {
        this.callCounts += callCounts;
        return this;
    }

    public TagCoverage incrementByState(CoverageState state) {
        this.coverageCounter.incrementByState(state);
        return this;
    }

    public TagCoverage updateAllConditionCount(long count) {
        this.conditionCounter.updateAll(count);
        return this;
    }

    public TagCoverage updateCoveredConditionCount(long count) {
        this.conditionCounter.updateCovered(count);
        return this;
    }

    public Tag getTag() {
        return this.tag;
    }

    public TagCoverage setTag(Tag tag) {
        this.tag = tag;
        return this;
    }

    public CoverageCounter getCoverageCounter() {
        return this.coverageCounter;
    }

    public TagCoverage setCoverageCounter(CoverageCounter coverageCounter) {
        this.coverageCounter = coverageCounter;
        return this;
    }

    public Set<OperationKey> getOperations() {
        return this.operations;
    }

    public TagCoverage setOperations(Set<OperationKey> operations) {
        this.operations = operations;
        return this;
    }

    public ConditionCounter getConditionCounter() {
        return this.conditionCounter;
    }

    public TagCoverage setConditionCounter(ConditionCounter conditionCounter) {
        this.conditionCounter = conditionCounter;
        return this;
    }

    public long getCallCounts() {
        return this.callCounts;
    }

    public TagCoverage setCallCounts(long callCounts) {
        this.callCounts = callCounts;
        return this;
    }

    public CoverageState getState() {
        return this.state;
    }

    public TagCoverage setState(CoverageState state) {
        this.state = state;
        return this;
    }

    public String toString() {
        return "TagCoverage{tag='" + this.tag.getName() + '\'' + ", operations=" + this.operations.toString() + ", coverageCounter=" + this.coverageCounter.toString() + ", conditionCounter=" + this.conditionCounter.toString() + '}';
    }
}

