/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.results.builder.prebuilder;

import com.github.viclovsky.swagger.coverage.CommandLine;
import com.github.viclovsky.swagger.coverage.configuration.Configuration;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.results.builder.core.StatisticsPreBuilder;
import com.github.viclovsky.swagger.coverage.core.results.data.GenerationStatistics;
import com.github.viclovsky.swagger.coverage.core.results.util.DateTimeUtil;
import com.github.viclovsky.swagger.coverage.core.rule.core.ConditionRule;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationStatisticsBuilder
extends StatisticsPreBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLine.class);
    private long fileCounter = 0L;
    private FileTime minResultTime = null;
    private FileTime maxResultTime = null;
    private long startTime;

    @Override
    public GenerationStatisticsBuilder configure(OpenAPI swagger, List<ConditionRule> rules) {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    @Override
    public GenerationStatisticsBuilder add(String path) {
        Path file = Paths.get(path, new String[0]);
        ++this.fileCounter;
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            if (this.minResultTime == null || this.minResultTime.toMillis() > attr.lastModifiedTime().toMillis()) {
                this.minResultTime = attr.lastModifiedTime();
            }
            if (this.maxResultTime == null || this.maxResultTime.toMillis() < attr.lastModifiedTime().toMillis()) {
                this.maxResultTime = attr.lastModifiedTime();
            }
        }
        catch (IOException e) {
            LOGGER.error("can't read file attributes", (Throwable)e);
        }
        return this;
    }

    @Override
    public void build(Results results, Configuration configuration) {
        long duration = System.currentTimeMillis() - this.startTime;
        String resultDateDuration = DateTimeUtil.formatDate(this.minResultTime.toInstant()) + " - " + DateTimeUtil.formatDate(this.maxResultTime.toInstant());
        results.setGenerationStatistics(new GenerationStatistics().setResultFileCount(this.fileCounter).setGenerationTime(duration).setFileResultDateInterval(resultDateDuration).setGenerateDate(DateTimeUtil.formatDate(Instant.now())));
    }
}

