/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.predicate;

import com.github.viclovsky.swagger.coverage.core.predicate.ConditionPredicate;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Objects;
import java.util.Optional;

public abstract class PropertyConditionPredicate
extends ConditionPredicate {
    protected String mediaTypeName;
    protected String propertyName;

    public PropertyConditionPredicate(String mediaTypeName, String propertyName) {
        this.mediaTypeName = mediaTypeName;
        this.propertyName = propertyName;
    }

    @Override
    public boolean check(Operation operation) {
        if (operation.getRequestBody() == null || operation.getRequestBody().getContent() == null || operation.getRequestBody().getContent().isEmpty()) {
            return false;
        }
        Optional<Schema> schema = operation.getRequestBody().getContent().entrySet().stream().filter(o -> this.mediaTypeName.equals(o.getKey())).map(o -> ((MediaType)o.getValue()).getSchema()).filter(Objects::nonNull).flatMap(o -> o.getProperties().entrySet().stream()).filter(o -> this.propertyName.equals(o.getKey())).map(o -> (Schema)o.getValue()).findFirst();
        return this.check(schema);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getMediaTypeName() {
        return this.mediaTypeName;
    }

    public PropertyConditionPredicate setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public PropertyConditionPredicate setMediaTypeName(String mediaTypeName) {
        this.mediaTypeName = mediaTypeName;
        return this;
    }

    protected abstract boolean check(Optional<Schema> var1);
}

