/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.github.viclovsky.swagger.coverage.ExitCode;
import com.github.viclovsky.swagger.coverage.core.generator.Generator;
import com.github.viclovsky.swagger.coverage.option.MainOptions;
import com.github.viclovsky.swagger.coverage.option.VerboseOptions;
import java.util.Optional;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"swagger-coverage"}, commandDescription="Swagger-coverage Commandline")
public class CommandLine {
    @ParametersDelegate
    private MainOptions mainOptions = new MainOptions();
    @ParametersDelegate
    private VerboseOptions verboseOptions = new VerboseOptions();
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLine.class);
    private final JCommander commander = new JCommander((Object)this);

    public static void main(String[] argv) {
        CommandLine commandLine = new CommandLine();
        ExitCode exitCode = commandLine.parse(argv).orElseGet(commandLine::run);
        System.exit(exitCode.getCode());
    }

    public Optional<ExitCode> parse(String ... args) {
        if (args.length == 0) {
            this.printUsage(this.commander);
            return Optional.of(ExitCode.ARGUMENT_PARSING_ERROR);
        }
        try {
            this.commander.parse(args);
        }
        catch (ParameterException e) {
            LOGGER.debug("Error during arguments parsing: {}", (Throwable)e);
            LOGGER.info("Could not parse arguments: {}", (Object)e.getMessage());
            this.printUsage(this.commander);
            return Optional.of(ExitCode.ARGUMENT_PARSING_ERROR);
        }
        return Optional.empty();
    }

    private ExitCode run() {
        if (this.verboseOptions.isQuiet()) {
            LogManager.getRootLogger().setLevel(Level.OFF);
        }
        if (this.verboseOptions.isVerbose()) {
            LogManager.getRootLogger().setLevel(Level.DEBUG);
        }
        if (this.mainOptions.isHelp()) {
            this.printUsage(this.commander);
            return ExitCode.NO_ERROR;
        }
        new Generator().setInputPath(this.mainOptions.getInputPath()).setSpecPath(this.mainOptions.getSpecPath()).setConfigurationPath(this.mainOptions.getConfiguration()).run();
        return ExitCode.NO_ERROR;
    }

    private void printUsage(JCommander commander) {
        commander.usage();
    }
}

