# OpenSesame のヘルプ

*こちらはオフラインのヘルプページです。インターネットに接続されていれば、次のリンクからオンラインドキュメンテーションをご覧になることができます。<http://osdoc.cogsci.nl>*

## はじめに

OpenSesameは社会科学分野のためのGUIを用いた実験ビルダーです。
OpenSesameを利用することによって、マウスを用いてポイント&クリックが行える実験を簡単に作成できます。より複雑なタスクでは、OpenSesameがサポートしている [Python] を使用することができます。

## 実験を作る

初めて実験を作成する場合、チュートリアルから始めるのがおすすめです。チュートリアルをはじめとした様々な情報はオンラインでアクセスすることができます:

- <http://osdoc.cogsci.nl/tutorials/>

## 引用

OpenSesameを引用するには、次のリファレンスを使用してください:

- Mathôt, S., Schreij, D., & Theeuwes, J. (2012). OpenSesame: An open-source, graphical experiment builder for the social sciences. *Behavior Research Methods*, *44*(2), 314-324. doi:[10.3758/s13428-011-0168-7](http://dx.doi.org/10.3758/s13428-011-0168-7)

## インターフェース

グラフィカルインタフェースには大別して以下の要素があります。 各要素の右上にあるヘルプアイコンをクリックすると、要素ごとのヘルプが表示されます。

- *メニュー* (ウィンドウ上部) にはプログラムの終了，ファイルを開く/保存 などの一般的なオプションがあり，このヘルプページもメニューから開くことができます．
- *メインツールバー* (メニュー下部のアイコン) は最も関連性の高いオプションを選択できます。
- *アイテムツールバー* (ウィンドウ左側のボタン) には利用できるアイテムが表示されます。実験にこのアイテムを追加するには、このアイテムツールバーから実験概要エリアにドラッグしてください。
- *実験概要エリア* (Control + \\) にはあなたの実験の大まかな流れが，ツリー表示のように表示されます。
- *タブエリア* ではアイテムを編集する内容がタブとして表示されます。実験概要エリアにあるアイテムを選択することで、タブエリアには関連するタブが開きます。ヘルプ画面もまたこのタブエリアに表示されます。
- [ファイルプール](opensesame://help.pool) (Control + P) には実験に内包されているファイルが一覧で表示されます。
- [変数インスペクター](opensesame://help.extension.variable_inspector) (Control + I) には利用されている全ての変数が一覧で表示されます。
- [デバッグウィンドウ](opensesame://help.stdout). (Control + D) は [IPython] ターミナルです。実験が出力する全ての標準出力(i.e. `print()`) はここに表示されます。

## アイテム

アイテムはあなたの実験を構成するブロックのようなものです。実験を作成するための基本的な機能は10個の主要アイテムで構成されます。 実験にアイテムを追加するには、アイテムツールバーから使用したいアイテムを実験概要エリアにドラッグします。

- [loop](opensesame://help.loop): ループアイテムは他のアイテムを反復実行するために使用します。また，ループアイテム内部で独立変数を定義することもできます。
- [sequence](opensesame://help.sequence): シーケンスアイテムでは複数のアイテムを実行することができます。
- [sketchpad](opensesame://help.sketchpad): スケッチパッドアイテムは視覚刺激の呈示に使用します。内蔵されている描画ツールを用いることで簡単に視覚刺激を表示することができます。
- [feedback](opensesame://help.feedback): フィードバックアイテムは `sketchpad (スケッチパッドアイテム)`と似ていますが、表示内容は事前に決めることができません。そのため、フィードバックアイテムは実験参加者にフィードバックする際に使用できます。
- [sampler](opensesame://help.sampler): サンプラーアイテムは音声ファイルの再生に用いられます。
- [synth](opensesame://help.synth): シンセアイテムは純音をはじめとした音声の再生に用いられます。
- [keyboard_response](opensesame://help.keyboard_response): キーボード入力アイテムは押下されたキーボードのキーを取得します。
- [mouse_response](opensesame://help.mouse_response): マウス入力アイテムはマウスによるクリック入力を取得します。
- [logger](opensesame://help.logger): ロガーアイテムは変数の内容をログファイルに書き出します。
- [inline_script](opensesame://help.inline_script): インラインスクリプトアイテムは実験中にPythonコードを実行するために使用します。

また、インストールがされていればプラグインにより，追加機能が使用できます。プラグインによる追加アイテムは主要アイテムと並んでアイテムツールバーに表示されます。

## 実験を行う

実験は以下の方法で実行できます:

- フルスクリーンモード (*Control+R* もしくは *実行 -> フルスクリーンで実行*)
- ウィンドウモード (*Control+W* もしくは *実行 -> ウィンドウモードで実行*)
- クイック実行モード (*Control+Shift+W* もしくは *実行 -> Quick run*)

クイック実行モード(Quick Run)では、実験はすぐにウィンドウ上で実行され、ログファイルは `quickrun.csv`、実験者番号は 999 になります。
この機能は開発段階でとても有用な方法です。

また、'auto-response' オプション(*Run -> Enable auto-response*)が有効な場合、OpenSesameが自動的にキー入力やマウス入力を行うため、開発段階において便利です。

[python]: http://www.python.org/
[ipython]: http://www.ipython.org/
