# Generated by sila2.code_generator; sila2.__version__: 0.8.0
# -----
# This class does not do anything useful at runtime. Its only purpose is to provide type annotations.
# Since sphinx does not support .pyi files (yet?), so this is a .py file.
# -----

from __future__ import annotations

from typing import TYPE_CHECKING

if TYPE_CHECKING:

    from typing import Iterable, Optional

    from lockcontroller_types import LockServer_Responses, UnlockServer_Responses

    from sila2.client import ClientMetadata, ClientMetadataInstance, ClientUnobservableProperty


class LockControllerClient:
    """

    This Feature allows a SiLA Client to lock a SiLA Server for exclusive use, preventing other SiLA Clients
    from using the SiLA Server while it is locked. To lock a SiLA Server a Lock Identifier has to be set, using the
    'LockServer' command. This Lock Identifier has to be sent along with every (lock protected)
    request to the SiLA Server in order to use its functionality.

    To send the lock identifier the SiLA Client Meta Data 'LockIdentifier' has to be used.

    When locking a SiLA Server a timeout can be specified that defines the time after which the SiLA Server will
    be automatically unlocked if no request with a valid lock identifier has been received meanwhile.
    After the timeout has expired or after explicit unlock no lock identifier has to be sent any more.

    """

    IsLocked: ClientUnobservableProperty[bool]
    """
    
      Returns true if the SiLA Server is currently locked or false else.

      This property MUST NOT be lock protected, so that any SiLA Client can query the current lock state
      of a SiLA Server.
    
    """

    LockIdentifier: ClientMetadata[str]
    """
    
      The lock identifier has to be sent with every (lock protected) call in order to use the functionality
      of a locked SiLA Server.
    
    """

    def LockServer(
        self, LockIdentifier: str, Timeout: int, *, metadata: Optional[Iterable[ClientMetadataInstance]] = None
    ) -> LockServer_Responses:
        """

        Locks a SiLA Server for exclusive use by setting a lock identifier that has to be sent along with
        any following (lock protected) request as long as the SiLA Server is locked.
        The lock can be reset by issuing the 'Unlock Server' command.

        """
        ...

    def UnlockServer(
        self, LockIdentifier: str, *, metadata: Optional[Iterable[ClientMetadataInstance]] = None
    ) -> UnlockServer_Responses:
        """

        Unlocks a locked SiLA Server. No lock identifier has to be sent for any following calls until
        the server is locked again via the 'Lock Server' command.

        """
        ...
