# Machine Learning Evx

This is a simplified version of [regpredict](https://pypi.org/project/regpredict/) package used to generate buy and sell signals for crypto and conventional stock markets based on the excess volume indicator(EVX). EVX is a concept where the bid-ask spread is estimated inherently from current market prices. 

You can read more about Evx in the whitepaper [here](https://www.researchgate.net/publication/345313655_DeFiPaper)  
# Installation
Install mlevx with `python3 -m pip install mlevx`  
# Usage

In your python script simply import the module and use as follows:

```  
from mlevx.regbot import signal
print(signal(20,65,0.5,'enter'))
```
The above methods take an assets opening and closing prices of the asset based on the time interval you have chosen. The third option is the threshold, and the last option is the decision to enter or exit the trade. A zero classification output would instruct the user to sell, while one output means don't sell or buy if the asset  is not already present in the orders.  

NB: The arguments can only be one between 'enter' or exit.  

# Testing an entire dataframe
Testing of a dataframe for correct buy, sell signals is as simple as applying the function as follows:  

```
import pandas as pd
from mlevx.regbot import signal

df = pd.read_csv('../../../path/to_your.csv')

y_pred = []
def getSignal(open,close):
    return signal(open,close)


df = df[df['buy'] == 1]
print(df.head())

df['signal'] = df.apply(lambda row: getSignal(row['open'], row['close'], 0.5, 'enter'), axis=1)

print(df.head())

print(len(df[df['signal'] == df['buy']]), len(df))

```

Your original data must already have some presumed 'buy' signal.

# Warning
This is not financial advise. MlEVX is entirely on its preliminary stages. Use it at your own risk.