# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from typing import Optional

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------------ Public methods ------------------------------------------------------------ #

def extract_number(s: str, debug: bool = False) -> Optional[int]:
    try:
        s = s.lower().strip().replace(',', '').replace('.', '').replace('k', '000').replace('m', '000000')

        return int([w for w in s.split(' ') if w.isdigit()][0])
    except Exception as e:
        if debug:
            print('ERROR - YoutubeScraper - __extract_number({})'.format(s), e)

        return None


# ---------------------------------------------------------------------------------------------------------------------------------------- #