# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['simpel_captcha']

package_data = \
{'': ['*'], 'simpel_captcha': ['font/*']}

install_requires = \
['Pillow>=8.4.0,<9.0.0']

setup_kwargs = {
    'name': 'simpel-captcha',
    'version': '0.1.4',
    'description': 'FastAPI or starlette 生成验证码(图片/文字) 提供 io/ base64/ 本地文件存储方式',
    'long_description': '生成验证码 图片 ～（BytesIO，image file， base64）， 文字\n# install\n```shell\npip install simpel_captcha\n```\n# use\n## 文字验证码\n```python\nfrom simpel_captcha import captcha\ncode = captcha()\n```\n## 图片验证码（本地保存）\n```python\nfrom simpel_captcha import img_captcha\nimg, code = img_captcha()\nprint(f\'图片对象: {image}\')\nprint(f\'验证码: {text}\')\n```\noutput:\n```shell\n图片对象: <PIL.Image.Image image mode=RGB size=100x30 at 0x1C7A0CAA7C0>\n验证码: TjXP\n```\n## 图片验证码（BytesIO）- 可使用`Web框架`直接通过流的形式返回\n``` python\nfrom simpel_captcha import img_captcha\nimg, code = img_captcha(byte_stream=True)\n```\n### fastapi example\n```python\nfrom fastapi import FastAPI\nfrom fastapi.responses import StreamingResponse\n\nfrom simpel_captcha import img_captcha\n\napp = FastAPI()\n\n\n@app.get("/captcha", summary=\'图片验证码\')\ndef image_captcha():\n    image, text = img_captcha(byte_stream=True)\n    # todo 将验证码缓存到Redis中 \n    return StreamingResponse(content=image, media_type=\'image/jpeg\')\n```\n![postman result](https://gitee.com/zy7y/simpel_captcha/raw/master/example/image/postman.png)\n## base64字符串（推荐使用）\n```python\nfrom simpel_captcha import b64_captcha\nobj, code = b64_captcha()\nprint(f\'base64图片: {image}\')\nprint(f\'验证码: {text}\')\n```\noutput:\n```shell\n# 直接将base64字符串 复制到浏览器\nbase64图片: data:image/jpeg;base64,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\n验证码: Q2of\n```\n\n### fastapi vue3 example\n```python\nfrom fastapi import FastAPI\nfrom starlette.middleware.cors import CORSMiddleware\n\nfrom simpel_captcha import b64_captcha\n\napp = FastAPI()\n\napp.add_middleware(\n    CORSMiddleware,\n    allow_origins=["*"],\n    allow_credentials=True,\n    allow_methods=["*"],\n    allow_headers=["*"],\n)\n\n@app.get("/captcha", summary=\'图片验证码\')\ndef image_captcha():\n    image, text = b64_captcha()\n    # todo 将验证码缓存到Redis中 \n    return {"captcha_img": image, "captcha_code": text}\n```\n```vue\n<!-- vue3 -->\n<template>\n   <img :src="captcha" />\n</template>\n<script setup>\nimport { ref } from "vue";\nimport axios from "axios"\nconst captcha = ref("")\naxios({\n  method: \'get\',\n  url: \'http://127.0.0.1:8000/captcha\'\n}).then(res => captcha.value = res.data.captcha_img)\n\n</script>\n```\n\n# LICENSE\n```text\nMIT License\n\nCopyright (c) 2022 柒意\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n```',
    'author': '柒意',
    'author_email': '396667207@qq.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/zy7y/simpel_captcha',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
