QUERY = {
    "alarmsQ": "query Alarms($uid: String!) {\n  alarms(uid: $uid) {\n    __typename\n    ...WatchAlarmFragment\n  }\n}\nfragment WatchAlarmFragment on WatchAlarm {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  start\n  end\n  weekRepeat\n  occurMin\n  description\n  extra\n  start\n  create\n  update\n  status\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "cardGroupsQ": "query CardGroups($isCampaign : Boolean!) {\n  cardGroups(status: ENABLE, isCampaign: $isCampaign) {\n    __typename\n    id\n    name\n    type\n    kind\n    status\n    listOrder\n    extra\n    description\n    create\n    update\n  }\n}",
    "contactsQ": "query Contacts($uid: String) {\n  contacts(uid: $uid) {\n    __typename\n    ...ContactListFragment\n  }\n}\nfragment ContactListFragment on XPContactList {\n  __typename\n  contacts {\n    __typename\n    ...ContactFragment\n  }\n  followRequest {\n    __typename\n    ...FollowRequestFragment\n  }\n}\nfragment ContactFragment on XPContact {\n  __typename\n  id\n  ownUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  name\n  countryPhoneNumber\n  phoneNumber\n  contactUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  approval\n  guardianType\n  create\n  update\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment FollowRequestFragment on XPFollowRequest {\n  __typename\n  id\n  qid\n  deviceId\n  name\n  iconUrl\n  phoneNumber\n  countryCode\n  requestTime\n}",
    "readMyInfoQ": "query ReadMyInfo {\n  readMyInfo {\n    __typename\n    ...UserFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "watchesQ": "query Watches($uid: String) {\n  watches(uid: $uid) {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "watchLastLocateQ": "query WatchLastLocate($uid: String!) {\n  watchLastLocate(uid: $uid) {\n    __typename\n    ...WatchLastLocateFragment\n  }\n}\nfragment WatchLastLocateFragment on Location {\n  __typename\n  tm\n  lat\n  lng\n  rad\n  country\n  countryAbbr\n  province\n  city\n  addr\n  poi\n  battery\n  isCharging\n  isAdjusted\n  locateType\n  step\n  distance\n  isInSafeZone\n  safeZoneLabel\n}",
    "askWatchLocateQ": "query AskWatchLocate($uid: String!) {\n  askWatchLocate(uid: $uid)\n}",
    "trackWatchQ": "query TrackWatch($uid: String!) {\n  trackWatch(uid: $uid)\n}",
    "watchCountQ": "query FollowRequestWatchCount {\n  followRequestWatchCount\n}",
    "getWifiQ": "query GetWifis($uid : String!) {\n  getWiFis(uid: $uid) {\n    __typename\n    ...WiFiFragment\n  }\n}\nfragment WiFiFragment on WiFi {\n  __typename\n  id\n  name\n  ssid\n  password\n  state\n  create\n  update\n  user {\n    __typename\n    ...UserFragment\n  }\n  watch {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}",
    "avatarsQ": "query Avatars($id: String) {\n  avatars(id: $id) {\n    __typename\n    id\n    name\n    file {\n      __typename\n      ...FileFragment\n    }\n    listOrder\n    create\n    update\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}",
    "subscribedCampaignQ": "query SubscribedCampaign($uid: String!, $needDetail: Boolean!) {\n  subscribedCampaign(uid:$uid) {\n    __typename\n    campaign @include(if: $needDetail) {\n      __typename\n      ...CampaignFragment\n    }\n    user @include(if: $needDetail) {\n      __typename\n      ...UserFragment\n    }\n    avatar @include(if: $needDetail) {\n      __typename\n      ...FileFragment\n    }\n    profile @include(if: $needDetail) {\n      __typename\n      ...FileFragment\n    }\n    name\n    subscribedDate\n  }\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "staticCardQ": "query StaticCard {\n  staticCards(groupId: \"#groupId\") {\n    __typename\n    id\n    title {\n      __typename\n      ...MultiLangTextFragment\n    }\n    type\n    lgBackground {\n      __typename\n      ...FileFragment\n    }\n    smBackground {\n      __typename\n      ...FileFragment\n    }\n    mov {\n      __typename\n      ...FileFragment\n    }\n    bgColor\n    fgColor\n    extra\n    description {\n      __typename\n      ...MultiLangTextFragment\n    }\n    status\n    width\n    height\n    create\n    update\n    campaign {\n      __typename\n      ...CampaignFragment\n    }\n    docLink {\n      __typename\n      ...DocLinkFragment\n    }\n    campaignRanks {\n      __typename\n      ...RankCardFragment\n    }\n    product {\n      __typename\n      ...UnpurchaseProductFragment\n    }\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}\nfragment DocLinkFragment on DocLink {\n  __typename\n  id\n  campaignId\n  title {\n    __typename\n    ...MultiLangTextFragment\n  }\n  link\n  type\n  lgImage {\n    __typename\n    ...FileFragment\n  }\n  status\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n  update\n}\nfragment RankCardFragment on RankCard {\n  __typename\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  topRank {\n    __typename\n    ...RankRowFragment\n  }\n  userRank {\n    __typename\n    ...RankRowFragment\n  }\n}\nfragment RankRowFragment on RankRow {\n  __typename\n  user {\n    __typename\n    ...SimpleUserFragment\n  }\n  score\n  rank\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment UnpurchaseProductFragment on UnpurchaseProduct {\n  __typename\n  productId\n  productName\n}",
    "CampaignUserProfilesQ": "query CampaignUserProfiles {\n  campaignUserProfiles {\n    __typename\n    ...CampaignUserProfilesFragment\n  }\n  followRequestWatchCount\n}\nfragment CampaignUserProfilesFragment on CampaignUserProfile {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  avatar {\n    __typename\n    ...AvatarFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment AvatarFragment on Avatar {\n  __typename\n  id\n  name\n  file {\n    __typename\n    ...FileFragment\n  }\n}",
    "GetReviewStatusQ": "query GetReviewStatus($uid: String!) {\n  getReviewStatus(uid: $uid)\n}",
    "CountriesQ": "query Countries {\n  countries(status: ENABLE) {\n    __typename\n    ...CountryFragment\n  }\n}\nfragment CountryFragment on Country {\n  __typename\n  id\n  code\n  name\n  status\n  listOrder\n  create\n}",
    "unReadChatMsgCountQ": "query UnReadChatMsgCount($uid : String!) {\n  unReadChatMsgCount(uid: $uid)\n}",
    "noticeQ": "query noticeQ {\n  getNotices {\n    id\n    noticeType\n    name\n    desc\n    content\n    startDate\n    endDate\n    status\n    cDate\n    uDate\n  }\n}",
    "chatsQ": "query Chats($uid : String!, $offset: Int, $limit: Int, $msgId: String) {\n  chats(uid: $uid, offset: $offset, limit: $limit, msgId: $msgId) {\n    __typename\n    offset\n    limit\n    list {\n      __typename\n      ...SimpleChatFragment\n    }\n  }\n}\nfragment SimpleChatFragment on SimpleChat {\n  __typename\n  id\n  msgId\n  type\n  sender {\n    __typename\n    ...SimpleUserFragment\n  }\n  receiver {\n    __typename\n    ...SimpleUserFragment\n  }\n  data\n  create\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "safeZonesQ": "query SafeZones($uid: String!) {\n  safeZones(uid: $uid) {\n    __typename\n    ...SafeZoneFragment\n  }\n}\nfragment SafeZoneFragment on SafeZone {\n  __typename\n  id\n  vendorName\n  vendorId\n  groupName\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  group {\n    __typename\n    ...SafeZoneGroupFragment\n  }\n  name\n  lat\n  lng\n  rad\n  address\n  description\n  extra\n  create\n  update\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment SafeZoneGroupFragment on SafeZoneGroup {\n  __typename\n  id\n  name\n  status\n  description\n  create\n  update\n}",
    "safeZoneGroupsQ": "query SafeZoneGroups {\n  safeZoneGroups(status: ENABLE) {\n    __typename\n    ...SafeZoneGroupFragment\n  }\n}\nfragment SafeZoneGroupFragment on SafeZoneGroup {\n  __typename\n  id\n  name\n  status\n  description\n  create\n  update\n}",
    "silentTimesQ": "query SlientTimes($uid : String!) {\n  silentTimes(uid: $uid) {\n    __typename\n    ...SilentModeFragment\n  }\n}\nfragment SilentModeFragment on SilentMode {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  start\n  end\n  weekRepeat\n  description\n  extra\n  status\n  create\n  update\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
}
