"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnServiceLevelObjective = exports.toJson_ErrorBudgetBurnRate = exports.CfnServiceLevelObjectivePropsEvaluationType = exports.toJson_CfnServiceLevelObjectiveProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnServiceLevelObjectiveProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnServiceLevelObjectiveProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Description': obj.description,
        'MetricName': obj.metricName,
        'MetricExpression': obj.metricExpression,
        'EvaluationType': obj.evaluationType,
        'Filter': obj.filter,
        'Target': obj.target,
        'Warning': obj.warning,
        'ErrorBudgetBurnRate': toJson_ErrorBudgetBurnRate(obj.errorBudgetBurnRate),
        'Timeframe': obj.timeframe,
        'HasAccess': obj.hasAccess,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnServiceLevelObjectiveProps = toJson_CfnServiceLevelObjectiveProps;
/* eslint-enable max-len, quote-props */
/**
 * The evaluation type of the SLO.
 *
 * @schema CfnServiceLevelObjectivePropsEvaluationType
 */
var CfnServiceLevelObjectivePropsEvaluationType;
(function (CfnServiceLevelObjectivePropsEvaluationType) {
    /** AGGREGATE */
    CfnServiceLevelObjectivePropsEvaluationType["AGGREGATE"] = "AGGREGATE";
})(CfnServiceLevelObjectivePropsEvaluationType = exports.CfnServiceLevelObjectivePropsEvaluationType || (exports.CfnServiceLevelObjectivePropsEvaluationType = {}));
/**
 * Converts an object of type 'ErrorBudgetBurnRate' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ErrorBudgetBurnRate(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'FastBurnThreshold': obj.fastBurnThreshold,
        'BurnRateVisualizationEnabled': obj.burnRateVisualizationEnabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ErrorBudgetBurnRate = toJson_ErrorBudgetBurnRate;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Dynatrace::Environment::ServiceLevelObjective`
 *
 * @cloudformationResource Dynatrace::Environment::ServiceLevelObjective
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
 */
class CfnServiceLevelObjective extends cdk.CfnResource {
    /**
     * Create a new `Dynatrace::Environment::ServiceLevelObjective`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnServiceLevelObjective.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnServiceLevelObjectiveProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrEnabled = this.getAtt('Enabled');
        this.attrBurnRateMetricKey = cdk.Token.asString(this.getAtt('BurnRateMetricKey'));
        this.attrRelatedOpenProblems = cdk.Token.asNumber(this.getAtt('RelatedOpenProblems'));
        this.attrRelatedTotalProblems = cdk.Token.asNumber(this.getAtt('RelatedTotalProblems'));
        this.attrEvaluatedPercentage = cdk.Token.asNumber(this.getAtt('EvaluatedPercentage'));
        this.attrErrorBudget = cdk.Token.asNumber(this.getAtt('ErrorBudget'));
        this.attrMetricKey = cdk.Token.asString(this.getAtt('MetricKey'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.attrError = cdk.Token.asString(this.getAtt('Error'));
    }
}
exports.CfnServiceLevelObjective = CfnServiceLevelObjective;
_a = JSII_RTTI_SYMBOL_1;
CfnServiceLevelObjective[_a] = { fqn: "@cdk-cloudformation/dynatrace-environment-servicelevelobjective.CfnServiceLevelObjective", version: "1.3.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnServiceLevelObjective.CFN_RESOURCE_TYPE_NAME = "Dynatrace::Environment::ServiceLevelObjective";
//# sourceMappingURL=data:application/json;base64,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