import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Service Level Objective in Dynatrace.
 *
 * @schema CfnServiceLevelObjectiveProps
 */
export interface CfnServiceLevelObjectiveProps {
    /**
     * The name of the SLO.
     *
     * @schema CfnServiceLevelObjectiveProps#Name
     */
    readonly name: string;
    /**
     * The description of the SLO.
     *
     * @schema CfnServiceLevelObjectiveProps#Description
     */
    readonly description?: string;
    /**
     * The name for a metric expression.
     *
     * @schema CfnServiceLevelObjectiveProps#MetricName
     */
    readonly metricName?: string;
    /**
     * The percentage-based metric expression for the calculation of the SLO.
     *
     * @schema CfnServiceLevelObjectiveProps#MetricExpression
     */
    readonly metricExpression?: string;
    /**
     * The evaluation type of the SLO.
     *
     * @schema CfnServiceLevelObjectiveProps#EvaluationType
     */
    readonly evaluationType: CfnServiceLevelObjectivePropsEvaluationType;
    /**
     * The entity filter for the SLO evaluation. Use the syntax of entity selector (https://dt-url.net/entityselector).
     *
     * @schema CfnServiceLevelObjectiveProps#Filter
     */
    readonly filter?: string;
    /**
     * The target value of the SLO.
     *
     * @schema CfnServiceLevelObjectiveProps#Target
     */
    readonly target?: number;
    /**
     * The warning value of the SLO.
     *
     * At warning state the SLO is still fulfilled but is getting close to failure.
     *
     * @schema CfnServiceLevelObjectiveProps#Warning
     */
    readonly warning?: number;
    /**
     * @schema CfnServiceLevelObjectiveProps#ErrorBudgetBurnRate
     */
    readonly errorBudgetBurnRate?: ErrorBudgetBurnRate;
    /**
     * The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector.
     *
     * @schema CfnServiceLevelObjectiveProps#Timeframe
     */
    readonly timeframe: string;
    /**
     * The SLO is accessible through the settings if hasAccess is true.
     *
     * @schema CfnServiceLevelObjectiveProps#HasAccess
     */
    readonly hasAccess?: boolean;
}
/**
 * Converts an object of type 'CfnServiceLevelObjectiveProps' to JSON representation.
 */
export declare function toJson_CfnServiceLevelObjectiveProps(obj: CfnServiceLevelObjectiveProps | undefined): Record<string, any> | undefined;
/**
 * The evaluation type of the SLO.
 *
 * @schema CfnServiceLevelObjectivePropsEvaluationType
 */
export declare enum CfnServiceLevelObjectivePropsEvaluationType {
    /** AGGREGATE */
    AGGREGATE = "AGGREGATE"
}
/**
 * Error budget burn rate configuration of a service-level objective (SLO).
 *
 * @schema ErrorBudgetBurnRate
 */
export interface ErrorBudgetBurnRate {
    /**
     * The threshold between a slow and a fast burn rate.
     *
     * @schema ErrorBudgetBurnRate#FastBurnThreshold
     */
    readonly fastBurnThreshold: number;
    /**
     * The error budget burn rate visualization is enabled (true) or disabled (false).
     *
     * In case of false, no calculated values will be present here.
     *
     * @schema ErrorBudgetBurnRate#BurnRateVisualizationEnabled
     */
    readonly burnRateVisualizationEnabled: boolean;
}
/**
 * Converts an object of type 'ErrorBudgetBurnRate' to JSON representation.
 */
export declare function toJson_ErrorBudgetBurnRate(obj: ErrorBudgetBurnRate | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Dynatrace::Environment::ServiceLevelObjective`
 *
 * @cloudformationResource Dynatrace::Environment::ServiceLevelObjective
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
 */
export declare class CfnServiceLevelObjective extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Dynatrace::Environment::ServiceLevelObjective";
    /**
     * Resource props.
     */
    readonly props: CfnServiceLevelObjectiveProps;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.Id`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrId: string;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.Enabled`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrEnabled: cdk.IResolvable;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.BurnRateMetricKey`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrBurnRateMetricKey: string;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.RelatedOpenProblems`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrRelatedOpenProblems: number;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.RelatedTotalProblems`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrRelatedTotalProblems: number;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.EvaluatedPercentage`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrEvaluatedPercentage: number;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.ErrorBudget`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrErrorBudget: number;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.MetricKey`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrMetricKey: string;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.Status`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrStatus: string;
    /**
     * Attribute `Dynatrace::Environment::ServiceLevelObjective.Error`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrError: string;
    /**
     * Create a new `Dynatrace::Environment::ServiceLevelObjective`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnServiceLevelObjectiveProps);
}
