import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "attini-cdk-lib",
    "version": "1.2.4",
    "description": "Attini CDK Constructs",
    "license": "Apache-2.0",
    "url": "https://attini.io",
    "long_description_content_type": "text/markdown",
    "author": "oscarostrand<contact@attini.io>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/attini-cloud-solutions/attini-cdk-constructs"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "attini_cdk",
        "attini_cdk._jsii"
    ],
    "package_data": {
        "attini_cdk._jsii": [
            "cdk@1.2.4.jsii.tgz"
        ],
        "attini_cdk": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.7",
    "install_requires": [
        "aws-cdk-lib>=2.1.0, <3.0.0",
        "constructs>=10.0.5, <11.0.0",
        "jsii>=1.79.0, <2.0.0",
        "publication>=0.0.3",
        "typeguard~=2.13.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
