"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAction = exports.PropsUtil = exports.DeploymentPlan = exports.AttiniDeploymentPlanStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const constructs_1 = require("constructs");
class AttiniDeploymentPlanStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addTransform('AttiniDeploymentPlan');
        this.addTransform('AWS::Serverless-2016-10-31');
    }
}
exports.AttiniDeploymentPlanStack = AttiniDeploymentPlanStack;
_a = JSII_RTTI_SYMBOL_1;
AttiniDeploymentPlanStack[_a] = { fqn: "@attini/cdk.AttiniDeploymentPlanStack", version: "1.2.4" };
class DeploymentPlan extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::DeploymentPlan',
            properties: {
                DeploymentPlan: new aws_stepfunctions_1.StateGraph(props.definition.startState, 'not important').toGraphJson(),
            },
        });
    }
}
exports.DeploymentPlan = DeploymentPlan;
_b = JSII_RTTI_SYMBOL_1;
DeploymentPlan[_b] = { fqn: "@attini/cdk.DeploymentPlan", version: "1.2.4" };
class PropsUtil {
    static fixCase(props) {
        let copy = {};
        Object.entries(props).forEach(([key, value]) => {
            copy[key.charAt(0).toUpperCase() + key.slice(1)] = value;
        });
        return copy;
    }
}
exports.PropsUtil = PropsUtil;
_c = JSII_RTTI_SYMBOL_1;
PropsUtil[_c] = { fqn: "@attini/cdk.PropsUtil", version: "1.2.4" };
var CfnAction;
(function (CfnAction) {
    CfnAction[CfnAction["DEPLOY"] = 0] = "DEPLOY";
    CfnAction[CfnAction["DELETE"] = 1] = "DELETE";
})(CfnAction = exports.CfnAction || (exports.CfnAction = {}));
__exportStar(require("./attini-state"), exports);
__exportStar(require("./attini-merge"), exports);
__exportStar(require("./attini-runner-job"), exports);
__exportStar(require("./attini-cfn"), exports);
__exportStar(require("./attini-manual-approval"), exports);
__exportStar(require("./attini-import"), exports);
__exportStar(require("./attini-lambda-invoke"), exports);
__exportStar(require("./attini-sam"), exports);
__exportStar(require("./attini-task"), exports);
__exportStar(require("./attini-runner"), exports);
__exportStar(require("./attini-cdk"), exports);
__exportStar(require("./attini-runtime-variables"), exports);
__exportStar(require("./attini-payload"), exports);
//# sourceMappingURL=data:application/json;base64,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