"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniTask = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_state_1 = require("./attini-state");
class AttiniTask extends attini_state_1.AttiniState {
    /**
     *
     * Get the json path to this steps output. Convenience
     * method that will return a string with the following format
     * $.output.<id>.<path>.<path>
     *
     * @param {string[]} [paths] - The path to the value from the outputs root.
     *
     */
    getOutputPath(...paths) {
        if (paths.length !== 0) {
            let path = paths.join('.');
            return '$.output.' + this.id + '.' + path;
        }
        return '$.output.' + this.id;
    }
    /**
     *
     * Get a string value from the steps output.
     * This method can only be used as the value for a key/value pair in another Attini or
     * StepFunction step.
     *
     * @example
     * Valid examples:
     *
     * {my-key: step.getOutput()}
     * {my-key: step.getOutput('path','to','key')}
     *
     * Invalid examples:
     *
     * {my-key: 'test'+ step.getOutput()}
     * {my-key: '[step.getOutput()]}
     *
     * @param {string[]} [paths] - The path to the value from the outputs root.
     *
     */
    getOutput(...paths) {
        return aws_stepfunctions_1.JsonPath.stringAt(this.getOutputPath(...paths));
    }
}
exports.AttiniTask = AttiniTask;
_a = JSII_RTTI_SYMBOL_1;
AttiniTask[_a] = { fqn: "@attini/cdk.AttiniTask", version: "1.2.4" };
//# sourceMappingURL=data:application/json;base64,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