"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniSam = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
/**
 * A step for deploying an AWS SAM Project
 */
class AttiniSam extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniSam';
    }
    renderProps() {
        let copy = { ...this.props };
        if (this.props.action && this.props.action.valueOf() === index_1.CfnAction.DEPLOY.valueOf()) {
            copy.action = 'Deploy';
        }
        else if (this.props.action && this.props.action.valueOf() === index_1.CfnAction.DELETE.valueOf()) {
            copy.action = 'Delete';
        }
        return {
            Properties: {
                ...aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(copy)),
                Project: aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(this.props.project)),
            },
        };
    }
}
exports.AttiniSam = AttiniSam;
_a = JSII_RTTI_SYMBOL_1;
AttiniSam[_a] = { fqn: "@attini/cdk.AttiniSam", version: "1.2.4" };
//# sourceMappingURL=data:application/json;base64,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