"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const index_1 = require("./index");
class AttiniRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let copy = { ...props };
        if (props.awsVpcConfiguration?.subnets) {
            copy.awsVpcConfiguration.subnets = props.awsVpcConfiguration.subnets.join(',');
        }
        if (props.awsVpcConfiguration?.securityGroups) {
            copy.awsVpcConfiguration.securityGroups = props.awsVpcConfiguration.securityGroups.join(',');
        }
        if (props.awsVpcConfiguration?.assignPublicIp) {
            copy.awsVpcConfiguration.assignPublicIp = props.awsVpcConfiguration?.assignPublicIp ? 'ENABLED' : 'DISABLED';
        }
        if (props.awsVpcConfiguration) {
            copy.awsVpcConfiguration = index_1.PropsUtil.fixCase(copy.awsVpcConfiguration);
        }
        if (props.runnerConfiguration) {
            copy.runnerConfiguration = index_1.PropsUtil.fixCase(copy.runnerConfiguration);
        }
        if (props.startup) {
            copy.startup = index_1.PropsUtil.fixCase(props.startup);
        }
        let cfnResource = new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::Runner',
            properties: index_1.PropsUtil.fixCase(copy),
        });
        this.runnerName = cfnResource.logicalId;
    }
}
exports.AttiniRunner = AttiniRunner;
_a = JSII_RTTI_SYMBOL_1;
AttiniRunner[_a] = { fqn: "@attini/cdk.AttiniRunner", version: "1.2.4" };
//# sourceMappingURL=data:application/json;base64,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