"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniLambdaInvoke = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_state_1 = require("./attini-state");
const index_1 = require("./index");
/**
 * AttiniLambdaInvoke will call a Lambda function while preserving the payload for subsequent steps.
 *
 */
class AttiniLambdaInvoke extends attini_state_1.AttiniState {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniLambdaInvoke';
    }
    renderProps() {
        return {
            Parameters: aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(this.props)),
        };
    }
}
exports.AttiniLambdaInvoke = AttiniLambdaInvoke;
_a = JSII_RTTI_SYMBOL_1;
AttiniLambdaInvoke[_a] = { fqn: "@attini/cdk.AttiniLambdaInvoke", version: "1.2.4" };
//# sourceMappingURL=data:application/json;base64,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