"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codeartifact_1 = require("aws-cdk-lib/aws-codeartifact");
const constructs_1 = require("constructs");
const repository_1 = require("./repository");
const validations = require("./validations");
/**
 * CodeArtifact Domain Construct - enables creation of a domain along with zero or more Repositories.
 *
 * Can be used to create just a domain by passing in no IDomainRepositoryProp elements
 *
 */
class Domain extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repositories = [];
        this.props = props;
        validations.validateDomainNameLength(props.domainName);
        validations.validateDomainName(props.domainName);
        const domainId = `${props.domainName}-cfnDom`;
        this.domainInstance = new aws_codeartifact_1.CfnDomain(this, domainId, props);
        if (props.repositories) {
            for (const repoProps of props.repositories) {
                validations.validateRepoNameLength(repoProps.repositoryName);
                validations.validateRepoName(repoProps.repositoryName);
                validations.validateExternalConnections(repoProps.externalConnections);
                const repoName = `${repoProps.repositoryName}-cfnRepo`;
                const repo = new repository_1.Repository(this, repoName, {
                    domainName: this.props.domainName,
                    ...repoProps,
                });
                repo.node.addDependency(this.domainInstance);
                this.repositories.push(repo);
            }
        }
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "cdk-codeartifact.Domain", version: "1.0.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2RvbWFpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLG1FQUF5RDtBQUN6RCwyQ0FBdUM7QUFDdkMsNkNBQTBDO0FBQzFDLDZDQUE2QztBQXdGN0M7Ozs7O0dBS0c7QUFDSCxNQUFhLE1BQU8sU0FBUSxzQkFBUztJQUtuQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQW1CO1FBQzNELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFKVixpQkFBWSxHQUFpQixFQUFFLENBQUM7UUFLdkMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFFbkIsV0FBVyxDQUFDLHdCQUF3QixDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUN2RCxXQUFXLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRWpELE1BQU0sUUFBUSxHQUFHLEdBQUcsS0FBSyxDQUFDLFVBQVUsU0FBUyxDQUFDO1FBQzlDLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSw0QkFBUyxDQUFDLElBQUksRUFBRSxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFM0QsSUFBSSxLQUFLLENBQUMsWUFBWSxFQUFFO1lBQ3RCLEtBQUssTUFBTSxTQUFTLElBQUksS0FBSyxDQUFDLFlBQVksRUFBRTtnQkFDMUMsV0FBVyxDQUFDLHNCQUFzQixDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsQ0FBQztnQkFDN0QsV0FBVyxDQUFDLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsQ0FBQztnQkFDdkQsV0FBVyxDQUFDLDJCQUEyQixDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO2dCQUV2RSxNQUFNLFFBQVEsR0FBRyxHQUFHLFNBQVMsQ0FBQyxjQUFjLFVBQVUsQ0FBQztnQkFDdkQsTUFBTSxJQUFJLEdBQUcsSUFBSSx1QkFBVSxDQUFDLElBQUksRUFBRSxRQUFRLEVBQUU7b0JBQzFDLFVBQVUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVU7b0JBQ2pDLEdBQUcsU0FBUztpQkFDYixDQUFDLENBQUM7Z0JBRUgsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO2dCQUM3QyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQzthQUM5QjtTQUNGO0lBQ0gsQ0FBQzs7QUEvQkgsd0JBaUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENmbkRvbWFpbiB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1jb2RlYXJ0aWZhY3QnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBSZXBvc2l0b3J5IH0gZnJvbSAnLi9yZXBvc2l0b3J5JztcbmltcG9ydCAqIGFzIHZhbGlkYXRpb25zIGZyb20gJy4vdmFsaWRhdGlvbnMnO1xuXG4vKipcbiAqIFByb3AgZGVmaW5pdGlvbiBmb3IgRG9tYWluUmVwb3NpdG9yeSAtIHdoZW4gY3JlYXRpbmcgRG9tYWluIGFuZCBSZXBvc2l0b3J5IHRvZ2V0aGVyIHVzaW5nIHRoZSBjb21iaW5lZCBEb21haW4gY29uc3RydWN0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSURvbWFpblJlcG9zaXRvcnlQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiBhbiB1cHN0cmVhbSByZXBvc2l0b3J5LlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS5odG1sI2Nmbi1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS1yZXBvc2l0b3J5bmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVwb3NpdG9yeU5hbWU6IHN0cmluZztcbiAgLyoqXG4gICAqIEEgdGV4dCBkZXNjcmlwdGlvbiBvZiB0aGUgcmVwb3NpdG9yeS5cbiAgICpcbiAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY29kZWFydGlmYWN0LXJlcG9zaXRvcnkuaHRtbCNjZm4tY29kZWFydGlmYWN0LXJlcG9zaXRvcnktZGVzY3JpcHRpb25cbiAgICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgICogVGhlIDEyLWRpZ2l0IGFjY291bnQgbnVtYmVyIG9mIHRoZSBBV1MgYWNjb3VudCB0aGF0IG93bnMgdGhlIGRvbWFpbiB0aGF0IGNvbnRhaW5zIHRoZSByZXBvc2l0b3J5LiBJdCBkb2VzIG5vdCBpbmNsdWRlIGRhc2hlcyBvciBzcGFjZXMuXG4gICAqXG4gICAqIEBsaW5rIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS5odG1sI2Nmbi1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS1kb21haW5vd25lclxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluT3duZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBbiBhcnJheSBvZiBleHRlcm5hbCBjb25uZWN0aW9ucyBhc3NvY2lhdGVkIHdpdGggdGhlIHJlcG9zaXRvcnkuXG4gICAqXG4gICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNvZGVhcnRpZmFjdC1yZXBvc2l0b3J5Lmh0bWwjY2ZuLWNvZGVhcnRpZmFjdC1yZXBvc2l0b3J5LWV4dGVybmFsY29ubmVjdGlvbnNcbiAgICovXG4gIHJlYWRvbmx5IGV4dGVybmFsQ29ubmVjdGlvbnM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICAqIFRoZSBkb2N1bWVudCB0aGF0IGRlZmluZXMgdGhlIHJlc291cmNlIHBvbGljeSB0aGF0IGlzIHNldCBvbiBhIHJlcG9zaXRvcnkuXG4gICAqXG4gICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNvZGVhcnRpZmFjdC1yZXBvc2l0b3J5Lmh0bWwjY2ZuLWNvZGVhcnRpZmFjdC1yZXBvc2l0b3J5LXBlcm1pc3Npb25zcG9saWN5ZG9jdW1lbnRcbiAgICovXG4gIHJlYWRvbmx5IHBlcm1pc3Npb25zUG9saWN5RG9jdW1lbnQ/OiBhbnkgfCBjZGsuSVJlc29sdmFibGU7XG4gIC8qKlxuICAgKiBBIGxpc3Qgb2YgdGFncyB0byBiZSBhcHBsaWVkIHRvIHRoZSByZXBvc2l0b3J5LlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS5odG1sI2Nmbi1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS10YWdzXG4gICAqL1xuICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xuICAvKipcbiAgICogQSBsaXN0IG9mIHVwc3RyZWFtIHJlcG9zaXRvcmllcyB0byBhc3NvY2lhdGUgd2l0aCB0aGUgcmVwb3NpdG9yeS4gVGhlIG9yZGVyIG9mIHRoZSB1cHN0cmVhbSByZXBvc2l0b3JpZXMgaW4gdGhlIGxpc3QgZGV0ZXJtaW5lcyB0aGVpciBwcmlvcml0eSBvcmRlciB3aGVuIEFXUyBDb2RlQXJ0aWZhY3QgbG9va3MgZm9yIGEgcmVxdWVzdGVkIHBhY2thZ2UgdmVyc2lvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbV29ya2luZyB3aXRoIHVwc3RyZWFtIHJlcG9zaXRvcmllc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvZGVhcnRpZmFjdC9sYXRlc3QvdWcvcmVwb3MtdXBzdHJlYW0uaHRtbCkgLlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS5odG1sI2Nmbi1jb2RlYXJ0aWZhY3QtcmVwb3NpdG9yeS11cHN0cmVhbXNcbiAgICovXG4gIHJlYWRvbmx5IHVwc3RyZWFtcz86IHN0cmluZ1tdO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGNyZWF0aW5nIENvZGVBcnRpZmFjdCBEb21haW4gdXNpbmcgdGhlIERvbWFpbiBjb250cnN0cnVjdFxuICpcbiAqIERvbWFpblByb3BzIGV4dGVuZHMgdGhlIEwxIENmbkRvbWFpblByb3BzIGludGVyZmFjZSB0byBlbnN1cmUgYWxsIENsb3VkRm9ybWF0aW9uIGNhcGFiaWxpdGllcyBhcmUgcmV0YWluZWRcbiAqXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSURvbWFpblByb3BzIHtcbiAgLyoqXG4gICAqIEEgc3RyaW5nIHRoYXQgc3BlY2lmaWVzIHRoZSBuYW1lIG9mIHRoZSByZXF1ZXN0ZWQgZG9tYWluLlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlYXJ0aWZhY3QtZG9tYWluLmh0bWwjY2ZuLWNvZGVhcnRpZmFjdC1kb21haW4tZG9tYWlubmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZTogc3RyaW5nO1xuICAvKipcbiAgICogVGhlIGtleSB1c2VkIHRvIGVuY3J5cHQgdGhlIGRvbWFpbi5cbiAgICpcbiAgICogQGxpbmsgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNvZGVhcnRpZmFjdC1kb21haW4uaHRtbCNjZm4tY29kZWFydGlmYWN0LWRvbWFpbi1lbmNyeXB0aW9ua2V5XG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzogc3RyaW5nO1xuICAvKipcbiAgICogVGhlIGRvY3VtZW50IHRoYXQgZGVmaW5lcyB0aGUgcmVzb3VyY2UgcG9saWN5IHRoYXQgaXMgc2V0IG9uIGEgZG9tYWluLlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlYXJ0aWZhY3QtZG9tYWluLmh0bWwjY2ZuLWNvZGVhcnRpZmFjdC1kb21haW4tcGVybWlzc2lvbnNwb2xpY3lkb2N1bWVudFxuICAgKi9cbiAgcmVhZG9ubHkgcGVybWlzc2lvbnNQb2xpY3lEb2N1bWVudD86IGFueSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICAqIEEgbGlzdCBvZiB0YWdzIHRvIGJlIGFwcGxpZWQgdG8gdGhlIGRvbWFpbi5cbiAgICpcbiAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY29kZWFydGlmYWN0LWRvbWFpbi5odG1sI2Nmbi1jb2RlYXJ0aWZhY3QtZG9tYWluLXRhZ3NcbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG4gIC8qKlxuICAgKiBhIGxpc3Qgb2YgUmVwb3NpdG9yaWVzIHRvIGNyZWF0ZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVwb3NpdG9yaWVzPzogSURvbWFpblJlcG9zaXRvcnlQcm9wc1tdO1xufVxuXG5cbi8qKlxuICogQ29kZUFydGlmYWN0IERvbWFpbiBDb25zdHJ1Y3QgLSBlbmFibGVzIGNyZWF0aW9uIG9mIGEgZG9tYWluIGFsb25nIHdpdGggemVybyBvciBtb3JlIFJlcG9zaXRvcmllcy5cbiAqXG4gKiBDYW4gYmUgdXNlZCB0byBjcmVhdGUganVzdCBhIGRvbWFpbiBieSBwYXNzaW5nIGluIG5vIElEb21haW5SZXBvc2l0b3J5UHJvcCBlbGVtZW50c1xuICpcbiAqL1xuZXhwb3J0IGNsYXNzIERvbWFpbiBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHJlYWRvbmx5IHByb3BzIDogSURvbWFpblByb3BzO1xuICByZWFkb25seSByZXBvc2l0b3JpZXM6IFJlcG9zaXRvcnlbXSA9IFtdO1xuICByZWFkb25seSBkb21haW5JbnN0YW5jZSA6IENmbkRvbWFpbjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSURvbWFpblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG5cbiAgICB2YWxpZGF0aW9ucy52YWxpZGF0ZURvbWFpbk5hbWVMZW5ndGgocHJvcHMuZG9tYWluTmFtZSk7XG4gICAgdmFsaWRhdGlvbnMudmFsaWRhdGVEb21haW5OYW1lKHByb3BzLmRvbWFpbk5hbWUpO1xuXG4gICAgY29uc3QgZG9tYWluSWQgPSBgJHtwcm9wcy5kb21haW5OYW1lfS1jZm5Eb21gO1xuICAgIHRoaXMuZG9tYWluSW5zdGFuY2UgPSBuZXcgQ2ZuRG9tYWluKHRoaXMsIGRvbWFpbklkLCBwcm9wcyk7XG5cbiAgICBpZiAocHJvcHMucmVwb3NpdG9yaWVzKSB7XG4gICAgICBmb3IgKGNvbnN0IHJlcG9Qcm9wcyBvZiBwcm9wcy5yZXBvc2l0b3JpZXMpIHtcbiAgICAgICAgdmFsaWRhdGlvbnMudmFsaWRhdGVSZXBvTmFtZUxlbmd0aChyZXBvUHJvcHMucmVwb3NpdG9yeU5hbWUpO1xuICAgICAgICB2YWxpZGF0aW9ucy52YWxpZGF0ZVJlcG9OYW1lKHJlcG9Qcm9wcy5yZXBvc2l0b3J5TmFtZSk7XG4gICAgICAgIHZhbGlkYXRpb25zLnZhbGlkYXRlRXh0ZXJuYWxDb25uZWN0aW9ucyhyZXBvUHJvcHMuZXh0ZXJuYWxDb25uZWN0aW9ucyk7XG5cbiAgICAgICAgY29uc3QgcmVwb05hbWUgPSBgJHtyZXBvUHJvcHMucmVwb3NpdG9yeU5hbWV9LWNmblJlcG9gO1xuICAgICAgICBjb25zdCByZXBvID0gbmV3IFJlcG9zaXRvcnkodGhpcywgcmVwb05hbWUsIHtcbiAgICAgICAgICBkb21haW5OYW1lOiB0aGlzLnByb3BzLmRvbWFpbk5hbWUsXG4gICAgICAgICAgLi4ucmVwb1Byb3BzLFxuICAgICAgICB9KTtcblxuICAgICAgICByZXBvLm5vZGUuYWRkRGVwZW5kZW5jeSh0aGlzLmRvbWFpbkluc3RhbmNlKTtcbiAgICAgICAgdGhpcy5yZXBvc2l0b3JpZXMucHVzaChyZXBvKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxufVxuIl19