import { CfnDomain, CfnRepository } from 'aws-cdk-lib/aws-codeartifact';
import { Construct } from 'constructs';
import { IDomainProps } from './domain';
import { IRepositoryProps } from './repository';
/**
 * Props for Repository class
 *
 * @deprecated RepositoryProps is replaced by IRepositoryProps and will be removed in future major release 1.1.0
 */
export declare type RepositoryProps = IRepositoryProps;
/**
 * Props for CodeArtifact construct
 *
 * @deprecated CodeArtifactProps is replaced by IDomainProps and will be removed in future major release 1.1.0
 */
export declare type CodeArtifactProps = IDomainProps;
/**
 * A Construct that will allow easy setup of an AWS CodeArtifact Repository within a domain
 *
 * @deprecated CodeArtifact class is replaced by Domain and will be removed in future major release 1.1.0
 */
export declare class CodeArtifact extends Construct {
    readonly props: CodeArtifactProps;
    readonly repositories: CfnRepository[];
    readonly domainInstance: CfnDomain;
    constructor(scope: Construct, id: string, props: CodeArtifactProps);
}
