# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2018-07-09 18:28
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Pool',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True, db_index=True, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, unique=True, verbose_name='Readable Name')),
                ('machine_name', models.CharField(help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, unique=True, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('request_threshold', models.BigIntegerField(default=50000, help_text='The maximum number of items that can be requested from this pool at once.  Default of 50000.', verbose_name='Threshold')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Response',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True, db_index=True, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('fulfilled', models.BooleanField(help_text='Whether or not the full request was fulfilled by the system', verbose_name='Fulfilled')),
                ('type', models.CharField(choices=[('sequential', 'Sequential'), ('random', 'Random'), ('list', 'List')], help_text='The type of response- either sequential, random, or list based.', max_length=10, verbose_name='Type')),
                ('encoding', models.CharField(choices=[('base-36', 'Base 36 (1-9, A-Z)'), ('hex', 'Base 16 (0-F)'), ('decimal', 'Base 10 (0-9)')], default='decimal', help_text='The number encoding, choices are base-36, hex or decimal.', max_length=10, verbose_name='Encoding')),
                ('pool', models.CharField(help_text='The machine_name value of the Pool that served the request.', max_length=100, verbose_name='Pool')),
                ('region', models.CharField(blank=True, help_text='The machine_name of the Region that served the request.  This may be any type of region.', max_length=100, null=True, verbose_name='Region')),
                ('size_granted', models.IntegerField(help_text='The number of serial numbers that were actually granted from the given pool.', verbose_name='Size Granted')),
                ('remote_host', models.CharField(help_text='The remote host which made the request.', max_length=400, verbose_name='Remote Host')),
            ],
            options={
                'verbose_name': 'Response',
                'verbose_name_plural': 'Responses',
            },
        ),
        migrations.CreateModel(
            name='ResponseTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True, db_index=True, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(help_text='The name of the template.', max_length=100, verbose_name='Name')),
                ('description', models.TextField(help_text='A brief description of what this template does.', verbose_name='Description')),
                ('template_text', models.TextField(help_text='The template text using Jinja2 format markup.  For more info on Jinja templates see http://jinja.pocoo.org/', verbose_name='Template Text')),
                ('pool', models.ManyToManyField(help_text='This will associate a response template with a pool.  If there is only one associated then it will be the default.  If there is more than one then the template must be explicitly defined on any API requests.', to='serialbox.Pool', verbose_name='Pools')),
            ],
            options={
                'verbose_name': 'Response Template',
                'verbose_name_plural': 'Response Templates',
            },
        ),
        migrations.CreateModel(
            name='SequentialRegion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True, db_index=True, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, unique=True, verbose_name='Readable Name')),
                ('machine_name', models.CharField(help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, unique=True, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('order', models.IntegerField(blank=True, help_text='The order in which this region will be consumed as numbers are issued from the pool overall', null=True, verbose_name='Order')),
                ('start', models.BigIntegerField(help_text='The starting number for this region.', verbose_name='Starting Number')),
                ('end', models.BigIntegerField(help_text='The ending number for this region.', verbose_name='Ending Number')),
                ('state', models.BigIntegerField(help_text='The State represents the current number in use if an API request were to come in now.', verbose_name='State')),
                ('pool', models.ForeignKey(blank=True, help_text='The Number Pool this region will belong to.', null=True, on_delete=django.db.models.deletion.CASCADE, to='serialbox.Pool', verbose_name='Number Pool')),
            ],
            options={
                'verbose_name': 'Sequential Region',
                'verbose_name_plural': 'Sequential Regions',
            },
        ),
    ]
