# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['script_args_parser']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.4.1,<6.0.0', 'toml>=0.10.2,<0.11.0']

setup_kwargs = {
    'name': 'script-args-parser',
    'version': '0.4.0rc0',
    'description': 'Script arguments parsing library.',
    'long_description': '# Script Arguments Parser\n\nThis library is meant to provide an easy way to consume arguments for scripts in more complex scenarios without writing too much code.\n\n## Why something more?\n\nIn Python there are a lot of ways to consume cli parameters, starting from built-in parsers finishing at libraries like docopt. But unfortunately during my adventure I encountered a few problems that were not solvable just by using one of them. Few of those problems:\n\n* get values from multiple sources: cli, config file, environment variable, default;\n* convert given variable according to argument definition;\n* all argument information (cli option, fallback env var, conversion type, default value etc.) defined in one place;\n* definitions written outside the code, so the script is kept clean and simple;\n* more complex conversion types build in.\n\n## Main features\n\n* Parameters defined in both human- and computer-readable format outside of the code, in one place\n* Argument values converted to given format (predefined or custom)\n* Config file fallback\n* Environmental variable fallback\n* Default values\n* Human readable errors\n\n## Usage\n\nOne of the goals of this library was to minimize amount of the code. Therefore whole usage looks like this:\n\n```python\nfrom script_args_parser import ArgumentsParser\n\nargs = ArgumentsParser.from_files(\'example-parameters.toml\', yaml_config=\'example-config.yaml\')\nprint(args.name)\nprint(args.age)\n```\n\nAbove script will read arguments definition from `example-parameters.toml` and try to read their values in following order:\n\n1. from cli options,\n2. from config file (`example-config.yaml` in example),\n3. from environment variables,\n4. default values.\n\nIn any argument does not have value defined it will be None, unless it is required, so it will raise an exception.\n\nWhen all values are established, parser will convert them to specified type.\n\n### Arguments definition\n\nThe list of script arguments is provided in toml file. Example argument can look like this:\n```toml\n[name]\ndescription = "Some fancy description"  # required\ntype = "str"   # required\ncli_arg = "--cli-opt"  # required\nenv_var = "ENV_VAR_NAME"\nrequired = false\ndefault_value = "I got you"\n```\n\n#### description **(mandatory)**\n\nHuman readable description of an argument.\n\n#### type **(mandatory)**\n\nParser will use this field to convert value of the argument from string to one that is specified.\n\nSome more complex types are also changing the way cli options are parsed.\n\nFor detailed description of possible values and their meaning, see [Types section](#types).\n\n#### cli_arg **(mandatory)**\n\nName of the cli option throught which value can be set.\n\n#### env_var\n\nName of environment variable that will be used to read value if not specified by CLI or config file.\n\nFor the format used by more complex types see [Types section](#types).\n\n#### required\n\nBy default False. If set to true, the parser will raise an error if value will not be found anywhere.\n\nCan be specified as boolean value (true, false) or by string (\'true\', \'false\', \'yes\', \'no\', \'1\', \'0\').\n\n#### default_value\n\nValue that will be used if not specified by CLI, config file or environment variable.\n\nFor the format used by more complex types see [Types section](#types).\n\n### Types\n\nThis is the list of built-in types supported.\n\n#### String\n\nType field value: `str`\n\nNo special operations are performed.\n\n#### Integer\n\nType field value: `int`\n\nValue will be parsed to integer, if not possible, exception will be raised.\n\n#### Boolean\n\nType field value: `bool`\n\nSome strings has been defined to be matched to specific values (case insensitive):\n\n* True can be specified as: true, yes, 1;\n* False can be specified as: false, no, 0;\n\nAll other values will be converted to bool using Python rules.\n\n#### Switch\n\nType field value: `switch`\n\nBehaves in the same way as `bool` but additionaly cli option can be passed without an argument and will be considered True.\n\n#### Path\n\nType field value: `path`\n\nWill be converted into `pathlib.Path` object. Worth noticing is that empty string will be equivalent of current directory.\n\n#### List\n\nType field value: `list[<simple type>]`\n\nWill produce a list of elements with given simple types (any that was described above).\n\nWhen this type is specified, multiple cli options should be used to pass list elements:\n```\nscript.py --child-name John --child-name David\n```\n\nIn default value or environment variable use semicolon to split values:\n```\ndefault_value = "John; David; \'Some;Very;Strange;Name\'"\n```\n\n#### Tuple\n\nType field value: `tuple[<simple type>, <optional simple type>, ...]`\n\nExample type field value: `tuple[str]`, `tuple[int, str, bool]`.\n\nWill produce a list with given amount of values of simple types elements.\n\nWhen this type is specified, cli options should be used once but with multiple values. For  `tuple[str, str, str]`\n```\nscript.py --all-my-names John Maria "De\'naban"\n```\n\nIn default value or environment variable separate values with space:\n```\ndefault_value = "John Maria "De\'naban"\n```\n\n#### List of tuples\n\nType field value: `list[tuple[<simple type>, <optional simple type>, ...]]`\n\nCombining list and tuple types. Will produce a list of lists.\n\nFor cli use:\n```\nscript.py --child John 16 --child David 18 --child Maria 21\n```\n\nFor default values and enviroment variables use:\n```\ndefault_value = "John 16; David 18; Maria 21"\n```\n\nAbove examples for `list[tuple[str, int]]` will produce:\n\n```python\n[[\'John\', 16], [\'David\', 18], [\'Maria\', 21]]\n```\n\n## Planned work\n\nWork that still need to be done prior to v1.0\n\n- [x] Default and envs for list\n- [x] Default and envs for tuple\n- [x] Default and envs for list of tuples\n- [x] Add more list of tuples tests\n- [x] Add path type (with tests)\n- [x] Create from path\n- [x] Support config file\n- [x] Document possible types\n- [ ] Write some complex test cases\n- [ ] Allow non-cli arguments\n- [ ] Add logging\n- [ ] Allow custom argument types\n- [ ] Generate usage\n- [ ] Error handling\n- [ ] TOML file validation\n- [ ] CI/CD\n\n## Contributing\n\nRight now I would like to finish what I planned by myself and release version 1.0. If you have any suggestions or you have found bugs, feel free to submit an issue and I will take a look at it as soon as possible.\n\n## Development\n\nDevelopment documentation can be found [here](README-DEV.md)\n',
    'author': 'KRunchPL',
    'author_email': 'krunchfrompoland@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/KRunchPL/script-args-parser',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
