"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.AllowListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * The policy for the receipt filter.
 *
 * @stability stable
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @stability stable
 */
class ReceiptFilter extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
_a = JSII_RTTI_SYMBOL_1;
ReceiptFilter[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptFilter", version: "1.100.0" };
/**
 * An allow list receipt filter.
 *
 * @stability stable
 */
class AllowListReceiptFilter extends core_2.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.AllowListReceiptFilter = AllowListReceiptFilter;
_b = JSII_RTTI_SYMBOL_1;
AllowListReceiptFilter[_b] = { fqn: "@aws-cdk/aws-ses.AllowListReceiptFilter", version: "1.100.0" };
/**
 * (deprecated) An allow list receipt filter.
 *
 * @deprecated use `AllowListReceiptFilter`
 */
class WhiteListReceiptFilter extends AllowListReceiptFilter {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
_c = JSII_RTTI_SYMBOL_1;
WhiteListReceiptFilter[_c] = { fqn: "@aws-cdk/aws-ses.WhiteListReceiptFilter", version: "1.100.0" };
//# sourceMappingURL=data:application/json;base64,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