"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    /**
     * AWS Proxy Integration Type
     */
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
    /**
     * Mock Integration Type
     */
    WebSocketIntegrationType["MOCK"] = "MOCK";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketIntegrationProps(props);
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
exports.WebSocketIntegration = WebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketIntegration", version: "2.18.0-alpha.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class WebSocketRouteIntegration {
    /**
     * Initialize an integration for a route on websocket api.
     * @param id id of the underlying `WebSocketIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRouteIntegration", version: "2.18.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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