"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRouteIntegration = exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.IntegrationCredentials = exports.HttpIntegrationSubtype = exports.HttpIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is an HTTP proxy.
     *
     * For integrating the route or method request with an HTTP endpoint, with the
     * client request passed through as-is. This is also referred to as HTTP proxy
     * integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
    /**
     * Integration type is an AWS proxy.
     *
     * For integrating the route or method request with a Lambda function or other
     * AWS service action. This integration is also referred to as a Lambda proxy
     * integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Supported integration subtypes
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
 */
var HttpIntegrationSubtype;
(function (HttpIntegrationSubtype) {
    /**
     * EventBridge PutEvents integration
     */
    HttpIntegrationSubtype["EVENTBRIDGE_PUT_EVENTS"] = "EventBridge-PutEvents";
    /**
     * SQS SendMessage integration
     */
    HttpIntegrationSubtype["SQS_SEND_MESSAGE"] = "SQS-SendMessage";
    /**
     * SQS ReceiveMessage integration,
     */
    HttpIntegrationSubtype["SQS_RECEIVE_MESSAGE"] = "SQS-ReceiveMessage";
    /**
     * SQS DeleteMessage integration,
     */
    HttpIntegrationSubtype["SQS_DELETE_MESSAGE"] = "SQS-DeleteMessage";
    /**
     * SQS PurgeQueue integration
     */
    HttpIntegrationSubtype["SQS_PURGE_QUEUE"] = "SQS-PurgeQueue";
    /**
     * AppConfig GetConfiguration integration
     */
    HttpIntegrationSubtype["APPCONFIG_GET_CONFIGURATION"] = "AppConfig-GetConfiguration";
    /**
     * Kinesis PutRecord integration
     */
    HttpIntegrationSubtype["KINESIS_PUT_RECORD"] = "Kinesis-PutRecord";
    /**
     * Step Functions StartExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_EXECUTION"] = "StepFunctions-StartExecution";
    /**
     * Step Functions StartSyncExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_SYNC_EXECUTION"] = "StepFunctions-StartSyncExecution";
    /**
     * Step Functions StopExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_STOP_EXECUTION"] = "StepFunctions-StopExecution";
})(HttpIntegrationSubtype = exports.HttpIntegrationSubtype || (exports.HttpIntegrationSubtype = {}));
/**
 * Credentials used for AWS Service integrations.
 */
class IntegrationCredentials {
    /**
     * Use the specified role for integration requests
     */
    static fromRole(role) {
        return { credentialsArn: role.roleArn };
    }
    /** Use the calling user's identity to call the integration */
    static useCallerIdentity() {
        return { credentialsArn: 'arn:aws:iam::*:user/*' };
    }
}
exports.IntegrationCredentials = IntegrationCredentials;
_a = JSII_RTTI_SYMBOL_1;
IntegrationCredentials[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.IntegrationCredentials", version: "2.18.0-alpha.0" };
/**
 * Supported connection types
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    /**
     * For private connections between API Gateway and resources in a VPC
     */
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    /**
     * For connections through public routable internet
     */
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType = exports.HttpConnectionType || (exports.HttpConnectionType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
_b = JSII_RTTI_SYMBOL_1;
PayloadFormatVersion[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.PayloadFormatVersion", version: "2.18.0-alpha.0" };
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpIntegrationProps(props);
        if (!props.integrationSubtype && !props.integrationUri) {
            throw new Error('Either `integrationSubtype` or `integrationUri` must be specified.');
        }
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.apiId,
            integrationType: props.integrationType,
            integrationSubtype: props.integrationSubtype,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: (_e = props.payloadFormatVersion) === null || _e === void 0 ? void 0 : _e.version,
            requestParameters: (_f = props.parameterMapping) === null || _f === void 0 ? void 0 : _f.mappings,
            credentialsArn: (_g = props.credentials) === null || _g === void 0 ? void 0 : _g.credentialsArn,
        });
        if (props.secureServerName) {
            integ.tlsConfig = {
                serverNameToVerify: props.secureServerName,
            };
        }
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
_c = JSII_RTTI_SYMBOL_1;
HttpIntegration[_c] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpIntegration", version: "2.18.0-alpha.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class HttpRouteIntegration {
    /**
     * Initialize an integration for a route on http api.
     * @param id id of the underlying `HttpIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.httpApi.node.addr !== options.route.httpApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new HttpIntegration(options.scope, this.id, {
                httpApi: options.route.httpApi,
                integrationType: config.type,
                integrationSubtype: config.subtype,
                integrationUri: config.uri,
                method: config.method,
                connectionId: config.connectionId,
                connectionType: config.connectionType,
                payloadFormatVersion: config.payloadFormatVersion,
                secureServerName: config.secureServerName,
                parameterMapping: config.parameterMapping,
                credentials: config.credentials,
            });
        }
        this.completeBind(options);
        return { integrationId: this.integration.integrationId };
    }
    /**
     * Complete the binding of the integration to the route. In some cases, there is
     * some additional work to do, such as adding permissions for the API to access
     * the target. This work is necessary whether the integration has just been
     * created for this route or it is an existing one, previously created for other
     * routes. In most cases, however, concrete implementations do not need to
     * override this method.
     */
    completeBind(_options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteIntegrationBindOptions(_options);
    }
}
exports.HttpRouteIntegration = HttpRouteIntegration;
_d = JSII_RTTI_SYMBOL_1;
HttpRouteIntegration[_d] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteIntegration", version: "2.18.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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